/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.cert;

import br.com.ophos.cert.Certificado;
import br.com.ophos.cert.CertificadoException;
import br.com.ophos.cert.StatusCertificado;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class VerificaCertificado {
    public static final DERObjectIdentifier OID_PJ_CNPJ = new DERObjectIdentifier("2.16.76.1.3.3");

    public static Certificado obterDadosCertficado(KeyStore keyStore) throws CertificadoException {
        try {
            Certificado c = null;
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                Certificate certificado = keyStore.getCertificate(alias);
                X509Certificate cert = (X509Certificate)certificado;
                c = new Certificado();
                c.setEmissor(cert.getIssuerDN().toString());
                c.setRequerente(VerificaCertificado.obterCN(certificado));
                c.setDataInicio(cert.getNotBefore());
                c.setDataTermino(cert.getNotAfter());
                c.setAlias(alias);
                try {
                    cert.checkValidity();
                    c.setStatus(StatusCertificado.VALIDO);
                }
                catch (CertificateExpiredException cee) {
                    System.out.println("Certificado vencido.");
                    c.setStatus(StatusCertificado.VENCIDO);
                }
                catch (CertificateNotYetValidException cnyv) {
                    c.setStatus(StatusCertificado.NAO_VALIDO);
                }
                c.setCadeia(keyStore.getCertificateChain(alias));
                Collection col = X509ExtensionUtil.getSubjectAlternativeNames((X509Certificate)cert);
                for (Object obj : col) {
                    DEROctetString octet;
                    ArrayList lst;
                    Object value;
                    if (!(obj instanceof ArrayList) || !((value = (lst = (ArrayList)obj).get(1)) instanceof DLSequence)) continue;
                    DLSequence seq = (DLSequence)value;
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)seq.getObjectAt(0);
                    DERTaggedObject tagged = (DERTaggedObject)seq.getObjectAt(1);
                    String info = null;
                    ASN1Primitive derObj = tagged.getObject();
                    if (derObj instanceof DEROctetString) {
                        octet = (DEROctetString)derObj;
                        info = new String(octet.getOctets());
                    } else if (derObj instanceof DERPrintableString) {
                        octet = (DERPrintableString)derObj;
                        info = new String(octet.getOctets());
                    } else if (derObj instanceof DERUTF8String) {
                        DERUTF8String str = (DERUTF8String)derObj;
                        info = str.getString();
                    }
                    if (info == null || info.isEmpty() || !oid.equals((Object)OID_PJ_CNPJ)) continue;
                    c.setCnpj(info);
                }
                return c;
            }
            return c;
        }
        catch (CertificateParsingException ex) {
            throw new CertificadoException("Ocorreu um erro ao extrair os atributos do certificado. " + ex.getMessage());
        }
        catch (KeyStoreException ex) {
            throw new CertificadoException("Reposit\u00c3\u00b3rio informado nulo. " + ex.getMessage());
        }
    }

    private static String obterCN(Certificate certificado) {
        String cert = certificado.toString();
        int idx = cert.indexOf("CN=");
        return cert.substring(idx, cert.indexOf(",", idx));
    }
}

