/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.sign;

import br.com.ophos.sign.AssinaturaException;
import br.com.ophos.sign.X509KeySelector;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ValidarAssinatura {
    public static boolean validar(InputStream is) throws AssinaturaException {
        try {
            NodeList node;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(is);
            Node element = doc.getDocumentElement().getFirstChild();
            if (element.getNodeType() != 1) {
                element = element.getNextSibling();
            }
            if ((node = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature")).getLength() == 0) {
                throw new AssinaturaException("N\u00c3\u00a3o foi encontrado o elemento de assinatura no XML informado.");
            }
            DOMValidateContext ctx = new DOMValidateContext(new X509KeySelector(), node.item(0));
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            XMLSignature sign = fac.unmarshalXMLSignature(ctx);
            return sign.validate(ctx);
        }
        catch (XMLSignatureException ex) {
            throw new AssinaturaException("Falha ao validar a assinatura digital. Erro: " + ex.getMessage());
        }
        catch (MarshalException ex) {
            throw new AssinaturaException("Falha ao validar a assinatura digital. Erro: " + ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            throw new AssinaturaException("Falha no parse XML. Erro: " + ex.getMessage());
        }
        catch (SAXException ex) {
            throw new AssinaturaException("Falha no parse XML. Erro: " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new AssinaturaException("Falha no parse XML. Erro: " + ex.getMessage());
        }
    }

    public static boolean validar(Document doc) throws AssinaturaException {
        try {
            NodeList node = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (node.getLength() == 0) {
                throw new AssinaturaException("N\u00c3\u00a3o foi encontrado o elemento de assinatura no XML informado.");
            }
            DOMValidateContext ctx = new DOMValidateContext(new X509KeySelector(), node.item(0));
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            XMLSignature sign = fac.unmarshalXMLSignature(ctx);
            return sign.validate(ctx);
        }
        catch (XMLSignatureException ex) {
            throw new AssinaturaException("Falha ao validar a assinatura digital. Erro: " + ex.getMessage());
        }
        catch (MarshalException ex) {
            throw new AssinaturaException("Falha ao validar a assinatura digital. Erro: " + ex.getMessage());
        }
    }

    public static boolean validarXmlNfe(Document doc) throws AssinaturaException {
        try {
            Element e;
            if (doc.getDocumentElement().getNodeName().equals("nfeProc")) {
                e = (Element)doc.getDocumentElement().getElementsByTagName("NFe").item(0).getFirstChild();
                e.setIdAttribute("Id", true);
            } else {
                e = (Element)doc.getDocumentElement().getElementsByTagName("infNfe").item(0);
                e.setIdAttribute("Id", true);
            }
            NodeList node = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (node.getLength() == 0) {
                throw new AssinaturaException("N\u00c3\u00a3o foi encontrado o elemento de assinatura no XML informado.");
            }
            DOMValidateContext ctx = new DOMValidateContext(new X509KeySelector(), node.item(0));
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            XMLSignature sign = fac.unmarshalXMLSignature(ctx);
            return sign.validate(ctx);
        }
        catch (XMLSignatureException ex) {
            throw new AssinaturaException("Falha ao validar a assinatura digital. Erro: " + ex.getMessage());
        }
        catch (MarshalException ex) {
            throw new AssinaturaException("Falha ao validar a assinatura digital. Erro: " + ex.getMessage());
        }
    }

    public static boolean validarXmlCte(Document doc) throws AssinaturaException {
        try {
            Element e;
            if (doc.getDocumentElement().getNodeName().equals("cteProc")) {
                e = (Element)doc.getDocumentElement().getElementsByTagName("CTe").item(0).getFirstChild();
                e.setIdAttribute("Id", true);
            } else {
                e = (Element)doc.getDocumentElement().getElementsByTagName("infCte").item(0);
                e.setIdAttribute("Id", true);
            }
            NodeList node = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (node.getLength() == 0) {
                throw new AssinaturaException("N\u00c3\u00a3o foi encontrado o elemento de assinatura no XML informado.");
            }
            DOMValidateContext ctx = new DOMValidateContext(new X509KeySelector(), node.item(0));
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            XMLSignature sign = fac.unmarshalXMLSignature(ctx);
            return sign.validate(ctx);
        }
        catch (XMLSignatureException ex) {
            throw new AssinaturaException("Falha ao validar a assinatura digital. Erro: " + ex.getMessage());
        }
        catch (MarshalException ex) {
            throw new AssinaturaException("Falha ao validar a assinatura digital. Erro: " + ex.getMessage());
        }
    }
}

