/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.util.ssl;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public class OwnKeyManager
implements X509KeyManager {
    private final X509KeyManager mManager;
    private final KeyStore mKeyStore;
    private final String mKeyAlias;
    private final String mKeyPassword;

    public OwnKeyManager(X509KeyManager parent, KeyStore keystore, String keyAlias, String keyPassword) {
        this.mManager = parent;
        this.mKeyStore = keystore;
        this.mKeyAlias = keyAlias;
        this.mKeyPassword = keyPassword;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return new String[]{this.mKeyAlias};
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.mManager.getServerAliases(keyType, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        this.assertAlias(alias);
        Certificate[] chain = null;
        try {
            chain = this.mKeyStore.getCertificateChain(alias);
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
        }
        catch (Exception kse) {
            kse.printStackTrace();
        }
        X509Certificate[] certChain = new X509Certificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            certChain[i] = (X509Certificate)chain[i];
            ++i;
        }
        return certChain;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        this.assertAlias(alias);
        try {
            return (PrivateKey)this.mKeyStore.getKey(alias, this.mKeyPassword.toCharArray());
        }
        catch (GeneralSecurityException gse) {
            gse.printStackTrace();
            return null;
        }
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.mKeyAlias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.mManager.chooseServerAlias(keyType, issuers, socket);
    }

    private void assertAlias(String alias) {
        if (!alias.equals(this.mKeyAlias)) {
            System.out.println("Unexpected alias <" + alias + ">");
        }
    }
}

