/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos;

import br.com.ophos.enumerations.TipoIntegracao;
import br.com.ophos.integracao.admin.Server;
import br.com.ophos.integracao.admin.config.Configuracoes;
import br.com.ophos.integracao.admin.config.Parametro;
import br.com.ophos.interfaces.MDFeInterface;
import br.com.ophos.interfaces.NFSeInterface;
import br.com.ophos.monitor.BufferDB;
import br.com.ophos.monitor.ConsumidorAverbacao;
import br.com.ophos.monitor.ConsumidorCancel;
import br.com.ophos.monitor.ConsumidorConsulta;
import br.com.ophos.monitor.ConsumidorConsultaStatus;
import br.com.ophos.monitor.ConsumidorContRet;
import br.com.ophos.monitor.ConsumidorEnvio;
import br.com.ophos.monitor.ConsumidorEvento;
import br.com.ophos.monitor.ConsumidorInutilizacao;
import br.com.ophos.monitor.ConsumidorReenvio;
import br.com.ophos.monitor.ConsumidorRetorno;
import br.com.ophos.monitor.ProdutorEnvioFile;
import br.com.ophos.monitor.ProdutorOverBuffer;
import br.com.ophos.retorno.ReciboEnvio;
import br.com.ophos.util.nfe.Util;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    public Logger logger = Logger.getLogger(this.getClass().getName());
    private Server server = new Server();
    private Configuracoes config;

    private void carregarParametros() throws Exception {
        try {
            String path = System.getProperty("user.dir") + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "config.json";
            FileInputStream resourceAsStream = new FileInputStream(new File(path));
            ObjectMapper mapper = new ObjectMapper();
            this.config = (Configuracoes)mapper.readValue((InputStream)resourceAsStream, Configuracoes.class);
            if (this.config.getParametros() == null || this.config.getParametros().isEmpty()) {
                return;
            }
            this.config.getParametros().forEach(param -> {
                this.logger.log(Level.FINE, "Parametros " + param.getTipo().name() + "...");
                this.logger.log(Level.FINE, "DataIn " + param.getTipo().name() + "= ", param.getDataIn());
                this.logger.log(Level.FINE, "DataOut " + param.getTipo().name() + "= ", param.getDataOut());
                this.logger.log(Level.FINE, "URL " + param.getTipo().name() + "= ", param.getUrlbase());
                if (param.getCharQuebraLinha() == null) {
                    param.setCharQuebraLinha("#");
                }
                if (param.getLogSoap().booleanValue()) {
                    System.setProperty("com.sun.xml.ws.transport.http.client.HttpTransportPipe.dump", "true");
                }
                this.logger.log(Level.FINE, "Theads Envio " + param.getTipo().name() + "= ", String.valueOf(param.getThreadsEnvio()));
                this.logger.log(Level.FINE, "Theads Retorno " + param.getTipo().name() + "= ", String.valueOf(param.getThreadsRetorno()));
                this.logger.log(Level.FINE, "Theads Sincrono " + param.getTipo().name() + "= ", String.valueOf(param.getThreadsSincrono()));
            });
        }
        catch (Exception ex) {
            this.logger.severe(Util.readStackTrace(ex));
            throw new IOException("Ocorreu um erro ao carregar os par\u00e2metros. Erro: " + ex.getMessage());
        }
    }

    private String RetornaNomeSemExtensao(String nomeFile) {
        return nomeFile.substring(0, nomeFile.lastIndexOf("."));
    }

    private void ConsisteTmpFiles(String pattern, Parametro param) throws Exception {
        File[] arquivos = Util.listaArquivos(param.getDataIn(), pattern);
        for (int idx = 0; idx < arquivos.length; ++idx) {
            try {
                String nomeFilein = arquivos[idx].getPath();
                nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
                String ext = "";
                if (pattern.toLowerCase().endsWith(".tmp")) {
                    ext = ".txt";
                }
                if (pattern.toLowerCase().endsWith(".tmx")) {
                    ext = ".xml";
                }
                File tmpFile = new File(nomeFilein + ext);
                while (!tmpFile.exists()) {
                    arquivos[idx].renameTo(tmpFile);
                }
                arquivos[idx].delete();
                continue;
            }
            catch (Exception ex) {
                this.logger.severe(Util.readStackTrace(ex));
                this.logger.log(Level.SEVERE, "{0}-Erro ao restaurar arquivo TMP. Arquivo = {1} MSG = {2}", new Object[]{param.getVersaoIntegrador(), arquivos[idx], ex.getMessage()});
            }
        }
    }

    private void ConsisteRecFiles(BufferDB bufferRetorno, String pattern, Parametro param) throws Exception {
        File[] arquivos;
        for (File arquivo : arquivos = Util.listaArquivos(param.getDataIn(), pattern)) {
            try {
                FileInputStream fi = new FileInputStream(arquivo.getPath());
                ObjectInputStream oi = new ObjectInputStream(fi);
                ReciboEnvio obj = (ReciboEnvio)oi.readObject();
                bufferRetorno.Set(obj);
                oi.close();
            }
            catch (Exception ex) {
                this.logger.severe(Util.readStackTrace(ex));
                this.logger.log(Level.SEVERE, "{0}-Erro ao restaurar arquivo REC. Arquivo = {1} MSG = {2}", new Object[]{param.getVersaoIntegrador(), arquivo, ex.getMessage()});
            }
        }
    }

    private void ApagaArquivos(String pattern, Parametro param) throws Exception {
        File[] arquivos;
        for (File arquivo : arquivos = Util.listaArquivos(param.getDataIn(), pattern)) {
            try {
                arquivo.delete();
            }
            catch (Exception ex) {
                this.logger.severe(Util.readStackTrace(ex));
                this.logger.log(Level.SEVERE, "{0}-Erro ao apagar arquivo = {1} MSG = {2}", new Object[]{param.getVersaoIntegrador(), arquivo, ex.getMessage()});
            }
        }
    }

    private void carregarMonitoresNFE(Parametro parametro) throws Exception {
        BufferDB bufferEnvio = new BufferDB(parametro.getBufferEnvio());
        BufferDB bufferCancel = new BufferDB(parametro.getBufferCancelamento());
        BufferDB bufferInutilizacao = new BufferDB(parametro.getBufferInutilizacao());
        BufferDB bufferRetorno = new BufferDB(parametro.getBufferRetorno());
        BufferDB bufferReenvio = new BufferDB(parametro.getBufferEnvio(), parametro.getThreadsEnvio());
        BufferDB bufferImpContingencia = new BufferDB(parametro.getBufferImpContingencia());
        BufferDB bufferContingencia = new BufferDB(parametro.getBufferRetorno());
        BufferDB bufferConsulta = new BufferDB(parametro.getBufferConsulta());
        BufferDB bufferEvento = new BufferDB(parametro.getBufferEvento());
        BufferDB bufferConsultaStatus = new BufferDB(parametro.getBufferConsultaStatus());
        ExecutorService executorEnvio = Executors.newFixedThreadPool(parametro.getThreadsEnvio() + 2);
        ExecutorService executorCancelamento = Executors.newFixedThreadPool(parametro.getThreadsCancelamento() + 1);
        ExecutorService executorRetorno = Executors.newFixedThreadPool(parametro.getThreadsRetorno() + 1);
        ExecutorService executorInutilizacao = Executors.newFixedThreadPool(parametro.getThreadsInutilizacao() + 1);
        ExecutorService executorReenvio = Executors.newFixedThreadPool(parametro.getThreadsEnvio());
        ExecutorService executorContingencia = Executors.newFixedThreadPool(parametro.getThreadsRetorno() + 2);
        ExecutorService executorConsutla = Executors.newFixedThreadPool(parametro.getThreadsConsulta() + 1);
        ExecutorService executorEvento = Executors.newFixedThreadPool(parametro.getThreadsEvento() + 1);
        ExecutorService executorConsultaStatus = Executors.newFixedThreadPool(parametro.getThreadsConsultaStatus() + 1);
        try {
            int count;
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(parametro.getMaskEnvio()) + ".TMP", parametro);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(parametro.getMaskCancelamento()) + ".TMP", parametro);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(parametro.getMaskInutilizacao()) + ".TMP", parametro);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(parametro.getMaskConsulta()) + ".TMP", parametro);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(parametro.getMaskEvento()) + ".TMP", parametro);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(parametro.getMaskConsultaStatus()) + ".TMP", parametro);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(parametro.getMaskEnvio()) + ".LCK", parametro);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(parametro.getMaskEnvio()) + ".RCO", parametro);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(parametro.getMaskEnvio()) + ".REE", parametro);
            executorEnvio.execute(new ProdutorEnvioFile(bufferEnvio, parametro, parametro.getMaskEnvio()));
            executorEnvio.execute(new ProdutorOverBuffer(bufferRetorno, this.RetornaNomeSemExtensao(parametro.getMaskEnvio()) + ".LCK", parametro.getDataIn(), parametro.getTempoRetorno()));
            executorCancelamento.execute(new ProdutorEnvioFile(bufferCancel, parametro, parametro.getMaskCancelamento()));
            executorInutilizacao.execute(new ProdutorEnvioFile(bufferInutilizacao, parametro, parametro.getMaskInutilizacao()));
            executorContingencia.execute(new ProdutorOverBuffer(bufferContingencia, this.RetornaNomeSemExtensao(parametro.getMaskEnvio()) + ".RCO", parametro.getDataIn(), parametro.getTempoRetorno()));
            executorConsutla.execute(new ProdutorEnvioFile(bufferConsulta, parametro, parametro.getMaskConsulta()));
            executorEvento.execute(new ProdutorEnvioFile(bufferEvento, parametro, parametro.getMaskEvento()));
            executorConsultaStatus.execute(new ProdutorEnvioFile(bufferConsultaStatus, parametro, parametro.getMaskConsultaStatus()));
            for (count = 1; count <= parametro.getThreadsEnvio(); ++count) {
                executorEnvio.execute(new ConsumidorEnvio(bufferEnvio, bufferRetorno, bufferReenvio, false, bufferImpContingencia, parametro, bufferConsulta));
            }
            for (count = 1; count <= parametro.getThreadsEnvio(); ++count) {
                executorReenvio.execute(new ConsumidorReenvio(bufferRetorno, bufferReenvio, parametro));
            }
            for (count = 1; count <= parametro.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorRetorno(bufferRetorno, parametro));
            }
            this.ConsisteRecFiles(bufferRetorno, this.RetornaNomeSemExtensao(parametro.getMaskEnvio()) + ".REC", parametro);
            for (count = 1; count <= parametro.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorContRet(bufferContingencia, parametro));
            }
            for (count = 1; count <= parametro.getThreadsCancelamento(); ++count) {
                executorCancelamento.execute(new ConsumidorCancel(bufferCancel, parametro));
            }
            for (count = 1; count <= parametro.getThreadsInutilizacao(); ++count) {
                executorInutilizacao.execute(new ConsumidorInutilizacao(bufferInutilizacao, parametro));
            }
            for (count = 1; count <= parametro.getThreadsConsulta(); ++count) {
                executorConsutla.execute(new ConsumidorConsulta(bufferConsulta, parametro));
            }
            for (count = 1; count <= parametro.getThreadsEvento(); ++count) {
                executorEvento.execute(new ConsumidorEvento(bufferEvento, parametro));
            }
            for (count = 1; count <= parametro.getThreadsConsultaStatus(); ++count) {
                executorConsultaStatus.execute(new ConsumidorConsultaStatus(bufferConsultaStatus, parametro));
            }
        }
        catch (Exception ex) {
            this.logger.severe(Util.readStackTrace(ex));
            throw new Exception(parametro.getVersaoIntegrador() + "-Ocorreu um erro ao iniciar o Executor. Erro: " + ex.getMessage());
        }
    }

    private void carregarMonitoresNFEXML(Parametro paramNFE) throws Exception {
        BufferDB bufferEnvio = new BufferDB(paramNFE.getBufferEnvio());
        BufferDB bufferCancel = new BufferDB(paramNFE.getBufferCancelamento());
        BufferDB bufferInutilizacao = new BufferDB(paramNFE.getBufferInutilizacao());
        BufferDB bufferRetorno = new BufferDB(paramNFE.getBufferRetorno());
        BufferDB bufferReenvio = new BufferDB(paramNFE.getBufferEnvio(), paramNFE.getThreadsEnvio());
        BufferDB bufferImpContingencia = new BufferDB(paramNFE.getBufferImpContingencia());
        BufferDB bufferContingencia = new BufferDB(paramNFE.getBufferRetorno());
        BufferDB bufferConsulta = new BufferDB(paramNFE.getBufferConsulta());
        BufferDB bufferEvento = new BufferDB(paramNFE.getBufferEvento());
        ExecutorService executorEnvio = Executors.newFixedThreadPool(paramNFE.getThreadsEnvio() + 2);
        ExecutorService executorCancelamento = Executors.newFixedThreadPool(paramNFE.getThreadsCancelamento() + 1);
        ExecutorService executorRetorno = Executors.newFixedThreadPool(paramNFE.getThreadsRetorno() + 1);
        ExecutorService executorInutilizacao = Executors.newFixedThreadPool(paramNFE.getThreadsInutilizacao() + 1);
        ExecutorService executorReenvio = Executors.newFixedThreadPool(paramNFE.getThreadsEnvio());
        ExecutorService executorContingencia = Executors.newFixedThreadPool(paramNFE.getThreadsRetorno() + 2);
        ExecutorService executorConsutla = Executors.newFixedThreadPool(paramNFE.getThreadsConsulta() + 1);
        ExecutorService executorEvento = Executors.newFixedThreadPool(paramNFE.getThreadsEvento() + 1);
        try {
            int count;
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramNFE.getMaskEnvio()) + ".TMX", paramNFE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramNFE.getMaskCancelamento()) + ".TMX", paramNFE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramNFE.getMaskInutilizacao()) + ".TMX", paramNFE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramNFE.getMaskConsulta()) + ".TMX", paramNFE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramNFE.getMaskEvento()) + ".TMX", paramNFE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramNFE.getMaskEnvio()) + ".LCK", paramNFE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramNFE.getMaskEnvio()) + ".RCO", paramNFE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramNFE.getMaskEnvio()) + ".REE", paramNFE);
            executorEnvio.execute(new ProdutorEnvioFile(bufferEnvio, paramNFE, paramNFE.getMaskEnvio()));
            executorEnvio.execute(new ProdutorOverBuffer(bufferRetorno, this.RetornaNomeSemExtensao(paramNFE.getMaskEnvio()) + ".LCK", paramNFE.getDataIn(), paramNFE.getTempoRetorno()));
            executorCancelamento.execute(new ProdutorEnvioFile(bufferCancel, paramNFE, paramNFE.getMaskCancelamento()));
            executorInutilizacao.execute(new ProdutorEnvioFile(bufferInutilizacao, paramNFE, paramNFE.getMaskInutilizacao()));
            executorConsutla.execute(new ProdutorEnvioFile(bufferConsulta, paramNFE, paramNFE.getMaskConsulta()));
            executorContingencia.execute(new ProdutorOverBuffer(bufferContingencia, this.RetornaNomeSemExtensao(paramNFE.getMaskEnvio()) + ".RCO", paramNFE.getDataIn(), paramNFE.getTempoRetorno()));
            executorEvento.execute(new ProdutorEnvioFile(bufferEvento, paramNFE, paramNFE.getMaskEvento()));
            this.ConsisteRecFiles(bufferRetorno, this.RetornaNomeSemExtensao(paramNFE.getMaskEnvio()) + ".REC", paramNFE);
            for (count = 1; count <= paramNFE.getThreadsEnvio(); ++count) {
                executorEnvio.execute(new ConsumidorEnvio(bufferEnvio, bufferRetorno, bufferReenvio, false, bufferImpContingencia, paramNFE, bufferConsulta));
            }
            for (count = 1; count <= paramNFE.getThreadsEnvio(); ++count) {
                executorReenvio.execute(new ConsumidorReenvio(bufferRetorno, bufferReenvio, paramNFE));
            }
            for (count = 1; count <= paramNFE.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorRetorno(bufferRetorno, paramNFE));
            }
            for (count = 1; count <= paramNFE.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorContRet(bufferContingencia, paramNFE));
            }
            for (count = 1; count <= paramNFE.getThreadsCancelamento(); ++count) {
                executorCancelamento.execute(new ConsumidorCancel(bufferCancel, paramNFE));
            }
            for (count = 1; count <= paramNFE.getThreadsInutilizacao(); ++count) {
                executorInutilizacao.execute(new ConsumidorInutilizacao(bufferInutilizacao, paramNFE));
            }
            for (count = 1; count <= paramNFE.getThreadsConsulta(); ++count) {
                executorConsutla.execute(new ConsumidorConsulta(bufferConsulta, paramNFE));
            }
            for (count = 1; count <= paramNFE.getThreadsEvento(); ++count) {
                executorEvento.execute(new ConsumidorEvento(bufferEvento, paramNFE));
            }
        }
        catch (Exception ex) {
            this.logger.severe(Util.readStackTrace(ex));
            throw new Exception(paramNFE.getVersaoIntegrador() + "-Ocorreu um erro ao iniciar o Executor - XML. Erro: " + ex.getMessage());
        }
    }

    private void carregarMonitoresCTE(Parametro paramCTE) throws Exception {
        BufferDB bufferEnvio = new BufferDB(paramCTE.getBufferEnvio());
        BufferDB bufferRetorno = new BufferDB(paramCTE.getBufferRetorno());
        BufferDB bufferCancel = new BufferDB(paramCTE.getBufferCancelamento());
        BufferDB bufferInutilizacao = new BufferDB(paramCTE.getBufferInutilizacao());
        BufferDB bufferReenvio = new BufferDB(paramCTE.getBufferEnvio(), paramCTE.getThreadsEnvio());
        BufferDB bufferImpContingencia = new BufferDB(paramCTE.getBufferImpContingencia());
        BufferDB bufferContingencia = new BufferDB(paramCTE.getBufferRetorno());
        BufferDB bufferConsulta = new BufferDB(paramCTE.getBufferConsulta());
        BufferDB bufferEvento = new BufferDB(paramCTE.getBufferEvento());
        BufferDB bufferAverbacao = new BufferDB(paramCTE.getBufferAverbacao());
        ExecutorService executorEnvio = Executors.newFixedThreadPool(paramCTE.getThreadsEnvio() + 3);
        ExecutorService executorReenvio = Executors.newFixedThreadPool(paramCTE.getThreadsEnvio());
        ExecutorService executorRetorno = Executors.newFixedThreadPool(paramCTE.getThreadsRetorno() + 1);
        ExecutorService executorCancelamento = Executors.newFixedThreadPool(paramCTE.getThreadsCancelamento() + 1);
        ExecutorService executorInutilizacao = Executors.newFixedThreadPool(paramCTE.getThreadsInutilizacao() + 1);
        ExecutorService executorContingencia = Executors.newFixedThreadPool(paramCTE.getThreadsRetorno() + 2);
        ExecutorService executorConsulta = Executors.newFixedThreadPool(paramCTE.getThreadsConsulta() + 1);
        ExecutorService executorEvento = Executors.newFixedThreadPool(paramCTE.getThreadsEvento() + 1);
        ExecutorService executorAverbacao = Executors.newFixedThreadPool(paramCTE.getThreadsAverbacao() + 1);
        try {
            int count;
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTE.getMaskEnvio()) + ".TMP", paramCTE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTE.getMaskEnvio()) + ".TMX", paramCTE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTE.getMaskCancelamento()) + ".TMP", paramCTE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTE.getMaskCancelamento()) + ".TMX", paramCTE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTE.getMaskInutilizacao()) + ".TMP", paramCTE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTE.getMaskInutilizacao()) + ".TMX", paramCTE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTE.getMaskEvento()) + ".TMP", paramCTE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTE.getMaskAverbacao()) + ".TMP", paramCTE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramCTE.getMaskEnvio()) + ".LCK", paramCTE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramCTE.getMaskEnvio()) + ".RCO", paramCTE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramCTE.getMaskEnvio()) + ".REE", paramCTE);
            executorEnvio.execute(new ProdutorEnvioFile(bufferEnvio, paramCTE, paramCTE.getMaskEnvio()));
            executorEnvio.execute(new ProdutorOverBuffer(bufferRetorno, this.RetornaNomeSemExtensao(paramCTE.getMaskEnvio()) + ".LCK", paramCTE.getDataIn(), paramCTE.getTempoRetorno()));
            executorCancelamento.execute(new ProdutorEnvioFile(bufferCancel, paramCTE, paramCTE.getMaskCancelamento()));
            executorInutilizacao.execute(new ProdutorEnvioFile(bufferInutilizacao, paramCTE, paramCTE.getMaskInutilizacao()));
            executorContingencia.execute(new ProdutorOverBuffer(bufferContingencia, this.RetornaNomeSemExtensao(paramCTE.getMaskEnvio()) + ".RCO", paramCTE.getDataIn(), paramCTE.getTempoRetorno()));
            executorConsulta.execute(new ProdutorEnvioFile(bufferConsulta, paramCTE, paramCTE.getMaskConsulta()));
            executorEvento.execute(new ProdutorEnvioFile(bufferEvento, paramCTE, paramCTE.getMaskEvento()));
            executorAverbacao.execute(new ProdutorEnvioFile(bufferAverbacao, paramCTE, paramCTE.getMaskAverbacao()));
            for (count = 1; count <= paramCTE.getThreadsEnvio(); ++count) {
                executorEnvio.execute(new ConsumidorEnvio(bufferEnvio, bufferRetorno, bufferReenvio, false, bufferImpContingencia, paramCTE, null));
            }
            for (count = 1; count <= paramCTE.getThreadsEnvio(); ++count) {
                executorReenvio.execute(new ConsumidorReenvio(bufferRetorno, bufferReenvio, paramCTE));
            }
            for (count = 1; count <= paramCTE.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorRetorno(bufferRetorno, paramCTE));
            }
            this.ConsisteRecFiles(bufferRetorno, this.RetornaNomeSemExtensao(paramCTE.getMaskEnvio()) + ".REC", paramCTE);
            for (count = 1; count <= paramCTE.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorContRet(bufferContingencia, paramCTE));
            }
            for (count = 1; count <= paramCTE.getThreadsCancelamento(); ++count) {
                executorCancelamento.execute(new ConsumidorCancel(bufferCancel, paramCTE));
            }
            for (count = 1; count <= paramCTE.getThreadsInutilizacao(); ++count) {
                executorInutilizacao.execute(new ConsumidorInutilizacao(bufferInutilizacao, paramCTE));
            }
            for (count = 1; count <= paramCTE.getThreadsConsulta(); ++count) {
                executorConsulta.execute(new ConsumidorConsulta(bufferConsulta, paramCTE));
            }
            for (count = 1; count <= paramCTE.getThreadsEvento(); ++count) {
                executorEvento.execute(new ConsumidorEvento(bufferEvento, paramCTE));
            }
            for (count = 1; count <= paramCTE.getThreadsAverbacao(); ++count) {
                executorAverbacao.execute(new ConsumidorAverbacao(bufferAverbacao, paramCTE));
            }
        }
        catch (Exception ex) {
            this.logger.severe(Util.readStackTrace(ex));
            throw new Exception(paramCTE.getVersaoIntegrador() + "-Ocorreu um erro ao iniciar o Executor. Erro: " + ex.getMessage());
        }
    }

    private void carregarMonitoresCTEOS(Parametro paramCTEOS) throws Exception {
        BufferDB bufferEnvio = new BufferDB(paramCTEOS.getBufferEnvio());
        BufferDB bufferRetorno = new BufferDB(paramCTEOS.getBufferRetorno());
        BufferDB bufferCancel = new BufferDB(paramCTEOS.getBufferCancelamento());
        BufferDB bufferInutilizacao = new BufferDB(paramCTEOS.getBufferInutilizacao());
        BufferDB bufferReenvio = new BufferDB(paramCTEOS.getBufferEnvio(), paramCTEOS.getThreadsEnvio());
        BufferDB bufferContingencia = new BufferDB(paramCTEOS.getBufferRetorno());
        BufferDB bufferConsulta = new BufferDB(paramCTEOS.getBufferConsulta());
        BufferDB bufferEvento = new BufferDB(paramCTEOS.getBufferEvento());
        BufferDB bufferAverbacao = new BufferDB(paramCTEOS.getBufferAverbacao());
        ExecutorService executorEnvio = Executors.newFixedThreadPool(paramCTEOS.getThreadsEnvio() + 3);
        ExecutorService executorReenvio = Executors.newFixedThreadPool(paramCTEOS.getThreadsEnvio());
        ExecutorService executorRetorno = Executors.newFixedThreadPool(paramCTEOS.getThreadsRetorno() + 1);
        ExecutorService executorCancelamento = Executors.newFixedThreadPool(paramCTEOS.getThreadsCancelamento() + 1);
        ExecutorService executorInutilizacao = Executors.newFixedThreadPool(paramCTEOS.getThreadsInutilizacao() + 1);
        ExecutorService executorContingencia = Executors.newFixedThreadPool(paramCTEOS.getThreadsRetorno() + 2);
        ExecutorService executorConsulta = Executors.newFixedThreadPool(paramCTEOS.getThreadsConsulta() + 1);
        ExecutorService executorEvento = Executors.newFixedThreadPool(paramCTEOS.getThreadsEvento() + 1);
        ExecutorService executorAverbacao = Executors.newFixedThreadPool(paramCTEOS.getThreadsAverbacao() + 1);
        try {
            int count;
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTEOS.getMaskEnvio()) + ".TMP", paramCTEOS);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTEOS.getMaskEnvio()) + ".TMX", paramCTEOS);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTEOS.getMaskCancelamento()) + ".TMP", paramCTEOS);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTEOS.getMaskCancelamento()) + ".TMX", paramCTEOS);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTEOS.getMaskInutilizacao()) + ".TMP", paramCTEOS);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTEOS.getMaskInutilizacao()) + ".TMX", paramCTEOS);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTEOS.getMaskEvento()) + ".TMP", paramCTEOS);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramCTEOS.getMaskAverbacao()) + ".TMP", paramCTEOS);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramCTEOS.getMaskEnvio()) + ".LCK", paramCTEOS);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramCTEOS.getMaskEnvio()) + ".RCO", paramCTEOS);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramCTEOS.getMaskEnvio()) + ".REE", paramCTEOS);
            executorEnvio.execute(new ProdutorEnvioFile(bufferEnvio, paramCTEOS, paramCTEOS.getMaskEnvio()));
            executorEnvio.execute(new ProdutorOverBuffer(bufferRetorno, this.RetornaNomeSemExtensao(paramCTEOS.getMaskEnvio()) + ".LCK", paramCTEOS.getDataIn(), paramCTEOS.getTempoRetorno()));
            executorCancelamento.execute(new ProdutorEnvioFile(bufferCancel, paramCTEOS, paramCTEOS.getMaskCancelamento()));
            executorInutilizacao.execute(new ProdutorEnvioFile(bufferInutilizacao, paramCTEOS, paramCTEOS.getMaskInutilizacao()));
            executorContingencia.execute(new ProdutorOverBuffer(bufferContingencia, this.RetornaNomeSemExtensao(paramCTEOS.getMaskEnvio()) + ".RCO", paramCTEOS.getDataIn(), paramCTEOS.getTempoRetorno()));
            executorConsulta.execute(new ProdutorEnvioFile(bufferConsulta, paramCTEOS, paramCTEOS.getMaskConsulta()));
            executorEvento.execute(new ProdutorEnvioFile(bufferEvento, paramCTEOS, paramCTEOS.getMaskEvento()));
            executorAverbacao.execute(new ProdutorEnvioFile(bufferAverbacao, paramCTEOS, paramCTEOS.getMaskAverbacao()));
            for (count = 1; count <= paramCTEOS.getThreadsEnvio(); ++count) {
                executorEnvio.execute(new ConsumidorEnvio(bufferEnvio, bufferRetorno, bufferReenvio, false, null, paramCTEOS, bufferConsulta));
            }
            for (count = 1; count <= paramCTEOS.getThreadsEnvio(); ++count) {
                executorReenvio.execute(new ConsumidorReenvio(bufferRetorno, bufferReenvio, paramCTEOS));
            }
            for (count = 1; count <= paramCTEOS.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorRetorno(bufferRetorno, paramCTEOS));
            }
            this.ConsisteRecFiles(bufferRetorno, this.RetornaNomeSemExtensao(paramCTEOS.getMaskEnvio()) + ".REC", paramCTEOS);
            for (count = 1; count <= paramCTEOS.getThreadsInutilizacao(); ++count) {
                executorInutilizacao.execute(new ConsumidorInutilizacao(bufferInutilizacao, paramCTEOS));
            }
            for (count = 1; count <= paramCTEOS.getThreadsConsulta(); ++count) {
                executorConsulta.execute(new ConsumidorConsulta(bufferConsulta, paramCTEOS));
            }
            for (count = 1; count <= paramCTEOS.getThreadsEvento(); ++count) {
                executorEvento.execute(new ConsumidorEvento(bufferEvento, paramCTEOS));
            }
            for (count = 1; count <= paramCTEOS.getThreadsAverbacao(); ++count) {
                executorAverbacao.execute(new ConsumidorAverbacao(bufferAverbacao, paramCTEOS));
            }
        }
        catch (Exception ex) {
            this.logger.severe(Util.readStackTrace(ex));
            throw new Exception(paramCTEOS.getVersaoIntegrador() + "-Ocorreu um erro ao iniciar o Executor. Erro: " + ex.getMessage());
        }
    }

    private void carregarMonitoresMDFE(Parametro paramMDFE) throws Exception {
        BufferDB bufferEnvio = new BufferDB(paramMDFE.getBufferEnvio());
        BufferDB bufferEvento = new BufferDB(paramMDFE.getBufferEvento());
        BufferDB bufferRetorno = new BufferDB(paramMDFE.getBufferRetorno());
        BufferDB bufferReenvio = new BufferDB(paramMDFE.getBufferEnvio(), paramMDFE.getThreadsEnvio());
        BufferDB bufferImpContingencia = new BufferDB(paramMDFE.getBufferImpContingencia());
        BufferDB bufferContingencia = new BufferDB(paramMDFE.getBufferRetorno());
        ExecutorService executorEnvio = Executors.newFixedThreadPool(paramMDFE.getThreadsEnvio() + 3);
        ExecutorService executorEvento = Executors.newFixedThreadPool(paramMDFE.getThreadsEvento() + 1);
        ExecutorService executorReenvio = Executors.newFixedThreadPool(paramMDFE.getThreadsEnvio());
        ExecutorService executorRetorno = Executors.newFixedThreadPool(paramMDFE.getThreadsRetorno() + 1);
        ExecutorService executorContingencia = Executors.newFixedThreadPool(paramMDFE.getThreadsRetorno() + 2);
        try {
            int count;
            MDFeInterface iface = new MDFeInterface(paramMDFE.getUrlbase(), paramMDFE.getToken(), paramMDFE.getTimeOutWS());
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramMDFE.getMaskEnvio()) + ".TMP", paramMDFE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramMDFE.getMaskEnvio()) + ".LCK", paramMDFE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramMDFE.getMaskEnvio()) + ".RCO", paramMDFE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramMDFE.getMaskEnvio()) + ".REE", paramMDFE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramMDFE.getMaskEvento()) + ".TMP", paramMDFE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramMDFE.getMaskEvento()) + ".LCK", paramMDFE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramMDFE.getMaskEvento()) + ".RCO", paramMDFE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramMDFE.getMaskEvento()) + ".REE", paramMDFE);
            executorEnvio.execute(new ProdutorEnvioFile(bufferEnvio, paramMDFE, paramMDFE.getMaskEnvio()));
            executorEvento.execute(new ProdutorEnvioFile(bufferEvento, paramMDFE, paramMDFE.getMaskEvento()));
            executorEnvio.execute(new ProdutorOverBuffer(bufferRetorno, this.RetornaNomeSemExtensao(paramMDFE.getMaskEnvio()) + ".LCK", paramMDFE.getDataIn(), paramMDFE.getTempoRetorno()));
            executorContingencia.execute(new ProdutorOverBuffer(bufferContingencia, this.RetornaNomeSemExtensao(paramMDFE.getMaskEnvio()) + ".RCO", paramMDFE.getDataIn(), paramMDFE.getTempoRetorno()));
            for (count = 1; count <= paramMDFE.getThreadsEnvio(); ++count) {
                executorEnvio.execute(new ConsumidorEnvio(bufferEnvio, paramMDFE.getDataOut(), paramMDFE.getDataIn(), null, null, bufferRetorno, TipoIntegracao.TXT, bufferReenvio, (Boolean)false, bufferImpContingencia, paramMDFE, null, iface));
            }
            for (count = 1; count <= paramMDFE.getThreadsEvento(); ++count) {
                executorEvento.execute(new ConsumidorEvento(bufferEvento, paramMDFE, iface));
            }
            for (count = 1; count <= paramMDFE.getThreadsEnvio(); ++count) {
                executorReenvio.execute(new ConsumidorReenvio(paramMDFE.getDataOut(), paramMDFE.getDataIn(), null, null, bufferRetorno, bufferReenvio, paramMDFE.getTempoEnvio(), paramMDFE, iface));
            }
            for (count = 1; count <= paramMDFE.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorRetorno(bufferRetorno, paramMDFE.getDataIn(), paramMDFE.getDataOut(), null, paramMDFE.getTempoRetorno(), TipoIntegracao.TXT, paramMDFE, iface));
            }
            this.ConsisteRecFiles(bufferRetorno, this.RetornaNomeSemExtensao(paramMDFE.getMaskEnvio()) + ".REC", paramMDFE);
            for (count = 1; count <= paramMDFE.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorContRet(bufferContingencia, paramMDFE.getDataIn(), paramMDFE.getDataOut(), null, paramMDFE.getTempoRetorno(), paramMDFE, iface));
            }
        }
        catch (Exception ex) {
            this.logger.severe(Util.readStackTrace(ex));
            throw new Exception(paramMDFE.getVersaoIntegrador() + "-Ocorreu um erro ao iniciar o Executor. Erro: " + ex.getMessage());
        }
    }

    private void carregarMonitoresNFSE(Parametro paramNFSE) throws Exception {
        BufferDB bufferEnvio = new BufferDB(paramNFSE.getBufferEnvio());
        BufferDB bufferEvento = new BufferDB(paramNFSE.getBufferEvento());
        BufferDB bufferRetorno = new BufferDB(paramNFSE.getBufferRetorno());
        BufferDB bufferReenvio = new BufferDB(paramNFSE.getBufferEnvio(), paramNFSE.getThreadsEnvio());
        BufferDB bufferImpContingencia = new BufferDB(paramNFSE.getBufferImpContingencia());
        BufferDB bufferContingencia = new BufferDB(paramNFSE.getBufferRetorno());
        ExecutorService executorEnvio = Executors.newFixedThreadPool(paramNFSE.getThreadsEnvio() + 3);
        ExecutorService executorEvento = Executors.newFixedThreadPool(paramNFSE.getThreadsEvento() + 1);
        ExecutorService executorReenvio = Executors.newFixedThreadPool(paramNFSE.getThreadsEnvio());
        ExecutorService executorRetorno = Executors.newFixedThreadPool(paramNFSE.getThreadsRetorno() + 1);
        ExecutorService executorContingencia = Executors.newFixedThreadPool(paramNFSE.getThreadsRetorno() + 2);
        try {
            int count;
            NFSeInterface iface = new NFSeInterface(paramNFSE.getUrlbase(), paramNFSE.getToken(), paramNFSE.getTimeOutWS());
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramNFSE.getMaskEnvio()) + ".TMP", paramNFSE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramNFSE.getMaskEnvio()) + ".LCK", paramNFSE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramNFSE.getMaskEnvio()) + ".RCO", paramNFSE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramNFSE.getMaskEnvio()) + ".REE", paramNFSE);
            this.ConsisteTmpFiles(this.RetornaNomeSemExtensao(paramNFSE.getMaskEvento()) + ".TMP", paramNFSE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramNFSE.getMaskEvento()) + ".LCK", paramNFSE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramNFSE.getMaskEvento()) + ".RCO", paramNFSE);
            this.ApagaArquivos(this.RetornaNomeSemExtensao(paramNFSE.getMaskEvento()) + ".REE", paramNFSE);
            executorEnvio.execute(new ProdutorEnvioFile(bufferEnvio, paramNFSE, paramNFSE.getMaskEnvio()));
            executorEvento.execute(new ProdutorEnvioFile(bufferEvento, paramNFSE, paramNFSE.getMaskEvento()));
            executorEnvio.execute(new ProdutorOverBuffer(bufferRetorno, this.RetornaNomeSemExtensao(paramNFSE.getMaskEnvio()) + ".LCK", paramNFSE.getDataIn(), paramNFSE.getTempoRetorno()));
            executorContingencia.execute(new ProdutorOverBuffer(bufferContingencia, this.RetornaNomeSemExtensao(paramNFSE.getMaskEnvio()) + ".RCO", paramNFSE.getDataIn(), paramNFSE.getTempoRetorno()));
            for (count = 1; count <= paramNFSE.getThreadsEnvio(); ++count) {
                executorEnvio.execute(new ConsumidorEnvio(bufferEnvio, paramNFSE.getDataOut(), paramNFSE.getDataIn(), null, null, bufferRetorno, TipoIntegracao.TXT, bufferReenvio, (Boolean)false, bufferImpContingencia, paramNFSE, null, iface));
            }
            for (count = 1; count <= paramNFSE.getThreadsEvento(); ++count) {
                executorEvento.execute(new ConsumidorEvento(bufferEvento, paramNFSE, iface));
            }
            for (count = 1; count <= paramNFSE.getThreadsEnvio(); ++count) {
                executorReenvio.execute(new ConsumidorReenvio(paramNFSE.getDataOut(), paramNFSE.getDataIn(), null, null, bufferRetorno, bufferReenvio, paramNFSE.getTempoEnvio(), paramNFSE, iface));
            }
            for (count = 1; count <= paramNFSE.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorRetorno(bufferRetorno, paramNFSE.getDataIn(), paramNFSE.getDataOut(), null, paramNFSE.getTempoRetorno(), TipoIntegracao.TXT, paramNFSE, iface));
            }
            this.ConsisteRecFiles(bufferRetorno, this.RetornaNomeSemExtensao(paramNFSE.getMaskEnvio()) + ".REC", paramNFSE);
            for (count = 1; count <= paramNFSE.getThreadsRetorno(); ++count) {
                executorRetorno.execute(new ConsumidorContRet(bufferContingencia, paramNFSE.getDataIn(), paramNFSE.getDataOut(), null, paramNFSE.getTempoRetorno(), paramNFSE, iface));
            }
        }
        catch (Exception ex) {
            this.logger.severe(Util.readStackTrace(ex));
            throw new Exception(paramNFSE.getVersaoIntegrador() + "-Ocorreu um erro ao iniciar o Executor. Erro: " + ex.getMessage());
        }
    }

    public static void main(String[] args) {
        System.setProperty("java.util.logging.config.file", "config/logging.properties");
        System.setProperty("user.country", "BR");
        System.setProperty("user.language", "pt");
        System.setProperty("user.timezone", "GMT-3");
        Main m = new Main();
        try {
            m.logger.setLevel(Level.ALL);
            m.logger.info("TimeZone: " + System.getProperty("user.timezone") + " Encoding: " + System.getProperty("file.encoding"));
            String pathConfig = System.getProperty("user.dir") + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "config.json";
            File fileParam = new File(pathConfig);
            if (fileParam.exists()) {
                m.carregarParametros();
                m.server.startServer(m.config.getPortConfig(), m.config.getUserConfig(), m.config.getPasswordConfig());
                m.config.getParametros().forEach(param -> {
                    try {
                        block1 : switch (param.getTipo()) {
                            case NFE: {
                                switch (param.getTipoEntrada()) {
                                    case TXT: 
                                    case TXT_SEFAZ: {
                                        m.carregarMonitoresNFE((Parametro)param);
                                        break block1;
                                    }
                                    case XML: 
                                    case XML_SEFAZ: {
                                        m.carregarMonitoresNFEXML((Parametro)param);
                                    }
                                }
                                break;
                            }
                            case CTE: {
                                m.carregarMonitoresCTE((Parametro)param);
                                break;
                            }
                            case MDFE: {
                                m.carregarMonitoresMDFE((Parametro)param);
                                break;
                            }
                            case NFSE: {
                                m.carregarMonitoresNFSE((Parametro)param);
                                break;
                            }
                            case CTEOS: {
                                m.carregarMonitoresCTEOS((Parametro)param);
                            }
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, Util.readStackTrace(ex));
                    }
                });
                m.logger.log(Level.FINE, "Vers\u00e3o APP: 5.14");
                m.logger.log(Level.FINE, "Data Build APP: 01/09/2025");
            } else {
                m.logger.log(Level.FINE, "5.14 - Arquivo de configura\u00e7\u00e3o n\u00e3o localizado");
                m.server.startServer(9988, "admin", "admin");
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, Util.readStackTrace(ex));
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void stop(String[] args) {
        System.exit(0);
    }
}

