/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.admin;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import spark.Filter;
import spark.Response;
import spark.Spark;

public class Server {
    Gson gson = new Gson();

    public void startServer(Integer porta, String userConfig, String passwordConfig) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.log(Level.FINE, "Iniciando servi\u00e7o de configura\u00e7\u00e3o...");
        Spark.staticFiles.location("/main/resources/public");
        Spark.initExceptionHandler(e -> logger.log(Level.SEVERE, "Erro ao iniciar o servi\u00e7o de configura\u00e7\u00e3o: " + e.getStackTrace()));
        Spark.port((int)porta);
        Spark.after((Filter[])new Filter[]{(request, response) -> {
            response.header("Access-Control-Allow-Methods", "GET,PUT,POST,DELETE,OPTIONS");
            response.header("Access-Control-Allow-Origin", "*");
            response.header("Access-Control-Allow-Headers", "Access-Control-Allow-Origin, Accept, Content-Type");
        }});
        Spark.before((String)"*", (request, response) -> {
            response.header("WWW-Authenticate", "Basic realm=\"Restricted\"");
            Boolean authenticated = false;
            String auth = request.headers("Authorization");
            if (auth != null && auth.startsWith("Basic")) {
                String b64Credentials = auth.substring("Basic".length()).trim();
                String credentials = new String(Base64.getDecoder().decode(b64Credentials));
                if (credentials.equals(userConfig + ":" + passwordConfig)) {
                    authenticated = true;
                }
            }
            if (!authenticated.booleanValue()) {
                logger.log(Level.FINE, "Tentativa de acesso as configura\u00e7\u00f5es do sistema com status autentica\u00e7\u00e3o requerida");
                Spark.halt((int)401, (String)"<html>\n<head>\n  <title>401 Unauthorized</title>\n</head>\n<body bgcolor=\"ffffff\">\n  <h2>401 - N\u00e3o autorizado<h2>\n  <p>\n  Autoriza\u00e7\u00e3o requerida para a URL.\n</body>\n</html>");
            }
        });
        Spark.get((String)"/desconectado", (req, res) -> {
            Spark.halt((int)401);
            return res;
        });
        Spark.get((String)"/", (String)"text/html", (req, res) -> this.getClass().getResourceAsStream("/main/resources/index.html"));
        Spark.get((String)"/popular", (String)"application/javascript", (req, res) -> {
            File file = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "config.json");
            return new FileInputStream(file);
        });
        Spark.get((String)"/default", (String)"application/json", (req, res) -> {
            String produto = req.queryParams("prod");
            File file = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "default" + produto + ".json");
            return new FileInputStream(file);
        });
        Spark.get((String)"/log", (String)"text/xml", (req, res) -> {
            String arquivo = req.queryParams("arquivo");
            if (arquivo != null && !arquivo.isEmpty()) {
                res.header("Content-Type", "application/json;charset=" + System.getProperty("file.encoding"));
                File file = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "log" + System.getProperty("file.separator") + arquivo);
                List<InputStream> streams = Arrays.asList(new FileInputStream(file), new ByteArrayInputStream("]}".getBytes()));
                SequenceInputStream story = new SequenceInputStream(Collections.enumeration(streams));
                return story;
            }
            res.status(400);
            res.body("Conteudo \u00e9 nulo");
            return res;
        });
        Spark.get((String)"/log/listar", (String)"application/json", (req, res) -> {
            File[] files;
            res.type("application/json");
            ArrayList<String> ret = new ArrayList<String>();
            for (File f : files = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "log" + System.getProperty("file.separator")).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("LOG_\\w*.(json|JSON)");
                }
            })) {
                ret.add(f.getName());
            }
            return ret;
        }, arg_0 -> ((Gson)this.gson).toJson(arg_0));
        Spark.post((String)"/salvar", (String)"application/json", (req, res) -> {
            try (OutputStreamWriter file = null;){
                if (req.body() == null) {
                    res.status(400);
                    res.body("Conteudo \u00e9 nulo");
                    Response response = res;
                    return response;
                }
                try (PrintWriter out = new PrintWriter(new FileWriter(System.getProperty("user.dir") + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "config.json", StandardCharsets.UTF_8));){
                    out.write(req.body());
                    logger.log(Level.FINE, "Altera\u00e7\u00f5es nas configura\u00e7\u00f5es do sistema aplicada com sucesso.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return res;
        });
        logger.log(Level.FINE, "Servi\u00e7o de configura\u00e7\u00e3o iniciado com sucesso...");
        logger.log(Level.FINE, "http://localhost:" + porta);
    }
}

