/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.interfaces.nfe;

import br.com.ophos.integracao.interfaces.dto.RetInutilizacao;
import br.com.ophos.integracao.interfaces.nfe.EnvioNfeService;
import br.com.ophos.integracao.interfaces.nfe.EventoNfeService;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.NF;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetConsultaEnvio;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetConsultaNFe;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetEnvio;
import br.com.ophos.integracao.interfaces.nfe.dto.evento.EnvInutilizacao;
import br.com.ophos.integracao.interfaces.nfe.dto.evento.RetEvento;
import br.com.ophos.integracao.interfaces.nfe.dto.evento.TipoEvento;
import br.com.ophos.interfaces.LoggingFilter;
import br.com.ophos.util.nfe.Util;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class NfeInterface {
    private static final String PATH = "/nfe/service/";
    private static ResteasyClient client;
    private static boolean ativaLog;

    private static ResteasyClient getClient() {
        if (client == null) {
            client = new ResteasyClientBuilder().build();
            if (ativaLog) {
                client.register((Object)new LoggingFilter());
            }
        }
        return client;
    }

    public static RetEnvio enviar(String urlWS, String token, NF obj) {
        try {
            ResteasyClient client = NfeInterface.getClient();
            ResteasyWebTarget target = client.target(urlWS + PATH);
            EnvioNfeService proxy = (EnvioNfeService)target.proxy(EnvioNfeService.class);
            ObjectMapper mapper = new ObjectMapper();
            String data = mapper.writeValueAsString((Object)obj);
            return proxy.enviarNfe(token, data);
        }
        catch (Exception e) {
            RetEnvio ret = new RetEnvio();
            ret.setCnpj(obj.getEmitente().getNrCnpj());
            ret.setNumero(obj.getNumeroDocumentoFiscal());
            ret.setSerie(obj.getSerie());
            ret.setReferencia(obj.getNrReferencia());
            ret.setStatus(RetEnvio.StatusEnvio.ERRO_GERAL);
            ret.setMensagem(e.getMessage());
            return ret;
        }
    }

    public static RetConsultaEnvio obterRetornoEnvio(String urlWS, String token, String protocolo) {
        ResteasyClient client = NfeInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EnvioNfeService proxy = (EnvioNfeService)target.proxy(EnvioNfeService.class);
        return proxy.obterRetorno(token, protocolo);
    }

    public static byte[] obterXmlEvento(String urlWS, String token, String chaveAcesso, TipoEvento evento, String sequencial) throws Exception {
        ResteasyClient client = NfeInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoNfeService proxy = (EventoNfeService)target.proxy(EventoNfeService.class);
        return proxy.obterXmlEvento(token, chaveAcesso, evento.name(), sequencial);
    }

    public static byte[] obterXmlCancelamento(String urlWS, String token, String chaveAcesso) throws Exception {
        ResteasyClient client = NfeInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoNfeService proxy = (EventoNfeService)target.proxy(EventoNfeService.class);
        return proxy.obterXmlCancelamento(token, chaveAcesso);
    }

    public static RetEvento registrarCartaCorrecao2(String urlWS, String token, String chave, String justificativa) {
        ResteasyClient client = NfeInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoNfeService proxy = (EventoNfeService)target.proxy(EventoNfeService.class);
        return proxy.registrarCartaCorrecao(token, chave, justificativa);
    }

    public static RetEvento registrarManifestacao(String urlWS, String token, String chave, String cnpj, String tipo) {
        ResteasyClient client = NfeInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoNfeService proxy = (EventoNfeService)target.proxy(EventoNfeService.class);
        return proxy.registrarManifestacao(token, chave, cnpj, tipo);
    }

    public static RetEvento cancelar(String urlWS, String token, String cnpjEmitente, String numero, String serie, String justificativa) {
        ResteasyClient client = NfeInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoNfeService proxy = (EventoNfeService)target.proxy(EventoNfeService.class);
        return proxy.registrarCancelamento(token, cnpjEmitente, numero, serie, justificativa);
    }

    public static RetEvento cancelarPorChaveAcesso(String urlWS, String token, String chaveAcesso, String justificativa) {
        ResteasyClient client = NfeInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoNfeService proxy = (EventoNfeService)target.proxy(EventoNfeService.class);
        return proxy.registrarCancelamentoChaveAcesso(token, chaveAcesso, justificativa);
    }

    public static RetInutilizacao inutilizar(String urlWS, String token, Util.EnvInutilizacaoV200 obj) {
        RetInutilizacao ret = new RetInutilizacao();
        EnvInutilizacao env = new EnvInutilizacao(obj.cnpjEmitente, obj.nrIe, Integer.parseInt(obj.nrAno), Short.parseShort(obj.nrSerie), Integer.parseInt(obj.nrIni), Integer.parseInt(obj.nrFim), obj.justificativa, obj.usuario);
        ResteasyClient client = NfeInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoNfeService proxy = (EventoNfeService)target.proxy(EventoNfeService.class);
        Response retWs = proxy.registarInutilizacao(token, env);
        if (retWs.getStatus() == 201) {
            ret = (RetInutilizacao)retWs.readEntity(RetInutilizacao.class);
            ret.setStatus(201);
        } else {
            ret.setStatus(retWs.getStatus());
            ret.setMsg((String)retWs.readEntity(String.class));
        }
        return ret;
    }

    public static RetConsultaNFe consultar(String urlWS, String token, String cnpjEmitente, String numero, short serie) {
        ResteasyClient client = NfeInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EnvioNfeService proxy = (EnvioNfeService)target.proxy(EnvioNfeService.class);
        return proxy.consultarNfe(token, cnpjEmitente, numero, serie);
    }

    public static void setAtivaLog(boolean ativaLog) {
        NfeInterface.ativaLog = ativaLog;
    }

    static {
        ativaLog = false;
    }
}

