/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.parse.nfe.txt;

import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTCancelFactory;
import br.com.ophos.parse.ParseException;
import br.com.ophos.util.nfe.Util;
import java.io.InputStream;
import java.util.Scanner;

public class ParseTXTCancelamentoNFE
extends ParseTXTCancelFactory {
    protected Util.EnvCancelamento obj = null;
    private static ParseTXTCancelamentoNFE instance;

    public static ParseTXTCancelamentoNFE getInstance() {
        if (instance == null) {
            instance = new ParseTXTCancelamentoNFE();
        }
        return instance;
    }

    @Override
    public Util.EnvCancelamento parse(InputStream in) throws ParseException {
        try (Scanner scanner = null;){
            this.obj = new Util.EnvCancelamento();
            scanner = new Scanner(in);
            while (scanner.hasNextLine()) {
                this.lerLinha(scanner.nextLine() + "|");
            }
        }
        return this.obj;
    }

    protected void lerLinha(String aLine) throws ParseException {
        Integer ID = Integer.parseInt(aLine.substring(1, 3));
        switch (ID) {
            case 1: {
                this.InfoCancelamento(aLine);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + ID + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    protected void InfoCancelamento(String aLine) throws ParseException {
        try (Scanner scanner = new Scanner(aLine);){
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 6) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 6 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.cnpjEmitente = scanner.next();
                this.obj.nrReferente = scanner.next();
                this.obj.nrDocumento = scanner.next();
                this.obj.nrSerie = scanner.next();
                this.obj.justificativa = scanner.next();
                this.obj.usuario = scanner.next();
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 1." + ex.getMessage());
        }
    }
}

