/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.parse.nfe.txt.v1;

import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTEventoFactory;
import br.com.ophos.parse.ParseException;
import br.com.ophos.util.nfe.Util;
import java.io.InputStream;
import java.util.Scanner;

public class ParseTXTEventoNFEv101
extends ParseTXTEventoFactory {
    protected Util.EnvEvento101 obj = null;
    private static ParseTXTEventoNFEv101 instance;
    private String caracQuebraLinha;

    public static ParseTXTEventoNFEv101 getInstance(String charQuebraLinha) {
        if (instance == null) {
            instance = new ParseTXTEventoNFEv101(charQuebraLinha);
        }
        return instance;
    }

    public ParseTXTEventoNFEv101(String charQuebraLinha) {
        this.caracQuebraLinha = charQuebraLinha;
    }

    @Override
    public Util.EnvEvento101 parse(InputStream in) throws ParseException {
        try (Scanner scanner = null;){
            this.obj = new Util.EnvEvento101();
            scanner = new Scanner(in);
            scanner.useDelimiter("\\|");
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                this.lerLinha(scanner.nextLine() + "|");
            }
        }
        return this.obj;
    }

    protected void lerLinha(String aLine) throws ParseException {
        Integer ID = Integer.parseInt(aLine.substring(1, 3));
        switch (ID) {
            case 1: {
                this.InfoEvento(aLine);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + ID + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    protected void InfoEvento(String aLine) throws ParseException {
        try (Scanner scanner = new Scanner(aLine);){
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 6) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 6 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.cnpjEmitente = scanner.next();
                this.obj.ieEmitente = scanner.next();
                this.obj.chaveAcesso = scanner.next();
                this.obj.tpEvento = scanner.next();
                if (!this.obj.tpEvento.equals("0")) {
                    this.obj.tpManifestacao = Util.valueToTipoManifestacao(this.obj.tpEvento);
                }
                this.obj.dsDescricao = br.com.ophos.util.Util.adicionarQuebraLinha(scanner.next(), this.caracQuebraLinha).trim();
                this.obj.usuario = scanner.next();
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 1." + ex.getMessage(), this.obj);
        }
    }
}

