/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.parse.nfe.txt.v2;

import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Adicao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Di;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Item;
import br.com.ophos.integracao.parse.nfe.txt.v2.ParseTXTEnvioNFEv200;
import br.com.ophos.parse.ParseException;
import br.com.ophos.util.nfe.Util;
import java.util.Scanner;

public class ParseTXTEnvioNFEv201
extends ParseTXTEnvioNFEv200 {
    private static ParseTXTEnvioNFEv201 instance;

    public static ParseTXTEnvioNFEv201 getInstance(String charQuebraLinha) {
        if (instance == null) {
            instance = new ParseTXTEnvioNFEv201(charQuebraLinha);
        }
        return instance;
    }

    public ParseTXTEnvioNFEv201(String charQuebraLinha) {
        super(charQuebraLinha);
    }

    private Di GetDi(Integer nrItem, String nrDi) {
        Item item = this.GetItem(nrItem);
        for (Di di : item.getDi()) {
            if (!di.getNrDocumento().equals(nrDi)) continue;
            return di;
        }
        return null;
    }

    @Override
    protected void DocAdicao(String aLine) throws ParseException {
        try (Scanner scanner = new Scanner(aLine);){
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 6) {
                throw new ParseException("A linha 020 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 6 campos.");
            }
            Adicao adicao = new Adicao();
            String nrDi = "";
            Integer nrItem = 0;
            while (scanner.hasNext()) {
                scanner.next();
                nrItem = Util.StringToInteger(scanner.next());
                nrDi = scanner.next();
                adicao.setNrAdicao(Util.StringToShort(scanner.next().trim()));
                adicao.setNrSeq(Util.StringToShort(scanner.next().trim()));
                adicao.setFabricante(scanner.next().trim());
                String vDesc = scanner.next();
                if (vDesc.equals("")) continue;
                adicao.setValorDesconto(Util.StringToDouble(vDesc, Util.ST_FMT_DOIS_DECIMAIS));
            }
            this.GetDi(nrItem, nrDi).getAdicoes().add(adicao);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 20." + ex.getMessage());
        }
    }
}

