/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.parse.nfe.txt.v3;

import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Adicao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Armamento;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.AutorizacaoXML;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.ChaveReferenciada;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Cofins;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.CofinsAliq;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.CofinsOutros;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.CofinsQtde;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Cofinsnt;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Cofinsst;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Combustivel;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Compras;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.DeducaoCana;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Destinatario;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Devolucao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Di;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Duplicata;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Emitente;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Exportacao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Fatura;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.FornecimentoDiario;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.IcmsPartilha;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.IcmsProprioST;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn00;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn10;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn20;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn30;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn40;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn41;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn50;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn51;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn60;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn70;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn90;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn101;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn102;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn103;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn201;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn202;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn203;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn300;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn400;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn500;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmssn900;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsst;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Ii;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Info;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.InfoContribuinte;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.InfoExportacao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.InfoFisco;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.InfoPagamento;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Ipi;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.IpiTrib;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Ipint;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Issqn;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Item;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Lacre;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Local;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalDateTimeSerializer;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalEntrega;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalRetirada;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Medicamento;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.NF;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Pis;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.PisAliq;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.PisOutros;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.PisQtde;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Pisnt;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Pisst;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.ProcessoReferenciado;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Reboque;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RefCTe;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RefECF;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RefNF;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RefNFP;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RefNFe;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RegistroCana;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetencaoTransporte;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaCFOutros;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaCFQtde;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaICMSST;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaPISOutros;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaPISQtde;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Totais;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Transportadora;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Veiculo;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.VeiculoTransporte;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Volume;
import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTEnvioNFEFactory;
import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.ParseException2;
import br.com.ophos.util.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public class ParseTXTEnvioNFEv300
extends ParseTXTEnvioNFEFactory {
    private static ParseTXTEnvioNFEv300 instance;
    protected NF obj = null;
    private String caracQuebraLinha;

    public ParseTXTEnvioNFEv300() {
    }

    public ParseTXTEnvioNFEv300(String charQuebraLinha) {
        this.caracQuebraLinha = charQuebraLinha;
    }

    public static ParseTXTEnvioNFEv300 getInstance(String charQuebraLinha) {
        if (instance == null) {
            instance = new ParseTXTEnvioNFEv300(charQuebraLinha);
        }
        return instance;
    }

    protected Integer GetQtdDelimiter(String line, String delimiter) {
        Integer qtdRetorno = 0;
        char[] caracters = line.toCharArray();
        for (int i = 0; i < caracters.length; ++i) {
            String charac = String.valueOf(caracters[i]);
            if (!charac.equals(delimiter)) continue;
            qtdRetorno = qtdRetorno + 1;
        }
        return qtdRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NF parse(InputStream in) throws ParseException2 {
        this.obj = new NF();
        try (Scanner scanner = null;){
            ArrayList<Integer> linhasObrigatorias = new ArrayList<Integer>();
            linhasObrigatorias.add(0);
            linhasObrigatorias.add(1);
            linhasObrigatorias.add(6);
            linhasObrigatorias.add(14);
            ArrayList<Integer> linhasErro = new ArrayList<Integer>();
            ArrayList<Integer> linhasEncontradas = new ArrayList<Integer>();
            scanner = new Scanner(in);
            scanner.next();
            while (scanner.hasNextLine()) {
                String linha = scanner.nextLine().trim();
                if (linha.length() < 3) continue;
                Integer ID = Integer.parseInt(linha.substring(1, 3));
                linhasEncontradas.add(ID);
                try {
                    this.lerLinha(linha + "|");
                }
                catch (ParseException parseException) {
                    linhasErro.add(ID);
                }
            }
            Object msgException = "";
            for (Object e : linhasErro) {
                msgException = (String)msgException + e;
            }
            if (linhasErro.size() > 0) {
                throw new ParseException2("ERRO_LAYOUT: " + (String)msgException, this.obj);
            }
            for (Object e : linhasObrigatorias) {
                Integer id = (Integer)e;
                if (linhasEncontradas.contains(id)) continue;
                throw new ParseException2("Linha obrigat\u00f3ria: " + e.toString() + " n\u00e3o encontrada no arquivo texto.");
            }
        }
        return this.obj;
    }

    private void lerLinha(String aLine) throws ParseException {
        try {
            Integer ID = Integer.parseInt(aLine.substring(1, 3));
            switch (ID) {
                case 0: {
                    this.InfoNFe(aLine);
                    break;
                }
                case 1: {
                    this.Emitente(aLine);
                    break;
                }
                case 2: {
                    this.Destinatario(aLine);
                    break;
                }
                case 3: {
                    this.Fatura(aLine);
                    break;
                }
                case 4: {
                    this.Duplicata(aLine);
                    break;
                }
                case 5: {
                    this.Local(aLine);
                    break;
                }
                case 6: {
                    this.Transporte(aLine);
                    break;
                }
                case 7: {
                    this.Reboque(aLine);
                    break;
                }
                case 8: {
                    this.Volume(aLine);
                    break;
                }
                case 9: {
                    this.Lacre(aLine);
                    break;
                }
                case 11: {
                    this.InfADD(aLine);
                    break;
                }
                case 13: {
                    this.ChaveRef(aLine);
                    break;
                }
                case 14: {
                    this.Item(aLine);
                    break;
                }
                case 15: {
                    this.Veiculo(aLine);
                    break;
                }
                case 16: {
                    this.Armamento(aLine);
                    break;
                }
                case 17: {
                    this.Medicamento(aLine);
                    break;
                }
                case 18: {
                    this.Combustivel(aLine);
                    break;
                }
                case 19: {
                    this.DocImportacao(aLine);
                    break;
                }
                case 20: {
                    this.DocAdicao(aLine);
                    break;
                }
                case 24: {
                    this.DetExportacaoItem(aLine);
                    break;
                }
                case 25: {
                    this.DetPapelImune(aLine);
                    break;
                }
                case 26: {
                    this.InfoProcRef(aLine);
                    break;
                }
                case 27: {
                    this.AutorizacaoXML(aLine);
                    break;
                }
                case 28: {
                    this.FormaPagamentoNFCe(aLine);
                    break;
                }
                default: {
                    throw new ParseException("O identificador '" + ID + "'da linha informado n\u00e3o foi encontrado.");
                }
            }
        }
        catch (ParseException | NumberFormatException ex) {
            throw new ParseException(ex.getMessage());
        }
    }

    protected void InfoNFe(String aLine) throws ParseException {
        try {
            Integer totalCampos = 63;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 000 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.setNrReferencia(scanner.next().trim());
                this.obj.setUsuarioEmitente(scanner.next().trim());
                if (this.obj.getEmitente() == null) {
                    this.obj.setEmitente(new Emitente());
                }
                this.obj.getEmitente().setNrIbgeUf(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                this.obj.setNaturezaOperacao(scanner.next().trim());
                this.obj.setModeloDocumento(scanner.next());
                this.obj.setSerie(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                this.obj.setNumeroDocumentoFiscal(br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim()));
                this.obj.setDataEmissao(LocalDateTimeSerializer.parseDateTime(scanner.next().trim()));
                this.obj.setDataEntradaSaida(LocalDateTimeSerializer.parseDateTime(scanner.next().trim()));
                this.obj.setTipoDocumento(br.com.ophos.util.nfe.Util.valueToTipoDocumento(scanner.next().trim()));
                this.obj.setNrIbgeMunicipioFatoGerador(br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim()));
                scanner.next();
                scanner.next();
                scanner.next();
                this.obj.setFinalidadeEmissao(br.com.ophos.util.nfe.Util.valueToFinalidadeEmissao(scanner.next().trim()));
                this.obj.setTotais(new Totais());
                this.obj.getTotais().setBaseCalculoICMS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorICMS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorICMSDesonerado(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setBaseCalculoICMSST(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorICMSST(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorProdutoServico(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorFrete(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorSeguro(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorDesconto(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorII(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorIPI(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorPIS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorCOFINS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorOutros(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorNF(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorServico(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setBaseCalculoISS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorISS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorPISISS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorCOFINSISS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setDataPrestacaoISS(Util.parseData(scanner.next(), Util.FMTYYYYMMDDHHMMSS));
                this.obj.getTotais().setValorDeducaoISS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorOutrosISS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorDescIncondicionalISS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorDescCondicionalISS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorISSRetido(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setTipoRegimeISS(br.com.ophos.util.nfe.Util.valueToRegimeEspecial(scanner.next()));
                this.obj.getTotais().setValorRetidoPIS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorRetidoCOFINS(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorRetidoCSLL(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setBaseCalculoIRRPF(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorRetidoIRRF(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setBaseCalculoPrevidencia(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorRetidoPrevidencia(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.setInfoFisco(Util.adicionarQuebraLinha(scanner.next(), this.getCaracQuebraLinha()).trim());
                this.obj.setInfoContribuinte(Util.adicionarQuebraLinha(scanner.next(), this.getCaracQuebraLinha()).trim());
                String cM000_DS_UF_EMBARQUE = scanner.next();
                String cM000_DS_LOCAL_EMBARQUE = scanner.next();
                String localDespacho = scanner.next();
                if (!cM000_DS_LOCAL_EMBARQUE.equals("")) {
                    this.obj.setExportacao(new Exportacao());
                    this.obj.getExportacao().setUfEmbarque(cM000_DS_UF_EMBARQUE);
                    this.obj.getExportacao().setLocalEmbarque(cM000_DS_LOCAL_EMBARQUE);
                    if (localDespacho != null && !localDespacho.isEmpty()) {
                        this.obj.getExportacao().setLocalDespacho(localDespacho);
                    }
                }
                String cM000_DS_NF_EMPENHO = scanner.next();
                String cM000_DS_PEDIDO = scanner.next();
                String cM000_DS_CONTRATO = scanner.next();
                if (!(cM000_DS_PEDIDO.equals("") && cM000_DS_PEDIDO.equals("") && cM000_DS_CONTRATO.equals(""))) {
                    this.obj.setCompras(new Compras());
                    this.obj.getCompras().setNotaEmpenho(cM000_DS_NF_EMPENHO);
                    this.obj.getCompras().setNumeroPedido(cM000_DS_PEDIDO);
                    this.obj.getCompras().setNumeroContrato(cM000_DS_CONTRATO);
                }
                this.obj.setNrCarga(scanner.next().trim());
                this.obj.getTotais().setValorAproximadoTributo(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.setDestinoOperacao(br.com.ophos.util.nfe.Util.valueToDestinoOperacao(scanner.next()));
                this.obj.setConsumidorFinal(br.com.ophos.util.nfe.Util.valueToEscolhaSN(scanner.next()));
                this.obj.setPresencaComprador(br.com.ophos.util.nfe.Util.valueToPresencaComprador(scanner.next()));
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 0. " + ex.getMessage());
        }
    }

    private void Emitente(String aLine) throws ParseException {
        try {
            Integer totalCampos = 19;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getEmitente() == null) {
                    this.obj.setEmitente(new Emitente());
                }
                this.obj.getEmitente().setNrCnpj(scanner.next().trim());
                this.obj.getEmitente().setRazaoSocial(scanner.next().trim());
                this.obj.getEmitente().setNomeFantasia(scanner.next().trim());
                this.obj.getEmitente().setLogradouro(scanner.next().trim());
                this.obj.getEmitente().setNumeroLogradouro(scanner.next().trim());
                this.obj.getEmitente().setComplemento(scanner.next().trim());
                this.obj.getEmitente().setBairro(scanner.next().trim());
                this.obj.getEmitente().setNrIbgeMunicipio(br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim()));
                this.obj.getEmitente().setNomeMunicipio(scanner.next().trim());
                this.obj.getEmitente().setUf(scanner.next().trim());
                this.obj.getEmitente().setCep(scanner.next().trim());
                this.obj.getEmitente().setNrPais(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                this.obj.getEmitente().setNomePais(scanner.next().trim());
                this.obj.getEmitente().setTelefone(scanner.next().trim());
                this.obj.getEmitente().setIe(scanner.next().trim());
                this.obj.getEmitente().setIeSt(scanner.next().trim());
                this.obj.getEmitente().setIm(scanner.next().trim());
                this.obj.getEmitente().setCnae(scanner.next().trim());
                this.obj.getEmitente().setCrt(br.com.ophos.util.nfe.Util.valueToCrt(scanner.next().trim()));
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 1." + ex.getMessage());
        }
    }

    private void Destinatario(String aLine) throws ParseException {
        try {
            Integer totalCampos = 21;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.setDestinatario(new Destinatario());
                this.obj.getDestinatario().setNrCnpjCpf(scanner.next().trim());
                this.obj.getDestinatario().setNomeDestino(scanner.next().trim());
                this.obj.getDestinatario().setLogradouro(scanner.next().trim());
                this.obj.getDestinatario().setNumeroLogradouro(scanner.next().trim());
                this.obj.getDestinatario().setComplemento(scanner.next().trim());
                this.obj.getDestinatario().setBairro(scanner.next().trim());
                this.obj.getDestinatario().setNrIbgeMunicipio(br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim()));
                this.obj.getDestinatario().setNomeMunicipio(scanner.next().trim());
                this.obj.getDestinatario().setUf(scanner.next().trim());
                this.obj.getDestinatario().setCep(scanner.next().trim());
                this.obj.getDestinatario().setNrPais(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                this.obj.getDestinatario().setNomePais(scanner.next().trim());
                this.obj.getDestinatario().setTelefone(scanner.next().trim());
                this.obj.getDestinatario().setIe(scanner.next().trim());
                this.obj.getDestinatario().setNrSuframa(scanner.next().trim());
                this.obj.getDestinatario().setEmail(scanner.next().trim());
                scanner.next().trim();
                this.obj.getDestinatario().setNrCliente(scanner.next().trim());
                scanner.next();
                this.obj.getDestinatario().setTipoInscricao(br.com.ophos.util.nfe.Util.valueToInscricaoDestinatario(scanner.next()));
                this.obj.getDestinatario().setInscricaoMunicipal(scanner.next().trim());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 2." + ex.getMessage());
        }
    }

    private void Fatura(String aLine) throws ParseException {
        try {
            Integer totalCamposMin = 4;
            Integer totalCamposMax = 6;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCamposMin) && !qtdCampos.equals(totalCamposMax)) {
                throw new ParseException("A linha 003 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCamposMin.toString() + " ou " + totalCamposMax.toString() + " campos.");
            }
            Fatura fatura = new Fatura();
            while (scanner.hasNext()) {
                scanner.next();
                fatura.setNrFatura(scanner.next().trim());
                fatura.setValorOriginal(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                fatura.setValorDesconto(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                fatura.setValorLiquido(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                if (!qtdCampos.equals(6)) continue;
                fatura.setDsFpgto(scanner.next().trim());
                fatura.setDsCpgto(scanner.next().trim());
            }
            this.obj.setFatura(fatura);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 3." + ex.getMessage());
        }
    }

    private void Duplicata(String aLine) throws ParseException {
        try {
            Integer totalCampos = 3;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Duplicata duplicata = new Duplicata();
            while (scanner.hasNext()) {
                scanner.next();
                duplicata.setNrDuplicata(scanner.next().trim());
                duplicata.setDtVencimento(Util.parseData(scanner.next().trim(), Util.FMTYYYYMMDDHHMMSS));
                duplicata.setVlDuplicata(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
            }
            this.obj.getDuplicatas().add(duplicata);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 4." + ex.getMessage());
        }
    }

    private void Local(String aLine) throws ParseException {
        try {
            Integer totalCampos = 9;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 005 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Local local = null;
            while (scanner.hasNext()) {
                scanner.next();
                Integer iTipoLocal = br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim());
                if (iTipoLocal.equals(0)) {
                    local = new LocalRetirada();
                }
                if (iTipoLocal.equals(1)) {
                    local = new LocalEntrega();
                }
                local.setCnpj(scanner.next().trim());
                local.setLogradouro(scanner.next().trim());
                local.setNumero(scanner.next().trim());
                local.setComplemento(scanner.next().trim());
                local.setBairro(scanner.next().trim());
                local.setNrIbgeMunicipio(br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim()));
                local.setNomeMunicipio(scanner.next().trim());
                local.setUf(scanner.next().trim());
            }
            this.obj.getLocais().add(local);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 5." + ex.getMessage());
        }
    }

    private void Transporte(String aLine) throws ParseException {
        try {
            Integer totalCampos = 19;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 006 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Transportadora transportadora = new Transportadora();
            while (scanner.hasNext()) {
                scanner.next();
                transportadora.setModalidadeFrete(br.com.ophos.util.nfe.Util.valueToModalidadeFrete(scanner.next().trim()));
                transportadora.setNrCnpjCpf(scanner.next().trim());
                transportadora.setRazaoSocial(scanner.next().trim());
                transportadora.setNrIe(scanner.next().trim());
                transportadora.setEndereco(scanner.next().trim());
                transportadora.setMunicipio(scanner.next().trim());
                transportadora.setUf(scanner.next().trim());
                transportadora.setEmail(scanner.next().trim());
                String cM006_VL_SERV = scanner.next();
                String cM006_VL_BC_RET_ICMS = scanner.next();
                String cM006_VL_ALIQ_RET = scanner.next();
                String cM006_VL_RET_ICMS = scanner.next();
                String cM006_NR_CFOP = scanner.next();
                String cM006_NR_IBGE_MUN_FG = scanner.next();
                if (!cM006_VL_SERV.equals("")) {
                    transportadora.setRetencao(new RetencaoTransporte());
                    transportadora.getRetencao().setValorServico(br.com.ophos.util.nfe.Util.StringToDouble(cM006_VL_SERV, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    transportadora.getRetencao().setBaseCalculoRetencaoICMS(br.com.ophos.util.nfe.Util.StringToDouble(cM006_VL_BC_RET_ICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    transportadora.getRetencao().setAliquotaRetencao(br.com.ophos.util.nfe.Util.StringToDouble(cM006_VL_ALIQ_RET, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    transportadora.getRetencao().setValorRetidoICMS(br.com.ophos.util.nfe.Util.StringToDouble(cM006_VL_RET_ICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    transportadora.getRetencao().setNrCFOP(br.com.ophos.util.nfe.Util.StringToShort(cM006_NR_CFOP));
                    transportadora.getRetencao().setNrIbgeMunFg(br.com.ophos.util.nfe.Util.StringToInteger(cM006_NR_IBGE_MUN_FG));
                }
                String cM006_DS_PLACA = scanner.next();
                String cM006_DS_UF_PLACA = scanner.next();
                String cM006_NR_RNTC = scanner.next();
                String cM007_DS_VAGAO = scanner.next();
                String cM007_DS_BALSA = scanner.next();
                if (!cM006_DS_PLACA.equals("")) {
                    VeiculoTransporte veicTransp = new VeiculoTransporte();
                    veicTransp.setNrRNTC(cM006_NR_RNTC);
                    veicTransp.setPlacaVeiculo(cM006_DS_PLACA);
                    veicTransp.setUfVeiculo(cM006_DS_UF_PLACA);
                    transportadora.setVeiculoTransporte(veicTransp);
                }
                if (!cM007_DS_VAGAO.equals("")) {
                    transportadora.setVagao(cM007_DS_VAGAO);
                }
                if (cM007_DS_BALSA.equals("")) continue;
                transportadora.setBalsa(cM007_DS_BALSA);
            }
            this.obj.setTransportadora(transportadora);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 6." + ex.getMessage());
        }
    }

    private void Reboque(String aLine) throws ParseException {
        try {
            Integer totalCampos = 3;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 007 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Reboque reboque = new Reboque();
            while (scanner.hasNext()) {
                scanner.next();
                reboque.setPlaca(scanner.next().trim());
                reboque.setUf(scanner.next().trim());
                reboque.setNrRntc(scanner.next().trim());
            }
            this.obj.getTransportadora().getReboques().add(reboque);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 7." + ex.getMessage());
        }
    }

    private void Volume(String aLine) throws ParseException {
        try {
            Integer totalCamposMin = 6;
            Integer totalCamposMax = 7;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos1 = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos1.equals(totalCamposMin) && !qtdCampos1.equals(totalCamposMax)) {
                throw new ParseException("A linha 008 possui: " + qtdCampos1.toString() + " campos, mas \u00e9 esperado " + totalCamposMin.toString() + " ou " + totalCamposMax.toString() + " campos.");
            }
            Volume volume = new Volume();
            Integer seq = 1;
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|");
            if (qtdCampos.equals(8)) {
                scanner.next();
            }
            while (scanner.hasNext()) {
                scanner.next();
                volume.setQuantidade(br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim()));
                volume.setEspecie(scanner.next().trim());
                volume.setMarca(scanner.next().trim());
                volume.setIdentificacao(scanner.next().trim());
                String vlPL = scanner.next();
                String vlPB = scanner.next();
                if (!vlPL.equals("")) {
                    volume.setPesoLiquido(br.com.ophos.util.nfe.Util.StringToDouble(vlPL, br.com.ophos.util.nfe.Util.ST_FMT_TRES_DECIMAIS));
                }
                if (!vlPB.equals("")) {
                    volume.setPesoBruto(br.com.ophos.util.nfe.Util.StringToDouble(vlPB, br.com.ophos.util.nfe.Util.ST_FMT_TRES_DECIMAIS));
                }
                seq = seq + 1;
            }
            if (this.obj.getTransportadora() == null) {
                throw new ParseException("A linha com as informa\u00e7\u00f5es de transporte n\u00e3o foi informada. (006)");
            }
            this.obj.getTransportadora().getVolume().add(volume);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 8." + ex.getMessage());
        }
    }

    private void Lacre(String aLine) throws ParseException {
        try {
            Integer totalCampos = 2;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 009 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Lacre lacre = new Lacre();
            String nrVolume = "";
            while (scanner.hasNext()) {
                scanner.next();
                nrVolume = scanner.next();
                lacre.setNrLacre(scanner.next().trim());
            }
            this.GetVolume(nrVolume).getLacres().add(lacre);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 9." + ex.getMessage());
        }
    }

    private void InfADD(String aLine) throws ParseException {
        try {
            Integer totalCampos = 3;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 011 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Info info = null;
            while (scanner.hasNext()) {
                scanner.next();
                Integer iTipoInfo = br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim());
                if (iTipoInfo.equals(0)) {
                    info = new InfoContribuinte();
                }
                if (iTipoInfo.equals(1)) {
                    info = new InfoFisco();
                }
                info.setCampo(scanner.next().trim());
                info.setDescricao(scanner.next().trim());
                if (info.getCampo().trim().toUpperCase().equals("REFSIS")) {
                    this.obj.setNrReferencia(info.getDescricao());
                }
                if (info.getCampo().trim().toUpperCase().equals("USUARIO")) {
                    this.obj.setUsuarioEmitente(info.getDescricao());
                }
                if (!info.getCampo().trim().toUpperCase().equals("EMAILTRANSPORTADOR")) continue;
                this.obj.getTransportadora().setEmail(info.getDescricao());
            }
            this.obj.getInfo().add(info);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 11." + ex.getMessage());
        }
    }

    protected void Item(String aLine) throws ParseException {
        try {
            Integer totalCampos = 232;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos1 = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos1.equals(totalCampos)) {
                throw new ParseException("A linha 014 possui: " + qtdCampos1.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Item item = new Item();
            while (scanner.hasNext()) {
                scanner.next();
                item.setNrItem(br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim()));
                item.setCodigoProduto(ParseTXTEnvioNFEv300.retiraCaracteres2(scanner.next().trim()));
                item.setEan(scanner.next().trim());
                item.setNomeProduto(scanner.next().trim());
                item.setNcm(scanner.next().trim());
                String nve = scanner.next();
                if (nve != null && !nve.trim().isEmpty()) {
                    item.getNve().add(scanner.next().trim());
                }
                item.setExTIPI(scanner.next().trim());
                item.setGenero(scanner.next().trim());
                item.setCfop(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                item.setUnidadeComercial(scanner.next().trim());
                item.setQuantidadeComercial(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                item.setValorUnitario(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DEZ_DECIMAIS));
                item.setValorProduto(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                item.setEanTrib(scanner.next().trim());
                item.setUnidadeTributavel(scanner.next().trim());
                item.setQuantidadeTributavel(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                item.setValorUnitarioTributacao(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DEZ_DECIMAIS));
                item.setValorFrete(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                item.setValorSeguro(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                item.setValorDesconto(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                item.setValorOutros(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                item.setItemCompoeTotal(br.com.ophos.util.nfe.Util.valueToCompoeTotal(scanner.next().trim()));
                String nrPedidoCompra = scanner.next();
                String nrItemPedidoCompra = scanner.next();
                if (!nrPedidoCompra.equals("")) {
                    item.setNrPedidoCompra(nrPedidoCompra);
                }
                if (!nrItemPedidoCompra.equals("")) {
                    item.setNrItemPedidoCompra(nrItemPedidoCompra);
                }
                String situacaoTribICMS = scanner.next();
                IcmsProprioST icms = null;
                String grp_0_OrigemMercadoria = scanner.next();
                String grp_0_ModalidadaBcICMS = scanner.next();
                String grp_0_BaseCalculoICMS = scanner.next();
                String grp_0_AliquotaICMS = scanner.next();
                String grp_0_ValorICMS = scanner.next();
                String grp_1_OrigemMercadoria = scanner.next();
                String grp_1_ModalidadaBcICMS = scanner.next();
                String grp_1_BaseCalculoICMS = scanner.next();
                String grp_1_AliquotaICMS = scanner.next();
                String grp_1_ValorICMS = scanner.next();
                String grp_1_ModalidadaBcICMSST = scanner.next();
                String grp_1_PercentualMargemICMS = scanner.next();
                String grp_1_PercentualReducaoBCICMSST = scanner.next();
                String grp_1_ValorBCICMSST = scanner.next();
                String grp_1_AliquotaICMSST = scanner.next();
                String grp_1_ValorICMSST = scanner.next();
                String grp_2_OrigemMercadoria = scanner.next();
                String grp_2_ModalidadaBcICMS = scanner.next();
                String grp_2_BaseCalculoICMS = scanner.next();
                String grp_2_AliquotaICMS = scanner.next();
                String grp_2_ValorICMS = scanner.next();
                String grp_2_PercentualReducaoBCICMS = scanner.next();
                String grp_2_ValorICMSDesonerado = scanner.next();
                String grp_2_MotivoDesoneracao = scanner.next();
                String grp_3_OrigemMercadoria = scanner.next();
                String grp_3_ModalidadaBcICMSST = scanner.next();
                String grp_3_PercentualMargemICMS = scanner.next();
                String grp_3_PercentualReducaoBCICMSST = scanner.next();
                String grp_3_ValorBCICMSST = scanner.next();
                String grp_3_AliquotaICMSST = scanner.next();
                String grp_3_ValorICMSST = scanner.next();
                String grp_3_ValorICMSDesonerado = scanner.next();
                String grp_3_MotivoDesoneracao = scanner.next();
                String grp_4_5_6_OrigemMercadoria = scanner.next();
                String grp_4_5_6_ValorICMS = scanner.next();
                String grp_4_5_6_ModDesoneracao = scanner.next();
                String grp_7_OrigemMercadoria = scanner.next();
                String grp_7_ModalidadaBcICMS = scanner.next();
                String grp_7_BaseCalculoICMS = scanner.next();
                String grp_7_AliquotaICMS = scanner.next();
                String grp_7_ValorICMS = scanner.next();
                String grp_7_PercentualReducaoBCICMS = scanner.next();
                String grp_7_ValorICMSOperacao = scanner.next();
                String grp_7_PercentualDiferimento = scanner.next();
                String grp_7_ValorICMSDiferido = scanner.next();
                String grp_8_OrigemMercadoria = scanner.next();
                String grp_8_ValorBCICMSST = scanner.next();
                String grp_8_ValorICMSST = scanner.next();
                String grp_9_OrigemMercadoria = scanner.next();
                String grp_9_ModalidadaBcICMS = scanner.next();
                String grp_9_BaseCalculoICMS = scanner.next();
                String grp_9_AliquotaICMS = scanner.next();
                String grp_9_ValorICMS = scanner.next();
                String grp_9_PercentualReducaoBCICMS = scanner.next();
                String grp_9_ModalidadaBcICMSST = scanner.next();
                String grp_9_PercentualMargemICMS = scanner.next();
                String grp_9_PercentualReducaoBCICMSST = scanner.next();
                String grp_9_ValorBCICMSST = scanner.next();
                String grp_9_AliquotaICMSST = scanner.next();
                String grp_9_ValorICMSST = scanner.next();
                String grp_9_ValorICMSDesonerado = scanner.next();
                String grp_9_MotivoDesoneracao = scanner.next();
                String grp_10_OrigemMercadoria = scanner.next();
                String grp_10_ModalidadaBcICMS = scanner.next();
                String grp_10_BaseCalculoICMS = scanner.next();
                String grp_10_AliquotaICMS = scanner.next();
                String grp_10_ValorICMS = scanner.next();
                String grp_10_PercentualReducaoBCICMS = scanner.next();
                String grp_10_ModalidadaBcICMSST = scanner.next();
                String grp_10_PercentualMargemICMS = scanner.next();
                String grp_10_PercentualReducaoBCICMSST = scanner.next();
                String grp_10_ValorBCICMSST = scanner.next();
                String grp_10_AliquotaICMSST = scanner.next();
                String grp_10_ValorICMSST = scanner.next();
                String grp_10_ValorICMSDesonerado = scanner.next();
                String grp_10_MotivoDesoneracao = scanner.next();
                if (situacaoTribICMS.equals("0")) {
                    Icmsn00 icms00 = new Icmsn00();
                    icms00.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_0_OrigemMercadoria));
                    icms00.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(grp_0_ModalidadaBcICMS));
                    icms00.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(grp_0_BaseCalculoICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms00.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp_0_AliquotaICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms00.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_0_ValorICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms = icms00;
                }
                if (situacaoTribICMS.equals("1")) {
                    Icmsn10 icms10 = new Icmsn10();
                    icms10.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_1_OrigemMercadoria));
                    icms10.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(grp_1_ModalidadaBcICMS));
                    icms10.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(grp_1_BaseCalculoICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms10.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp_1_AliquotaICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms10.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_1_ValorICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms10.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(grp_1_ModalidadaBcICMSST));
                    icms10.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(grp_1_PercentualMargemICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms10.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp_1_PercentualReducaoBCICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms10.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp_1_ValorBCICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms10.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(grp_1_AliquotaICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms10.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grp_1_ValorICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms = icms10;
                }
                if (situacaoTribICMS.equals("2")) {
                    Icmsn20 icms20 = new Icmsn20();
                    icms20.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_2_OrigemMercadoria));
                    icms20.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(grp_2_ModalidadaBcICMS));
                    icms20.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_BaseCalculoICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms20.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_AliquotaICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms20.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_ValorICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms20.setPercentualReducaoBC(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_PercentualReducaoBCICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms20.setValorICMSDesonerado(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_ValorICMSDesonerado, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms20.setMotivoDesoneracao(br.com.ophos.util.nfe.Util.valueToMotivoDesoneracao(grp_2_MotivoDesoneracao));
                    icms = icms20;
                }
                if (situacaoTribICMS.equals("3")) {
                    Icmsn30 icms30 = new Icmsn30();
                    icms30.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_3_OrigemMercadoria));
                    icms30.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(grp_3_ModalidadaBcICMSST));
                    icms30.setPercentualMargemST(br.com.ophos.util.nfe.Util.StringToDouble(grp_3_PercentualMargemICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms30.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp_3_PercentualReducaoBCICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms30.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp_3_ValorBCICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms30.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(grp_3_AliquotaICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms30.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grp_3_ValorICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms30.setValorICMSDesonerado(br.com.ophos.util.nfe.Util.StringToDouble(grp_3_ValorICMSDesonerado, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms30.setMotivoDesoneracao(br.com.ophos.util.nfe.Util.valueToMotivoDesoneracao(grp_3_MotivoDesoneracao));
                    icms = icms30;
                }
                if (situacaoTribICMS.equals("4") || situacaoTribICMS.equals("5") || situacaoTribICMS.equals("6")) {
                    if (situacaoTribICMS.equals("4")) {
                        Icmsn40 icms40 = new Icmsn40();
                        icms40.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_4_5_6_OrigemMercadoria));
                        icms40.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_4_5_6_ValorICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icms40.setMotivoDesoneracao(br.com.ophos.util.nfe.Util.valueToMotivoDesoneracao(grp_4_5_6_ModDesoneracao));
                        icms = icms40;
                    }
                    if (situacaoTribICMS.equals("5")) {
                        Icmsn41 icms41 = new Icmsn41();
                        icms41.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_4_5_6_OrigemMercadoria));
                        icms41.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_4_5_6_ValorICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icms41.setMotivoDesoneracao(br.com.ophos.util.nfe.Util.valueToMotivoDesoneracao(grp_4_5_6_ModDesoneracao));
                        icms = icms41;
                    }
                    if (situacaoTribICMS.equals("6")) {
                        Icmsn50 icms50 = new Icmsn50();
                        icms50.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_4_5_6_OrigemMercadoria));
                        icms50.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_4_5_6_ValorICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icms50.setMotivoDesoneracao(br.com.ophos.util.nfe.Util.valueToMotivoDesoneracao(grp_4_5_6_ModDesoneracao));
                        icms = icms50;
                    }
                }
                if (situacaoTribICMS.equals("7")) {
                    Icmsn51 icms51 = new Icmsn51();
                    icms51.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_7_OrigemMercadoria));
                    icms51.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(grp_7_ModalidadaBcICMS));
                    icms51.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(grp_7_BaseCalculoICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms51.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp_7_AliquotaICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms51.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_7_ValorICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms51.setPercentualReducaoBC(br.com.ophos.util.nfe.Util.StringToDouble(grp_7_PercentualReducaoBCICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms51.setValorICMSOperacao(br.com.ophos.util.nfe.Util.StringToDouble(grp_7_ValorICMSOperacao, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms51.setPercentualDiferimento(br.com.ophos.util.nfe.Util.StringToDouble(grp_7_PercentualDiferimento, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms51.setValorICMSDiferido(br.com.ophos.util.nfe.Util.StringToDouble(grp_7_ValorICMSDiferido, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms = icms51;
                }
                if (situacaoTribICMS.equals("8")) {
                    Icmsn60 icms60 = new Icmsn60();
                    icms60.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_8_OrigemMercadoria));
                    icms60.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_ValorBCICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms60.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_ValorICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms = icms60;
                }
                if (situacaoTribICMS.equals("9")) {
                    Icmsn70 icms70 = new Icmsn70();
                    icms70.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_9_OrigemMercadoria));
                    icms70.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(grp_9_ModalidadaBcICMS));
                    icms70.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(grp_9_BaseCalculoICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms70.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp_9_AliquotaICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms70.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_9_ValorICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms70.setPercentualReducaoBC(br.com.ophos.util.nfe.Util.StringToDouble(grp_9_PercentualReducaoBCICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms70.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(grp_9_ModalidadaBcICMSST));
                    icms70.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(grp_9_PercentualMargemICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms70.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp_9_PercentualReducaoBCICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms70.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp_9_ValorBCICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms70.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(grp_9_AliquotaICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms70.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grp_9_ValorICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms70.setValorICMSDesonerado(br.com.ophos.util.nfe.Util.StringToDouble(grp_9_ValorICMSDesonerado, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms70.setMotivoDesoneracao(br.com.ophos.util.nfe.Util.valueToMotivoDesoneracao(grp_9_MotivoDesoneracao));
                    icms = icms70;
                }
                if (situacaoTribICMS.equals("10")) {
                    Icmsn90 icms90 = new Icmsn90();
                    icms90.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp_10_OrigemMercadoria));
                    icms90.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(grp_10_ModalidadaBcICMS));
                    icms90.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(grp_10_BaseCalculoICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms90.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp_10_AliquotaICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms90.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_10_ValorICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms90.setPercentualReducaoBC(br.com.ophos.util.nfe.Util.StringToDouble(grp_10_PercentualReducaoBCICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms90.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(grp_10_ModalidadaBcICMSST));
                    icms90.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(grp_10_PercentualMargemICMS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms90.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp_10_PercentualReducaoBCICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms90.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp_10_ValorBCICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms90.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(grp_10_AliquotaICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms90.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grp_10_ValorICMSST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms90.setValorICMSDesonerado(br.com.ophos.util.nfe.Util.StringToDouble(grp_10_ValorICMSDesonerado, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icms90.setMotivoDesoneracao(br.com.ophos.util.nfe.Util.valueToMotivoDesoneracao(grp_10_MotivoDesoneracao));
                    icms = icms90;
                }
                item.setIcms(icms);
                String cM014_NR_CLASSE_IPI = scanner.next();
                String cM014_NR_CNPJ_IPI = scanner.next();
                String cM014_CD_SELO_IPI = scanner.next();
                String cM014_NR_SELO_IPI = scanner.next();
                String cM014_CD_ENQ_IPI = scanner.next();
                String situacaoTribIPI = scanner.next();
                String grpIPIValorBCIPI = scanner.next();
                String grpIPIQuantidadeTotalIPI = scanner.next();
                String grpIPIValorUnidTributavelIPI = scanner.next();
                String grpIPIAliquotaIPI = scanner.next();
                String grpIPIValorIPI = scanner.next();
                if (!situacaoTribIPI.equals("")) {
                    Ipi ipi = null;
                    if (situacaoTribIPI.equals("0") || situacaoTribIPI.equals("6") || situacaoTribIPI.equals("7") || situacaoTribIPI.equals("13")) {
                        IpiTrib ipiTrib = new IpiTrib();
                        ipiTrib.setSituacaoTributaria(br.com.ophos.util.nfe.Util.valueToSituacaoTributariaIPITrib(situacaoTribIPI));
                        ipiTrib.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(grpIPIValorBCIPI, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        ipiTrib.setQuantidadeTotal(br.com.ophos.util.nfe.Util.StringToDouble(grpIPIQuantidadeTotalIPI, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                        ipiTrib.setValorUnidTributavel(br.com.ophos.util.nfe.Util.StringToDouble(grpIPIValorUnidTributavelIPI, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                        ipiTrib.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grpIPIAliquotaIPI, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        ipiTrib.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grpIPIValorIPI, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        if (ipiTrib.getValorBC() != null && ipiTrib.getAliquota() == null) {
                            ipiTrib.setAliquota(Double.parseDouble("0"));
                        }
                        ipi = ipiTrib;
                    } else {
                        Ipint ipiNt = new Ipint();
                        ipiNt.setSituacaoTributaria(br.com.ophos.util.nfe.Util.valueToSituacaoTributariaIPINT(situacaoTribIPI));
                        ipi = ipiNt;
                    }
                    ipi.setClasseEnquadramento(cM014_NR_CLASSE_IPI);
                    ipi.setCnpjProdutor(cM014_NR_CNPJ_IPI);
                    ipi.setCodigoSelo(cM014_CD_SELO_IPI);
                    ipi.setNrSeloIpi(cM014_NR_SELO_IPI);
                    ipi.setCodigoEnquadramento(cM014_CD_ENQ_IPI);
                    item.setIpi(ipi);
                }
                String cM014_VL_BC_IMPOSTO_IMPORT = scanner.next();
                String cM014_VL_DESP_ADUANEIRAS = scanner.next();
                String cM014_VL_IMPOSTO_IMPORT = scanner.next();
                String cM014_VL_IOF = scanner.next();
                if (!cM014_VL_IMPOSTO_IMPORT.equals("")) {
                    Ii ii = new Ii();
                    ii.setValorBCII(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_BC_IMPOSTO_IMPORT, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    ii.setValorDespesasAduaneiras(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_DESP_ADUANEIRAS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    ii.setValorII(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_IMPOSTO_IMPORT, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    ii.setValorIOF(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_IOF, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    item.setIi(ii);
                }
                String situacaoTribPIS = scanner.next();
                Pis pis = null;
                String grp_0_1_ValorBCPIS = scanner.next();
                String grp_0_1_PercentualAliqPIS = scanner.next();
                String grp_0_1_ValorPIS = scanner.next();
                String grp_2_QuantidadeVendidaPIS = scanner.next();
                String grp_2_AliquotaPIS = scanner.next();
                String grp_2_ValorPIS = scanner.next();
                String grp_8_situacaoTribPISOutros = scanner.next();
                String grp_8_ValorBCPIS = scanner.next();
                String grp_8_PercentualAliqPIS = scanner.next();
                String grp_8_QuantidadeVendidaPIS = scanner.next();
                String grp_8_AliquotaPIS = scanner.next();
                String grp_8_ValorPIS = scanner.next();
                if (situacaoTribPIS.equals("0") || situacaoTribPIS.equals("1")) {
                    PisAliq pisAliq = new PisAliq();
                    pisAliq.setSituacaotributaria(br.com.ophos.util.nfe.Util.valueToSituacaoTributariaPISAliq(situacaoTribPIS));
                    pisAliq.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(grp_0_1_ValorBCPIS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pisAliq.setPercentualAliq(br.com.ophos.util.nfe.Util.StringToDouble(grp_0_1_PercentualAliqPIS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pisAliq.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_0_1_ValorPIS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pis = pisAliq;
                }
                if (situacaoTribPIS.equals("2")) {
                    PisQtde pisQtde = new PisQtde();
                    pisQtde.setSituacaotributaria(SituacaoTributariaPISQtde.ST_03);
                    pisQtde.setQuantidadeVendida(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_QuantidadeVendidaPIS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pisQtde.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_AliquotaPIS, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    pisQtde.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_ValorPIS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pis = pisQtde;
                }
                if (situacaoTribPIS.equals("9")) {
                    PisOutros pisOutros = new PisOutros();
                    if (grp_8_situacaoTribPISOutros.equals("49")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_49);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("50")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_50);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("51")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_51);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("52")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_52);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("53")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_53);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("54")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_54);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("55")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_55);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("56")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_56);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("60")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_60);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("61")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_61);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("62")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_62);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("63")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_63);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("64")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_64);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("65")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_65);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("66")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_66);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("67")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_67);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("70")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_70);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("71")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_71);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("72")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_72);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("73")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_73);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("74")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_74);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("75")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_75);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("98")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_98);
                    }
                    if (grp_8_situacaoTribPISOutros.equals("99")) {
                        pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_99);
                    }
                    pisOutros.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_ValorBCPIS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pisOutros.setPercentualAliq(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_PercentualAliqPIS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pisOutros.setQuantidadeVendida(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_QuantidadeVendidaPIS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pisOutros.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_AliquotaPIS, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    pisOutros.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_ValorPIS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pis = pisOutros;
                }
                if (situacaoTribPIS.equals("3") || situacaoTribPIS.equals("4") || situacaoTribPIS.equals("5") || situacaoTribPIS.equals("6") || situacaoTribPIS.equals("7") || situacaoTribPIS.equals("8")) {
                    Pisnt pisNt = new Pisnt();
                    pisNt.setSituacaotributaria(br.com.ophos.util.nfe.Util.valueToSituacaoTributariaPISNT(situacaoTribPIS));
                    pis = pisNt;
                }
                item.setPis(pis);
                String cM014_VL_BC_PIS_ST = scanner.next();
                String cM014_VL_PALIQ_PIS_ST = scanner.next();
                String cM014_VL_QTD_PIS_ST = scanner.next();
                String cM014_VL_RALIQ_PIS_ST = scanner.next();
                String cM014_VL_PIS_ST = scanner.next();
                if (!cM014_VL_PIS_ST.equals("")) {
                    Pisst pisSt = new Pisst();
                    pisSt.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_BC_PIS_ST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pisSt.setValorPercentualAliqST(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_PALIQ_PIS_ST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    pisSt.setQuantidadeST(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_QTD_PIS_ST, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    pisSt.setValorReaisAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_RALIQ_PIS_ST, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    pisSt.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_PIS_ST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    item.setPisst(pisSt);
                }
                String situacaoTribCOFINS = scanner.next();
                Cofins cofins = null;
                String grp_0_1_ValorBCCOFINS = scanner.next();
                String grp_0_1_PercentualAliqCOFINS = scanner.next();
                String grp_0_1_ValorCOFINS = scanner.next();
                String grp_2_QuantidadeVendidaCOFINS = scanner.next();
                String grp_2_PercentualAliqCOFINS = scanner.next();
                String grp_2_ValorAliqCOFINS = scanner.next();
                String grp_8_situacaoTribCFOutros = scanner.next();
                String grp_8_ValorBCCOFINS = scanner.next();
                String grp_8_PercentualAliqCOFINS = scanner.next();
                String grp_8_ValorCOFINS = scanner.next();
                String grp_8_QuantidadeVendidaCOFINS = scanner.next();
                String grp_8_ValorAliqCOFINS = scanner.next();
                if (situacaoTribCOFINS.equals("0") || situacaoTribCOFINS.equals("1")) {
                    CofinsAliq cofinsAliq = new CofinsAliq();
                    cofinsAliq.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(grp_0_1_ValorBCCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    cofinsAliq.setPercentualAliq(br.com.ophos.util.nfe.Util.StringToDouble(grp_0_1_PercentualAliqCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    cofinsAliq.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_0_1_ValorCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    cofinsAliq.setSituacaoTributaria(br.com.ophos.util.nfe.Util.valueToSituacaoTributariaCFAliq(situacaoTribCOFINS));
                    cofins = cofinsAliq;
                }
                if (situacaoTribCOFINS.equals("2")) {
                    CofinsQtde cofinsQtde = new CofinsQtde();
                    cofinsQtde.setQuantidadeVendida(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_QuantidadeVendidaCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    cofinsQtde.setValorAliq(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_PercentualAliqCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    cofinsQtde.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_2_ValorAliqCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    cofinsQtde.setSituacaoTributaria(SituacaoTributariaCFQtde.ST_03);
                    cofins = cofinsQtde;
                }
                if (situacaoTribCOFINS.equals("9")) {
                    CofinsOutros cofinsOutros = new CofinsOutros();
                    if (grp_8_situacaoTribCFOutros.equals("49")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_49);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("50")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_50);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("51")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_51);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("52")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_52);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("53")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_53);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("54")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_54);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("55")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_55);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("56")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_56);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("60")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_60);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("61")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_61);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("62")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_62);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("63")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_63);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("64")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_64);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("65")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_65);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("66")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_66);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("67")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_67);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("70")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_70);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("71")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_71);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("72")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_72);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("73")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_73);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("74")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_74);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("75")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_75);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("98")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_98);
                    }
                    if (grp_8_situacaoTribCFOutros.equals("99")) {
                        cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_99);
                    }
                    cofinsOutros.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_ValorBCCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    cofinsOutros.setPercentualAliq(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_PercentualAliqCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    cofinsOutros.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_ValorCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    cofinsOutros.setQuantidadeVendida(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_QuantidadeVendidaCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    cofinsOutros.setValorAliq(br.com.ophos.util.nfe.Util.StringToDouble(grp_8_ValorAliqCOFINS, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    cofins = cofinsOutros;
                }
                if (situacaoTribCOFINS.equals("3") || situacaoTribCOFINS.equals("4") || situacaoTribCOFINS.equals("5") || situacaoTribCOFINS.equals("6") || situacaoTribCOFINS.equals("7") || situacaoTribCOFINS.equals("8")) {
                    Cofinsnt cofinsNt = new Cofinsnt();
                    cofinsNt.setSituacaoTributaria(br.com.ophos.util.nfe.Util.valueToSituacaoTributariaCFNT(situacaoTribCOFINS));
                    cofins = cofinsNt;
                }
                item.setCofins(cofins);
                String cM014_VL_BC_CF_ST = scanner.next();
                String cM014_VL_PALIQ_CF_ST = scanner.next();
                String cM014_VL_QTD_CF_ST = scanner.next();
                String cM014_VL_ALIQ_CF_ST = scanner.next();
                String cM014_VL_CF_ST = scanner.next();
                if (!cM014_VL_CF_ST.equals("")) {
                    Cofinsst cofinsSt = new Cofinsst();
                    cofinsSt.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_BC_CF_ST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    cofinsSt.setValorPercentualAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_PALIQ_CF_ST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    cofinsSt.setValorQuantidadeST(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_QTD_CF_ST, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    cofinsSt.setValorAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_ALIQ_CF_ST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    cofinsSt.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_CF_ST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    item.setCofinsst(cofinsSt);
                }
                String cM014_VL_BC_ISSQN = scanner.next();
                String cM014_VL_ALIQ_ISSQN = scanner.next();
                String cM014_VL_ISSQN = scanner.next();
                String cM014_NR_IBGE_MUN_ISSQN = scanner.next();
                String cM014_CD_LISTA_SERVICOS = scanner.next();
                String valorDeducao = scanner.next();
                String valorOutro = scanner.next();
                String valorDescontoIncond = scanner.next();
                String valorDescontoCond = scanner.next();
                String valorISSRetido = scanner.next();
                String indicadorISS = scanner.next();
                String codigoServico = scanner.next();
                String codigoMuncipio = scanner.next();
                String codigoPais = scanner.next();
                String nrProcesso = scanner.next();
                String indicadorIncentivo = scanner.next();
                if (!cM014_VL_ISSQN.equals("")) {
                    Issqn issqn = new Issqn();
                    issqn.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_BC_ISSQN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    issqn.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_ALIQ_ISSQN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    issqn.setValor(br.com.ophos.util.nfe.Util.StringToDouble(cM014_VL_ISSQN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    issqn.setNrIbgeMunicipioFG(br.com.ophos.util.nfe.Util.StringToInteger(cM014_NR_IBGE_MUN_ISSQN));
                    issqn.setCodigoListaServicos(cM014_CD_LISTA_SERVICOS);
                    issqn.setValorDeducao(br.com.ophos.util.nfe.Util.StringToDouble(valorDeducao, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    issqn.setValorOutras(br.com.ophos.util.nfe.Util.StringToDouble(valorOutro, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    issqn.setValorDescIncondicionado(br.com.ophos.util.nfe.Util.StringToDouble(valorDescontoIncond, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    issqn.setValorDescCondicionado(br.com.ophos.util.nfe.Util.StringToDouble(valorDescontoCond, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    issqn.setValorISSRetido(br.com.ophos.util.nfe.Util.StringToDouble(valorISSRetido, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    issqn.setTipoISS(br.com.ophos.util.nfe.Util.valueToIndicadorISS(indicadorISS));
                    if (codigoServico != null && !codigoServico.isEmpty()) {
                        issqn.setCodigoServico(codigoServico);
                    }
                    if (codigoMuncipio != null && !codigoMuncipio.isEmpty()) {
                        issqn.setCodigoMuncipio(codigoMuncipio);
                    }
                    if (codigoPais != null && !codigoPais.isEmpty()) {
                        issqn.setCodigoPais(codigoPais);
                    }
                    if (nrProcesso != null && !nrProcesso.isEmpty()) {
                        issqn.setNrProcesso(nrProcesso);
                    }
                    issqn.setIncentivoFiscal(br.com.ophos.util.nfe.Util.valueToIncentivoFiscal(indicadorIncentivo));
                    item.setIssqn(issqn);
                }
                IcmsPartilha icmsPartilha = new IcmsPartilha();
                String grpM014_DM_ORIG_ICMS_P = scanner.next();
                String grpM014_DM_TRIB_ICMS_P = scanner.next();
                String grpM014_DM_MOD_BC_ICMS_P = scanner.next();
                String grpM014_VL_BC_ICMS_P = scanner.next();
                String grpM014_VL_PERC_REDUC_ICMS_P = scanner.next();
                String grpM014_VL_ALIQ_ICMS_P = scanner.next();
                String grpM014_VL_ICMS_P = scanner.next();
                String grpM014_DM_MOD_BC_ST_ICMS_P = scanner.next();
                String grpM014_VL_PERC_MARG_ICMS_P = scanner.next();
                String grpM014_VL_PERC_REDUC_ICMS_ST_P = scanner.next();
                String grpM014_VL_BC_ST_ICMS_P = scanner.next();
                String grpM014_VL_ALIQ_ST_ICMS_P = scanner.next();
                String grpM014_VL_ICMS_ST_P = scanner.next();
                String grpM014_VL_PERC_BC_P = scanner.next();
                String grpM014_DS_UF_ICMST_P = scanner.next();
                if (!grpM014_VL_ICMS_P.trim().equals("")) {
                    icmsPartilha.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grpM014_DM_ORIG_ICMS_P));
                    icmsPartilha.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(grpM014_DM_MOD_BC_ICMS_P));
                    icmsPartilha.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_BC_ICMS_P, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsPartilha.setPercentualReducaoBC(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_PERC_REDUC_ICMS_P, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsPartilha.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_ALIQ_ICMS_P, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsPartilha.setValor(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_ICMS_P, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsPartilha.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(grpM014_DM_MOD_BC_ST_ICMS_P));
                    icmsPartilha.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_PERC_MARG_ICMS_P, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsPartilha.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_PERC_REDUC_ICMS_ST_P, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsPartilha.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_BC_ST_ICMS_P, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsPartilha.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_ALIQ_ST_ICMS_P, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsPartilha.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_ICMS_ST_P, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsPartilha.setValorPercentualBC(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_PERC_BC_P, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsPartilha.setSiglaUfDevido(grpM014_DS_UF_ICMST_P);
                    icmsPartilha.setSituacaoTributaria(br.com.ophos.util.nfe.Util.valueToSituacaoTribIcmsPartilha(grpM014_DM_TRIB_ICMS_P));
                    item.setIcms(icmsPartilha);
                }
                Icmsst icmsst = new Icmsst();
                String grpM014_DM_ORIG_ICMS_RET = scanner.next();
                scanner.next();
                String grpM014_VL_BC_ST_ICMS_RET = scanner.next();
                String grpM014_VL_ICMS_ST_RET = scanner.next();
                String grpM014_VL_BC_ST_ICMS_DEST = scanner.next();
                String grpM014_VL_ICMS_ST_DEST = scanner.next();
                if (!grpM014_VL_ICMS_ST_RET.equals("")) {
                    icmsst.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grpM014_DM_ORIG_ICMS_RET));
                    icmsst.setValorBCSTRetido(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_BC_ST_ICMS_RET, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsst.setValorSTRetido(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_ICMS_ST_RET, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsst.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_BC_ST_ICMS_DEST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsst.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grpM014_VL_ICMS_ST_DEST, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    icmsst.setSituacaoTributaria(SituacaoTributariaICMSST.ST_41);
                    item.setIcms(icmsst);
                }
                String grpM014_DM_TRIB_ICMS_SN = scanner.next();
                String grp0M014_DM_ORIG_ICMS_SN = scanner.next();
                String grp0M014_VL_ALIQ_CRED_SN = scanner.next();
                String grp0M014_VL_CRED_SN = scanner.next();
                String grp2367M014_DM_ORIG_ICMS_SN = scanner.next();
                String grp3M014_DM_ORIG_ICMS_SN = scanner.next();
                String grp3M014_DM_MOD_BC_ST_ICMS_SN = scanner.next();
                String grp3M014_VL_PERC_MARG_ICMS_SN = scanner.next();
                String grp3M014_VL_PERC_REDUC_ICMS_ST_SN = scanner.next();
                String grp3M014_VL_BC_ST_ICMS_SN = scanner.next();
                String grp3M014_VL_ALIQ_ST_ICMS_SN = scanner.next();
                String grp3M014_VL_ICMS_ST_SN = scanner.next();
                String grp3M014_VL_ALIQ_CRED_SN = scanner.next();
                String grp3M014_VL_CRED_SN = scanner.next();
                String grp45M014_DM_ORIG_ICMS_SN = scanner.next();
                String grp45M014_DM_MOD_BC_ST_ICMS_SN = scanner.next();
                String grp45M014_VL_PERC_MARG_ICMS_SN = scanner.next();
                String grp45M014_VL_PERC_REDUC_ICMS_ST_SN = scanner.next();
                String grp45M014_VL_BC_ST_ICMS_SN = scanner.next();
                String grp45M014_VL_ALIQ_ST_ICMS_SN = scanner.next();
                String grp45M014_VL_ICMS_ST_SN = scanner.next();
                String grp8M014_DM_ORIG_ICMS_SN = scanner.next();
                String grp8M014_VL_BC_ST_ICMS_RET_SN = scanner.next();
                String grp8M014_VL_ICMS_ST_RET_SN = scanner.next();
                String grp9M014_DM_ORIG_ICMS_SN = scanner.next();
                String grp9M014_DM_MOD_BC_ICMS_SN = scanner.next();
                String grp9M014_VL_BC_ICMS_SN = scanner.next();
                String grp9M014_VL_PERC_REDUC_ICMS_SN = scanner.next();
                String grp9M014_VL_ALIQ_ICMS_SN = scanner.next();
                String gpr9M014_VL_ICMS_SN = scanner.next();
                String grp9M014_DM_MOD_BC_ST_ICMS_SN = scanner.next();
                String grp9M014_VL_PERC_MARG_ICMS_SN = scanner.next();
                String grp9M014_VL_PERC_REDUC_ICMS_ST_SN = scanner.next();
                String grp9M014_VL_BC_ST_ICMS_SN = scanner.next();
                String grp9M014_VL_ALIQ_ST_ICMS_SN = scanner.next();
                String grp9M014_VL_ICMS_ST_SN = scanner.next();
                String grp9M014_VL_ALIQ_CRED_SN = scanner.next();
                String grp9M014_VL_CRED_SN = scanner.next();
                if (!grpM014_DM_TRIB_ICMS_SN.equals("")) {
                    Icmssn icmssn = null;
                    if (grpM014_DM_TRIB_ICMS_SN.equals("0")) {
                        Icmssn101 icmssn101 = new Icmssn101();
                        icmssn101.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp0M014_DM_ORIG_ICMS_SN));
                        icmssn101.setPercentualAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp0M014_VL_ALIQ_CRED_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn101.setValorCreditoICMS(br.com.ophos.util.nfe.Util.StringToDouble(grp0M014_VL_CRED_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn = icmssn101;
                    }
                    if (grpM014_DM_TRIB_ICMS_SN.equals("1")) {
                        Icmssn102 icmssn102 = new Icmssn102();
                        icmssn102.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp2367M014_DM_ORIG_ICMS_SN));
                        icmssn = icmssn102;
                    }
                    if (grpM014_DM_TRIB_ICMS_SN.equals("2")) {
                        Icmssn103 icmssn103 = new Icmssn103();
                        icmssn103.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp2367M014_DM_ORIG_ICMS_SN));
                        icmssn = icmssn103;
                    }
                    if (grpM014_DM_TRIB_ICMS_SN.equals("6")) {
                        Icmssn300 icmssn300 = new Icmssn300();
                        icmssn300.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp2367M014_DM_ORIG_ICMS_SN));
                        icmssn = icmssn300;
                    }
                    if (grpM014_DM_TRIB_ICMS_SN.equals("7")) {
                        Icmssn400 icmssn400 = new Icmssn400();
                        icmssn400.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp2367M014_DM_ORIG_ICMS_SN));
                        icmssn = icmssn400;
                    }
                    if (grpM014_DM_TRIB_ICMS_SN.equals("3")) {
                        Icmssn201 icmssn201 = new Icmssn201();
                        icmssn201.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp3M014_DM_ORIG_ICMS_SN));
                        icmssn201.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(grp3M014_DM_MOD_BC_ST_ICMS_SN));
                        icmssn201.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(grp3M014_VL_PERC_MARG_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn201.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp3M014_VL_PERC_REDUC_ICMS_ST_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn201.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp3M014_VL_BC_ST_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn201.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp3M014_VL_ALIQ_ST_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn201.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grp3M014_VL_ICMS_ST_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn201.setPercentualAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp3M014_VL_ALIQ_CRED_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn201.setValorCreditoICMS(br.com.ophos.util.nfe.Util.StringToDouble(grp3M014_VL_CRED_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn = icmssn201;
                    }
                    if (grpM014_DM_TRIB_ICMS_SN.equals("4")) {
                        Icmssn202 icmssn202 = new Icmssn202();
                        icmssn202.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp45M014_DM_ORIG_ICMS_SN));
                        icmssn202.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(grp45M014_DM_MOD_BC_ST_ICMS_SN));
                        icmssn202.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(grp45M014_VL_PERC_MARG_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn202.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp45M014_VL_PERC_REDUC_ICMS_ST_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn202.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp45M014_VL_BC_ST_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn202.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(grp45M014_VL_ALIQ_ST_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn202.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grp45M014_VL_ICMS_ST_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn = icmssn202;
                    }
                    if (grpM014_DM_TRIB_ICMS_SN.equals("5")) {
                        Icmssn203 icmssn203 = new Icmssn203();
                        icmssn203.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp45M014_DM_ORIG_ICMS_SN));
                        icmssn203.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(grp45M014_DM_MOD_BC_ST_ICMS_SN));
                        icmssn203.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(grp45M014_VL_PERC_MARG_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn203.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp45M014_VL_PERC_REDUC_ICMS_ST_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn203.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp45M014_VL_BC_ST_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn203.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(grp45M014_VL_ALIQ_ST_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn203.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grp45M014_VL_ICMS_ST_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn = icmssn203;
                    }
                    if (grpM014_DM_TRIB_ICMS_SN.equals("8")) {
                        Icmssn500 icmssn500 = new Icmssn500();
                        icmssn500.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp8M014_DM_ORIG_ICMS_SN));
                        icmssn500.setValorBCRetST(br.com.ophos.util.nfe.Util.StringToDouble(grp8M014_VL_BC_ST_ICMS_RET_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn500.setValorRetST(br.com.ophos.util.nfe.Util.StringToDouble(grp8M014_VL_ICMS_ST_RET_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn = icmssn500;
                    }
                    if (grpM014_DM_TRIB_ICMS_SN.equals("9")) {
                        Icmssn900 icmssn900 = new Icmssn900();
                        icmssn900.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(grp9M014_DM_ORIG_ICMS_SN));
                        icmssn900.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(grp9M014_DM_MOD_BC_ICMS_SN));
                        icmssn900.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(grp9M014_VL_BC_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn900.setPercentualReducaoBC(br.com.ophos.util.nfe.Util.StringToDouble(grp9M014_VL_PERC_REDUC_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn900.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp9M014_VL_ALIQ_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn900.setValor(br.com.ophos.util.nfe.Util.StringToDouble(gpr9M014_VL_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn900.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(grp9M014_DM_MOD_BC_ST_ICMS_SN));
                        icmssn900.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(grp9M014_VL_PERC_MARG_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn900.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp9M014_VL_PERC_REDUC_ICMS_ST_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn900.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(grp9M014_VL_BC_ST_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn900.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(grp9M014_VL_ALIQ_ST_ICMS_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn900.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(grp9M014_VL_ICMS_ST_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn900.setPercentualAliquota(br.com.ophos.util.nfe.Util.StringToDouble(grp9M014_VL_ALIQ_CRED_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn900.setValorCredito(br.com.ophos.util.nfe.Util.StringToDouble(grp9M014_VL_CRED_SN, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        icmssn = icmssn900;
                    }
                    item.setIcms(icmssn);
                }
                item.setObservacao(scanner.next().trim());
                item.setValorAproximadoTributo(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                item.setnFCI(scanner.next());
                String percentualDevolvido = scanner.next();
                String valorIPIDevolvido = scanner.next();
                if (percentualDevolvido == null || percentualDevolvido.isEmpty()) continue;
                item.setInfoDevolucao(new Devolucao());
                item.getInfoDevolucao().setPercentualMercadoria(br.com.ophos.util.nfe.Util.StringToDouble(percentualDevolvido, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                item.getInfoDevolucao().setValorIPI(br.com.ophos.util.nfe.Util.StringToDouble(valorIPIDevolvido, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
            }
            this.obj.getItens().add(item);
            scanner.close();
        }
        catch (ParseException | NumberFormatException ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 14." + ex.getMessage());
        }
    }

    private void Veiculo(String aLine) throws ParseException {
        try {
            Integer totalCampos = 25;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != totalCampos) {
                throw new ParseException("A linha 015 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Veiculo veiculo = new Veiculo();
            Integer nrItem = 0;
            while (scanner.hasNext()) {
                scanner.next();
                nrItem = br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim());
                veiculo.setTipoOperacao(br.com.ophos.util.nfe.Util.valueToTipoOperacao(scanner.next().trim()));
                veiculo.setChassi(scanner.next().trim());
                veiculo.setCor(scanner.next().trim());
                veiculo.setDescricaoCor(scanner.next().trim());
                veiculo.setPotencia(scanner.next().trim());
                veiculo.setCm3(scanner.next().trim());
                veiculo.setPesoLiquido(scanner.next().trim());
                veiculo.setPesoBruto(scanner.next().trim());
                veiculo.setSerie(scanner.next().trim());
                veiculo.setTipoCombustivel(scanner.next().trim());
                veiculo.setNumeroMotor(scanner.next().trim());
                veiculo.setCmkg(scanner.next().trim());
                veiculo.setDistanciaEixo(scanner.next().trim());
                veiculo.setAnoModeloFabricacao(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                veiculo.setAnoFabricacao(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                veiculo.setTipoPintura(scanner.next().trim());
                veiculo.setTipoVeiculo(br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim()));
                veiculo.setEspecie(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                veiculo.setVin(br.com.ophos.util.nfe.Util.valueToVinVeiculo(scanner.next().trim()));
                veiculo.setCondicaoVeiculo(br.com.ophos.util.nfe.Util.valueToCondicaoVeiculo(scanner.next().trim()));
                veiculo.setModelo(scanner.next().trim());
                veiculo.setNrCor(scanner.next().trim());
                veiculo.setCapacidadeLotacao(scanner.next().trim());
                veiculo.setTipoRestricao(br.com.ophos.util.nfe.Util.valueToTipoRestricao(scanner.next().trim()));
            }
            this.GetItem(nrItem).setVeiculo(veiculo);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 15." + ex.getMessage());
        }
    }

    private void Armamento(String aLine) throws ParseException {
        try {
            Integer totalCampos = 5;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 017 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Armamento armamento = new Armamento();
            Integer nrItem = 0;
            while (scanner.hasNext()) {
                scanner.next();
                nrItem = br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim());
                armamento.setTipoArma(br.com.ophos.util.nfe.Util.valueToTipoArma(scanner.next().trim()));
                armamento.setNrSerie(br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim()));
                armamento.setSerieCano(br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim()));
                armamento.setDescricao(scanner.next().trim());
            }
            this.GetItem(nrItem).getArmamentos().add(armamento);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 16." + ex.getMessage());
        }
    }

    private void Medicamento(String aLine) throws ParseException {
        try {
            Integer totalCampos = 6;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|");
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 017 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Medicamento medicamento = new Medicamento();
            Integer nrItem = 0;
            while (scanner.hasNext()) {
                scanner.next();
                nrItem = br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim());
                medicamento.setNrLote(scanner.next().trim());
                medicamento.setQuantidadeLote(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_TRES_DECIMAIS));
                medicamento.setDataFabricacao(Util.parseData(scanner.next().trim(), Util.FMTYYYYMMDDHHMMSS));
                medicamento.setDataValidade(Util.parseData(scanner.next().trim(), Util.FMTYYYYMMDDHHMMSS));
                medicamento.setPrecoMaximo(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
            }
            this.GetItem(nrItem).getMedicamento().add(medicamento);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 17." + ex.getMessage());
        }
    }

    protected void Combustivel(String aLine) throws ParseException {
        try {
            Integer totalCampos = 9;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 018 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Combustivel combustivel = new Combustivel();
            Integer nrItem = 0;
            while (scanner.hasNext()) {
                scanner.next();
                nrItem = br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim());
                combustivel.setNrProdAnp(scanner.next().trim());
                combustivel.setNrCodif(scanner.next().trim());
                combustivel.setQtCombTemp(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                combustivel.setUfCon(scanner.next().trim());
                combustivel.setPercentualGas(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next().trim(), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                combustivel.setValorBcCide(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                combustivel.setValorAliqCide(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                combustivel.setValorCide(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
            }
            this.GetItem(nrItem).setCombustivel(combustivel);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 18." + ex.getMessage());
        }
    }

    private void DocImportacao(String aLine) throws ParseException {
        try {
            Integer totalCampos = 12;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 019 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Di di = new Di();
            Integer nrItem = 0;
            while (scanner.hasNext()) {
                scanner.next();
                nrItem = br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim());
                di.setNrDocumento(scanner.next().trim());
                di.setDataRegistro(Util.parseData(scanner.next().trim(), Util.FMTYYYYMMDDHHMMSS));
                di.setLocalDesembaraco(scanner.next().trim());
                di.setUf(scanner.next().trim());
                di.setDataDesembaraco(Util.parseData(scanner.next().trim(), Util.FMTYYYYMMDDHHMMSS));
                di.setCodigoExportador(scanner.next().trim());
                di.setTipoVia(br.com.ophos.util.nfe.Util.valueToViaTransporte(scanner.next().trim()));
                di.setValorAFRMM(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                di.setTipoIntermedio(br.com.ophos.util.nfe.Util.valueToTipoIntermedio(scanner.next().trim()));
                di.setCnpjCpf(scanner.next());
                di.setUfTerceiro(scanner.next());
            }
            this.GetItem(nrItem).getDi().add(di);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 19." + ex.getMessage());
        }
    }

    private void DocAdicao(String aLine) throws ParseException {
        try {
            Integer totalCampos = 7;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 020 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Adicao adicao = new Adicao();
            String nrDi = "";
            Integer nrItem = 0;
            while (scanner.hasNext()) {
                String nDraw;
                scanner.next();
                nrItem = br.com.ophos.util.nfe.Util.StringToInteger(scanner.next());
                nrDi = scanner.next();
                adicao.setNrAdicao(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                adicao.setNrSeq(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                adicao.setFabricante(scanner.next().trim());
                String vDesc = scanner.next();
                if (!vDesc.equals("")) {
                    adicao.setValorDesconto(br.com.ophos.util.nfe.Util.StringToDouble(vDesc, br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if ((nDraw = scanner.next()) == null || nDraw.isEmpty()) continue;
                adicao.setNrDraw(nDraw);
            }
            this.GetDi(nrItem, nrDi).getAdicoes().add(adicao);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 20." + ex.getMessage());
        }
    }

    private void ChaveRef(String aLine) throws ParseException {
        try {
            Integer totalCampos = 20;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 013 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            ChaveReferenciada chaveRef = null;
            while (scanner.hasNext()) {
                scanner.next();
                String cM013_DM_CHAVE_REF = scanner.next();
                String chaveAcessoNFe = scanner.next();
                if (cM013_DM_CHAVE_REF.equals("0")) {
                    RefNFe refNFe = new RefNFe();
                    refNFe.setChaveAcessoRef(chaveAcessoNFe);
                    chaveRef = refNFe;
                }
                String nrCnpjNF = scanner.next();
                String nrModeloNF = scanner.next();
                String nrIbgeNf = scanner.next();
                String nrSerieNF = scanner.next();
                String nrDocumentoNF = scanner.next();
                String dataEmissaoNF = scanner.next();
                if (cM013_DM_CHAVE_REF.equals("1")) {
                    RefNF refNf = new RefNF();
                    refNf.setNrCnpj(nrCnpjNF);
                    refNf.setNrModelo(nrModeloNF);
                    refNf.setNrIbgeUf(br.com.ophos.util.nfe.Util.StringToShort(nrIbgeNf));
                    refNf.setNrSerie(br.com.ophos.util.nfe.Util.StringToShort(nrSerieNF));
                    refNf.setNrDocumento(br.com.ophos.util.nfe.Util.StringToInteger(nrDocumentoNF));
                    if (!dataEmissaoNF.equals("")) {
                        refNf.setDataEmissao(br.com.ophos.util.nfe.Util.StringToDate("20" + dataEmissaoNF + "01"));
                    }
                    chaveRef = refNf;
                }
                String nrIbgeNFP = scanner.next();
                String dataEmissaoNFP = scanner.next();
                String nrCnpjNFP = scanner.next();
                String nrCpfNFP = scanner.next();
                String nrIeNFP = scanner.next();
                String nrModeloNFP = scanner.next();
                String nrSerieNFP = scanner.next();
                String nrDocumentoNFP = scanner.next();
                if (cM013_DM_CHAVE_REF.equals("2")) {
                    RefNFP refNfp = new RefNFP();
                    refNfp.setNrIbgeUf(br.com.ophos.util.nfe.Util.StringToShort(nrIbgeNFP));
                    refNfp.setDataEmissao(br.com.ophos.util.nfe.Util.StringToDate("20" + dataEmissaoNFP + "01"));
                    refNfp.setNrCnpjCpf(!nrCnpjNFP.isEmpty() ? nrCnpjNFP : nrCpfNFP);
                    refNfp.setNrIe(nrIeNFP);
                    refNfp.setNrModelo(nrModeloNFP);
                    refNfp.setNrSerie(br.com.ophos.util.nfe.Util.StringToShort(nrSerieNFP));
                    refNfp.setNrDocumento(br.com.ophos.util.nfe.Util.StringToInteger(nrDocumentoNFP));
                    chaveRef = refNfp;
                }
                String nrChaveAcessoCTe = scanner.next();
                if (cM013_DM_CHAVE_REF.equals("3")) {
                    RefCTe refCte = new RefCTe();
                    refCte.setChaveAcessoRefCte(nrChaveAcessoCTe);
                    chaveRef = refCte;
                }
                String nrModeloECF = scanner.next();
                String nrSeqECF = scanner.next();
                String nrCOOECF = scanner.next();
                if (!cM013_DM_CHAVE_REF.equals("4")) continue;
                RefECF refECF = new RefECF();
                refECF.setNrModelo(nrModeloECF);
                refECF.setNrSeqECF(br.com.ophos.util.nfe.Util.StringToShort(nrSeqECF));
                refECF.setNrCOOECF(br.com.ophos.util.nfe.Util.StringToInteger(nrCOOECF));
                chaveRef = refECF;
            }
            this.obj.getChavesReferenciadas().add(chaveRef);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 13." + ex.getMessage());
        }
    }

    private void RegistroCana(String aLine) throws ParseException {
        try {
            Integer totalCampos = 8;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 021 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            RegistroCana registroCana = new RegistroCana();
            while (scanner.hasNext()) {
                scanner.next();
                registroCana.setIdentificacaoSafra(scanner.next().trim());
                registroCana.setReferenciaAnoMes(scanner.next().trim());
                registroCana.setQtdeFornecimentoMes(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DEZ_DECIMAIS));
                registroCana.setQtdeFornecimentoAnterior(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DEZ_DECIMAIS));
                registroCana.setQtdeFornecimentoTotal(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DEZ_DECIMAIS));
                registroCana.setValorFornecimento(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                registroCana.setValorTotal(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                registroCana.setValorLiquido(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
            }
            this.obj.setRegistroCana(registroCana);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 21." + ex.getMessage());
        }
    }

    private void FornecimentoDiarioCana(String aLine) throws ParseException {
        try {
            Integer totalCampos = 2;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 022 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            FornecimentoDiario fornecimento = new FornecimentoDiario();
            while (scanner.hasNext()) {
                scanner.next();
                fornecimento.setNrDia(br.com.ophos.util.nfe.Util.StringToShort(scanner.next().trim()));
                fornecimento.setQtdeFornecimento(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DEZ_DECIMAIS));
            }
            this.obj.getRegistroCana().getFornecimentoDiario().add(fornecimento);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 22." + ex.getMessage());
        }
    }

    private void DeducaoCana(String aLine) throws ParseException {
        try {
            Integer totalCampos = 2;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 023 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            DeducaoCana deducao = new DeducaoCana();
            while (scanner.hasNext()) {
                scanner.next();
                deducao.setDescricao(scanner.next().trim());
                deducao.setValor(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
            }
            this.obj.getRegistroCana().getDeducaoCana().add(deducao);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 23." + ex.getMessage());
        }
    }

    private void DetExportacaoItem(String aLine) throws ParseException {
        try {
            Integer totalCampos = 5;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 024 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            InfoExportacao infoExportacao = new InfoExportacao();
            Integer nrItem = 0;
            while (scanner.hasNext()) {
                scanner.next();
                nrItem = br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim());
                String nrDraw = scanner.next();
                String nrRe = scanner.next();
                String chaveAcesso = scanner.next();
                String qtdExportacao = scanner.next();
                if (nrDraw != null && !nrDraw.isEmpty()) {
                    infoExportacao.setNrDraw(nrDraw);
                }
                if (nrRe == null || nrRe.isEmpty()) continue;
                infoExportacao.setNrRE(nrRe);
                infoExportacao.setChaveAcesso(chaveAcesso);
                infoExportacao.setQuantidade(br.com.ophos.util.nfe.Util.StringToDouble(qtdExportacao, br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
            }
            this.GetItem(nrItem).getInfoExportacao().add(infoExportacao);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 24." + ex.getMessage());
        }
    }

    private void DetPapelImune(String aLine) throws ParseException {
        try {
            Integer totalCampos = 2;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 025 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            Integer nrItem = 0;
            while (scanner.hasNext()) {
                scanner.next();
                nrItem = br.com.ophos.util.nfe.Util.StringToInteger(scanner.next().trim());
                String nrRECOPI = scanner.next();
                this.GetItem(nrItem).setNrRECOPI(nrRECOPI);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 25." + ex.getMessage());
        }
    }

    private void InfoProcRef(String aLine) throws ParseException {
        try {
            Integer totalCampos = 2;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 026 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                ProcessoReferenciado pr = new ProcessoReferenciado();
                pr.setNrProcesso(scanner.next());
                pr.setTipo(br.com.ophos.util.nfe.Util.valueToOrigemProcesso(scanner.next()));
                this.obj.getProcessos().add(pr);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 26." + ex.getMessage());
        }
    }

    private void AutorizacaoXML(String aLine) throws ParseException {
        try {
            Integer totalCampos = 1;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 027 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            if (this.obj.getAutorizados() == null) {
                this.obj.setAutorizados(new AutorizacaoXML());
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.getAutorizados().getNrCnpjCpf().add(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 27." + ex.getMessage());
        }
    }

    protected void FormaPagamentoNFCe(String aLine) throws ParseException {
        try {
            Integer totalCampos = 5;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (!qtdCampos.equals(totalCampos)) {
                throw new ParseException("A linha 028 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + totalCampos.toString() + " campos.");
            }
            while (scanner.hasNext()) {
                InfoPagamento info = new InfoPagamento();
                scanner.next();
                info.setTipoPagamento(br.com.ophos.util.nfe.Util.valueToTipoPagamento(scanner.next()));
                info.setValor(br.com.ophos.util.nfe.Util.StringToDouble(scanner.next(), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                String cnpj = scanner.next();
                if (cnpj != null && !cnpj.isEmpty()) {
                    info.setCnpjCredenciadoraCartao(cnpj);
                    info.setTipoBandeira(br.com.ophos.util.nfe.Util.valueToTipoBandeira(scanner.next()));
                    info.setNrAutorizacao(scanner.next());
                } else {
                    scanner.next();
                    scanner.next();
                }
                this.obj.getInfoPagamento().add(info);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 28." + ex.getMessage());
        }
    }

    protected static String retiraCaracteres2(String str) {
        if (str != null) {
            String[] strAcentuada = new String[]{"\u00e7", "\u00c7", "\u00e1", "\u00c1", "\u00e3", "\u00c3", "\u00e9", "\u00c9", "\u00ed", "\u00cd", "\u00f3", "\u00d3", "\u00f4", "\u00d4", "\u00f5", "\u00d5", "\u00fa", "\u00da", "\u00ba", "&", "#13", "\u00ea", "\u00ca", "\u00a7", "\u00aa", "\u00c2", "\u00c4", "\u00dc", "\u00b4", "\u00b0", "\u00bf", "\u00e2", "\u00d8", "`", "\u00c0", "\u00d1", "\u00f1", "\u00e0", "\u20ac", "\u00b5", "\u00c5", "\u2021", "\u2013", "\u00a6", "\u00f9", "\u00d9", "\u00af", "\u00b2", "\u00b3"};
            List<String> lsAcentuada = Arrays.asList(strAcentuada);
            String[] strTrocada = new String[]{"c", "C", "a", "A", "a", "A", "e", "e", "i", "I", "o", "O", "o", "O", "o", "O", "u", "U", ".", " ", " ", "e", "E", " ", " ", "A", "A", "U", " ", " ", " ", "a", "d", " ", "A", "N", "n", "a", " ", " ", "I", " ", " ", " ", "u", "U", " ", "2", "3"};
            List<String> lsTrocada = Arrays.asList(strTrocada);
            Object words = str;
            for (int i = 0; i < ((String)words).length(); ++i) {
                char letra = ((String)words).charAt(i);
                String sLetra = String.valueOf(letra);
                if (lsAcentuada.indexOf(sLetra) == -1) continue;
                words = ((String)words).substring(0, i) + lsTrocada.get(lsAcentuada.indexOf(sLetra)) + ((String)words).substring(i + 1, ((String)words).length());
            }
            return ((String)words).trim();
        }
        return str;
    }

    protected Item GetItem(Integer nrItem) {
        for (Item item : this.obj.getItens()) {
            if (!item.getNrItem().equals(nrItem)) continue;
            return item;
        }
        return null;
    }

    private Di GetDi(Integer nrItem, String nrDi) {
        Item item = this.GetItem(nrItem);
        for (Di di : item.getDi()) {
            if (!di.getNrDocumento().equals(nrDi)) continue;
            return di;
        }
        return null;
    }

    private Volume GetVolume(String nrVolume) {
        for (Volume volume : this.obj.getTransportadora().getVolume()) {
            if (!volume.getIdentificacao().equals(nrVolume)) continue;
            return volume;
        }
        return null;
    }

    public String getCaracQuebraLinha() {
        return this.caracQuebraLinha;
    }
}

