/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.parse.nfe.xml.v1;

import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Adicao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Armamento;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.ChaveReferenciada;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Cofins;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.CofinsAliq;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.CofinsOutros;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.CofinsQtde;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Cofinsnt;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Cofinsst;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Combustivel;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.CondicaoVeiculo;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Destinatario;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Di;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Duplicata;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Emitente;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Fatura;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.FinalidadeEmissao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.IcmsProprioST;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn00;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn10;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn20;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn30;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn40;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn41;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn50;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn51;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn60;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn70;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Icmsn90;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Ii;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Info;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.InfoContribuinte;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.InfoFisco;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Ipi;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.IpiTrib;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Ipint;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Issqn;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Item;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Lacre;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Local;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalEntrega;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalRetirada;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Medicamento;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.NF;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Pis;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.PisAliq;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.PisOutros;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.PisQtde;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Pisnt;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Pisst;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Reboque;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RefNF;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RefNFe;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaCFAliq;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaCFNT;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaCFOutros;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaCFQtde;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaIPINT;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaIPITrib;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaPISAliq;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaPISNT;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaPISOutros;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaPISQtde;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Totais;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Transportadora;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Veiculo;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Volume;
import br.com.ophos.integracao.parse.nfe.xml.factory.ParseXMLFactory;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.TNFe;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.TVeiculo;
import br.com.ophos.parse.ParseException;
import br.com.ophos.util.FormatoImpressao;
import br.com.ophos.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class ParseXMLEnvioNFE
extends ParseXMLFactory {
    private NF obj = null;
    private String caracQuebraLinha;
    private static ParseXMLEnvioNFE instance;

    public ParseXMLEnvioNFE(String charQuebraLinha) {
        this.caracQuebraLinha = charQuebraLinha;
    }

    public static ParseXMLEnvioNFE getInstance(String charQuebraLinha) {
        if (instance == null) {
            instance = new ParseXMLEnvioNFE(charQuebraLinha);
        }
        return instance;
    }

    public static String retiraCaracteres(String str) {
        if (str != null) {
            String[] strAcentuada = new String[]{"\u00e7", "\u00c7", "\u00e1", "\u00c1", "\u00e3", "\u00c3", "\u00e9", "\u00c9", "\u00ed", "\u00cd", "\u00f3", "\u00d3", "\u00f4", "\u00d4", "\u00f5", "\u00d5", "\u00fa", "\u00da", "\u00ba", "&", "#13", "\u00ea", "\u00ca", "\u00a7", "\u00aa", "\u00c2", "\u00c4", "\u00dc", "\u00b4", "\u00b0", "\u00bf", "\u00e2", "\u00d8", "`", "\u00c0", "\u00d1", "\u00f1", "\u00e0", "\u20ac", "\u00b5", "\u00c5", "\u2021", "\u2013", "\u00a6", "\u00f9", "\u00d9", "\u00af", "\u00b2", "\u00b3"};
            List<String> lsAcentuada = Arrays.asList(strAcentuada);
            String[] strTrocada = new String[]{"c", "C", "a", "A", "a", "A", "e", "e", "i", "I", "o", "O", "o", "O", "o", "O", "u", "U", ".", " ", " ", "e", "E", " ", " ", "A", "A", "U", " ", " ", " ", "a", "d", " ", "A", "N", "n", "a", " ", " ", "I", " ", " ", " ", "u", "U", " ", "2", "3"};
            List<String> lsTrocada = Arrays.asList(strTrocada);
            Object words = str;
            for (int i = 0; i < ((String)words).length(); ++i) {
                char letra = ((String)words).charAt(i);
                String sLetra = String.valueOf(letra);
                if (lsAcentuada.indexOf(sLetra) == -1) continue;
                words = ((String)words).substring(0, i) + lsTrocada.get(lsAcentuada.indexOf(sLetra)) + ((String)words).substring(i + 1, ((String)words).length());
            }
            return ((String)words).trim();
        }
        return str;
    }

    private InputStream GetInputStream(byte[] xml) {
        String retorno = "";
        try {
            String arquivoXML = new String(xml);
            Integer inicio = arquivoXML.indexOf("<infNFe ", 0);
            Integer fim = arquivoXML.indexOf("</infNFe>", 0) + 9;
            retorno = arquivoXML.substring(inicio, fim);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ByteArrayInputStream(retorno.getBytes());
    }

    @Override
    public NF parse(JAXBContext ctx, byte[] xml) throws ParseException {
        InputStream in = this.GetInputStream(xml);
        try {
            Local local;
            this.obj = new NF();
            Unmarshaller um = ctx.createUnmarshaller();
            TNFe.InfNFe objXML = (TNFe.InfNFe)um.unmarshal(in);
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyyMMddHHmmss");
            if (objXML.getIde() != null) {
                this.obj.setNrReferencia(objXML.getIde().getChaveOrigem());
                if (objXML.getId() != null) {
                    if (objXML.getId().toLowerCase().startsWith("nfe")) {
                        this.obj.setNrChaveAcesso(objXML.getId().substring(3, 47));
                    } else {
                        this.obj.setNrChaveAcesso(objXML.getId().substring(0, 44));
                    }
                }
                if (this.obj.getEmitente() == null) {
                    this.obj.setEmitente(new Emitente());
                }
                if (objXML.getEmit() != null) {
                    this.obj.getEmitente().setNrIbgeUf(Short.valueOf(objXML.getIde().getCUF()));
                }
                this.obj.setNaturezaOperacao(objXML.getIde().getNatOp());
                if (objXML.getIde().getSerie() != null) {
                    this.obj.setSerie(Short.valueOf(objXML.getIde().getSerie()));
                }
                if (objXML.getIde().getNNF() != null) {
                    this.obj.setNumeroDocumentoFiscal(br.com.ophos.util.nfe.Util.StringToInteger(objXML.getIde().getNNF()));
                }
                if (objXML.getIde().getDEmi() != null) {
                    this.obj.setDataEmissao(objXML.getIde().getDEmi().toGregorianCalendar().toZonedDateTime().toLocalDateTime());
                }
                if (objXML.getIde().getDSaiEnt() != null) {
                    this.obj.setDataEntradaSaida(objXML.getIde().getDSaiEnt().toGregorianCalendar().toZonedDateTime().toLocalDateTime());
                }
                this.obj.setTipoDocumento(br.com.ophos.util.nfe.Util.valueToTipoDocumento(objXML.getIde().getTpNF()));
                if (!objXML.getIde().getCMunFG().equals("")) {
                    this.obj.setNrIbgeMunicipioFatoGerador(br.com.ophos.util.nfe.Util.StringToInteger(objXML.getIde().getCMunFG()));
                }
                if (objXML.getIde().getChaveOrigem() != null) {
                    this.obj.setFinalidadeEmissao(br.com.ophos.util.nfe.Util.valueToFinalidadeEmissao(objXML.getIde().getFinNFe()));
                } else {
                    this.obj.setFinalidadeEmissao(ParseXMLEnvioNFE.valueToFinalidadeEmissao(objXML.getIde().getFinNFe()));
                    this.obj.setNrReferencia(objXML.getIde().getNrrefsis());
                }
            } else {
                throw new ParseException("N\u00e3o foi encontrada a TAG IDE (Informa\u00e7\u00f5es da NFe) ");
            }
            if (objXML.getTotal().getICMSTot() != null) {
                this.obj.setTotais(new Totais());
                this.obj.getTotais().setBaseCalculoICMS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorICMS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setBaseCalculoICMSST(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVBCST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorICMSST(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorProdutoServico(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorFrete(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVFrete().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorSeguro(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVSeg().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorDesconto(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVDesc().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorII(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVII().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorIPI(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVIPI().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorPIS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVPIS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorCOFINS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVCOFINS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorOutros(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVOutro().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorNF(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getICMSTot().getVNF().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (objXML.getTotal().getISSQNtot() != null) {
                if (objXML.getTotal().getISSQNtot().getVServ() != null) {
                    this.obj.getTotais().setValorServico(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getISSQNtot().getVServ().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (objXML.getTotal().getISSQNtot().getVBC() != null) {
                    this.obj.getTotais().setBaseCalculoISS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getISSQNtot().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (objXML.getTotal().getISSQNtot().getVISS() != null) {
                    this.obj.getTotais().setValorISS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getISSQNtot().getVISS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (objXML.getTotal().getISSQNtot().getVPIS() != null) {
                    this.obj.getTotais().setValorPISISS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getISSQNtot().getVPIS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (objXML.getTotal().getISSQNtot().getVCOFINS() != null) {
                    this.obj.getTotais().setValorCOFINSISS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getISSQNtot().getVCOFINS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
            }
            if (objXML.getTotal().getRetTrib() != null) {
                if (objXML.getTotal().getRetTrib().getVRetPIS() != null) {
                    this.obj.getTotais().setValorRetidoPIS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getRetTrib().getVRetPIS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (objXML.getTotal().getRetTrib().getVRetCOFINS() != null) {
                    this.obj.getTotais().setValorRetidoCOFINS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getRetTrib().getVRetCOFINS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (objXML.getTotal().getRetTrib().getVRetCSLL() != null) {
                    this.obj.getTotais().setValorRetidoCSLL(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getRetTrib().getVRetCSLL().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (objXML.getTotal().getRetTrib().getVBCIRRF() != null) {
                    this.obj.getTotais().setBaseCalculoIRRPF(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getRetTrib().getVBCIRRF().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (objXML.getTotal().getRetTrib().getVIRRF() != null) {
                    this.obj.getTotais().setValorRetidoIRRF(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getRetTrib().getVIRRF().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (objXML.getTotal().getRetTrib().getVBCRetPrev() != null) {
                    this.obj.getTotais().setBaseCalculoPrevidencia(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getRetTrib().getVBCRetPrev().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (objXML.getTotal().getRetTrib().getVRetPrev() != null) {
                    this.obj.getTotais().setValorRetidoPrevidencia(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTotal().getRetTrib().getVRetPrev().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                }
            }
            if (objXML.getInfAdic() != null) {
                this.obj.setInfoFisco(Util.adicionarQuebraLinha(objXML.getInfAdic().getInfAdFisco(), this.caracQuebraLinha));
                this.obj.setInfoContribuinte(Util.adicionarQuebraLinha(objXML.getInfAdic().getInfCpl(), this.caracQuebraLinha));
            }
            if (objXML.getExporta() != null) {
                this.obj.getExportacao().setUfEmbarque(objXML.getExporta().getUFEmbarq().value());
                this.obj.getExportacao().setLocalEmbarque(objXML.getExporta().getXLocEmbarq());
            }
            if (objXML.getCompra() != null) {
                this.obj.getCompras().setNotaEmpenho(objXML.getCompra().getXNEmp());
                this.obj.getCompras().setNumeroPedido(objXML.getCompra().getXPed());
                this.obj.getCompras().setNumeroContrato(objXML.getCompra().getXCont());
            }
            if (objXML.getIde().getNFref() != null) {
                for (TNFe.InfNFe.Ide.NFref nFref : objXML.getIde().getNFref()) {
                    ChaveReferenciada chaveRef = null;
                    if (nFref.getRefNF() != null) {
                        RefNF refNf = new RefNF();
                        refNf.setNrCnpj(nFref.getRefNF().getCNPJ());
                        refNf.setNrModelo(nFref.getRefNF().getMod());
                        refNf.setNrIbgeUf(br.com.ophos.util.nfe.Util.StringToShort(nFref.getRefNF().getCUF()));
                        refNf.setNrSerie(br.com.ophos.util.nfe.Util.StringToShort(nFref.getRefNF().getSerie()));
                        refNf.setDataEmissao(br.com.ophos.util.nfe.Util.StringToDate("20" + nFref.getRefNF().getAAMM() + "01"));
                        if (!nFref.getRefNF().getNNF().equals("")) {
                            refNf.setNrDocumento(br.com.ophos.util.nfe.Util.StringToInteger(nFref.getRefNF().getNNF()));
                        }
                        chaveRef = refNf;
                    }
                    if (nFref.getRefNFe() != null) {
                        RefNFe refNfe = new RefNFe();
                        refNfe.setChaveAcessoRef(nFref.getRefNFe());
                        chaveRef = refNfe;
                    }
                    this.obj.getChavesReferenciadas().add(chaveRef);
                }
            }
            if (objXML.getEmit() != null) {
                this.obj.getEmitente().setNrCnpj(objXML.getEmit().getCNPJ());
                this.obj.getEmitente().setRazaoSocial(objXML.getEmit().getXNome());
                this.obj.getEmitente().setNomeFantasia(objXML.getEmit().getXFant());
                this.obj.getEmitente().setLogradouro(objXML.getEmit().getEnderEmit().getXLgr());
                this.obj.getEmitente().setNumeroLogradouro(objXML.getEmit().getEnderEmit().getNro());
                this.obj.getEmitente().setComplemento(objXML.getEmit().getEnderEmit().getXCpl());
                this.obj.getEmitente().setBairro(objXML.getEmit().getEnderEmit().getXBairro());
                this.obj.getEmitente().setNrIbgeMunicipio(br.com.ophos.util.nfe.Util.StringToInteger(objXML.getEmit().getEnderEmit().getCMun()));
                this.obj.getEmitente().setNomeMunicipio(objXML.getEmit().getEnderEmit().getXMun());
                this.obj.getEmitente().setUf(objXML.getEmit().getEnderEmit().getUF().value());
                this.obj.getEmitente().setCep(objXML.getEmit().getEnderEmit().getCEP());
                this.obj.getEmitente().setNrPais(br.com.ophos.util.nfe.Util.StringToShort(objXML.getEmit().getEnderEmit().getCPais()));
                this.obj.getEmitente().setNomePais(objXML.getEmit().getEnderEmit().getXPais());
                this.obj.getEmitente().setTelefone(objXML.getEmit().getEnderEmit().getFone());
                this.obj.getEmitente().setIe(objXML.getEmit().getIE());
                this.obj.getEmitente().setIeSt(objXML.getEmit().getIEST());
                this.obj.getEmitente().setIm(objXML.getEmit().getIM());
                this.obj.getEmitente().setCnae(objXML.getEmit().getCNAE());
            }
            if (objXML.getDest() != null) {
                this.obj.setDestinatario(new Destinatario());
                if (objXML.getDest().getCNPJ() != null) {
                    this.obj.getDestinatario().setNrCnpjCpf(objXML.getDest().getCNPJ());
                }
                if (objXML.getDest().getCPF() != null) {
                    this.obj.getDestinatario().setNrCnpjCpf(objXML.getDest().getCPF());
                }
                this.obj.getDestinatario().setNomeDestino(objXML.getDest().getXNome());
                this.obj.getDestinatario().setLogradouro(objXML.getDest().getEnderDest().getXLgr());
                this.obj.getDestinatario().setNumeroLogradouro(objXML.getDest().getEnderDest().getNro());
                this.obj.getDestinatario().setComplemento(objXML.getDest().getEnderDest().getXCpl());
                this.obj.getDestinatario().setBairro(objXML.getDest().getEnderDest().getXBairro());
                this.obj.getDestinatario().setNrIbgeMunicipio(br.com.ophos.util.nfe.Util.StringToInteger(objXML.getDest().getEnderDest().getCMun()));
                this.obj.getDestinatario().setNomeMunicipio(objXML.getDest().getEnderDest().getXMun());
                this.obj.getDestinatario().setUf(objXML.getDest().getEnderDest().getUF().value());
                this.obj.getDestinatario().setCep(objXML.getDest().getEnderDest().getCEP());
                this.obj.getDestinatario().setNrPais(br.com.ophos.util.nfe.Util.StringToShort(objXML.getDest().getEnderDest().getCPais()));
                this.obj.getDestinatario().setNomePais(objXML.getDest().getEnderDest().getXPais());
                this.obj.getDestinatario().setTelefone(objXML.getDest().getEnderDest().getFone());
                this.obj.getDestinatario().setIe(objXML.getDest().getIE());
                this.obj.getDestinatario().setNrSuframa(objXML.getDest().getISUF());
                this.obj.getDestinatario().setEmail(objXML.getIde().getEmail());
                if (this.obj.getDestinatario().getNrCnpjCpf().trim().equals("") && this.obj.getDestinatario().getUf().equals("EX")) {
                    this.obj.getDestinatario().setNrCnpjCpf("00000000000000");
                }
            }
            if (objXML.getCobr() != null) {
                if (objXML.getCobr().getFat() != null) {
                    Fatura fatura = new Fatura();
                    fatura.setNrFatura(objXML.getCobr().getFat().getNFat());
                    fatura.setValorOriginal(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getCobr().getFat().getVOrig().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    if (objXML.getCobr().getFat().getVDesc() != null) {
                        fatura.setValorDesconto(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getCobr().getFat().getVDesc().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (objXML.getCobr().getFat().getVLiq() != null) {
                        fatura.setValorLiquido(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getCobr().getFat().getVLiq().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    this.obj.setFatura(fatura);
                }
                if (objXML.getCobr().getDup() != null) {
                    for (TNFe.InfNFe.Cobr.Dup dup : objXML.getCobr().getDup()) {
                        Duplicata duplicata = new Duplicata();
                        duplicata.setNrDuplicata(dup.getNDup());
                        duplicata.setDtVencimento(dup.getDVenc().toGregorianCalendar().getTime());
                        duplicata.setVlDuplicata(br.com.ophos.util.nfe.Util.StringToDouble(dup.getVDup().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        this.obj.getDuplicatas().add(duplicata);
                    }
                }
            }
            if (objXML.getEntrega() != null) {
                local = new LocalEntrega();
                local.setCnpj(objXML.getEntrega().getCNPJ());
                local.setLogradouro(objXML.getEntrega().getXLgr());
                local.setNumero(objXML.getEntrega().getNro());
                local.setComplemento(objXML.getEntrega().getXCpl());
                local.setBairro(objXML.getEntrega().getXBairro());
                local.setNrIbgeMunicipio(br.com.ophos.util.nfe.Util.StringToInteger(objXML.getEntrega().getCMun()));
                local.setNomeMunicipio(objXML.getEntrega().getXMun());
                local.setUf(objXML.getEntrega().getUF().value());
                this.obj.getLocais().add(local);
            }
            if (objXML.getRetirada() != null) {
                local = new LocalRetirada();
                local.setCnpj(objXML.getRetirada().getCNPJ());
                local.setLogradouro(objXML.getRetirada().getXLgr());
                local.setNumero(objXML.getRetirada().getNro());
                local.setComplemento(objXML.getRetirada().getXCpl());
                local.setBairro(objXML.getRetirada().getXBairro());
                local.setNrIbgeMunicipio(br.com.ophos.util.nfe.Util.StringToInteger(objXML.getRetirada().getCMun()));
                local.setNomeMunicipio(objXML.getRetirada().getXMun());
                local.setUf(objXML.getRetirada().getUF().value());
                this.obj.getLocais().add(local);
            }
            if (objXML.getTransp() != null) {
                Transportadora transportadora = new Transportadora();
                transportadora.setModalidadeFrete(br.com.ophos.util.nfe.Util.valueToModalidadeFrete(objXML.getTransp().getModFrete()));
                if (objXML.getTransp().getTransporta() != null) {
                    if (objXML.getTransp().getModFrete().equals("1") || objXML.getTransp().getModFrete().equals("0")) {
                        if (objXML.getTransp().getTransporta().getCNPJ() != null) {
                            transportadora.setNrCnpjCpf(objXML.getTransp().getTransporta().getCNPJ());
                        }
                        if (objXML.getTransp().getTransporta().getCPF() != null) {
                            transportadora.setNrCnpjCpf(objXML.getTransp().getTransporta().getCPF());
                        }
                        transportadora.setRazaoSocial(objXML.getTransp().getTransporta().getXNome());
                        transportadora.setNrIe(objXML.getTransp().getTransporta().getIE());
                        transportadora.setEndereco(objXML.getTransp().getTransporta().getXEnder());
                        transportadora.setMunicipio(objXML.getTransp().getTransporta().getXMun());
                    }
                    if (objXML.getTransp().getTransporta().getUF() != null) {
                        transportadora.setUf(objXML.getTransp().getTransporta().getUF().value());
                    }
                }
                if (objXML.getTransp().getRetTransp() != null) {
                    transportadora.getRetencao().setValorServico(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTransp().getRetTransp().getVServ().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    transportadora.getRetencao().setBaseCalculoRetencaoICMS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTransp().getRetTransp().getVBCRet().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    transportadora.getRetencao().setAliquotaRetencao(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTransp().getRetTransp().getPICMSRet().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    transportadora.getRetencao().setValorRetidoICMS(br.com.ophos.util.nfe.Util.StringToDouble(objXML.getTransp().getRetTransp().getVICMSRet().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    transportadora.getRetencao().setNrCFOP(br.com.ophos.util.nfe.Util.StringToShort(objXML.getTransp().getRetTransp().getCFOP()));
                    transportadora.getRetencao().setNrIbgeMunFg(br.com.ophos.util.nfe.Util.StringToInteger(objXML.getTransp().getRetTransp().getCMunFG()));
                }
                if (objXML.getTransp().getVeicTransp() != null) {
                    transportadora.getVeiculoTransporte().setPlacaVeiculo(objXML.getTransp().getVeicTransp().getPlaca());
                    transportadora.getVeiculoTransporte().setUfVeiculo(objXML.getTransp().getVeicTransp().getUF().value());
                    transportadora.getVeiculoTransporte().setNrRNTC(objXML.getTransp().getVeicTransp().getRNTC());
                }
                this.obj.setTransportadora(transportadora);
            }
            if (objXML.getTransp() != null && objXML.getTransp().getReboque() != null) {
                for (TVeiculo tVeiculo : objXML.getTransp().getReboque()) {
                    Reboque reboque = new Reboque();
                    reboque.setPlaca(tVeiculo.getPlaca());
                    reboque.setUf(tVeiculo.getUF().value());
                    reboque.setNrRntc(tVeiculo.getRNTC());
                    this.obj.getTransportadora().getReboques().add(reboque);
                }
            }
            if (objXML.getTransp() != null) {
                for (TNFe.InfNFe.Transp.Vol vol : objXML.getTransp().getVol()) {
                    Volume volume = new Volume();
                    if (vol.getQVol() != null) {
                        volume.setQuantidade(br.com.ophos.util.nfe.Util.StringToInteger(vol.getQVol()));
                    }
                    if (vol.getEsp() != null) {
                        volume.setEspecie(vol.getEsp());
                    }
                    if (vol.getMarca() != null) {
                        volume.setMarca(vol.getMarca());
                    }
                    if (vol.getNVol() != null) {
                        volume.setIdentificacao(vol.getNVol());
                    }
                    if (vol.getPesoL() != null) {
                        volume.setPesoLiquido(br.com.ophos.util.nfe.Util.StringToDouble(vol.getPesoL().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_TRES_DECIMAIS));
                    }
                    if (vol.getPesoB() != null) {
                        volume.setPesoBruto(br.com.ophos.util.nfe.Util.StringToDouble(vol.getPesoB().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_TRES_DECIMAIS));
                    }
                    for (TNFe.InfNFe.Transp.Vol.Lacres lacreDB : vol.getLacres()) {
                        Lacre lacre = new Lacre();
                        lacre.setNrLacre(lacreDB.getNLacre());
                        volume.getLacres().add(lacre);
                    }
                    this.obj.getTransportadora().getVolume().add(volume);
                }
            }
            if (objXML.getInfAdic() != null) {
                Info info;
                if (objXML.getInfAdic().getObsCont() != null) {
                    for (TNFe.InfNFe.InfAdic.ObsCont obsCont : objXML.getInfAdic().getObsCont()) {
                        info = new InfoContribuinte();
                        info.setCampo(obsCont.getXCampo());
                        info.setDescricao(obsCont.getXTexto());
                        this.obj.getInfo().add(info);
                    }
                }
                if (objXML.getInfAdic().getObsFisco() != null) {
                    for (TNFe.InfNFe.InfAdic.ObsFisco obsFisco : objXML.getInfAdic().getObsFisco()) {
                        info = new InfoFisco();
                        info.setCampo(obsFisco.getXCampo());
                        info.setDescricao(obsFisco.getXTexto());
                        this.obj.getInfo().add(info);
                    }
                }
            }
            if (objXML.getDet().size() > 0) {
                for (TNFe.InfNFe.Det det : objXML.getDet()) {
                    Item item = new Item();
                    if (!det.getNItem().equals("")) {
                        item.setNrItem(br.com.ophos.util.nfe.Util.StringToInteger(det.getNItem()));
                    }
                    item.setCodigoProduto(det.getProd().getCProd());
                    item.setEan(det.getProd().getCEAN());
                    item.setNomeProduto(det.getProd().getXProd());
                    item.setNcm(det.getProd().getNCM());
                    item.setExTIPI(det.getProd().getEXTIPI());
                    item.setGenero(det.getProd().getGenero());
                    item.setCfop(br.com.ophos.util.nfe.Util.StringToShort(det.getProd().getCFOP()));
                    item.setUnidadeComercial(det.getProd().getUCom());
                    item.setQuantidadeComercial(br.com.ophos.util.nfe.Util.StringToDouble(det.getProd().getQCom().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    item.setValorUnitario(br.com.ophos.util.nfe.Util.StringToDouble(det.getProd().getVUnCom().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    item.setValorProduto(br.com.ophos.util.nfe.Util.StringToDouble(det.getProd().getVProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    item.setEanTrib(det.getProd().getCEANTrib());
                    item.setUnidadeTributavel(det.getProd().getUTrib());
                    item.setQuantidadeTributavel(br.com.ophos.util.nfe.Util.StringToDouble(det.getProd().getQTrib().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    item.setValorUnitarioTributacao(br.com.ophos.util.nfe.Util.StringToDouble(det.getProd().getVUnTrib().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                    if (det.getProd().getVFrete() != null) {
                        item.setValorFrete(br.com.ophos.util.nfe.Util.StringToDouble(det.getProd().getVFrete().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (det.getProd().getVSeg() != null) {
                        item.setValorSeguro(br.com.ophos.util.nfe.Util.StringToDouble(det.getProd().getVSeg().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (det.getProd().getVDesc() != null) {
                        item.setValorDesconto(br.com.ophos.util.nfe.Util.StringToDouble(det.getProd().getVDesc().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    IcmsProprioST icms = null;
                    if (det.getImposto().getICMS() != null) {
                        if (det.getImposto().getICMS().getICMS00() != null) {
                            Icmsn00 icms00 = new Icmsn00();
                            icms00.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS00().getOrig()));
                            icms00.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(det.getImposto().getICMS().getICMS00().getModBC()));
                            icms00.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS00().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms00.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS00().getPICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms00.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS00().getVICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms = icms00;
                        }
                        if (det.getImposto().getICMS().getICMS10() != null) {
                            Icmsn10 icms10 = new Icmsn10();
                            icms10.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS10().getOrig()));
                            icms10.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(det.getImposto().getICMS().getICMS10().getModBC()));
                            icms10.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS10().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms10.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS10().getPICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms10.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS10().getVICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms10.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(det.getImposto().getICMS().getICMS10().getModBCST()));
                            if (det.getImposto().getICMS().getICMS10().getPMVAST() != null) {
                                icms10.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS10().getPMVAST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS10().getPRedBCST() != null) {
                                icms10.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS10().getPRedBCST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            icms10.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS10().getVBCST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms10.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS10().getPICMSST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms10.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS10().getVICMSST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms = icms10;
                        }
                        if (det.getImposto().getICMS().getICMS20() != null) {
                            Icmsn20 icms20 = new Icmsn20();
                            icms20.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS20().getOrig()));
                            icms20.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(det.getImposto().getICMS().getICMS20().getModBC()));
                            icms20.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS20().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms20.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS20().getPICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms20.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS20().getVICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms20.setPercentualReducaoBC(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS20().getPRedBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms = icms20;
                        }
                        if (det.getImposto().getICMS().getICMS30() != null) {
                            Icmsn30 icms30 = new Icmsn30();
                            icms30.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS30().getOrig()));
                            icms30.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(det.getImposto().getICMS().getICMS30().getModBCST()));
                            if (det.getImposto().getICMS().getICMS30().getPMVAST() != null) {
                                icms30.setPercentualMargemST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS30().getPMVAST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS30().getPRedBCST() != null) {
                                icms30.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS30().getPRedBCST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            icms30.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS30().getVBCST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms30.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS30().getPICMSST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms30.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS30().getVICMSST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms = icms30;
                        }
                        if (det.getImposto().getICMS().getICMS40() != null) {
                            if (det.getImposto().getICMS().getICMS40().getCST().equals("41")) {
                                Icmsn41 icms41 = new Icmsn41();
                                icms41.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS40().getOrig()));
                                icms = icms41;
                            }
                            if (det.getImposto().getICMS().getICMS40().getCST().equals("40")) {
                                Icmsn40 icms40 = new Icmsn40();
                                icms40.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS40().getOrig()));
                                icms = icms40;
                            }
                            if (det.getImposto().getICMS().getICMS40().getCST().equals("50")) {
                                Icmsn50 icms50 = new Icmsn50();
                                icms50.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS40().getOrig()));
                                icms = icms50;
                            }
                        }
                        if (det.getImposto().getICMS().getICMS51() != null) {
                            Icmsn51 icms51 = new Icmsn51();
                            icms51.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS51().getOrig()));
                            if (det.getImposto().getICMS().getICMS51().getModBC() != null) {
                                icms51.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(det.getImposto().getICMS().getICMS51().getModBC()));
                            }
                            if (det.getImposto().getICMS().getICMS51().getVBC() != null) {
                                icms51.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS51().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS51().getPICMS() != null) {
                                icms51.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS51().getPICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS51().getVICMS() != null) {
                                icms51.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS51().getVICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS51().getPRedBC() != null) {
                                icms51.setPercentualReducaoBC(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS51().getPRedBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            icms = icms51;
                        }
                        if (det.getImposto().getICMS().getICMS60() != null) {
                            Icmsn60 icmsn60 = new Icmsn60();
                            icmsn60.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS60().getOrig()));
                            icmsn60.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS60().getVBCST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icmsn60.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS60().getVICMSST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms = icmsn60;
                        }
                        if (det.getImposto().getICMS().getICMS70() != null) {
                            Icmsn70 icms70 = new Icmsn70();
                            icms70.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS70().getOrig()));
                            icms70.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(det.getImposto().getICMS().getICMS70().getModBC()));
                            icms70.setPercentualReducaoBC(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS70().getPRedBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms70.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS70().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms70.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS70().getPICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms70.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS70().getVICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms70.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(det.getImposto().getICMS().getICMS70().getModBCST()));
                            if (det.getImposto().getICMS().getICMS70().getPMVAST() != null) {
                                icms70.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS70().getPMVAST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS70().getPRedBCST() != null) {
                                icms70.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS70().getPRedBCST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            icms70.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS70().getVBCST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms70.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS70().getPICMSST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms70.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS70().getVICMSST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            icms = icms70;
                        }
                        if (det.getImposto().getICMS().getICMS90() != null) {
                            Icmsn90 icms90 = new Icmsn90();
                            icms90.setOrigemMercadoria(br.com.ophos.util.nfe.Util.valueToOrigemMercadoria(det.getImposto().getICMS().getICMS90().getOrig()));
                            if (det.getImposto().getICMS().getICMS90().getModBC() != null) {
                                icms90.setModalidadeBC(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMS(det.getImposto().getICMS().getICMS90().getModBC()));
                            }
                            if (det.getImposto().getICMS().getICMS90().getVBC() != null) {
                                icms90.setBaseCalculo(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS90().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS90().getPRedBC() != null) {
                                icms90.setPercentualReducaoBC(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS90().getPRedBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS90().getPICMS() != null) {
                                icms90.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS90().getPICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS90().getVICMS() != null) {
                                icms90.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS90().getVICMS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS90().getModBCST() != null) {
                                icms90.setModalidadeBCST(br.com.ophos.util.nfe.Util.valueToModalidadeBCICMSST(det.getImposto().getICMS().getICMS90().getModBCST()));
                            }
                            if (det.getImposto().getICMS().getICMS90().getPMVAST() != null) {
                                icms90.setPercentualMargem(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS90().getPMVAST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS90().getPRedBCST() != null) {
                                icms90.setPercentualReducaoBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS90().getPRedBCST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS90().getVBCST() != null) {
                                icms90.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS90().getVBCST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS90().getPICMSST() != null) {
                                icms90.setAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS90().getPICMSST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getICMS().getICMS90().getVICMSST() != null) {
                                icms90.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getICMS().getICMS90().getVICMSST().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            icms = icms90;
                        }
                        item.setIcms(icms);
                    }
                    if (det.getImposto().getIPI() != null) {
                        Ipi ipi = null;
                        if (det.getImposto().getIPI().getIPITrib() != null) {
                            IpiTrib ipiTrib = new IpiTrib();
                            if (det.getImposto().getIPI().getIPITrib().getCST().equals("00")) {
                                ipiTrib.setSituacaoTributaria(SituacaoTributariaIPITrib.ST_00);
                            }
                            if (det.getImposto().getIPI().getIPITrib().getCST().equals("49")) {
                                ipiTrib.setSituacaoTributaria(SituacaoTributariaIPITrib.ST_49);
                            }
                            if (det.getImposto().getIPI().getIPITrib().getCST().equals("50")) {
                                ipiTrib.setSituacaoTributaria(SituacaoTributariaIPITrib.ST_50);
                            }
                            if (det.getImposto().getIPI().getIPITrib().getCST().equals("99")) {
                                ipiTrib.setSituacaoTributaria(SituacaoTributariaIPITrib.ST_99);
                            }
                            if (det.getImposto().getIPI().getIPITrib().getVBC() != null) {
                                ipiTrib.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getIPI().getIPITrib().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getIPI().getIPITrib().getQUnid() != null) {
                                ipiTrib.setQuantidadeTotal(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getIPI().getIPITrib().getQUnid().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                            }
                            if (det.getImposto().getIPI().getIPITrib().getVUnid() != null) {
                                ipiTrib.setValorUnidTributavel(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getIPI().getIPITrib().getVUnid().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                            }
                            if (det.getImposto().getIPI().getIPITrib().getPIPI() != null) {
                                ipiTrib.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getIPI().getIPITrib().getPIPI().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getIPI().getIPITrib().getVIPI() != null) {
                                ipiTrib.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getIPI().getIPITrib().getVIPI().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            ipi = ipiTrib;
                        }
                        if (det.getImposto().getIPI().getIPINT() != null) {
                            Ipint ipiNt = new Ipint();
                            if (det.getImposto().getIPI().getIPINT().getCST().equals("01")) {
                                ipiNt.setSituacaoTributaria(SituacaoTributariaIPINT.ST_01);
                            }
                            if (det.getImposto().getIPI().getIPINT().getCST().equals("02")) {
                                ipiNt.setSituacaoTributaria(SituacaoTributariaIPINT.ST_02);
                            }
                            if (det.getImposto().getIPI().getIPINT().getCST().equals("03")) {
                                ipiNt.setSituacaoTributaria(SituacaoTributariaIPINT.ST_03);
                            }
                            if (det.getImposto().getIPI().getIPINT().getCST().equals("04")) {
                                ipiNt.setSituacaoTributaria(SituacaoTributariaIPINT.ST_04);
                            }
                            if (det.getImposto().getIPI().getIPINT().getCST().equals("05")) {
                                ipiNt.setSituacaoTributaria(SituacaoTributariaIPINT.ST_05);
                            }
                            if (det.getImposto().getIPI().getIPINT().getCST().equals("51")) {
                                ipiNt.setSituacaoTributaria(SituacaoTributariaIPINT.ST_51);
                            }
                            if (det.getImposto().getIPI().getIPINT().getCST().equals("52")) {
                                ipiNt.setSituacaoTributaria(SituacaoTributariaIPINT.ST_52);
                            }
                            if (det.getImposto().getIPI().getIPINT().getCST().equals("53")) {
                                ipiNt.setSituacaoTributaria(SituacaoTributariaIPINT.ST_53);
                            }
                            if (det.getImposto().getIPI().getIPINT().getCST().equals("54")) {
                                ipiNt.setSituacaoTributaria(SituacaoTributariaIPINT.ST_54);
                            }
                            if (det.getImposto().getIPI().getIPINT().getCST().equals("55")) {
                                ipiNt.setSituacaoTributaria(SituacaoTributariaIPINT.ST_55);
                            }
                            ipi = ipiNt;
                        }
                        if (ipi != null) {
                            if (det.getImposto().getIPI().getClEnq() != null) {
                                ipi.setClasseEnquadramento(det.getImposto().getIPI().getClEnq());
                            }
                            if (det.getImposto().getIPI().getCNPJProd() != null) {
                                ipi.setCnpjProdutor(det.getImposto().getIPI().getCNPJProd());
                            }
                            if (det.getImposto().getIPI().getCSelo() != null) {
                                ipi.setCodigoSelo(det.getImposto().getIPI().getCSelo());
                            }
                            if (det.getImposto().getIPI().getQSelo() != null) {
                                ipi.setNrSeloIpi(det.getImposto().getIPI().getQSelo());
                            }
                            if (det.getImposto().getIPI().getCEnq() != null) {
                                ipi.setCodigoEnquadramento(det.getImposto().getIPI().getCEnq());
                            }
                        }
                        item.setIpi(ipi);
                    }
                    if (det.getImposto().getII() != null) {
                        Ii ii = new Ii();
                        ii.setValorBCII(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getII().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        ii.setValorDespesasAduaneiras(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getII().getVDespAdu().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        ii.setValorII(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getII().getVII().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        ii.setValorIOF(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getII().getVIOF().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        item.setIi(ii);
                    }
                    if (det.getImposto().getPIS() != null) {
                        Pis pis = null;
                        if (det.getImposto().getPIS().getPISAliq() != null) {
                            PisAliq pisAliq = new PisAliq();
                            if (det.getImposto().getPIS().getPISAliq().getCST().equals("01")) {
                                pisAliq.setSituacaotributaria(SituacaoTributariaPISAliq.ST_01);
                            }
                            if (det.getImposto().getPIS().getPISAliq().getCST().equals("02")) {
                                pisAliq.setSituacaotributaria(SituacaoTributariaPISAliq.ST_02);
                            }
                            pisAliq.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISAliq().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            pisAliq.setPercentualAliq(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISAliq().getPPIS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            pisAliq.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISAliq().getVPIS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            pis = pisAliq;
                        }
                        if (det.getImposto().getPIS().getPISQtde() != null) {
                            PisQtde pisQtd = new PisQtde();
                            if (det.getImposto().getPIS().getPISQtde().getCST().equals("03")) {
                                pisQtd.setSituacaotributaria(SituacaoTributariaPISQtde.ST_03);
                            }
                            pisQtd.setQuantidadeVendida(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISQtde().getQBCProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            pisQtd.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISQtde().getVAliqProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                            pisQtd.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISQtde().getVPIS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            pis = pisQtd;
                        }
                        if (det.getImposto().getPIS().getPISNT() != null) {
                            Pisnt pisnt = new Pisnt();
                            if (det.getImposto().getPIS().getPISNT().getCST().equals("04")) {
                                pisnt.setSituacaotributaria(SituacaoTributariaPISNT.ST_04);
                            }
                            if (det.getImposto().getPIS().getPISNT().getCST().equals("06")) {
                                pisnt.setSituacaotributaria(SituacaoTributariaPISNT.ST_06);
                            }
                            if (det.getImposto().getPIS().getPISNT().getCST().equals("07")) {
                                pisnt.setSituacaotributaria(SituacaoTributariaPISNT.ST_07);
                            }
                            if (det.getImposto().getPIS().getPISNT().getCST().equals("08")) {
                                pisnt.setSituacaotributaria(SituacaoTributariaPISNT.ST_08);
                            }
                            if (det.getImposto().getPIS().getPISNT().getCST().equals("09")) {
                                pisnt.setSituacaotributaria(SituacaoTributariaPISNT.ST_09);
                            }
                            pis = pisnt;
                        }
                        if (det.getImposto().getPIS().getPISOutr() != null) {
                            PisOutros pisOutros = new PisOutros();
                            if (det.getImposto().getPIS().getPISOutr().getCST().equals("99")) {
                                pisOutros.setSituacaotributaria(SituacaoTributariaPISOutros.ST_99);
                            }
                            if (det.getImposto().getPIS().getPISOutr().getPPIS() != null) {
                                pisOutros.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISOutr().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                                pisOutros.setPercentualAliq(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISOutr().getPPIS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            if (det.getImposto().getPIS().getPISOutr().getVAliqProd() != null) {
                                pisOutros.setQuantidadeVendida(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISOutr().getQBCProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                                pisOutros.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISOutr().getVAliqProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                            }
                            pisOutros.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPIS().getPISOutr().getVPIS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            pis = pisOutros;
                        }
                        item.setPis(pis);
                    }
                    if (det.getImposto().getPISST() != null) {
                        Pisst pisSt = new Pisst();
                        pisSt.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPISST().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        pisSt.setValorPercentualAliqST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPISST().getPPIS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        pisSt.setQuantidadeST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPISST().getQBCProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                        pisSt.setValorReaisAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPISST().getVAliqProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                        pisSt.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getPISST().getVPIS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        item.setPisst(pisSt);
                    }
                    Cofins cofins = null;
                    if (det.getImposto().getCOFINS().getCOFINSAliq() != null) {
                        CofinsAliq cofinsAliq = new CofinsAliq();
                        if (det.getImposto().getCOFINS().getCOFINSAliq().getCST().equals("01")) {
                            cofinsAliq.setSituacaoTributaria(SituacaoTributariaCFAliq.ST_01);
                        }
                        if (det.getImposto().getCOFINS().getCOFINSAliq().getCST().equals("02")) {
                            cofinsAliq.setSituacaoTributaria(SituacaoTributariaCFAliq.ST_02);
                        }
                        cofinsAliq.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSAliq().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        cofinsAliq.setPercentualAliq(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSAliq().getPCOFINS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        cofinsAliq.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSAliq().getVCOFINS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        cofins = cofinsAliq;
                    }
                    if (det.getImposto().getCOFINS().getCOFINSQtde() != null) {
                        CofinsQtde cofinsQtde = new CofinsQtde();
                        if (det.getImposto().getCOFINS().getCOFINSQtde().getCST().equals("03")) {
                            cofinsQtde.setSituacaoTributaria(SituacaoTributariaCFQtde.ST_03);
                        }
                        cofinsQtde.setQuantidadeVendida(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSQtde().getQBCProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                        cofinsQtde.setValorAliq(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSQtde().getVAliqProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                        cofinsQtde.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSQtde().getVCOFINS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        cofins = cofinsQtde;
                    }
                    if (det.getImposto().getCOFINS().getCOFINSNT() != null) {
                        Cofinsnt cofinsnt = new Cofinsnt();
                        if (det.getImposto().getCOFINS().getCOFINSNT().getCST().equals("04")) {
                            cofinsnt.setSituacaoTributaria(SituacaoTributariaCFNT.ST_04);
                        }
                        if (det.getImposto().getCOFINS().getCOFINSNT().getCST().equals("06")) {
                            cofinsnt.setSituacaoTributaria(SituacaoTributariaCFNT.ST_06);
                        }
                        if (det.getImposto().getCOFINS().getCOFINSNT().getCST().equals("07")) {
                            cofinsnt.setSituacaoTributaria(SituacaoTributariaCFNT.ST_07);
                        }
                        if (det.getImposto().getCOFINS().getCOFINSNT().getCST().equals("08")) {
                            cofinsnt.setSituacaoTributaria(SituacaoTributariaCFNT.ST_08);
                        }
                        if (det.getImposto().getCOFINS().getCOFINSNT().getCST().equals("09")) {
                            cofinsnt.setSituacaoTributaria(SituacaoTributariaCFNT.ST_09);
                        }
                        cofins = cofinsnt;
                    }
                    if (det.getImposto().getCOFINS().getCOFINSOutr() != null) {
                        CofinsOutros cofinsOutros = new CofinsOutros();
                        if (det.getImposto().getCOFINS().getCOFINSOutr().getCST().equals("99")) {
                            cofinsOutros.setSituacaoTributaria(SituacaoTributariaCFOutros.ST_99);
                        }
                        if (det.getImposto().getCOFINS().getCOFINSOutr().getVBC() != null || det.getImposto().getCOFINS().getCOFINSOutr().getPCOFINS() != null) {
                            cofinsOutros.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSOutr().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            cofinsOutros.setPercentualAliq(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSOutr().getPCOFINS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        }
                        if (det.getImposto().getCOFINS().getCOFINSOutr().getQBCProd() != null || det.getImposto().getCOFINS().getCOFINSOutr().getVAliqProd() != null) {
                            cofinsOutros.setQuantidadeVendida(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSOutr().getQBCProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                            cofinsOutros.setValorAliq(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSOutr().getVAliqProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                        }
                        cofinsOutros.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINS().getCOFINSOutr().getVCOFINS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        cofins = cofinsOutros;
                    }
                    if (det.getImposto().getCOFINSST() != null) {
                        Cofinsst cofinsst = new Cofinsst();
                        cofinsst.setValorBCST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINSST().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        cofinsst.setValorPercentualAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINSST().getPCOFINS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        cofinsst.setValorQuantidadeST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINSST().getQBCProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                        cofinsst.setValorAliquotaST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINSST().getVAliqProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        cofinsst.setValorST(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getCOFINSST().getVCOFINS().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        item.setCofinsst(cofinsst);
                    }
                    if (det.getImposto().getISSQN() != null) {
                        Issqn issqn = new Issqn();
                        issqn.setValorBC(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getISSQN().getVBC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        issqn.setAliquota(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getISSQN().getVAliq().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        issqn.setValor(br.com.ophos.util.nfe.Util.StringToDouble(det.getImposto().getISSQN().getVISSQN().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        issqn.setNrIbgeMunicipioFG(br.com.ophos.util.nfe.Util.StringToInteger(det.getImposto().getISSQN().getCMunFG()));
                        issqn.setCodigoListaServicos(det.getImposto().getISSQN().getCListServ());
                        item.setIssqn(issqn);
                    }
                    item.setObservacao(det.getInfAdProd());
                    if (det.getProd().getVeicProd() != null) {
                        Iterator<TNFe.InfNFe.Det.Prod.Med> veiculo = new Veiculo();
                        ((Veiculo)((Object)veiculo)).setTipoOperacao(br.com.ophos.util.nfe.Util.valueToTipoOperacao(det.getProd().getVeicProd().getTpOp()));
                        ((Veiculo)((Object)veiculo)).setChassi(det.getProd().getVeicProd().getChassi());
                        ((Veiculo)((Object)veiculo)).setCor(det.getProd().getVeicProd().getCCor());
                        ((Veiculo)((Object)veiculo)).setDescricaoCor(det.getProd().getVeicProd().getXCor());
                        ((Veiculo)((Object)veiculo)).setPotencia(det.getProd().getVeicProd().getPot());
                        ((Veiculo)((Object)veiculo)).setCm3(det.getProd().getVeicProd().getCM3());
                        ((Veiculo)((Object)veiculo)).setPesoLiquido(det.getProd().getVeicProd().getPesoL());
                        ((Veiculo)((Object)veiculo)).setPesoBruto(det.getProd().getVeicProd().getPesoB());
                        ((Veiculo)((Object)veiculo)).setSerie(det.getProd().getVeicProd().getNSerie());
                        ((Veiculo)((Object)veiculo)).setTipoCombustivel(det.getProd().getVeicProd().getTpComb());
                        ((Veiculo)((Object)veiculo)).setNumeroMotor(det.getProd().getVeicProd().getNMotor());
                        ((Veiculo)((Object)veiculo)).setCmkg(det.getProd().getVeicProd().getCMKG());
                        ((Veiculo)((Object)veiculo)).setDistanciaEixo(det.getProd().getVeicProd().getDist());
                        ((Veiculo)((Object)veiculo)).setRenavam(det.getProd().getVeicProd().getRENAVAM());
                        ((Veiculo)((Object)veiculo)).setAnoModeloFabricacao(br.com.ophos.util.nfe.Util.StringToShort(det.getProd().getVeicProd().getAnoMod()));
                        ((Veiculo)((Object)veiculo)).setAnoFabricacao(br.com.ophos.util.nfe.Util.StringToShort(det.getProd().getVeicProd().getAnoFab()));
                        ((Veiculo)((Object)veiculo)).setTipoPintura(det.getProd().getVeicProd().getTpPint());
                        if (!det.getProd().getVeicProd().getTpVeic().equals("")) {
                            ((Veiculo)((Object)veiculo)).setTipoVeiculo(br.com.ophos.util.nfe.Util.StringToInteger(det.getProd().getVeicProd().getTpVeic()));
                        }
                        if (!det.getProd().getVeicProd().getEspVeic().equals("")) {
                            ((Veiculo)((Object)veiculo)).setEspecie(br.com.ophos.util.nfe.Util.StringToShort(det.getProd().getVeicProd().getEspVeic()));
                        }
                        ((Veiculo)((Object)veiculo)).setVin(br.com.ophos.util.nfe.Util.valueToVinVeiculo(det.getProd().getVeicProd().getVIN()));
                        ((Veiculo)((Object)veiculo)).setCondicaoVeiculo(CondicaoVeiculo.ACABADO);
                        ((Veiculo)((Object)veiculo)).setModelo(det.getProd().getVeicProd().getCMod());
                        item.setVeiculo((Veiculo)((Object)veiculo));
                    }
                    if (det.getProd().getArma() != null) {
                        for (TNFe.InfNFe.Det.Prod.Arma armaDB : det.getProd().getArma()) {
                            Armamento armamento = new Armamento();
                            armamento.setTipoArma(br.com.ophos.util.nfe.Util.valueToTipoArma(armaDB.getTpArma()));
                            if (!armaDB.getNSerie().equals("")) {
                                armamento.setNrSerie(br.com.ophos.util.nfe.Util.StringToInteger(armaDB.getNSerie()));
                            }
                            if (!armaDB.getNCano().equals("")) {
                                armamento.setSerieCano(br.com.ophos.util.nfe.Util.StringToInteger(armaDB.getNCano()));
                            }
                            armamento.setDescricao(armaDB.getDescr());
                            item.getArmamentos().add(armamento);
                        }
                    }
                    if (det.getProd().getMed() != null) {
                        for (TNFe.InfNFe.Det.Prod.Med medDB : det.getProd().getMed()) {
                            Medicamento medicamento = new Medicamento();
                            medicamento.setNrLote(medDB.getNLote());
                            medicamento.setQuantidadeLote(Double.parseDouble(medDB.getQLote()));
                            medicamento.setDataFabricacao(medDB.getDFab().toGregorianCalendar().getTime());
                            medicamento.setDataValidade(medDB.getDVal().toGregorianCalendar().getTime());
                            medicamento.setPrecoMaximo(br.com.ophos.util.nfe.Util.StringToDouble(medDB.getVPMC().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            item.getMedicamento().add(medicamento);
                        }
                    }
                    if (det.getProd().getComb() != null) {
                        TNFe.InfNFe.Det.Prod.Comb combDB = det.getProd().getComb();
                        Combustivel combustivel = new Combustivel();
                        combustivel.setNrProdAnp(combDB.getCProdANP());
                        combustivel.setNrCodif(combDB.getCODIF());
                        if (combDB.getQTemp() != null) {
                            combustivel.setQtCombTemp(br.com.ophos.util.nfe.Util.StringToDouble(combDB.getQTemp().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                        }
                        if (combDB.getCIDE() != null) {
                            combustivel.setValorBcCide(br.com.ophos.util.nfe.Util.StringToDouble(combDB.getCIDE().getQBCProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            combustivel.setValorAliqCide(br.com.ophos.util.nfe.Util.StringToDouble(combDB.getCIDE().getVAliqProd().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_QUATRO_DECIMAIS));
                            combustivel.setValorCide(br.com.ophos.util.nfe.Util.StringToDouble(combDB.getCIDE().getVCIDE().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                        }
                        item.setCombustivel(combustivel);
                    }
                    for (TNFe.InfNFe.Det.Prod.DI diDB : det.getProd().getDI()) {
                        Di di = new Di();
                        di.setNrDocumento(diDB.getNDI());
                        di.setDataRegistro(diDB.getDDI().toGregorianCalendar().getTime());
                        di.setLocalDesembaraco(diDB.getXLocDesemb());
                        di.setUf(diDB.getUFDesemb().value());
                        di.setDataDesembaraco(diDB.getDDesemb().toGregorianCalendar().getTime());
                        di.setCodigoExportador(diDB.getCExportador());
                        for (TNFe.InfNFe.Det.Prod.DI.Adi adicaoDB : diDB.getAdi()) {
                            Adicao adicao = new Adicao();
                            adicao.setNrAdicao(br.com.ophos.util.nfe.Util.StringToShort(adicaoDB.getNAdicao()));
                            adicao.setNrSeq(br.com.ophos.util.nfe.Util.StringToShort(adicaoDB.getNSeqAdic()));
                            adicao.setFabricante(adicaoDB.getCFabricante());
                            if (adicaoDB.getVDescDI() != null) {
                                adicao.setValorDesconto(br.com.ophos.util.nfe.Util.StringToDouble(adicaoDB.getVDescDI().replace(".", ""), br.com.ophos.util.nfe.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            di.getAdicoes().add(adicao);
                        }
                        item.getDi().add(di);
                    }
                    this.obj.getItens().add(item);
                }
            }
            in.close();
            return this.obj;
        }
        catch (Exception ex) {
            try {
                in.close();
                throw new ParseException(ex.getMessage(), this.obj);
            }
            catch (IOException iOException) {
                ex.printStackTrace();
                if (ex.getCause() != null) {
                    throw new ParseException("Ocorreu um erro ao fazer o bind do XML para o OBJ nf " + ex.getMessage() + ex.getCause().getMessage());
                }
                throw new ParseException("Ocorreu um erro ao fazer o bind do XML para o OBJ nf " + ex.getMessage());
            }
        }
    }

    public static FormatoImpressao valueToFormatoImpressao(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return FormatoImpressao.RETRATO;
                    }
                    case 2: {
                        return FormatoImpressao.PAISAGEM;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static FinalidadeEmissao valueToFinalidadeEmissao(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return FinalidadeEmissao.NORMAL;
                    }
                    case 2: {
                        return FinalidadeEmissao.COMPLEMENTAR;
                    }
                    case 3: {
                        return FinalidadeEmissao.AJUSTE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

