/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.interfaces;

import br.com.ophos.util.Util;
import br.com.ophos.xml.mdfe.consulta.RetConsultaMDFE;
import br.com.ophos.xml.mdfe.envio.Mdfe;
import br.com.ophos.xml.mdfe.evento.EventoMDFE;
import br.com.ophos.xml.mdfe.evento.EventoPagamento;
import br.com.ophos.xml.mdfe.evento.retorno.RetEnvioEventoMDFE;
import br.com.ophos.xml.mdfe.retorno.RetEnvioMdfe;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class MDFeInterface {
    private String wsEvento = "";
    private String wsManifesto = "";
    private String token = "";
    private Integer timeOut = 5;
    static final JAXBContext jaxbContextMdfe = MDFeInterface.iniciarContextoMdfe();
    static final JAXBContext jaxbContextRetEnvioMdfe = MDFeInterface.iniciarContextoRetEnvioMdfe();
    static final JAXBContext jaxbContextEventoPagamento = MDFeInterface.iniciarContextoEventoPagamentoMdfe();
    static final JAXBContext jaxbContextRetEnvioEvento = MDFeInterface.iniciarContextoRetEnvioEvento();
    static final JAXBContext jaxbContextRetConsultaMdfe = MDFeInterface.iniciarContextoRetConsultaMdfe();

    public MDFeInterface(String wsManifesto, String token, Integer timeOutp) {
        this.wsManifesto = wsManifesto + "/mdfe/service/manifesto";
        this.wsEvento = wsManifesto + "/mdfe/service/evento";
        this.token = token;
        this.timeOut = timeOutp;
    }

    private static JAXBContext iniciarContextoMdfe() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{Mdfe.class});
        }
        catch (JAXBException ex) {
            Logger.getLogger(MDFeInterface.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static JAXBContext iniciarContextoRetEnvioMdfe() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{RetEnvioMdfe.class});
        }
        catch (JAXBException ex) {
            Logger.getLogger(MDFeInterface.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static JAXBContext iniciarContextoEventoPagamentoMdfe() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{EventoPagamento.class});
        }
        catch (JAXBException ex) {
            Logger.getLogger(MDFeInterface.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static JAXBContext iniciarContextoRetEnvioEvento() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{RetEnvioEventoMDFE.class});
        }
        catch (JAXBException ex) {
            Logger.getLogger(MDFeInterface.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static JAXBContext iniciarContextoRetConsultaMdfe() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{RetConsultaMDFE.class});
        }
        catch (JAXBException ex) {
            Logger.getLogger(MDFeInterface.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public RetEnvioEventoMDFE escolherEvento(EventoMDFE evento) {
        switch (evento.getTipoEvento()) {
            case CANCELAMENTO: {
                try {
                    String complemento = "/" + evento.getChaveAcesso() + "/cancelar?justificativa=" + evento.getJustificativa();
                    RetEnvioEventoMDFE retornoEvento = this.enviarEvento(Util.stringToUrl(this.wsEvento + complemento));
                    return retornoEvento;
                }
                catch (Exception ex) {
                    Logger.getLogger(MDFeInterface.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }
            case ENCERRAMENTO: {
                try {
                    String complemento = "/" + evento.getChaveAcesso() + "/encerrar?data=" + Util.formataData(evento.getDataEncerramento(), Util.FMTYYYYMMDD) + "&ibge=" + evento.getNrIbge() + "&municipio=" + evento.getMunicipio() + "&uf=" + evento.getUf();
                    RetEnvioEventoMDFE retornoEvento = this.enviarEvento(Util.stringToUrl(this.wsEvento + complemento));
                    return retornoEvento;
                }
                catch (Exception ex) {
                    Logger.getLogger(MDFeInterface.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }
            case PAGAMENTO: {
                try {
                    RetEnvioEventoMDFE retornoEvento = this.enviarEventoPagamento((EventoPagamento)evento.getEvento());
                    return retornoEvento;
                }
                catch (Exception ex) {
                    Logger.getLogger(MDFeInterface.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }
        }
        return null;
    }

    private RetEnvioEventoMDFE enviarEvento(URL url) throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        conn.setRequestProperty("x-access-token", this.token);
        Unmarshaller jaxbUnmarshaller = jaxbContextRetEnvioEvento.createUnmarshaller();
        RetEnvioEventoMDFE retEvento = (RetEnvioEventoMDFE)jaxbUnmarshaller.unmarshal(conn.getInputStream());
        conn.disconnect();
        return retEvento;
    }

    public RetEnvioEventoMDFE enviarEventoPagamento(EventoPagamento evento) throws Exception {
        URL url = Util.stringToUrl(this.wsEvento + "/pagamento");
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/xml");
        conn.setRequestProperty("x-access-token", this.token);
        conn.setConnectTimeout(this.getTimeOut() * 1000);
        conn.setReadTimeout(this.getTimeOut() * 1000);
        conn.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        Marshaller jaxbMarshaller = jaxbContextEventoPagamento.createMarshaller();
        jaxbMarshaller.marshal((Object)evento, (OutputStream)wr);
        wr.flush();
        wr.close();
        Unmarshaller jaxbUnmarshaller = jaxbContextRetEnvioEvento.createUnmarshaller();
        RetEnvioEventoMDFE retEvento = (RetEnvioEventoMDFE)jaxbUnmarshaller.unmarshal(conn.getInputStream());
        conn.disconnect();
        return retEvento;
    }

    public RetEnvioMdfe enviarManifesto(Mdfe mdfe) throws Exception {
        URL url = Util.stringToUrl(this.wsManifesto);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/xml");
        conn.setRequestProperty("x-access-token", this.token);
        conn.setConnectTimeout(this.getTimeOut() * 1000);
        conn.setReadTimeout(this.getTimeOut() * 1000);
        conn.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        Marshaller jaxbMarshaller = jaxbContextMdfe.createMarshaller();
        jaxbMarshaller.marshal((Object)mdfe, (OutputStream)wr);
        wr.flush();
        wr.close();
        return this.retornoEnvioMdfe(conn);
    }

    private RetEnvioMdfe retornoEnvioMdfe(HttpsURLConnection conn) throws Exception {
        Unmarshaller jaxbUnmarshaller = jaxbContextRetEnvioMdfe.createUnmarshaller();
        RetEnvioMdfe retMdfe = (RetEnvioMdfe)jaxbUnmarshaller.unmarshal(conn.getInputStream());
        conn.disconnect();
        return retMdfe;
    }

    public RetConsultaMDFE retornoConsultaMdfe(String chaveAcesso) throws Exception {
        URL url = Util.stringToUrl(this.wsManifesto + chaveAcesso);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        conn.setRequestProperty("x-access-token", this.token);
        Unmarshaller jaxbUnmarshaller = jaxbContextRetConsultaMdfe.createUnmarshaller();
        RetConsultaMDFE retConsulta = (RetConsultaMDFE)jaxbUnmarshaller.unmarshal(conn.getInputStream());
        conn.disconnect();
        return retConsulta;
    }

    public RetConsultaMDFE retornoConsultaMdfe(String cnpj, String numero, String serie) throws Exception {
        URL url = Util.stringToUrl(this.wsManifesto + "?cnpj=" + cnpj + "&numero=" + numero + "&serie=" + serie);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        conn.setRequestProperty("x-access-token", this.token);
        Unmarshaller jaxbUnmarshaller = jaxbContextRetConsultaMdfe.createUnmarshaller();
        RetConsultaMDFE retConsulta = (RetConsultaMDFE)jaxbUnmarshaller.unmarshal(conn.getInputStream());
        conn.disconnect();
        return retConsulta;
    }

    public Integer getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(Integer timeOut) {
        this.timeOut = timeOut;
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

