/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.monitor;

import br.com.ophos.enumerations.TipoIntegracao;
import br.com.ophos.enumerations.TipoOBJ;
import br.com.ophos.integracao.admin.config.Parametro;
import br.com.ophos.integracao.admin.config.TipoArmazenamento;
import br.com.ophos.integracao.cte.CteInterface;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaCTe;
import br.com.ophos.integracao.interfaces.nfe.NfeInterface;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetConsultaNFe;
import br.com.ophos.monitor.BufferDB;
import br.com.ophos.monitor.EnvioConsulta;
import br.com.ophos.monitor.EnvioIntegracao;
import br.com.ophos.retorno.RetornoCTE;
import br.com.ophos.retorno.RetornoNFE;
import java.io.IOException;
import java.util.logging.Logger;

public class ConsumidorConsulta
implements Runnable {
    private BufferDB sharedLocation;
    private Parametro paramProperties;

    public ConsumidorConsulta(BufferDB shared, Parametro param) {
        this.sharedLocation = shared;
        this.paramProperties = param;
    }

    private String RetornaNomeSemExtensao(String nomeFile) {
        return nomeFile.substring(0, nomeFile.lastIndexOf("."));
    }

    private void GeraRetornoNFE(Object result, EnvioIntegracao objEnvio) throws IOException {
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoNFE.gerarTXT(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
            }
            RetornoNFE.gerarTXT(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
        }
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoNFE.gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result, null, objEnvio);
            }
            RetornoNFE.gerarXML_SEFAZ(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result, null, objEnvio);
        }
    }

    private void GeraRetornoCTE(Object result, EnvioIntegracao objEnvio) throws IOException {
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ || objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoCTE.gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo()) + ".XML", objEnvio, result);
            }
            RetornoCTE.gerarXML_SEFAZ(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo()) + ".XML", objEnvio, result);
        }
    }

    @Override
    public void run() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        String nomeFile = "";
        while (true) {
            EnvioIntegracao objEnvio = new EnvioIntegracao();
            objEnvio = (EnvioIntegracao)this.sharedLocation.Get();
            try {
                nomeFile = objEnvio.getNomeArquivo();
                logger.info("Consultando arquivo " + nomeFile);
                if (!(objEnvio.getObjEnvio() instanceof EnvioConsulta)) continue;
                EnvioConsulta objEnv = (EnvioConsulta)objEnvio.getObjEnvio();
                if (((EnvioConsulta)objEnvio.getObjEnvio()).getUsuario() == null) {
                    ((EnvioConsulta)objEnvio.getObjEnvio()).setUsuario(this.paramProperties.getUsuarioPadraoGeral());
                }
                if (objEnv.getTipo() == TipoOBJ.CTE) {
                    RetConsultaCTe retConsCte = null;
                    retConsCte = CteInterface.consultar(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), objEnv.getNrCnpj(), objEnv.getNrDocumento().toString(), objEnv.getNrSerie(), objEnv.getTipo().name());
                    if (retConsCte.getStatus().equals((Object)RetConsultaCTe.StatusConsultaCte.AUTORIZADA) || retConsCte.getStatus().equals((Object)RetConsultaCTe.StatusConsultaCte.DENEGADO)) {
                        objEnvio.setNrChaveAcesso(retConsCte.getChaveAcesso());
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - " + retConsCte.getStatus().toString() + " - " + retConsCte.getDescricao());
                        this.GeraRetornoCTE(retConsCte, objEnvio);
                    } else if (retConsCte.getStatus().equals((Object)RetConsultaCTe.StatusConsultaCte.CANCELADO)) {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - " + retConsCte.getStatus().toString() + " - " + retConsCte.getDescricao());
                        this.GeraRetornoCTE(retConsCte, objEnvio);
                    } else {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - " + retConsCte.getStatus().toString() + " - " + retConsCte.getDescricao());
                        retConsCte.setNumero(objEnv.getNrDocumento());
                        retConsCte.setSerie(objEnv.getNrSerie());
                        this.GeraRetornoCTE(retConsCte, objEnvio);
                    }
                    RetornoCTE.DeleteTmpFile(objEnvio);
                    continue;
                }
                RetConsultaNFe retCons = null;
                retCons = NfeInterface.consultar(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), objEnv.getNrCnpj(), objEnv.getNrDocumento().toString(), objEnv.getNrSerie());
                if (retCons.getStatus().equals((Object)RetConsultaNFe.StatusConsultaNfe.AUTORIZADA) || retCons.getStatus().equals((Object)RetConsultaNFe.StatusConsultaNfe.DENEGADA)) {
                    objEnvio.setNrChaveAcesso(retCons.getChaveAcesso());
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - " + retCons.getStatus().toString() + " - " + retCons.getDescricao());
                    this.GeraRetornoNFE(retCons, objEnvio);
                } else if (retCons.getStatus().equals((Object)RetConsultaNFe.StatusConsultaNfe.CANCELADA)) {
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - " + retCons.getStatus().toString() + " - " + retCons.getDescricao());
                    RetornoNFE.GeraRetornoCancelamento(retCons, objEnvio, nomeFile, this.paramProperties);
                } else {
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - " + retCons.getStatus().toString() + " - " + retCons.getDescricao());
                    retCons.setNumero(objEnv.getNrDocumento());
                    retCons.setSerie(objEnv.getNrSerie());
                    this.GeraRetornoNFE(retCons, objEnvio);
                }
                RetornoNFE.DeleteTmpFile(objEnvio);
                continue;
            }
            catch (IOException exIO) {
                logger.severe("Erro ao gerar o arquivo: " + nomeFile + " - " + exIO.getMessage());
                continue;
            }
            catch (Exception ex) {
                logger.severe("Erro geral no envio: " + nomeFile + " - " + ex.getMessage());
                continue;
            }
            break;
        }
    }
}

