/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.monitor;

import br.com.ophos.enumerations.TipoIntegracao;
import br.com.ophos.enumerations.TipoOBJ;
import br.com.ophos.integracao.admin.config.Parametro;
import br.com.ophos.integracao.admin.config.TipoArmazenamento;
import br.com.ophos.integracao.cte.CteInterface;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTe;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.CTeOS;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.RetEnvioCTEOS;
import br.com.ophos.integracao.interfaces.nfe.NfeInterface;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.NF;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetConsultaEnvio;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetEnvio;
import br.com.ophos.interfaces.MDFeInterface;
import br.com.ophos.interfaces.NFSeInterface;
import br.com.ophos.monitor.BufferDB;
import br.com.ophos.monitor.EnvioConsulta;
import br.com.ophos.monitor.EnvioIntegracao;
import br.com.ophos.retorno.ReciboEnvio;
import br.com.ophos.retorno.RetornoCTE;
import br.com.ophos.retorno.RetornoMDFE;
import br.com.ophos.retorno.RetornoNFE;
import br.com.ophos.retorno.RetornoNFSE;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.envio.Mdfe;
import br.com.ophos.xml.mdfe.retorno.RetEnvioMdfe;
import br.com.ophos.xml.nfse.envio.v100.Rps;
import br.com.ophos.xml.nfse.retorno.v100.RetEnvioRps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class ConsumidorEnvio
implements Runnable {
    private BufferDB sharedLocation;
    private String dirSaida;
    private String dirEntrada;
    public BufferDB bRetorno;
    private BufferDB bReenvio;
    private Boolean usaContingencia;
    private BufferDB bImpContingencia;
    private Parametro paramProperties;
    private BufferDB bConsulta;
    private MDFeInterface ifaceMdfe;
    private NFSeInterface ifaceNfse;

    public ConsumidorEnvio(BufferDB shared, BufferDB bufferRetorno, BufferDB bufferReenvio, Boolean impContingencia, BufferDB bufferImpressao, Parametro param, BufferDB bufferConsulta) {
        this.sharedLocation = shared;
        this.bRetorno = bufferRetorno;
        this.bReenvio = bufferReenvio;
        this.usaContingencia = impContingencia;
        this.bImpContingencia = bufferImpressao;
        this.paramProperties = param;
        this.bConsulta = bufferConsulta;
        this.dirEntrada = param.getDataIn();
        this.dirSaida = param.getDataOut();
    }

    public ConsumidorEnvio(BufferDB shared, String saida, String entrada, Object portNFE, Object portAdmin, BufferDB bufferRetorno, TipoIntegracao tpSaida, BufferDB bufferReenvio, Boolean impContingencia, BufferDB bufferImpressao, Parametro param, BufferDB bufferConsulta, MDFeInterface ifaceMdfe) {
        this.sharedLocation = shared;
        this.dirSaida = saida;
        this.dirEntrada = entrada;
        this.bRetorno = bufferRetorno;
        this.bReenvio = bufferReenvio;
        this.usaContingencia = impContingencia;
        this.bImpContingencia = bufferImpressao;
        this.paramProperties = param;
        this.bConsulta = bufferConsulta;
        this.ifaceMdfe = ifaceMdfe;
    }

    public ConsumidorEnvio(BufferDB shared, String saida, String entrada, Object portNFE, Object portAdmin, BufferDB bufferRetorno, TipoIntegracao tpSaida, BufferDB bufferReenvio, Boolean impContingencia, BufferDB bufferImpressao, Parametro param, BufferDB bufferConsulta, NFSeInterface ifaceNfse) {
        this.sharedLocation = shared;
        this.dirSaida = saida;
        this.dirEntrada = entrada;
        this.bRetorno = bufferRetorno;
        this.bReenvio = bufferReenvio;
        this.usaContingencia = impContingencia;
        this.bImpContingencia = bufferImpressao;
        this.paramProperties = param;
        this.bConsulta = bufferConsulta;
        this.ifaceNfse = ifaceNfse;
    }

    private String RetornaNomeSemExtensao(String nomeFile) {
        return nomeFile.substring(0, nomeFile.lastIndexOf("."));
    }

    private void DeleteTmpFile(EnvioIntegracao objEnvio) throws IOException {
        File file2;
        File file;
        String nomeFilein = objEnvio.getPathFileArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.XML) {
            file = new File(nomeFilein + ".TMX");
            file.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.TXT) {
            file = new File(nomeFilein + ".TMP");
            while (file.exists()) {
                file.delete();
            }
            file2 = new File(nomeFilein + ".TMX");
            while (file2.exists()) {
                file2.delete();
            }
            file2.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.BANCO) {
            file = new File(nomeFilein + ".BD");
            file.delete();
            file2 = new File(nomeFilein + ".BDK");
            file2.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.SAP) {
            file = new File(nomeFilein + ".SAP1");
            file.delete();
        }
    }

    private void SerializeObjectRecibo(ReciboEnvio obj) throws IOException {
        String nomeFilein = obj.getNomeArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        FileOutputStream fo = new FileOutputStream(this.dirEntrada + "/" + nomeFilein + ".REC");
        ObjectOutputStream oo = new ObjectOutputStream(fo);
        oo.writeObject(obj);
        oo.close();
    }

    private void CriarREEFile(EnvioIntegracao obj) throws IOException {
        String nomeFilein = obj.getNomeArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        FileOutputStream fo = new FileOutputStream(this.dirEntrada + "/" + nomeFilein + ".REE");
        ObjectOutputStream oo = new ObjectOutputStream(fo);
        oo.writeObject(obj);
        oo.close();
    }

    private void AcionaContingencia(EnvioIntegracao obj) throws IOException {
        this.CriarREEFile(obj);
        if (this.usaContingencia.booleanValue()) {
            if (obj.getObjEnvio() instanceof NF) {
                NF objNf = (NF)obj.getObjEnvio();
                obj.setObjEnvio(objNf);
            }
            if (obj.getObjEnvio() instanceof CTe) {
                CTe objCt = (CTe)obj.getObjEnvio();
                obj.setObjEnvio(objCt);
            }
            if (obj.getObjEnvio() instanceof Mdfe) {
                Mdfe objMdfe = (Mdfe)obj.getObjEnvio();
                obj.setObjEnvio(objMdfe);
            }
            this.bImpContingencia.Set(obj);
            obj.setObjEmContingencia(true);
            obj.setObjImpresso(true);
            this.bReenvio.Set(obj);
        } else {
            obj.setObjEmContingencia(false);
            obj.setObjImpresso(false);
            this.bReenvio.Set(obj);
        }
    }

    private void GeraRetornoNFE(RetEnvio result, RetConsultaEnvio resultConsulta, EnvioIntegracao objEnvio, String nrMsgEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        NF objNF = (NF)objEnvio.getObjEnvio();
        result.setReferencia(objNF.getNrReferencia());
        result.setCnpj(objNF.getEmitente().getNrCnpj());
        result.setNumero(objNF.getNumeroDocumentoFiscal());
        result.setSerie(objNF.getSerie());
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            RetornoNFE.gerarTXT(this.dirSaida, this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoNFE.gerarTXT(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
            }
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML || objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                RetornoNFE.gerarXML_Integra(this.dirSaida, this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", resultConsulta, result, objEnvio.getNrChaveAcesso());
            }
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                if (result.getStatus().equals((Object)RetEnvio.StatusEnvio.ERRO_VALIDACAO) && result.getMensagem().startsWith("Rejei\u00e7\u00e3o")) {
                    EnvioConsulta objEnv = new EnvioConsulta();
                    NF objLido = (NF)objEnvio.getObjEnvio();
                    objEnv.setNrCnpj(objLido.getEmitente().getNrCnpj());
                    objEnv.setNrDocumento(objLido.getNumeroDocumentoFiscal());
                    objEnv.setNrIe(objLido.getEmitente().getIe());
                    objEnv.setNrSerie(objLido.getSerie());
                    objEnv.setUsuario(objLido.getUsuarioEmitente());
                    objEnvio.setObjEnvio(objEnv);
                    this.bConsulta.Set(objEnvio);
                } else {
                    RetornoNFE.gerarXML_SEFAZ(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", resultConsulta, result, objEnvio);
                }
            }
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                    RetornoNFE.gerarXML_Integra(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", resultConsulta, result, objEnvio.getNrChaveAcesso());
                }
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                    RetornoNFE.gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", resultConsulta, result, objEnvio);
                }
            }
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
    }

    private void GeraRetornoCTE(br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio result, EnvioIntegracao objEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            RetornoCTE.gerarTxtEnvio(this.dirSaida, objEnvio.getNomeArquivo(), result);
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
            RetornoCTE.gerarXML_SEFAZ(this.dirSaida, objEnvio.getNomeArquivo(), objEnvio, result);
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
    }

    private void GeraRetornoCTEOS(RetEnvioCTEOS result, EnvioIntegracao objEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            RetornoCTE.gerarTxtEnvio(this.dirSaida, objEnvio.getNomeArquivo(), result);
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
            RetornoCTE.gerarXML_SEFAZ(this.dirSaida, objEnvio.getNomeArquivo(), objEnvio, result);
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
    }

    private void GeraRetornoMDFE(RetEnvioMdfe result, EnvioIntegracao objEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            RetornoMDFE.gerarRetornoEnvio(this.dirSaida, objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), result);
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
    }

    private void GeraRetornoNFSE(RetEnvioRps result, EnvioIntegracao objEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            RetornoNFSE.gerarRetornoEnvio(this.dirSaida, objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), result);
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + String.valueOf(result.getStatus()) + " - " + result.getMensagem());
        }
    }

    @Override
    public void run() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        String nomeFile = "";
        String statusWS = "";
        while (true) {
            EnvioIntegracao objEnvio = new EnvioIntegracao();
            try {
                Object objLido;
                objEnvio = (EnvioIntegracao)this.sharedLocation.Get();
                nomeFile = objEnvio.getNomeArquivo();
                logger.info(this.paramProperties.getVersaoIntegrador() + " - Enviando arquivo " + objEnvio.getNomeArquivo());
                Object result = null;
                String idRecibo = "";
                String msgRet = "";
                TipoOBJ tpOBJ = null;
                if (objEnvio.getObjEnvio() instanceof NF) {
                    if (this.paramProperties.getValidaCaracteres().booleanValue()) {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - Retirando caracteres especiais...");
                        Util.retiraCaracteres((NF)objEnvio.getObjEnvio(), this.paramProperties.getCaracteresPermitidos());
                    }
                    if (((NF)objEnvio.getObjEnvio()).getUsuarioEmitente() == null) {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - Setando usu\u00e1rio padr\u00e3o...");
                        ((NF)objEnvio.getObjEnvio()).setUsuarioEmitente(this.paramProperties.getUsuarioPadraoGeral());
                    }
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - Comunicando com o WebService...");
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - URL: " + this.paramProperties.getUrlbase());
                    result = NfeInterface.enviar(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), (NF)objEnvio.getObjEnvio());
                    statusWS = ((RetEnvio)result).getStatus().toString();
                    msgRet = ((RetEnvio)result).getMensagem();
                    tpOBJ = TipoOBJ.NFE;
                }
                if (objEnvio.getObjEnvio() instanceof CTe) {
                    if (this.paramProperties.getValidaCaracteres().booleanValue()) {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - Retirando caracteres especiais...");
                        Util.retiraCaracteres((CTe)objEnvio.getObjEnvio(), this.paramProperties.getCaracteresPermitidos());
                    }
                    if (((CTe)objEnvio.getObjEnvio()).getUsuarioEmitente() == null) {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - Setando usu\u00e1rio padr\u00e3o...");
                        ((CTe)objEnvio.getObjEnvio()).setUsuarioEmitente(this.paramProperties.getUsuarioPadraoGeral());
                    }
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - Comunicando com o WebService...");
                    result = CteInterface.enviarCTE(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), (CTe)objEnvio.getObjEnvio());
                    statusWS = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio)result).getStatus().toString();
                    msgRet = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio)result).getMensagem();
                    tpOBJ = TipoOBJ.CTE;
                }
                if (objEnvio.getObjEnvio() instanceof CTeOS) {
                    if (this.paramProperties.getValidaCaracteres().booleanValue()) {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - Retirando caracteres especiais...");
                        Util.retiraCaracteres((CTeOS)objEnvio.getObjEnvio(), this.paramProperties.getCaracteresPermitidos());
                    }
                    if (((CTeOS)objEnvio.getObjEnvio()).getUsuarioEmitente() == null) {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - Setando usu\u00e1rio padr\u00e3o...");
                        ((CTeOS)objEnvio.getObjEnvio()).setUsuarioEmitente(this.paramProperties.getUsuarioPadraoGeral());
                    }
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - Comunicando com o WebService...");
                    result = CteInterface.enviarCTEOS(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), (CTeOS)objEnvio.getObjEnvio());
                    statusWS = ((RetEnvioCTEOS)result).getStatus().toString();
                    msgRet = ((RetEnvioCTEOS)result).getMensagem();
                    tpOBJ = TipoOBJ.CTEOS;
                }
                if (objEnvio.getObjEnvio() instanceof Mdfe) {
                    if (this.paramProperties.getValidaCaracteres().booleanValue()) {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - Retirando caracteres especiais...");
                        Util.retiraCaracteres((Mdfe)objEnvio.getObjEnvio(), this.paramProperties.getCaracteresPermitidos());
                    }
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - Comunicando com o WebService...");
                    result = this.ifaceMdfe.enviarManifesto((Mdfe)objEnvio.getObjEnvio());
                    statusWS = ((RetEnvioMdfe)result).getStatus().toString();
                    msgRet = ((RetEnvioMdfe)result).getMensagem();
                    tpOBJ = TipoOBJ.MDFE;
                }
                if (objEnvio.getObjEnvio() instanceof Rps) {
                    if (this.paramProperties.getValidaCaracteres().booleanValue()) {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - Retirando caracteres especiais...");
                        Util.retiraCaracteres((Rps)objEnvio.getObjEnvio(), this.paramProperties.getCaracteresPermitidos());
                    }
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - Comunicando com o WebService...");
                    result = this.ifaceNfse.enviarRps((Rps)objEnvio.getObjEnvio());
                    statusWS = String.valueOf(((RetEnvioRps)result).getStatus());
                    msgRet = ((RetEnvioRps)result).getMensagem();
                    tpOBJ = TipoOBJ.NFSE;
                }
                if (statusWS.equals("SUCESSO") || statusWS.equals("ERRO_NF_JA_AUTORIZADA") || statusWS.equals("ERRO_CT_JA_AUTORIZADO") || statusWS.equals("100") || statusWS.equals("503")) {
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - SUCESSO - " + msgRet);
                    if (tpOBJ == TipoOBJ.NFE) {
                        idRecibo = ((RetEnvio)result).getHash().toString();
                    }
                    if (tpOBJ == TipoOBJ.CTE) {
                        idRecibo = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio)result).getHash();
                    }
                    if (tpOBJ == TipoOBJ.CTEOS) {
                        idRecibo = ((RetEnvioCTEOS)result).getHash();
                    }
                    if (tpOBJ == TipoOBJ.MDFE) {
                        idRecibo = String.valueOf(((RetEnvioMdfe)result).getNumero());
                    }
                    if (tpOBJ == TipoOBJ.NFSE) {
                        idRecibo = String.valueOf(((RetEnvioRps)result).getNumero());
                    }
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - ID Envio: " + idRecibo);
                    ReciboEnvio objRec = new ReciboEnvio(idRecibo, nomeFile);
                    objRec.setTpOBJ(tpOBJ);
                    objRec.setTpIntegracao(objEnvio.getTpIntegraSaida());
                    objRec.setNrChaveAcesso(objEnvio.getNrChaveAcesso());
                    objRec.setNrReferencia(objEnvio.getIdObj());
                    if (objEnvio.getObjEnvio() instanceof NF) {
                        objLido = (NF)objEnvio.getObjEnvio();
                        objRec.setLock(Integer.parseInt(((NF)objLido).getSerie().toString()));
                    }
                    if (objEnvio.getObjEnvio() instanceof Mdfe) {
                        objLido = (Mdfe)objEnvio.getObjEnvio();
                        objRec.setCnpj(((Mdfe)objLido).getEmitente().getCnpj());
                        objRec.setNumero(String.valueOf(((Mdfe)objLido).getNumero()));
                        objRec.setSerie(String.valueOf(((Mdfe)objLido).getSerie()));
                    }
                    if (objEnvio.getObjEnvio() instanceof Rps) {
                        objLido = (Rps)objEnvio.getObjEnvio();
                        objRec.setCnpj(((Rps)objLido).getPrestador().getCnpj());
                        objRec.setNumero(String.valueOf(((Rps)objLido).getNumero()));
                        objRec.setSerie(String.valueOf(((Rps)objLido).getSerie()));
                    }
                    if (objEnvio.getObjEnvio() instanceof CTeOS) {
                        objLido = (CTeOS)objEnvio.getObjEnvio();
                        objRec.setCnpj(((CTeOS)objLido).getEmitente().getCnpj());
                        objRec.setNumero(String.valueOf(((CTeOS)objLido).getNumero()));
                        objRec.setSerie(String.valueOf(((CTeOS)objLido).getSerie()));
                    }
                    if (objEnvio.getObjEnvio() instanceof CTe) {
                        objLido = (CTe)objEnvio.getObjEnvio();
                        objRec.setCnpj(((CTe)objLido).getEmitente().getCnpj());
                        objRec.setNumero(String.valueOf(((CTe)objLido).getNumero()));
                        objRec.setSerie(String.valueOf(((CTe)objLido).getSerie()));
                    }
                    this.SerializeObjectRecibo(objRec);
                    this.bRetorno.Set(objRec);
                    this.DeleteTmpFile(objEnvio);
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - ID armazenado");
                    continue;
                }
                if (statusWS.equals("DENEGADA")) {
                    EnvioConsulta objEnv = new EnvioConsulta();
                    objLido = (NF)objEnvio.getObjEnvio();
                    objEnv.setNrCnpj(((NF)objLido).getEmitente().getNrCnpj());
                    objEnv.setNrDocumento(((NF)objLido).getNumeroDocumentoFiscal());
                    objEnv.setNrIe(((NF)objLido).getEmitente().getIe());
                    objEnv.setNrSerie(((NF)objLido).getSerie());
                    objEnv.setUsuario(((NF)objLido).getUsuarioEmitente());
                    objEnvio.setObjEnvio(objEnv);
                    this.bConsulta.Set(objEnvio);
                    continue;
                }
                if (result instanceof RetEnvio) {
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - " + ((RetEnvio)result).getMensagem());
                    NF objNf = (NF)objEnvio.getObjEnvio();
                    this.GeraRetornoNFE((RetEnvio)result, null, objEnvio, "999");
                    this.DeleteTmpFile(objEnvio);
                }
                if (result instanceof br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio) {
                    this.GeraRetornoCTE((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio)result, objEnvio);
                    this.DeleteTmpFile(objEnvio);
                }
                if (result instanceof RetEnvioCTEOS) {
                    this.GeraRetornoCTEOS((RetEnvioCTEOS)result, objEnvio);
                    this.DeleteTmpFile(objEnvio);
                }
                if (result instanceof RetEnvioMdfe) {
                    this.GeraRetornoMDFE((RetEnvioMdfe)result, objEnvio);
                    this.DeleteTmpFile(objEnvio);
                }
                if (!(result instanceof RetEnvioRps)) continue;
                this.GeraRetornoNFSE((RetEnvioRps)result, objEnvio);
                this.DeleteTmpFile(objEnvio);
                continue;
            }
            catch (ConnectException e) {
                logger.severe(this.paramProperties.getVersaoIntegrador() + " - Erro de conex\u00e3o:  - " + e.getMessage());
                try {
                    this.AcionaContingencia(objEnvio);
                }
                catch (IOException exClose) {
                    logger.severe(this.paramProperties.getVersaoIntegrador() + " - Erro ao acionar conting\u00eancia. " + exClose.getMessage());
                }
                continue;
            }
            catch (UnknownHostException e) {
                logger.severe(this.paramProperties.getVersaoIntegrador() + " - Host desconhecido:  - " + e.getMessage());
                try {
                    this.AcionaContingencia(objEnvio);
                }
                catch (IOException exClose) {
                    logger.severe(this.paramProperties.getVersaoIntegrador() + " - Erro ao acionar conting\u00eancia. " + exClose.getMessage());
                }
                continue;
            }
            catch (IOException e) {
                logger.severe(this.paramProperties.getVersaoIntegrador() + " - Erro de I/O:  - " + e.getMessage());
                try {
                    this.AcionaContingencia(objEnvio);
                }
                catch (IOException exClose) {
                    logger.severe(this.paramProperties.getVersaoIntegrador() + " - Erro ao acionar conting\u00eancia. " + exClose.getMessage());
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.severe(this.paramProperties.getVersaoIntegrador() + " - Erro geral no envio:  - " + ex.getMessage() + " " + ex.getCause());
                continue;
            }
            break;
        }
    }
}

