/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.monitor;

import br.com.ophos.enumerations.TipoIntegracao;
import br.com.ophos.enumerations.TipoOBJ;
import br.com.ophos.integracao.admin.config.Parametro;
import br.com.ophos.integracao.admin.config.TipoArmazenamento;
import br.com.ophos.integracao.cte.CteInterface;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTe;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.CTeOS;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.RetEnvioCTEOS;
import br.com.ophos.integracao.interfaces.nfe.NfeInterface;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.NF;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetConsultaEnvio;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetEnvio;
import br.com.ophos.interfaces.MDFeInterface;
import br.com.ophos.interfaces.NFSeInterface;
import br.com.ophos.monitor.BufferDB;
import br.com.ophos.monitor.EnvioIntegracao;
import br.com.ophos.retorno.ReciboEnvio;
import br.com.ophos.retorno.RetRecepcaoNFe;
import br.com.ophos.retorno.RetornoCTE;
import br.com.ophos.retorno.RetornoMDFE;
import br.com.ophos.retorno.RetornoNFE;
import br.com.ophos.retorno.RetornoNFSE;
import br.com.ophos.xml.mdfe.envio.Mdfe;
import br.com.ophos.xml.mdfe.retorno.RetEnvioMdfe;
import br.com.ophos.xml.nfse.envio.v100.Rps;
import br.com.ophos.xml.nfse.retorno.v100.RetEnvioRps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class ConsumidorReenvio
implements Runnable {
    private BufferDB bReenvio;
    private String dirSaida;
    private String dirEntrada;
    public BufferDB bRetorno;
    private Boolean nextObject;
    private Integer tReenvio;
    private Parametro paramProperties;
    private MDFeInterface ifaceMdfe;
    private NFSeInterface ifaceNfse;

    public ConsumidorReenvio(BufferDB bufferRetorno, BufferDB bufferReenvio, Parametro param) {
        this.dirSaida = param.getDataOut();
        this.dirEntrada = param.getDataIn();
        this.tReenvio = param.getTempoEnvio();
        this.bRetorno = bufferRetorno;
        this.bReenvio = bufferReenvio;
        this.paramProperties = param;
    }

    public ConsumidorReenvio(String saida, String entrada, Object portAdmin, Object portNFE, BufferDB bufferRetorno, BufferDB bufferReenvio, Integer tempoEnvio, Parametro param, MDFeInterface ifaceMdfe) {
        this.dirSaida = saida;
        this.dirEntrada = entrada;
        this.bRetorno = bufferRetorno;
        this.bReenvio = bufferReenvio;
        this.nextObject = false;
        this.tReenvio = tempoEnvio;
        this.paramProperties = param;
        this.ifaceMdfe = ifaceMdfe;
    }

    public ConsumidorReenvio(String saida, String entrada, Object portAdmin, Object portNFE, BufferDB bufferRetorno, BufferDB bufferReenvio, Integer tempoEnvio, Parametro param, NFSeInterface ifaceNfse) {
        this.dirSaida = saida;
        this.dirEntrada = entrada;
        this.bRetorno = bufferRetorno;
        this.bReenvio = bufferReenvio;
        this.nextObject = false;
        this.tReenvio = tempoEnvio;
        this.paramProperties = param;
        this.ifaceNfse = ifaceNfse;
    }

    private void DeleteTmpFile(EnvioIntegracao objEnvio) throws IOException {
        File file2;
        File file;
        String nomeFilein = objEnvio.getPathFileArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.XML) {
            file = new File(nomeFilein + ".TMX");
            file.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.TXT) {
            file = new File(nomeFilein + ".TMP");
            file.delete();
            file2 = new File(nomeFilein + ".TMX");
            file2.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.BANCO) {
            file = new File(nomeFilein + ".BD");
            file.delete();
            file2 = new File(nomeFilein + ".BDK");
            file2.delete();
        }
    }

    private void DeleteRenFile(String pathFile) throws IOException {
        String nomeFilein = pathFile;
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        File file = new File(nomeFilein + ".ren");
        file.delete();
    }

    private void DeleteReeFile(String pathFile) throws IOException {
        String nomeFilein = pathFile;
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        File file = new File(nomeFilein + ".ree");
        file.delete();
    }

    private void SerializeObjectRecibo(ReciboEnvio obj) throws IOException {
        String nomeFilein = obj.getNomeArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        FileOutputStream fo = new FileOutputStream(this.dirEntrada + "/" + nomeFilein + ".REC");
        ObjectOutputStream oo = new ObjectOutputStream(fo);
        oo.writeObject(obj);
        oo.close();
    }

    private void InsereBufferReenvio(EnvioIntegracao obj) throws IOException {
        this.nextObject = false;
    }

    private String RetornaNomeSemExtensao(String nomeFile) {
        return nomeFile.substring(0, nomeFile.lastIndexOf("."));
    }

    private void GeraRetornoNFE(RetEnvio result, RetConsultaEnvio resultConsulta, EnvioIntegracao objEnvio, String nrMsgEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        NF objNF = (NF)objEnvio.getObjEnvio();
        result.setReferencia(objNF.getNrReferencia());
        result.setCnpj(objNF.getEmitente().getNrCnpj());
        result.setNumero(objNF.getNumeroDocumentoFiscal());
        result.setSerie(objNF.getSerie());
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            RetornoNFE.gerarTXT(this.dirSaida, this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoNFE.gerarTXT(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
            }
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML || objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                RetornoNFE.gerarXML_Integra(this.dirSaida, this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", resultConsulta, result, objEnvio.getNrChaveAcesso());
            }
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                RetornoNFE.gerarXML_SEFAZ(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", resultConsulta, result, objEnvio);
            }
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                    RetornoNFE.gerarXML_Integra(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", resultConsulta, result, objEnvio.getNrChaveAcesso());
                }
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                    RetornoNFE.gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", resultConsulta, result, objEnvio);
                }
            }
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
    }

    private void GeraRetornoCTE(br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio result, EnvioIntegracao objEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            RetornoCTE.gerarTxtEnvio(this.dirSaida, objEnvio.getNomeArquivo(), result);
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
    }

    private void GeraRetornoCTEOS(RetEnvioCTEOS result, EnvioIntegracao objEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            RetornoCTE.gerarTxtEnvio(this.dirSaida, objEnvio.getNomeArquivo(), result);
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
    }

    private void GeraRetornoMDFE(RetEnvioMdfe result, EnvioIntegracao objEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            RetornoMDFE.gerarRetornoEnvio(this.dirSaida, objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), result);
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
        }
    }

    private void GeraRetornoNFSE(RetEnvioRps result, EnvioIntegracao objEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            RetornoNFSE.gerarRetornoEnvio(this.dirSaida, objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), result);
            logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + String.valueOf(result.getStatus()) + " - " + result.getMensagem());
        }
    }

    @Override
    public void run() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        String nomeFile = "";
        block13: while (true) {
            EnvioIntegracao objEnvio = (EnvioIntegracao)this.bReenvio.Get();
            this.nextObject = false;
            while (true) {
                if (this.nextObject.booleanValue()) continue block13;
                try {
                    logger.info("Reenviando arquivo " + objEnvio.getNomeArquivo());
                    Object result = null;
                    String statusWS = "";
                    String idRecibo = "";
                    String msgRet = "";
                    TipoOBJ tpOBJ = null;
                    nomeFile = objEnvio.getNomeArquivo();
                    if (objEnvio.getObjEnvio() instanceof NF) {
                        result = NfeInterface.enviar(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), (NF)objEnvio.getObjEnvio());
                        statusWS = ((RetEnvio)result).getStatus().toString();
                        msgRet = ((RetEnvio)result).getMensagem();
                        tpOBJ = TipoOBJ.NFE;
                    }
                    if (objEnvio.getObjEnvio() instanceof CTe) {
                        result = CteInterface.enviarCTE(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), (CTe)objEnvio.getObjEnvio());
                        statusWS = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio)result).getStatus().toString();
                        msgRet = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio)result).getMensagem();
                        tpOBJ = TipoOBJ.CTE;
                    }
                    if (objEnvio.getObjEnvio() instanceof CTeOS) {
                        result = CteInterface.enviarCTEOS(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), (CTeOS)objEnvio.getObjEnvio());
                        statusWS = ((RetEnvioCTEOS)result).getStatus().toString();
                        msgRet = ((RetEnvioCTEOS)result).getMensagem();
                        tpOBJ = TipoOBJ.CTEOS;
                    }
                    if (objEnvio.getObjEnvio() instanceof Mdfe) {
                        result = this.ifaceMdfe.enviarManifesto((Mdfe)objEnvio.getObjEnvio());
                        statusWS = ((RetEnvioMdfe)result).getStatus().toString();
                        msgRet = ((RetEnvioMdfe)result).getMensagem();
                        tpOBJ = TipoOBJ.MDFE;
                    }
                    if (objEnvio.getObjEnvio() instanceof Rps) {
                        result = this.ifaceNfse.enviarRps((Rps)objEnvio.getObjEnvio());
                        statusWS = String.valueOf(((RetEnvioRps)result).getStatus());
                        msgRet = ((RetEnvioRps)result).getMensagem();
                        tpOBJ = TipoOBJ.NFSE;
                    }
                    this.nextObject = true;
                    if (statusWS.equals("SUCESSO") || statusWS.equals("ERRO_NF_JA_AUTORIZADA") || statusWS.equals("ERRO_CT_JA_AUTORIZADO") || statusWS.equals("100") || statusWS.equals("503")) {
                        Object objLido;
                        logger.info("SUCESSO - " + msgRet);
                        logger.info("ID Envio: " + idRecibo);
                        if (tpOBJ == TipoOBJ.NFE) {
                            idRecibo = ((RetEnvio)result).getHash();
                        }
                        if (tpOBJ == TipoOBJ.CTE) {
                            idRecibo = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio)result).getHash();
                        }
                        if (tpOBJ == TipoOBJ.CTEOS) {
                            idRecibo = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio)result).getHash();
                        }
                        if (tpOBJ == TipoOBJ.MDFE) {
                            idRecibo = String.valueOf(((RetEnvioMdfe)result).getNumero());
                        }
                        if (tpOBJ == TipoOBJ.NFSE) {
                            idRecibo = String.valueOf(((RetEnvioRps)result).getNumero());
                        }
                        logger.info("ID Envio: " + idRecibo);
                        ReciboEnvio objRec = new ReciboEnvio(idRecibo, nomeFile);
                        objRec.setTpOBJ(tpOBJ);
                        objRec.setTpIntegracao(objEnvio.getTpIntegraSaida());
                        objRec.setNrChaveAcesso(objEnvio.getNrChaveAcesso());
                        objRec.setNrReferencia(objEnvio.getIdObj());
                        if (objEnvio.getObjEnvio() instanceof NF) {
                            objLido = (NF)objEnvio.getObjEnvio();
                            objRec.setLock(Integer.parseInt(((NF)objLido).getSerie().toString()));
                        }
                        if (objEnvio.getObjEnvio() instanceof Mdfe) {
                            objLido = (Mdfe)objEnvio.getObjEnvio();
                            objRec.setCnpj(((Mdfe)objLido).getEmitente().getCnpj());
                            objRec.setNumero(String.valueOf(((Mdfe)objLido).getNumero()));
                            objRec.setSerie(String.valueOf(((Mdfe)objLido).getSerie()));
                        }
                        if (objEnvio.getObjEnvio() instanceof Rps) {
                            objLido = (Rps)objEnvio.getObjEnvio();
                            objRec.setCnpj(((Rps)objLido).getPrestador().getCnpj());
                            objRec.setNumero(String.valueOf(((Rps)objLido).getNumero()));
                            objRec.setSerie(String.valueOf(((Rps)objLido).getSerie()));
                        }
                        this.SerializeObjectRecibo(objRec);
                        this.bRetorno.Set(objRec);
                        this.DeleteTmpFile(objEnvio);
                        logger.info("ID armazenado");
                    } else {
                        if (result instanceof RetRecepcaoNFe) {
                            logger.info(this.paramProperties.getVersaoIntegrador() + " - " + ((RetRecepcaoNFe)result).getMsg());
                            this.GeraRetornoNFE((RetEnvio)result, null, objEnvio, "999");
                            this.DeleteTmpFile(objEnvio);
                        }
                        if (result instanceof RetEnvio) {
                            logger.info(this.paramProperties.getVersaoIntegrador() + " - " + ((RetEnvio)result).getMensagem());
                            this.GeraRetornoNFE((RetEnvio)result, null, objEnvio, "999");
                            this.DeleteTmpFile(objEnvio);
                        }
                        if (result instanceof br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio) {
                            logger.info(this.paramProperties.getVersaoIntegrador() + " - " + ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio)result).getMensagem());
                            this.GeraRetornoCTE((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio)result, objEnvio);
                            this.DeleteTmpFile(objEnvio);
                        }
                        if (result instanceof RetEnvioCTEOS) {
                            this.GeraRetornoCTEOS((RetEnvioCTEOS)result, objEnvio);
                            this.DeleteTmpFile(objEnvio);
                        }
                        if (result instanceof RetEnvioMdfe) {
                            this.GeraRetornoMDFE((RetEnvioMdfe)result, objEnvio);
                            this.DeleteTmpFile(objEnvio);
                        }
                        if (result instanceof RetEnvioRps) {
                            this.GeraRetornoNFSE((RetEnvioRps)result, objEnvio);
                            this.DeleteTmpFile(objEnvio);
                        }
                    }
                    this.DeleteReeFile(objEnvio.getPathFileArquivo());
                    this.DeleteRenFile(objEnvio.getPathFileArquivo());
                }
                catch (ConnectException e) {
                    logger.severe("Erro de conex\u00e3o: " + objEnvio.getNomeArquivo() + " - " + e.getMessage());
                    try {
                        this.InsereBufferReenvio(objEnvio);
                    }
                    catch (IOException exClose) {
                        logger.severe("Erro ao acionar conting\u00eancia. " + exClose.getMessage());
                    }
                }
                catch (UnknownHostException e) {
                    logger.severe("Host desconhecido: " + objEnvio.getNomeArquivo() + " - " + e.getMessage());
                    try {
                        this.InsereBufferReenvio(objEnvio);
                    }
                    catch (IOException exClose) {
                        logger.severe("Erro ao acionar conting\u00eancia. " + exClose.getMessage());
                    }
                }
                catch (IOException e) {
                    logger.severe("Erro de I/O: " + objEnvio.getNomeArquivo() + " - " + e.getMessage());
                    try {
                        this.InsereBufferReenvio(objEnvio);
                    }
                    catch (IOException exClose) {
                        logger.severe("Erro ao acionar conting\u00eancia. " + exClose.getMessage());
                    }
                }
                catch (Exception ex) {
                    if (ex.getMessage() != null) {
                        logger.severe("Erro geral no envio: " + objEnvio.getNomeArquivo() + " - " + ex.getMessage());
                    }
                    logger.severe("Erro geral no envio (getCause): " + objEnvio.getNomeArquivo() + " - " + ex.getCause());
                }
                try {
                    if (this.tReenvio == 0) continue;
                    Thread.sleep(this.tReenvio.intValue());
                }
                catch (Exception exception) {
                }
            }
            break;
        }
    }
}

