/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.monitor;

import br.com.ophos.enumerations.TipoArquivo;
import br.com.ophos.enumerations.TipoIntegracao;
import br.com.ophos.enumerations.TipoOBJ;
import br.com.ophos.integracao.admin.config.Parametro;
import br.com.ophos.integracao.admin.config.TipoArmazenamento;
import br.com.ophos.integracao.cte.CteInterface;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTe;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaEnvio;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.CTeOS;
import br.com.ophos.integracao.interfaces.dto.RetEvento;
import br.com.ophos.integracao.interfaces.nfe.NfeInterface;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.NF;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetEnvio;
import br.com.ophos.integracao.interfaces.nfe.dto.evento.StatusEvento;
import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTCancelFactory;
import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTConsultaNFeFactory;
import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTConsultaStatusFactory;
import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTEnvioNFEFactory;
import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTEventoFactory;
import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTInutFactory;
import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTSefazFactory;
import br.com.ophos.integracao.parse.nfe.xml.ParseXMLCancelNFE;
import br.com.ophos.integracao.parse.nfe.xml.ParseXMLConsultaNFE;
import br.com.ophos.integracao.parse.nfe.xml.ParseXMLInutNFE;
import br.com.ophos.integracao.parse.nfe.xml.factory.ParseXMLEventoFactory;
import br.com.ophos.integracao.parse.nfe.xml.factory.ParseXMLFactory;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.TNFe;
import br.com.ophos.integracao.parse.nfe.xml.v4.sefaz.TNFe;
import br.com.ophos.monitor.BufferDB;
import br.com.ophos.monitor.EnvioConsultaXML;
import br.com.ophos.monitor.EnvioIntegracao;
import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.ParseException2;
import br.com.ophos.parse.txt.cte.factory.ParseTXTAverbacaoCTEFactory;
import br.com.ophos.parse.txt.cte.factory.ParseTXTCancelamentoCTEFactory;
import br.com.ophos.parse.txt.cte.factory.ParseTXTEnvioCTEFactory;
import br.com.ophos.parse.txt.cte.factory.ParseTXTEventoCTEFactory;
import br.com.ophos.parse.txt.cte.factory.ParseTXTInutilizacaoCTEFactory;
import br.com.ophos.parse.txt.cte.v1.ParseTXTCancelamentoCTE;
import br.com.ophos.parse.txt.cte.v1.ParseTXTInutilizacaoCTE;
import br.com.ophos.parse.txt.cteos.ParseTXTEnvioCTEOSFactory;
import br.com.ophos.parse.txt.cteos.ParseTXTEventoCTEOSFactory;
import br.com.ophos.parse.txt.mdfe.factory.ParseTXTEnvioMDFEFactory;
import br.com.ophos.parse.txt.mdfe.factory.ParseTXTEventoMDFEFactory;
import br.com.ophos.parse.txt.nfse.factory.ParseTXTEnvioNFSEFactory;
import br.com.ophos.parse.txt.nfse.factory.ParseTXTEventoNFSEFactory;
import br.com.ophos.parse.xml.cte.factory.ParseXMLEventoFactoryCTe;
import br.com.ophos.parse.xml.cte.factory.ParseXMLFactoryCTe;
import br.com.ophos.parse.xml.cte.factory.ParseXMLFactoryCancelCTe;
import br.com.ophos.parse.xml.cte.factory.ParseXMLFactoryConsCTe;
import br.com.ophos.parse.xml.cte.factory.ParseXMLFactoryInutCTe;
import br.com.ophos.retorno.RetRecepcaoCTE;
import br.com.ophos.retorno.RetRecepcaoInutilizacaoCTE;
import br.com.ophos.retorno.RetRecepcaoInutilizacaoNFE;
import br.com.ophos.retorno.RetRecepcaoNFe;
import br.com.ophos.retorno.RetornoCTE;
import br.com.ophos.retorno.RetornoMDFE;
import br.com.ophos.retorno.RetornoNFE;
import br.com.ophos.retorno.RetornoNFSE;
import br.com.ophos.status.StatusCancelamentoNFE;
import br.com.ophos.status.StatusInutilizacaoNFE;
import br.com.ophos.util.cte.Util;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.cte.V104.TCancCTe;
import br.com.ophos.xml.cte.V104.TInutCTe;
import br.com.ophos.xml.cte.V200.EventoCTE;
import br.com.ophos.xml.cte.V200.TCTe;
import br.com.ophos.xml.cte.V200.TEvento;
import br.com.ophos.xml.mdfe.evento.retorno.RetEnvioEventoMDFE;
import br.com.ophos.xml.mdfe.retorno.RetEnvioMdfe;
import br.com.ophos.xml.nfse.evento.retorno.v100.RetEnvioCancelamentoNfse;
import br.com.ophos.xml.nfse.retorno.v100.RetEnvioRps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class ProdutorEnvioFile
implements Runnable {
    private BufferDB sharedLocation;
    private Parametro paramProperties;
    private String filtroFiles;

    public ProdutorEnvioFile(BufferDB shared, Parametro param, String filtro) {
        this.sharedLocation = shared;
        this.paramProperties = param;
        this.filtroFiles = filtro;
        switch (param.getTipo()) {
            case CTE: 
            case CTEOS: {
                CteInterface.setAtivaLog(param.getLogSoap());
                break;
            }
            case NFE: {
                NfeInterface.setAtivaLog(param.getLogSoap());
            }
        }
    }

    private String RetornaNomeSemExtensao(String nomeFile) {
        return nomeFile.substring(0, nomeFile.lastIndexOf("."));
    }

    private void DeleteTmpFile(String pathFile) throws IOException {
        File file;
        String nomeFilein = pathFile;
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        if (pathFile.toLowerCase().endsWith(".txt")) {
            file = new File(nomeFilein + ".TMP");
            while (file.exists()) {
                file.delete();
            }
        }
        if (pathFile.toLowerCase().endsWith(".xml")) {
            file = new File(nomeFilein + ".TMX");
            file.delete();
            File file2 = new File(nomeFilein + ".xml");
            file2.delete();
        }
    }

    private void GeraRetornoEnvio(EnvioIntegracao objEnvio, String msg, Object objLido) throws Exception {
        Object retorno;
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (this.paramProperties.getTipo().equals((Object)TipoOBJ.CTE)) {
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoCTE.gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamento(), objEnvio.getNomeArquivo(), objEnvio, msg);
            }
            RetornoCTE.gerarXML_SEFAZ(this.paramProperties.getDataOut(), objEnvio.getNomeArquivo(), objEnvio, msg);
            logger.severe(msg);
        }
        if (this.paramProperties.getTipo().equals((Object)TipoOBJ.MDFE)) {
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + msg);
                retorno = new RetEnvioMdfe();
                ((RetEnvioMdfe)retorno).setStatus("500");
                ((RetEnvioMdfe)retorno).setMensagem(msg);
                ((RetEnvioMdfe)retorno).setAmbiente(null);
                ((RetEnvioMdfe)retorno).setChaveAcesso(null);
                ((RetEnvioMdfe)retorno).setCnpj(null);
                RetornoMDFE.gerarRetornoEnvio(this.paramProperties.getDataOut(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), retorno);
                if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                    RetornoMDFE.gerarRetornoEnvio(this.paramProperties.getPastaArmazenamentoRet(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), retorno);
                }
            }
            this.DeleteTmpFile(objEnvio.getPathFileArquivo());
        }
        if (this.paramProperties.getTipo().equals((Object)TipoOBJ.NFSE)) {
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + msg);
                retorno = new RetEnvioRps();
                ((RetEnvioRps)retorno).setStatus(Integer.parseInt("500"));
                ((RetEnvioRps)retorno).setMensagem(msg);
                ((RetEnvioRps)retorno).setPrestador(null);
                ((RetEnvioRps)retorno).setNumero(null);
                ((RetEnvioRps)retorno).setSerie(null);
                ((RetEnvioRps)retorno).setHash(null);
                ((RetEnvioRps)retorno).setAmbiente(null);
                RetornoNFSE.gerarRetornoEnvio(this.paramProperties.getDataOut(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), retorno);
                if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                    RetornoNFSE.gerarRetornoEnvio(this.paramProperties.getPastaArmazenamentoRet(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), retorno);
                }
            }
            this.DeleteTmpFile(objEnvio.getPathFileArquivo());
        }
        if (this.paramProperties.getTipo().equals((Object)TipoOBJ.NFE)) {
            br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetEnvio ret;
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                ret = new br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetEnvio();
                if (objLido != null) {
                    NF objNF = (NF)objLido;
                    ret.setAmbienteSistema(null);
                    ret.setReferencia(objNF.getNrReferencia());
                    if (objNF.getEmitente() != null) {
                        ret.setCnpj(objNF.getEmitente().getNrCnpj());
                    }
                    if (objNF.getNumeroDocumentoFiscal() != null) {
                        ret.setNumero(objNF.getNumeroDocumentoFiscal());
                    }
                    if (objNF.getSerie() != null) {
                        ret.setSerie(objNF.getSerie());
                    }
                }
                ret.setStatus(RetEnvio.StatusEnvio.ERRO_VALIDACAO);
                ret.setMensagem("Erro ao ler o arquivo " + objEnvio.getNomeArquivo() + " - Layout Inv\u00e1lido - " + msg);
                try {
                    RetornoNFE.gerarTXT(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", ret);
                    if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                        RetornoNFE.gerarTXT(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", ret);
                    }
                    logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + msg);
                }
                catch (IOException exIo) {
                    logger.severe("Ocorreu um erro ao gerar TXT de envio. " + exIo.getMessage());
                }
                try {
                    this.DeleteTmpFile(objEnvio.getPathFileArquivo());
                }
                catch (IOException exIo) {
                    logger.severe("Ocorreu um erro ao apagar o arquivo tempor\u00e1rio. " + exIo.getMessage());
                }
                logger.severe(ret.getMensagem());
            }
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML || objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                ret = new br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetEnvio();
                String chaveAcessoLida = "";
                if (objLido != null) {
                    NF objNF = (NF)objLido;
                    ret.setAmbienteSistema(null);
                    if (objNF.getNrReferencia() != null) {
                        ret.setReferencia(objNF.getNrReferencia());
                    } else {
                        ret.setReferencia("");
                    }
                    if (objNF.getEmitente() != null && objNF.getEmitente().getNrCnpj() != null) {
                        ret.setCnpj(objNF.getEmitente().getNrCnpj());
                    }
                    if (objNF.getNumeroDocumentoFiscal() != null) {
                        ret.setNumero(objNF.getNumeroDocumentoFiscal());
                    }
                    if (objNF.getSerie() != null) {
                        ret.setSerie(objNF.getSerie());
                    }
                    if (objNF.getNrChaveAcesso() != null) {
                        chaveAcessoLida = objNF.getNrChaveAcesso();
                    }
                }
                ret.setStatus(RetEnvio.StatusEnvio.ERRO_VALIDACAO);
                ret.setMensagem("Erro ao ler o arquivo " + objEnvio.getNomeArquivo() + " - Layout Inv\u00e1lido - " + msg);
                try {
                    if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                        RetornoNFE.gerarXML_Integra(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", null, ret, chaveAcessoLida);
                    }
                    if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                        RetornoNFE.gerarXML_SEFAZ(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", null, ret, objEnvio);
                    }
                    if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                            RetornoNFE.gerarXML_Integra(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", null, ret, chaveAcessoLida);
                        }
                        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                            RetornoNFE.gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", null, ret, objEnvio);
                        }
                    }
                }
                catch (IOException exIo) {
                    logger.severe("Ocorreu um erro ao gerar TXT de envio. " + exIo.getMessage());
                }
                try {
                    this.DeleteTmpFile(objEnvio.getPathFileArquivo());
                }
                catch (IOException exIo) {
                    logger.severe("Ocorreu um erro ao apagar o arquivo tempor\u00e1rio. " + exIo.getMessage());
                }
                logger.severe(ret.getMensagem());
            }
        }
    }

    private void GeraRetornoCTE(EnvioIntegracao objEnvio, String msg, Integer codParseError, Object objLido) throws Exception {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (codParseError.equals(10)) {
            RetEnvio ret = new RetEnvio();
            if (objLido != null) {
                CTe objCT = (CTe)objLido;
                if (objCT.getEmitente() != null) {
                    ret.setCnpj(objCT.getEmitente().getCnpj());
                } else {
                    ret.setCnpj("");
                }
                if (objCT.getNumero() != null) {
                    ret.setNumero(objCT.getNumero());
                } else {
                    ret.setNumero(null);
                }
                if (objCT.getReferencia() != null) {
                    ret.setReferencia(objCT.getReferencia());
                } else {
                    ret.setReferencia("");
                }
                if (objCT.getSerie() != null) {
                    ret.setSerie(objCT.getSerie());
                }
                ret.setMensagem("Arquivo: " + objEnvio.getNomeArquivo() + " - " + msg);
            }
            try {
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                    RetornoCTE.gerarTxtEnvio(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo()) + ".TXT", ret);
                    if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                        RetornoCTE.gerarTxtEnvio(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo()) + ".TXT", ret);
                    }
                }
            }
            catch (IOException exIo) {
                logger.severe("Ocorreu um erro ao gerar TXT de envio. " + exIo.getMessage());
            }
            try {
                this.DeleteTmpFile(objEnvio.getPathFileArquivo());
            }
            catch (IOException exIo) {
                logger.severe("Ocorreu um erro ao apagar o arquivo tempor\u00e1rio. " + exIo.getMessage());
            }
            logger.severe(ret.getMensagem());
        }
    }

    private void GeraRetornoCTEOS(EnvioIntegracao objEnvio, String msg, Integer codParseError, Object objLido) throws Exception {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (codParseError.equals(12)) {
            RetEnvio ret = new RetEnvio();
            if (objLido != null) {
                CTeOS objCT = (CTeOS)objLido;
                if (objCT.getEmitente() != null) {
                    ret.setCnpj(objCT.getEmitente().getCnpj());
                } else {
                    ret.setCnpj("");
                }
                if (objCT.getNumero() != null) {
                    ret.setNumero(objCT.getNumero());
                } else {
                    ret.setNumero(null);
                }
                if (objCT.getReferencia() != null) {
                    ret.setReferencia(objCT.getReferencia());
                } else {
                    ret.setReferencia("");
                }
                if (objCT.getSerie() != null) {
                    ret.setSerie(objCT.getSerie());
                }
                ret.setMensagem("Arquivo: " + objEnvio.getNomeArquivo() + " - " + msg);
            }
            try {
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                    RetornoCTE.gerarTxtEnvio(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo()) + ".TXT", ret);
                    if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                        RetornoCTE.gerarTxtEnvio(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo()) + ".TXT", ret);
                    }
                }
            }
            catch (IOException exIo) {
                logger.severe("Ocorreu um erro ao gerar TXT de envio. " + exIo.getMessage());
            }
            try {
                this.DeleteTmpFile(objEnvio.getPathFileArquivo());
            }
            catch (IOException exIo) {
                logger.severe("Ocorreu um erro ao apagar o arquivo tempor\u00e1rio. " + exIo.getMessage());
            }
            logger.severe(ret.getMensagem());
        }
    }

    private void GeraRetornoConsulta(EnvioIntegracao objEnvio, String msg, Integer codigoErro) throws Exception {
        if (codigoErro.equals(9)) {
            RetConsultaEnvio retorno = new RetConsultaEnvio();
            retorno.setStatus(RetConsultaEnvio.StatusConsultaEnvio.ERRO_VALIDACAO);
            retorno.setMensagem("Erro ao ler o arquivo " + objEnvio.getNomeArquivo() + " - Layout Inv\u00e1lido - " + msg);
            try {
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML || objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                    if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                        RetornoCTE.gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo()) + ".XML", objEnvio, retorno);
                    }
                    RetornoCTE.gerarXML_SEFAZ(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo()) + ".XML", objEnvio, retorno);
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    private void GeraRetornoCancelamento(EnvioIntegracao objEnvio, String msg, Integer codParseError) throws Exception {
        Object ret;
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (codParseError.equals(2)) {
            ret = new RetRecepcaoNFe();
            ((RetRecepcaoNFe)ret).setStatus(StatusCancelamentoNFE.ERRO_LAYOUT);
            ((RetRecepcaoNFe)ret).setMsg("Erro ao ler o arquivo " + objEnvio.getNomeArquivo() + " - Layout Inv\u00e1lido - " + msg);
            try {
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                    ((RetRecepcaoNFe)ret).gerarTXT(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT");
                    if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                        ((RetRecepcaoNFe)ret).gerarTXT(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT");
                    }
                }
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                    ((RetRecepcaoNFe)ret).gerarXML(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".XML");
                    if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                        ((RetRecepcaoNFe)ret).gerarXML(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".XML");
                    }
                }
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                    ((RetRecepcaoNFe)ret).gerarXML_SEFAZ(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".XML", objEnvio.getDadosImpressao());
                    if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                        ((RetRecepcaoNFe)ret).gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".XML", objEnvio.getDadosImpressao());
                    }
                }
            }
            catch (IOException exIo) {
                logger.severe("Ocorreu um erro ao gerar TXT de envio. " + exIo.getMessage());
            }
            try {
                this.DeleteTmpFile(objEnvio.getPathFileArquivo());
            }
            catch (IOException exIo) {
                logger.severe("Ocorreu um erro ao apagar o arquivo tempor\u00e1rio. " + exIo.getMessage());
            }
            logger.severe(((RetRecepcaoNFe)ret).getMsg());
        }
        if (codParseError.equals(5)) {
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                ret = new RetRecepcaoCTE();
                ((RetRecepcaoCTE)ret).setNrCNPJEmitente("");
                ((RetRecepcaoCTE)ret).setStatus(StatusCancelamentoNFE.ERRO_LAYOUT);
                ((RetRecepcaoCTE)ret).setMsg("Erro ao ler o arquivo " + objEnvio.getNomeArquivo() + " - Layout Inv\u00e1lido - " + msg);
                try {
                    ((RetRecepcaoCTE)ret).gerarTXT(this.paramProperties.getDataOut(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'));
                }
                catch (IOException exIo) {
                    logger.severe("Ocorreu um erro ao gerar TXT de envio. " + exIo.getMessage());
                }
                try {
                    this.DeleteTmpFile(objEnvio.getPathFileArquivo());
                }
                catch (IOException exIo) {
                    logger.severe("Ocorreu um erro ao apagar o arquivo tempor\u00e1rio. " + exIo.getMessage());
                }
                logger.severe(((RetRecepcaoCTE)ret).getMsg());
            }
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                RetornoCTE.gerarXML_CANCEL_SEFAZ(this.paramProperties.getDataOut(), objEnvio.getNomeArquivo(), objEnvio, null);
            }
        }
    }

    private void GeraRetornoEvento(EnvioIntegracao objEnvio, String msg, Integer codParseError) throws Exception {
        Object objLido;
        Object retEven;
        Object retorno;
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (this.paramProperties.getTipo().equals((Object)TipoOBJ.MDFE)) {
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + msg);
                retorno = new RetEnvioEventoMDFE();
                ((RetEnvioEventoMDFE)retorno).setStatus("500");
                ((RetEnvioEventoMDFE)retorno).setMensagem(msg);
                ((RetEnvioEventoMDFE)retorno).setChaveAcesso(null);
                ((RetEnvioEventoMDFE)retorno).setAmbiente(null);
                ((RetEnvioEventoMDFE)retorno).setProtocolo(null);
                ((RetEnvioEventoMDFE)retorno).setData(null);
                RetornoMDFE.gerarRetornoEvento(this.paramProperties.getDataOut(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), retorno);
                if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                    RetornoMDFE.gerarRetornoEvento(this.paramProperties.getPastaArmazenamentoRet(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), retorno);
                }
            }
            this.DeleteTmpFile(objEnvio.getPathFileArquivo());
        }
        if (this.paramProperties.getTipo().equals((Object)TipoOBJ.NFSE)) {
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                logger.severe(this.paramProperties.getVersaoIntegrador() + " - " + msg);
                retorno = new RetEnvioCancelamentoNfse();
                ((RetEnvioCancelamentoNfse)retorno).setStatus(Integer.parseInt("500"));
                ((RetEnvioCancelamentoNfse)retorno).setMensagem(msg);
                ((RetEnvioCancelamentoNfse)retorno).setHash(null);
                ((RetEnvioCancelamentoNfse)retorno).setAmbiente(null);
                ((RetEnvioCancelamentoNfse)retorno).setPrestador(null);
                ((RetEnvioCancelamentoNfse)retorno).setData(null);
                RetornoNFSE.gerarRetornoEvento(this.paramProperties.getDataOut(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), retorno);
                if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                    RetornoNFSE.gerarRetornoEvento(this.paramProperties.getPastaArmazenamentoRet(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), retorno);
                }
            }
            this.DeleteTmpFile(objEnvio.getPathFileArquivo());
        }
        if (this.paramProperties.getTipo().equals((Object)TipoOBJ.NFE)) {
            retEven = new br.com.ophos.integracao.interfaces.nfe.dto.evento.RetEvento();
            objLido = (Util.EnvEvento)objEnvio.getObjEnvio();
            ((br.com.ophos.integracao.interfaces.nfe.dto.evento.RetEvento)retEven).setChaveAcesso(((Util.EnvEvento)objLido).chaveAcesso);
            ((br.com.ophos.integracao.interfaces.nfe.dto.evento.RetEvento)retEven).setStatus(StatusEvento.ERRO_VALIDACAO);
            ((br.com.ophos.integracao.interfaces.nfe.dto.evento.RetEvento)retEven).setMensagem(msg);
            RetornoNFE.GeraRetornoEvento((br.com.ophos.integracao.interfaces.nfe.dto.evento.RetEvento)retEven, objEnvio, this.paramProperties);
        }
        if ((this.paramProperties.getTipo().equals((Object)TipoOBJ.CTE) || this.paramProperties.getTipo().equals((Object)TipoOBJ.CTEOS)) && objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            retEven = new RetEvento();
            objLido = objEnvio.getObjEnvio() != null ? (EventoCTE)objEnvio.getObjEnvio() : new EventoCTE();
            ((RetEvento)retEven).setChaveAcesso(((EventoCTE)objLido).getChaveAcesso());
            ((RetEvento)retEven).setStatus(br.com.ophos.integracao.interfaces.dto.StatusEvento.ERRO_VALIDACAO);
            ((RetEvento)retEven).setMensagem(msg);
            RetornoCTE.gerarTxtEvento(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", retEven);
        }
    }

    private void GeraRetornoInutilizacao(EnvioIntegracao objEnvio, String msg, Integer codParseError) throws Exception {
        Object ret;
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (codParseError.equals(3)) {
            ret = new RetRecepcaoInutilizacaoNFE();
            ((RetRecepcaoInutilizacaoNFE)ret).setStatus(StatusInutilizacaoNFE.ERRO_LAYOUT);
            ((RetRecepcaoInutilizacaoNFE)ret).setMsg("Erro ao ler o arquivo " + objEnvio.getNomeArquivo() + " - Layout Inv\u00e1lido - " + msg);
            try {
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                    ((RetRecepcaoInutilizacaoNFE)ret).gerarTXT(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", objEnvio.getObjEnvio());
                    if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                        ((RetRecepcaoInutilizacaoNFE)ret).gerarTXT(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", objEnvio.getObjEnvio());
                    }
                }
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML || objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                    if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                        ((RetRecepcaoInutilizacaoNFE)ret).gerarXML(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".XML");
                    }
                    if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                        ((RetRecepcaoInutilizacaoNFE)ret).gerarXML_SEFAZ(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".XML");
                    }
                    if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                            ((RetRecepcaoInutilizacaoNFE)ret).gerarXML(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".XML");
                        }
                        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                            ((RetRecepcaoInutilizacaoNFE)ret).gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".XML");
                        }
                    }
                }
            }
            catch (IOException exIo) {
                logger.severe("Ocorreu um erro ao gerar TXT de envio. " + exIo.getMessage());
            }
            try {
                this.DeleteTmpFile(objEnvio.getPathFileArquivo());
            }
            catch (IOException exIo) {
                logger.severe("Ocorreu um erro ao apagar o arquivo tempor\u00e1rio. " + exIo.getMessage());
            }
            logger.severe(((RetRecepcaoInutilizacaoNFE)ret).getMsg());
        }
        if (codParseError.equals(6)) {
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                ret = new RetRecepcaoInutilizacaoCTE();
                ((RetRecepcaoInutilizacaoCTE)ret).setNrCNPJEmitente("");
                ((RetRecepcaoInutilizacaoCTE)ret).setStatus(StatusInutilizacaoNFE.ERRO_LAYOUT);
                ((RetRecepcaoInutilizacaoCTE)ret).setMsg("Erro ao ler o arquivo " + objEnvio.getNomeArquivo() + " - Layout Inv\u00e1lido - " + msg);
                try {
                    ((RetRecepcaoInutilizacaoCTE)ret).gerarTXT(this.paramProperties.getDataOut(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'));
                }
                catch (IOException exIo) {
                    logger.severe("Ocorreu um erro ao gerar TXT de envio. " + exIo.getMessage());
                }
                try {
                    this.DeleteTmpFile(objEnvio.getNomeArquivo());
                }
                catch (IOException exIo) {
                    logger.severe("Ocorreu um erro ao apagar o arquivo tempor\u00e1rio. " + exIo.getMessage());
                }
                logger.severe(((RetRecepcaoInutilizacaoCTE)ret).getMsg());
            }
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                RetornoCTE.gerarXML_INUT_SEFAZ(this.paramProperties.getDataOut(), objEnvio.getNomeArquivo(), objEnvio, null);
            }
        }
    }

    private static void copyfile(File srFile, File dtFile) {
        try {
            int len;
            File f1 = srFile;
            File f2 = dtFile;
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            int offset;
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public boolean AcceptFile(File file) {
        return file.length() > (long)this.paramProperties.getTamanhoFile().intValue() && file.canRead() && file.canWrite();
    }

    public TipoIntegracao valueToTipoIntegracao(String valor) {
        if (valor.equals("0")) {
            return TipoIntegracao.TXT;
        }
        if (valor.equals("1")) {
            return TipoIntegracao.XML;
        }
        if (valor.equals("2")) {
            return TipoIntegracao.BANCO;
        }
        if (valor.equals("3")) {
            return TipoIntegracao.SAP;
        }
        if (valor.equals("4")) {
            return TipoIntegracao.TXT_SEFAZ;
        }
        if (valor.equals("5")) {
            return TipoIntegracao.XML_SEFAZ;
        }
        return null;
    }

    private void backupFile(File arquivo) {
        String nome = arquivo.getName().substring(0, arquivo.getName().lastIndexOf("."));
        String extensao = arquivo.getName().substring(arquivo.getName().lastIndexOf("."), arquivo.getName().length());
        String data = new SimpleDateFormat("_yyyyMMddHHmmss").format(new Date());
        File fileDest = new File(this.paramProperties.getPastaArmazenamento() + "/" + nome + data + extensao);
        ProdutorEnvioFile.copyfile(arquivo, fileDest);
    }

    private File renameArquivo(File arquivo, String ext) {
        String nomeFilein = arquivo.getPath();
        File tmpFile = new File((nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."))) + ext.toUpperCase());
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        while (!tmpFile.exists()) {
            arquivo.renameTo(tmpFile);
        }
        return tmpFile;
    }

    private void parseNFE_TXT_ENVIO(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTEnvioNFEFactory parseNFE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseNFE = ParseTXTEnvioNFEFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        obj.setObjEnvio(parseNFE.parse(new FileInputStream(tmpFile)));
    }

    private void parseNFE_TXT_SEFAZ_ENVIO(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTSefazFactory parseNFE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        scanner.useDelimiter("\\|");
        scanner.nextLine();
        if (scanner.hasNext()) {
            scanner.next();
            String versao = scanner.next().trim();
            parseNFE = ParseTXTSefazFactory.getFactory(versao);
        }
        scanner.close();
        obj.setObjEnvio(parseNFE.parse(new FileInputStream(tmpFile)));
        if (obj.getObjEnvio() instanceof ArrayList) {
            Integer idArquivo = 1;
            for (Object objNf : (ArrayList)obj.getObjEnvio()) {
                EnvioIntegracao nObj = new EnvioIntegracao();
                nObj.setDadosImpressao(obj.getDadosImpressao());
                nObj.setIdObj(obj.getIdObj());
                if (idArquivo > 1) {
                    nObj.setNomeArquivo(this.RetornaNomeSemExtensao(obj.getNomeArquivo()) + "_" + idArquivo.toString() + ".TXT");
                } else {
                    nObj.setNomeArquivo(this.RetornaNomeSemExtensao(obj.getNomeArquivo()) + ".TXT");
                }
                nObj.setNrChaveAcesso(obj.getNrChaveAcesso());
                nObj.setObjEmContingencia(obj.getObjEmContingencia());
                nObj.setObjEnvio(objNf);
                nObj.setObjImpresso(obj.getObjImpresso());
                nObj.setPathFileArquivo(obj.getPathFileArquivo());
                nObj.setTpIntegraEntrada(obj.getTpIntegraEntrada());
                nObj.setTpIntegraSaida(obj.getTpIntegraSaida());
                idArquivo = idArquivo + 1;
                this.sharedLocation.Set(nObj);
            }
            this.DeleteTmpFile(obj.getPathFileArquivo());
        }
    }

    private void parseCTE_TXT_SEFAZ_ENVIO(File tmpFile, EnvioIntegracao obj) throws Exception {
    }

    private void parseNFE_TXT_CANC(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTCancelFactory parseNFE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseNFE = ParseTXTCancelFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        Util.EnvCancelamento envCancel = parseNFE.parse(new FileInputStream(tmpFile));
        obj.setObjEnvio(envCancel);
        obj.setIdObj(envCancel.nrDocumento);
    }

    private void parseNFE_TXT_INUT(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTInutFactory parseNFE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseNFE = ParseTXTInutFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        obj.setObjEnvio(parseNFE.parse(new FileInputStream(tmpFile)));
    }

    private void parseNFE_TXT_CONS(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTConsultaNFeFactory parseNFE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseNFE = ParseTXTConsultaNFeFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        obj.setObjEnvio(parseNFE.parse(new FileInputStream(tmpFile)));
    }

    private void parseNFE_TXT_EVEN(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTEventoFactory parseNFE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseNFE = ParseTXTEventoFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        obj.setObjEnvio(parseNFE.parse(new FileInputStream(tmpFile)));
    }

    private void parseNFE_TXT_STATUS(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTConsultaStatusFactory parseNFE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseNFE = ParseTXTConsultaStatusFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        obj.setObjEnvio(parseNFE.parse(new FileInputStream(tmpFile)));
    }

    private void parseCTE_TXT_ENVIO(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTEnvioCTEFactory parseCTE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseCTE = ParseTXTEnvioCTEFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        obj.setObjEnvio(parseCTE.parse(new FileInputStream(tmpFile)));
    }

    private void parseCTEOS_TXT_ENVIO(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTEnvioCTEOSFactory parseCTE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseCTE = ParseTXTEnvioCTEOSFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        obj.setObjEnvio(parseCTE.parse(new FileInputStream(tmpFile)));
    }

    private void parseCTE_TXT_CANC(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTCancelamentoCTEFactory parseCTE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            if (!versao.startsWith("{")) {
                ParseTXTCancelamentoCTE parseCTE2 = new ParseTXTCancelamentoCTE();
                obj.setObjEnvio(parseCTE2.parse(new FileInputStream(tmpFile)));
            } else {
                parseCTE = ParseTXTCancelamentoCTEFactory.getFactory(versao);
                obj.setObjEnvio(parseCTE.parse(new FileInputStream(tmpFile)));
            }
            scanner.close();
        }
    }

    private void parseCTE_TXT_INUT(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTInutilizacaoCTEFactory parseCTE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            if (!versao.startsWith("{")) {
                ParseTXTInutilizacaoCTE parseCTE2 = new ParseTXTInutilizacaoCTE();
                obj.setObjEnvio(parseCTE2.parse(new FileInputStream(tmpFile)));
            } else {
                parseCTE = ParseTXTInutilizacaoCTEFactory.getFactory(versao);
                obj.setObjEnvio(parseCTE.parse(new FileInputStream(tmpFile)));
            }
            scanner.close();
        }
    }

    private void parseCTE_TXT_EVEN(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTEventoCTEFactory parseCTE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseCTE = ParseTXTEventoCTEFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        obj.setObjEnvio(parseCTE.parse(new FileInputStream(tmpFile)));
    }

    private void parseCTEOS_TXT_EVEN(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTEventoCTEOSFactory parseCTE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseCTE = ParseTXTEventoCTEOSFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        obj.setObjEnvio(parseCTE.parse(new FileInputStream(tmpFile)));
    }

    private void parseCTE_TXT_AVERBACAO(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTAverbacaoCTEFactory parseAverbacao = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseAverbacao = ParseTXTAverbacaoCTEFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        }
        scanner.close();
        obj.setObjEnvio(parseAverbacao.parse(new FileInputStream(tmpFile)));
    }

    private void parseCTE_XML_ENVIO(byte[] arquivoXML, EnvioIntegracao obj, JAXBContext ctx) throws Exception {
        ParseXMLFactoryCTe parseXML = null;
        Logger logger = Logger.getLogger(this.getClass().getName());
        String versao = RetornoCTE.GetVersaoXML_CTE(arquivoXML, TipoArquivo.ENVIO);
        try {
            if (versao.equals("1.04")) {
                ctx = JAXBContext.newInstance((Class[])new Class[]{br.com.ophos.xml.cte.V104.TCTe.class});
            }
            if (versao.equals("2.00")) {
                ctx = JAXBContext.newInstance((Class[])new Class[]{TCTe.class});
            }
            if (versao.equals("3.00")) {
                ctx = JAXBContext.newInstance((Class[])new Class[]{br.com.ophos.xml.cte.v300.TCTe.class});
            }
            if (versao.equals("4.00")) {
                ctx = JAXBContext.newInstance((Class[])new Class[]{br.com.ophos.xml.cte.v400.TCTe.class});
            }
        }
        catch (Exception ex1) {
            logger.severe("Erro ao iniciar o JAXBContext = " + ex1.getMessage());
        }
        parseXML = ParseXMLFactoryCTe.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        obj.setObjEnvio(parseXML.parse(ctx, arquivoXML));
        obj.setNrChaveAcesso(RetornoCTE.GetId_XML_CTE(arquivoXML));
    }

    private void parseNFE_XML_ENVIO(byte[] arquivoXML, EnvioIntegracao obj, JAXBContext ctx) throws Exception {
        Logger logger = Logger.getLogger(this.getClass().getName());
        ParseXMLFactory parseXML_NFE = null;
        String versao = RetornoNFE.GetVersaoXML_NFE(arquivoXML, TipoArquivo.ENVIO);
        try {
            switch (versao) {
                case "2.00": {
                    ctx = JAXBContext.newInstance((Class[])new Class[]{br.com.ophos.integracao.parse.nfe.xml.v2.sefaz.TNFe.class});
                    break;
                }
                case "3.10": {
                    ctx = JAXBContext.newInstance((Class[])new Class[]{br.com.ophos.integracao.parse.nfe.xml.v3.sefaz.TNFe.class});
                    break;
                }
                case "1.10": {
                    ctx = JAXBContext.newInstance((Class[])new Class[]{TNFe.InfNFe.class});
                    break;
                }
                case "4.00": {
                    ctx = JAXBContext.newInstance((Class[])new Class[]{TNFe.class});
                    break;
                }
                default: {
                    throw new ParseException("N\u00e3o encontrado vers\u00e3o para inicializar o JAXBContext");
                }
            }
        }
        catch (ParseException | JAXBException ex1) {
            logger.log(Level.SEVERE, "Erro ao iniciar o JAXBContext = {0}", ex1.getMessage());
        }
        parseXML_NFE = ParseXMLFactory.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        obj.setObjEnvio(parseXML_NFE.parse(ctx, arquivoXML));
        obj.setNrChaveAcesso(RetornoNFE.GetId_XML_NFE(arquivoXML));
    }

    private void parseNFE_XML_CANC_2(byte[] arquivoXML, EnvioIntegracao obj, JAXBContext ctx, File tmpFile) throws Exception {
        String versao = RetornoNFE.GetVersaoXML_NFE(arquivoXML, TipoArquivo.EVENTO);
        ParseXMLEventoFactory parseXML_NFE = ParseXMLEventoFactory.getFactory(versao);
        if (parseXML_NFE != null) {
            obj.setObjEnvio(parseXML_NFE.parse(arquivoXML));
        } else {
            new ParseException("Vers\u00e3o: " + versao + " desconhecida ou n\u00e3o informada no arquivo XML de Evento");
        }
    }

    private void parseNFE_XML_CANC_1(EnvioIntegracao obj, File tmpFile) throws Exception {
        ParseXMLCancelNFE parseXML_NFE = new ParseXMLCancelNFE();
        parseXML_NFE.in = new FileInputStream(tmpFile);
        Util.EnvCancelamento envCancel = parseXML_NFE.parse();
        obj.setObjEnvio(envCancel);
        obj.setIdObj(envCancel.nrDocumento);
        byte[] arquivoXML2 = ProdutorEnvioFile.getBytesFromFile(tmpFile);
        String arquivoEntrada = new String(arquivoXML2);
        obj.setDadosImpressao(arquivoEntrada);
    }

    private void parseNFE_XML_INUT(EnvioIntegracao obj, File tmpFile) throws Exception {
        ParseXMLInutNFE parseXML_NFE = new ParseXMLInutNFE();
        parseXML_NFE.in = new FileInputStream(tmpFile);
        obj.setObjEnvio(parseXML_NFE.parse());
    }

    private void parseNFE_XML_CONS(EnvioIntegracao obj, File tmpFile) throws Exception {
        ParseXMLConsultaNFE parseXML_NFE = new ParseXMLConsultaNFE();
        parseXML_NFE.in = new FileInputStream(tmpFile);
        obj.setObjEnvio(parseXML_NFE.parse());
    }

    private void parseNFE_XML_EVEN(byte[] arquivoXML, EnvioIntegracao obj, File tmpFile) throws Exception {
        String versao = RetornoNFE.GetVersaoXML_NFE(arquivoXML, TipoArquivo.EVENTO);
        ParseXMLEventoFactory parseXML_NFE = ParseXMLEventoFactory.getFactory(versao);
        if (parseXML_NFE == null) {
            throw new ParseException("Vers\u00e3o: " + versao + " desconhecida ou n\u00e3o informada no arquivo XML de Evento");
        }
        obj.setObjEnvio(parseXML_NFE.parse(arquivoXML));
    }

    private void parseCTE_XML_CANCEL(byte[] arquivoXML, EnvioIntegracao obj, JAXBContext ctx) throws Exception {
        ParseXMLFactoryCancelCTe parseXML = null;
        Logger logger = Logger.getLogger(this.getClass().getName());
        String versao = RetornoCTE.GetVersaoXML_CTE(arquivoXML, TipoArquivo.CANCELAMENTO);
        try {
            if (versao.equals("1.04")) {
                ctx = JAXBContext.newInstance((Class[])new Class[]{TCancCTe.class});
            }
        }
        catch (Exception ex1) {
            logger.severe("Erro ao iniciar o JAXBContext = " + ex1.getMessage());
        }
        parseXML = ParseXMLFactoryCancelCTe.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        obj.setObjEnvio(parseXML.parse(ctx, arquivoXML));
        obj.setNrChaveAcesso(((Util.EnvCancelamento)obj.getObjEnvio()).nrReferente);
    }

    private void parseCTE_XML_INUT(byte[] arquivoXML, EnvioIntegracao obj, JAXBContext ctx) throws Exception, ParseException {
        ParseXMLFactoryInutCTe parseXML = null;
        Logger logger = Logger.getLogger(this.getClass().getName());
        String versao = RetornoCTE.GetVersaoXML_CTE(arquivoXML, TipoArquivo.INUTILIZACAO);
        try {
            if (versao.equals("1.04")) {
                ctx = JAXBContext.newInstance((Class[])new Class[]{TInutCTe.class});
            } else if (versao.equals("2.00")) {
                ctx = JAXBContext.newInstance((Class[])new Class[]{br.com.ophos.xml.cte.V200.TInutCTe.class});
            }
        }
        catch (Exception ex1) {
            logger.severe("Erro ao iniciar o JAXBContext = " + ex1.getMessage());
        }
        parseXML = ParseXMLFactoryInutCTe.getFactory(versao, this.paramProperties.getCharQuebraLinha());
        obj.setObjEnvio(parseXML.parse(ctx, arquivoXML));
    }

    private void parseCTE_XML_CONS(byte[] arquivoXML, EnvioIntegracao obj, JAXBContext ctx) throws Exception, ParseException {
        ParseXMLFactoryConsCTe parseXML = null;
        Logger logger = Logger.getLogger(this.getClass().getName());
        try {
            ctx = JAXBContext.newInstance((Class[])new Class[]{EnvioConsultaXML.class});
        }
        catch (Exception ex1) {
            logger.severe("Erro ao iniciar o JAXBContext = " + ex1.getMessage());
        }
        parseXML = ParseXMLFactoryConsCTe.getFactory(this.paramProperties.getCharQuebraLinha());
        obj.setObjEnvio(parseXML.parse(ctx, arquivoXML));
    }

    private void parseCTE_XML_EVEN(byte[] arquivoXML, EnvioIntegracao obj, JAXBContext ctx) throws Exception, ParseException {
        ParseXMLEventoFactoryCTe parseXML = null;
        Logger logger = Logger.getLogger(this.getClass().getName());
        String versao = RetornoCTE.GetVersaoXML_CTE(arquivoXML, TipoArquivo.EVENTO);
        try {
            ctx = JAXBContext.newInstance((Class[])new Class[]{TEvento.class});
        }
        catch (Exception ex1) {
            logger.severe("Erro ao iniciar o JAXBContext = " + ex1.getMessage());
        }
        if (!versao.equals("3.00") && !versao.equals("2.00")) {
            logger.severe("Vers\u00e3o: " + versao + " desconhecida ou n\u00e3o informada no arquivo XML de Evento");
            throw new ParseException("Vers\u00e3o: " + versao + " desconhecida ou n\u00e3o informada no arquivo XML de Evento");
        }
        parseXML = ParseXMLEventoFactoryCTe.getFactory(versao);
        obj.setObjEnvio(parseXML.parse(arquivoXML));
    }

    private void parseMDFE_TXT(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTEnvioMDFEFactory parseMDFE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseMDFE = ParseTXTEnvioMDFEFactory.getFactory(versao);
        }
        scanner.close();
        obj.setObjEnvio(parseMDFE.parse(new FileInputStream(tmpFile)));
    }

    private void parseMDFE_TXT_EVEN(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTEventoMDFEFactory parseEventoMDFE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseEventoMDFE = ParseTXTEventoMDFEFactory.getFactory(versao);
        }
        scanner.close();
        obj.setObjEnvio(parseEventoMDFE.parse(new FileInputStream(tmpFile)));
    }

    private void parseNFSE_TXT(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTEnvioNFSEFactory parseNFSE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseNFSE = ParseTXTEnvioNFSEFactory.getFactory(versao);
        }
        scanner.close();
        obj.setObjEnvio(parseNFSE.parse(new FileInputStream(tmpFile)));
    }

    private void parseNFSE_TXT_EVEN(File tmpFile, EnvioIntegracao obj) throws Exception {
        ParseTXTEventoNFSEFactory parseEventoNFSE = null;
        Scanner scanner = new Scanner(new FileInputStream(tmpFile));
        if (scanner.hasNext()) {
            String versao = scanner.next();
            parseEventoNFSE = ParseTXTEventoNFSEFactory.getFactory(versao);
        }
        scanner.close();
        obj.setObjEnvio(parseEventoNFSE.parse(new FileInputStream(tmpFile)));
    }

    @Override
    public void run() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        JAXBContext ctx = null;
        logger.fine("Monitor iniciado para o filtro: " + this.filtroFiles);
        while (true) {
            Boolean inseriuBuffer = false;
            try {
                File[] arquivos = Util.listaArquivos(this.paramProperties.getDataIn(), this.filtroFiles);
                for (int idx = 0; idx < arquivos.length; ++idx) {
                    if (!this.AcceptFile(arquivos[idx])) continue;
                    EnvioIntegracao obj = new EnvioIntegracao();
                    Integer idParseException = 0;
                    File tmpFile = null;
                    try {
                        if (this.paramProperties.getTipoArmazenamento().equals((Object)TipoArmazenamento.SEMPRE)) {
                            this.backupFile(arquivos[idx]);
                            logger.info("Arquivo de integra\u00e7\u00e3o armazenado em: " + this.paramProperties.getPastaArmazenamento());
                        }
                        obj.setNomeArquivo(arquivos[idx].getName());
                        obj.setPathFileArquivo(arquivos[idx].getAbsolutePath());
                        obj.setTpIntegraSaida(this.paramProperties.getTipoSaida());
                        if (arquivos[idx].getName().toLowerCase().endsWith(".txt")) {
                            tmpFile = this.renameArquivo(arquivos[idx], ".TMP");
                            if (this.paramProperties.getTipo() == TipoOBJ.NFE) {
                                if (this.paramProperties.getTipoEntrada().equals((Object)TipoIntegracao.TXT)) {
                                    obj.setTpIntegraEntrada(TipoIntegracao.TXT);
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEnvio())) {
                                        idParseException = 1;
                                        this.parseNFE_TXT_ENVIO(tmpFile, obj);
                                    }
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskCancelamento())) {
                                        idParseException = 2;
                                        this.parseNFE_TXT_CANC(tmpFile, obj);
                                    }
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskInutilizacao())) {
                                        idParseException = 3;
                                        this.parseNFE_TXT_INUT(tmpFile, obj);
                                    }
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskConsulta())) {
                                        idParseException = 7;
                                        this.parseNFE_TXT_CONS(tmpFile, obj);
                                    }
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEvento())) {
                                        idParseException = 11;
                                        this.parseNFE_TXT_EVEN(tmpFile, obj);
                                    }
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskConsultaStatus())) {
                                        idParseException = 8;
                                        this.parseNFE_TXT_STATUS(tmpFile, obj);
                                    }
                                }
                                if (this.paramProperties.getTipoEntrada().equals((Object)TipoIntegracao.TXT_SEFAZ)) {
                                    obj.setTpIntegraEntrada(TipoIntegracao.TXT_SEFAZ);
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEnvio())) {
                                        idParseException = 1;
                                        this.parseNFE_TXT_SEFAZ_ENVIO(tmpFile, obj);
                                        inseriuBuffer = true;
                                    }
                                }
                            }
                            if (this.paramProperties.getTipo() == TipoOBJ.CTE) {
                                if (this.paramProperties.getTipoEntrada().equals((Object)TipoIntegracao.TXT)) {
                                    obj.setTpIntegraEntrada(TipoIntegracao.TXT);
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEnvio())) {
                                        idParseException = 10;
                                        this.parseCTE_TXT_ENVIO(tmpFile, obj);
                                    }
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskCancelamento())) {
                                        idParseException = 5;
                                        this.parseCTE_TXT_CANC(tmpFile, obj);
                                    }
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskInutilizacao())) {
                                        idParseException = 6;
                                        this.parseCTE_TXT_INUT(tmpFile, obj);
                                    }
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEvento())) {
                                        idParseException = 11;
                                        this.parseCTE_TXT_EVEN(tmpFile, obj);
                                    }
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskAverbacao())) {
                                        idParseException = 6;
                                        this.parseCTE_TXT_AVERBACAO(tmpFile, obj);
                                    }
                                }
                                if (this.paramProperties.getTipoEntrada().equals((Object)TipoIntegracao.TXT_SEFAZ)) {
                                    obj.setTpIntegraEntrada(TipoIntegracao.TXT_SEFAZ);
                                    if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEnvio())) {
                                        idParseException = 1;
                                        this.parseCTE_TXT_SEFAZ_ENVIO(tmpFile, obj);
                                        inseriuBuffer = true;
                                    }
                                }
                            }
                            if (this.paramProperties.getTipo() == TipoOBJ.CTEOS && this.paramProperties.getTipoEntrada().equals((Object)TipoIntegracao.TXT)) {
                                obj.setTpIntegraEntrada(TipoIntegracao.TXT);
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEnvio())) {
                                    idParseException = 12;
                                    this.parseCTEOS_TXT_ENVIO(tmpFile, obj);
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskInutilizacao())) {
                                    idParseException = 6;
                                    this.parseCTE_TXT_INUT(tmpFile, obj);
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEvento())) {
                                    idParseException = 6;
                                    this.parseCTEOS_TXT_EVEN(tmpFile, obj);
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskAverbacao())) {
                                    idParseException = 6;
                                    this.parseCTE_TXT_AVERBACAO(tmpFile, obj);
                                }
                            }
                        }
                        if (this.paramProperties.getTipo() == TipoOBJ.MDFE) {
                            obj.setTpIntegraEntrada(TipoIntegracao.TXT);
                            if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEnvio())) {
                                idParseException = 1;
                                this.parseMDFE_TXT(tmpFile, obj);
                            }
                            if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEvento())) {
                                idParseException = 11;
                                this.parseMDFE_TXT_EVEN(tmpFile, obj);
                            }
                        }
                        if (this.paramProperties.getTipo() == TipoOBJ.NFSE) {
                            obj.setTpIntegraEntrada(TipoIntegracao.TXT);
                            if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEnvio())) {
                                idParseException = 1;
                                this.parseNFSE_TXT(tmpFile, obj);
                            }
                            if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEvento())) {
                                idParseException = 11;
                                this.parseNFSE_TXT_EVEN(tmpFile, obj);
                            }
                        }
                        if (arquivos[idx].getName().toLowerCase().endsWith(".xml")) {
                            byte[] arquivoXML;
                            if (this.paramProperties.getTipo() == TipoOBJ.CTE) {
                                arquivoXML = ProdutorEnvioFile.getBytesFromFile(arquivos[idx]);
                                this.renameArquivo(arquivos[idx], ".TMX");
                                obj.setTpIntegraEntrada(TipoIntegracao.XML);
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEnvio())) {
                                    idParseException = 1;
                                    this.parseCTE_XML_ENVIO(arquivoXML, obj, ctx);
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskCancelamento())) {
                                    idParseException = 5;
                                    this.parseCTE_XML_CANCEL(arquivoXML, obj, ctx);
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskInutilizacao())) {
                                    idParseException = 5;
                                    this.parseCTE_XML_INUT(arquivoXML, obj, ctx);
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskConsulta())) {
                                    idParseException = 9;
                                    this.parseCTE_XML_CONS(arquivoXML, obj, ctx);
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEvento())) {
                                    idParseException = 11;
                                    this.parseCTE_XML_EVEN(arquivoXML, obj, ctx);
                                }
                            }
                            if (this.paramProperties.getTipo() == TipoOBJ.NFE) {
                                arquivoXML = ProdutorEnvioFile.getBytesFromFile(arquivos[idx]);
                                tmpFile = this.renameArquivo(arquivos[idx], ".TMX");
                                obj.setTpIntegraEntrada(TipoIntegracao.XML);
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEnvio())) {
                                    idParseException = 1;
                                    this.parseNFE_XML_ENVIO(arquivoXML, obj, ctx);
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskCancelamento())) {
                                    idParseException = 2;
                                    if (new String(arquivoXML).indexOf("evento") > 0) {
                                        this.parseNFE_XML_CANC_2(arquivoXML, obj, ctx, tmpFile);
                                    } else {
                                        this.parseNFE_XML_CANC_1(obj, tmpFile);
                                    }
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskInutilizacao())) {
                                    idParseException = 3;
                                    this.parseNFE_XML_INUT(obj, tmpFile);
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskConsulta())) {
                                    idParseException = 7;
                                    this.parseNFE_XML_CONS(obj, tmpFile);
                                }
                                if (arquivos[idx].getName().toUpperCase().matches(this.paramProperties.getMaskEvento())) {
                                    idParseException = 8;
                                    this.parseNFE_XML_EVEN(arquivoXML, obj, tmpFile);
                                }
                            }
                        }
                        if (inseriuBuffer.booleanValue()) continue;
                        this.sharedLocation.Set(obj);
                        continue;
                    }
                    catch (ParseException ex) {
                        if (this.paramProperties.getTipoArmazenamento().equals((Object)TipoArmazenamento.NAO_ARMAZENAR)) {
                            this.backupFile(tmpFile);
                            logger.info("Arquivo de integra\u00e7\u00e3o armazenado em: " + this.paramProperties.getPastaArmazenamento());
                        }
                        try {
                            if (idParseException.equals(1) || idParseException.equals(4) || idParseException.equals(7) || idParseException.equals(8)) {
                                this.GeraRetornoEnvio(obj, ex.getMessage(), ex.obj);
                            }
                            if (idParseException.equals(2) || idParseException.equals(5)) {
                                this.GeraRetornoCancelamento(obj, ex.getMessage(), idParseException);
                            }
                            if (idParseException.equals(3) || idParseException.equals(6)) {
                                this.GeraRetornoInutilizacao(obj, ex.getMessage(), idParseException);
                            }
                            if (idParseException.equals(9)) {
                                this.GeraRetornoConsulta(obj, ex.getMessage(), idParseException);
                            }
                            if (idParseException.equals(11)) {
                                obj.setObjEnvio(ex.obj);
                                this.GeraRetornoEvento(obj, ex.getMessage(), idParseException);
                            }
                            try {
                                this.DeleteTmpFile(obj.getPathFileArquivo());
                            }
                            catch (IOException exIo) {
                                logger.severe("Ocorreu um erro ao apagar o arquivo tempor\u00e1rio. " + exIo.getMessage());
                            }
                        }
                        catch (Exception ex1) {
                            logger.severe("Erro ao gerar o retorno Parse Error = " + arquivos[idx] + " MSG = " + ex1.getMessage());
                        }
                        continue;
                    }
                    catch (ParseException2 paex2) {
                        if (idParseException.equals(10)) {
                            this.GeraRetornoCTE(obj, paex2.getMessage(), idParseException, paex2.obj);
                        }
                        if (idParseException.equals(1) || idParseException.equals(4) || idParseException.equals(7) || idParseException.equals(8)) {
                            this.GeraRetornoEnvio(obj, paex2.getMessage(), paex2.obj);
                        }
                        if (!idParseException.equals(12)) continue;
                        obj.setObjEnvio(paex2.obj);
                        this.GeraRetornoCTEOS(obj, paex2.getMessage(), idParseException, paex2.obj);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.severe("Erro no envio do arquivo para o Buffer. Arquivo = " + arquivos[idx] + " MSG = " + ex.getMessage());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(this.paramProperties.getTempoEnvio().intValue());
            }
            catch (Exception exception) {
            }
        }
    }
}

