/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.cteos;

import br.com.ophos.integracao.interfaces.cteos.dto.emissao.CTeOS;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ResponsavelSeguro;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.TipoICMSTomador;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.TipoModal;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.TipoProprietario;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.TipoServico;
import br.com.ophos.parse.ParseException2;
import br.com.ophos.parse.txt.cteos.v1.ParseTXTEnvioCTEOSv100;
import br.com.ophos.parse.txt.cteos.v1.ParseTXTEnvioCTEOSv101;
import java.io.InputStream;

public abstract class ParseTXTEnvioCTEOSFactory {
    public static ParseTXTEnvioCTEOSFactory getFactory(String versao, String caractereDelimitador) {
        switch (versao) {
            case "{1.00}": {
                return ParseTXTEnvioCTEOSv100.getInstance(caractereDelimitador);
            }
            case "{1.01}": {
                return ParseTXTEnvioCTEOSv101.getInstance(caractereDelimitador);
            }
        }
        return null;
    }

    public abstract CTeOS parse(InputStream var1) throws ParseException2;

    protected static TipoModal valueToTipoModal(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return TipoModal.RODOVIARIO;
                    }
                    case 1: {
                        return TipoModal.AQUAVIARIO;
                    }
                    case 2: {
                        return TipoModal.AEREO;
                    }
                    case 3: {
                        return TipoModal.FERROVIARIO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static TipoServico valueToTipoServico(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return TipoServico.EXCESSO_BAGAGEM;
                    }
                    case 1: {
                        return TipoServico.TRANSPORTE_PESSOAS;
                    }
                    case 2: {
                        return TipoServico.TRANSPORTE_VALORES;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static TipoICMSTomador valueToTipoIcmsTomador(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return TipoICMSTomador.CONTRIBUINTE;
                    }
                    case 1: {
                        return TipoICMSTomador.ISENTO;
                    }
                    case 2: {
                        return TipoICMSTomador.NAO_CONTRIBUINTE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static ResponsavelSeguro valueToResponsavelSeguro(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return ResponsavelSeguro.EMITENTE;
                    }
                    case 1: {
                        return ResponsavelSeguro.TOMADOR;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static TipoProprietario valueToTipoProprietario(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return TipoProprietario.TAC_AGREGADO;
                    }
                    case 1: {
                        return TipoProprietario.TAC_INDEPENDENTE;
                    }
                    case 2: {
                        return TipoProprietario.OUTROS;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

