/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.cteos.v1;

import br.com.ophos.integracao.interfaces.cteos.dto.emissao.CTeAnulacao;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.CTeComplemento;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.CTeNormal;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.CTeOS;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.CTeSubstituto;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ComponentePrestacao;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.DocumentoReferenciado;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.Duplicata;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.Emitente;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.Fatura;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ICMSN00;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ICMSN40;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ICMSN41;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ICMSN51;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ICMSN90;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ICMSOutraUF;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ICMSSN;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ICMSUFDestino;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.Impostos;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.ImpostosFederais;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.Info;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.InfoContribuinte;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.InfoFisco;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.InformacaoAdicional;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.InformacaoServico;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.PermissaoDownload;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.Proprietario;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.Rodoviario;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.Seguro;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.Tomador;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.Veiculo;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalDateSerializer;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalDateTimeSerializer;
import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.ParseException2;
import br.com.ophos.parse.txt.cteos.ParseTXTEnvioCTEOSFactory;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.cte.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParseTXTEnvioCTEOSv100
extends ParseTXTEnvioCTEOSFactory {
    private static ParseTXTEnvioCTEOSv100 instance;
    protected CTeOS obj = null;
    protected String caracQuebraLinha;

    public static ParseTXTEnvioCTEOSv100 getInstance(String charQuebraLinha) {
        if (instance == null) {
            instance = new ParseTXTEnvioCTEOSv100(charQuebraLinha);
        }
        return instance;
    }

    public ParseTXTEnvioCTEOSv100(String charQuebraLinha) {
        this.caracQuebraLinha = charQuebraLinha;
    }

    protected Integer GetQtdDelimiter(String line, String delimiter) {
        Integer qtdRetorno = 0;
        char[] caracters = line.toCharArray();
        for (int i = 0; i < caracters.length; ++i) {
            String charac = String.valueOf(caracters[i]);
            if (!charac.equals(delimiter)) continue;
            qtdRetorno = qtdRetorno + 1;
        }
        return qtdRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CTeOS parse(InputStream in) throws ParseException2 {
        try (Scanner scanner = null;){
            this.obj = new CTeNormal();
            ArrayList<Integer> linhasErro = new ArrayList<Integer>();
            List<Integer> linhasObrigatorias = Arrays.asList(1, 4, 6, 7, 8);
            ArrayList<Integer> linhasEncontradas = new ArrayList<Integer>();
            scanner = new Scanner(in);
            scanner.next();
            while (scanner.hasNextLine()) {
                String linha = scanner.nextLine();
                if (linha.length() < 3) continue;
                Integer ID = Integer.parseInt(linha.substring(1, 3));
                linhasEncontradas.add(ID);
                try {
                    this.lerLinha(linha + "|");
                }
                catch (ParseException parseException) {
                    linhasErro.add(ID);
                }
            }
            Object msgException = "";
            for (Object e : linhasErro) {
                msgException = (String)msgException + e;
            }
            if (linhasErro.size() > 0) {
                throw new ParseException2("ERRO_LAYOUT: " + (String)msgException, this.obj);
            }
            for (Object object : linhasObrigatorias) {
                Integer id = (Integer)object;
                if (linhasEncontradas.contains(id)) continue;
                throw new ParseException2("Linha obrigat\u00f3ria: " + object.toString() + " n\u00e3o encontrada no arquivo texto.", this.obj);
            }
        }
        return this.obj;
    }

    protected void lerLinha(String aLine) throws ParseException {
        Integer ID = Integer.parseInt(aLine.substring(1, 3));
        switch (ID) {
            case 1: {
                this.informacoesCte(aLine);
                break;
            }
            case 2: {
                this.ufPercurso(aLine);
                break;
            }
            case 3: {
                this.informacoesComplementares(aLine);
                break;
            }
            case 4: {
                this.emitente(aLine);
                break;
            }
            case 5: {
                this.tomador(aLine);
                break;
            }
            case 6: {
                this.componentesPrestacao(aLine);
                break;
            }
            case 7: {
                this.valoresPrestacao(aLine);
                break;
            }
            case 8: {
                this.informacaoServico(aLine);
                break;
            }
            case 9: {
                this.documentos(aLine);
                break;
            }
            case 10: {
                this.seguro(aLine);
                break;
            }
            case 11: {
                this.cobranca(aLine);
                break;
            }
            case 12: {
                this.duplicatas(aLine);
                break;
            }
            case 13: {
                this.infoRodoviario(aLine);
                break;
            }
            case 14: {
                this.informacoesCteSubstituto(aLine);
                break;
            }
            case 15: {
                this.informacoesCteComplemento(aLine);
                break;
            }
            case 16: {
                this.informacoesCteAnulado(aLine);
                break;
            }
            case 17: {
                this.autorizacaoXml(aLine);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + ID + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    protected void informacoesCte(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 23) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 23 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.setReferencia(scanner.next());
                this.obj.setUsuarioEmitente(scanner.next());
                this.obj.setNrCFOP(Util.StringToShort(scanner.next()));
                this.obj.setNaturezaOperacao(scanner.next());
                this.obj.setSerie(Util.StringToShort(scanner.next()));
                this.obj.setNumero(Util.StringToInteger(scanner.next()));
                this.obj.setDataEmissao(LocalDateTimeSerializer.parseDateTime(scanner.next().replaceAll("-", "")));
                this.obj.setNrMunicipioEmissao(Util.StringToInteger(scanner.next()));
                this.obj.setMunicipioEmissao(scanner.next());
                this.obj.setUfEmissao(scanner.next());
                this.obj.setTipoModal(ParseTXTEnvioCTEOSv100.valueToTipoModal(scanner.next()));
                this.obj.setTipoServico(ParseTXTEnvioCTEOSv100.valueToTipoServico(scanner.next()));
                this.obj.setTipoIcmsTomador(ParseTXTEnvioCTEOSv100.valueToTipoIcmsTomador(scanner.next()));
                this.obj.setNrMunicipioInicio(Util.StringToInteger(scanner.next()));
                this.obj.setMunicipioInicio(scanner.next());
                this.obj.setUfInicio(scanner.next());
                this.obj.setNrMunicipioFim(Util.StringToInteger(scanner.next()));
                this.obj.setMunicipioFim(scanner.next());
                this.obj.setUfFim(scanner.next());
                String caracteristasAdicionais = scanner.next();
                String caracteristasAdicionaisServico = scanner.next();
                String observacoesGerais = scanner.next();
                String chaveAcessoCteCancelado = scanner.next();
                if (caracteristasAdicionais != null || caracteristasAdicionaisServico != null) {
                    this.obj.setInformacaoAdicional(new InformacaoAdicional());
                    if (caracteristasAdicionais != null && !caracteristasAdicionais.trim().isEmpty()) {
                        this.obj.getInformacaoAdicional().setCaracteristicaTransporte(caracteristasAdicionais);
                    }
                    if (caracteristasAdicionaisServico != null && !caracteristasAdicionaisServico.trim().isEmpty()) {
                        this.obj.getInformacaoAdicional().setCaracteristicaServico(caracteristasAdicionaisServico);
                    }
                }
                if (observacoesGerais != null && !observacoesGerais.trim().isEmpty()) {
                    this.obj.setObservacao(observacoesGerais);
                }
                if (chaveAcessoCteCancelado == null || chaveAcessoCteCancelado.trim().isEmpty()) continue;
                if (this.obj instanceof CTeNormal) {
                    CTeNormal cTeNormal = (CTeNormal)this.obj;
                    cTeNormal.setChaveCteCancelado(chaveAcessoCteCancelado);
                }
                if (!(this.obj instanceof CTeSubstituto)) continue;
                CTeSubstituto cTeSubstituto = (CTeSubstituto)this.obj;
                cTeSubstituto.setChaveCteCancelado(chaveAcessoCteCancelado);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 001. " + ex.getMessage(), this.obj);
        }
    }

    protected void ufPercurso(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.getUfPercurso().add(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002. " + ex.getMessage());
        }
    }

    protected void informacoesComplementares(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 3) {
                throw new ParseException("A linha 003 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 3 campos.");
            }
            if (this.obj.getInformacaoAdicional() == null) {
                this.obj.setInformacaoAdicional(new InformacaoAdicional());
            }
            while (scanner.hasNext()) {
                Info infoFisco;
                scanner.next();
                String tipo = scanner.next();
                String xCampo = scanner.next();
                String xTexto = scanner.next();
                if (tipo == null || xCampo == null || xTexto == null) {
                    throw new ParseException("Os par\u00e2metros informados na linha 003 est\u00e3o vazios");
                }
                if (tipo.equals("0")) {
                    infoFisco = new InfoFisco();
                    infoFisco.setCampo(xCampo);
                    infoFisco.setDescricao(xTexto);
                    this.obj.getInformacaoAdicional().getCamposAdicionais().add(infoFisco);
                    continue;
                }
                if (!tipo.equals("1")) continue;
                infoFisco = new InfoContribuinte();
                infoFisco.setCampo(xCampo);
                infoFisco.setDescricao(xTexto);
                this.obj.getInformacaoAdicional().getCamposAdicionais().add(infoFisco);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 003. " + ex.getMessage());
        }
    }

    protected void emitente(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 15) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 15 campos.");
            }
            Emitente emitente = new Emitente();
            while (scanner.hasNext()) {
                scanner.next();
                String cnpj = scanner.next();
                String inscricaoEstadual = scanner.next();
                String inscricaoEstadualSt = scanner.next();
                String razaoSocial = scanner.next();
                String fantasia = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String nrMunicipio = scanner.next();
                String municipio = scanner.next();
                String cep = scanner.next();
                String uf = scanner.next();
                String nrUf = scanner.next();
                String telefone = scanner.next();
                emitente.setCnpj(cnpj);
                emitente.setInscricaoEstadual(inscricaoEstadual);
                if (inscricaoEstadualSt != null && !inscricaoEstadualSt.trim().isEmpty()) {
                    emitente.setInscricaoEstadualSt(inscricaoEstadualSt);
                }
                emitente.setRazaoSocial(razaoSocial);
                if (fantasia != null && !fantasia.trim().isEmpty()) {
                    emitente.setFantasia(fantasia);
                }
                emitente.setLogradouro(logradouro);
                emitente.setNumero(numero);
                if (complemento != null && !complemento.trim().isEmpty()) {
                    emitente.setComplemento(complemento);
                }
                emitente.setBairro(bairro);
                emitente.setNrMunicipio(Util.StringToInteger(nrMunicipio));
                emitente.setMunicipio(municipio);
                if (cep != null && !cep.trim().isEmpty()) {
                    emitente.setCep(cep);
                }
                emitente.setUf(uf);
                emitente.setNrUF(Short.valueOf(nrUf));
                if (telefone == null || telefone.trim().isEmpty()) continue;
                emitente.setTelefone(telefone);
            }
            this.obj.setEmitente(emitente);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 004. " + ex.getMessage());
        }
    }

    protected void tomador(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 16) {
                throw new ParseException("A linha 005 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 16 campos.");
            }
            Tomador tomador = new Tomador();
            while (scanner.hasNext()) {
                scanner.next();
                String cpfCnpj = scanner.next();
                String inscricaoEstadual = scanner.next();
                String razaoSocial = scanner.next();
                String fantasia = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String nrMunicipio = scanner.next();
                String municipio = scanner.next();
                String cep = scanner.next();
                String uf = scanner.next();
                String nrPais = scanner.next();
                String pais = scanner.next();
                String telefone = scanner.next().trim();
                String email = scanner.next();
                tomador.setCnpjCpf(cpfCnpj);
                tomador.setInscricaoEstadual(inscricaoEstadual);
                tomador.setRazaoSocial(razaoSocial);
                if (fantasia != null && !fantasia.trim().isEmpty()) {
                    tomador.setNomeFantasia(fantasia);
                }
                tomador.setLogradouro(logradouro);
                tomador.setNumero(numero);
                if (complemento != null && !complemento.trim().isEmpty()) {
                    tomador.setComplemento(complemento);
                }
                tomador.setBairro(bairro);
                tomador.setNrMunicipio(Util.StringToInteger(nrMunicipio));
                tomador.setMunicipio(municipio);
                if (cep != null && !cep.trim().isEmpty()) {
                    tomador.setCep(cep);
                }
                tomador.setUf(uf);
                if (nrPais != null && !nrPais.trim().isEmpty()) {
                    tomador.setNrPais(Util.StringToShort(nrPais));
                }
                if (pais != null && !pais.trim().isEmpty()) {
                    tomador.setPais(pais);
                }
                if (telefone != null && !telefone.trim().isEmpty()) {
                    tomador.setTelefone(telefone);
                }
                if (email == null || email.trim().isEmpty()) continue;
                tomador.setEmail(email);
            }
            this.obj.setTomador(tomador);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 005. " + ex.getMessage());
        }
    }

    protected void componentesPrestacao(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 006 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            ComponentePrestacao comp = new ComponentePrestacao();
            while (scanner.hasNext()) {
                scanner.next();
                comp.setDescricao(scanner.next());
                comp.setValor(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
            }
            this.obj.getComponentePrestacao().add(comp);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 006. " + ex.getMessage());
        }
    }

    protected void valoresPrestacao(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 23) {
                throw new ParseException("A linha 007 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 23 campos.");
            }
            this.obj.setImpostos(new Impostos());
            while (scanner.hasNext()) {
                String infoFisco;
                scanner.next();
                this.obj.setValorTotalPrestacao(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.setValorReceber(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                String cst = scanner.next();
                if (cst == null) {
                    throw new ParseException("Linha 007: CST n\u00e3o informado.");
                }
                String baseCalculo = scanner.next();
                String aliquota = scanner.next();
                String valor = scanner.next();
                String percentualReducao = scanner.next();
                String valorCredito = scanner.next();
                switch (cst) {
                    case "0": {
                        ICMSN00 icmsn00 = new ICMSN00();
                        icmsn00.setValorBC(Util.StringToDouble(baseCalculo, Util.ST_FMT_DOIS_DECIMAIS));
                        icmsn00.setAliquota(Util.StringToDouble(aliquota, Util.ST_FMT_DOIS_DECIMAIS));
                        icmsn00.setValor(Util.StringToDouble(valor, Util.ST_FMT_DOIS_DECIMAIS));
                        this.obj.getImpostos().setIcms(icmsn00);
                        break;
                    }
                    case "1": {
                        ICMSN40 icmsn40 = new ICMSN40();
                        this.obj.getImpostos().setIcms(icmsn40);
                        break;
                    }
                    case "2": {
                        ICMSN41 icmsn41 = new ICMSN41();
                        this.obj.getImpostos().setIcms(icmsn41);
                        break;
                    }
                    case "3": {
                        ICMSN51 icmsn51 = new ICMSN51();
                        this.obj.getImpostos().setIcms(icmsn51);
                        break;
                    }
                    case "4": {
                        ICMSN90 icmsn90 = new ICMSN90();
                        icmsn90.setValorBC(Util.StringToDouble(baseCalculo, Util.ST_FMT_DOIS_DECIMAIS));
                        icmsn90.setAliquota(Util.StringToDouble(aliquota, Util.ST_FMT_DOIS_DECIMAIS));
                        icmsn90.setValor(Util.StringToDouble(valor, Util.ST_FMT_DOIS_DECIMAIS));
                        if (percentualReducao != null) {
                            icmsn90.setReducaoBC(Util.StringToDouble(valor, Util.ST_FMT_DOIS_DECIMAIS));
                        }
                        if (valorCredito != null) {
                            icmsn90.setValorCredito(Util.StringToDouble(valor, Util.ST_FMT_DOIS_DECIMAIS));
                        }
                        this.obj.getImpostos().setIcms(icmsn90);
                        break;
                    }
                    case "5": {
                        ICMSOutraUF icmsOutraUf = new ICMSOutraUF();
                        icmsOutraUf.setValorBC(Util.StringToDouble(baseCalculo, Util.ST_FMT_DOIS_DECIMAIS));
                        icmsOutraUf.setAliquota(Util.StringToDouble(aliquota, Util.ST_FMT_DOIS_DECIMAIS));
                        icmsOutraUf.setValor(Util.StringToDouble(valor, Util.ST_FMT_DOIS_DECIMAIS));
                        if (percentualReducao != null) {
                            icmsOutraUf.setReducaoBC(Util.StringToDouble(valor, Util.ST_FMT_DOIS_DECIMAIS));
                        }
                        this.obj.getImpostos().setIcms(icmsOutraUf);
                        break;
                    }
                    case "6": {
                        ICMSSN icmssn = new ICMSSN();
                        this.obj.getImpostos().setIcms(icmssn);
                        break;
                    }
                }
                String valorTributos = scanner.next();
                if (valorTributos != null && !valorTributos.trim().isEmpty()) {
                    this.obj.getImpostos().setValorTotalTributos(Util.StringToDouble(valorTributos, Util.ST_FMT_DOIS_DECIMAIS));
                }
                if ((infoFisco = scanner.next()) != null && !infoFisco.trim().isEmpty()) {
                    this.obj.getImpostos().setObservacaoFisco(infoFisco);
                }
                String vBCUFFim = scanner.next();
                String pFCPUFFim = scanner.next();
                String pICMSUFFim = scanner.next();
                String pICMSUFInter = scanner.next();
                String pICMSUFInterPart = scanner.next();
                String vFCPUFFim = scanner.next();
                String vICMSUFFim = scanner.next();
                String vICMSUFIni = scanner.next();
                if (vBCUFFim != null && pFCPUFFim != null && pICMSUFFim != null && pICMSUFInter != null && pICMSUFInterPart != null && vFCPUFFim != null && vICMSUFIni != null && vICMSUFFim != null) {
                    this.obj.getImpostos().setIcmsufdestino(new ICMSUFDestino());
                    this.obj.getImpostos().getIcmsufdestino().setAliquotaInterestadual(Util.StringToDouble(pICMSUFInter, Util.ST_FMT_DOIS_DECIMAIS));
                    this.obj.getImpostos().getIcmsufdestino().setAliquotaInterna(Util.StringToDouble(pICMSUFFim, Util.ST_FMT_DOIS_DECIMAIS));
                    this.obj.getImpostos().getIcmsufdestino().setBaseCalculoDest(Util.StringToDouble(vBCUFFim, Util.ST_FMT_DOIS_DECIMAIS));
                    this.obj.getImpostos().getIcmsufdestino().setPercentualFCP(Util.StringToDouble(pFCPUFFim, Util.ST_FMT_DOIS_DECIMAIS));
                    this.obj.getImpostos().getIcmsufdestino().setPercentualProvisorio(Util.StringToDouble(pICMSUFInterPart, Util.ST_FMT_DOIS_DECIMAIS));
                    this.obj.getImpostos().getIcmsufdestino().setValorFCPDest(Util.StringToDouble(vFCPUFFim, Util.ST_FMT_DOIS_DECIMAIS));
                    this.obj.getImpostos().getIcmsufdestino().setValorICMSDest(Util.StringToDouble(vICMSUFFim, Util.ST_FMT_DOIS_DECIMAIS));
                    this.obj.getImpostos().getIcmsufdestino().setValorICMSRem(Util.StringToDouble(vICMSUFIni, Util.ST_FMT_DOIS_DECIMAIS));
                }
                String vPIS = scanner.next();
                String vCOFINS = scanner.next();
                String vIR = scanner.next();
                String vINSS = scanner.next();
                String vCSLL = scanner.next();
                if (vPIS == null && vCOFINS == null && vIR == null && vINSS == null && vCSLL == null) continue;
                this.obj.getImpostos().setImpostosFederais(new ImpostosFederais());
                this.obj.getImpostos().getImpostosFederais().setValorCofins(Util.StringToDouble(vCOFINS, Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getImpostos().getImpostosFederais().setValorCsll(Util.StringToDouble(vCSLL, Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getImpostos().getImpostosFederais().setValorInss(Util.StringToDouble(vINSS, Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getImpostos().getImpostosFederais().setValorIr(Util.StringToDouble(vIR, Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getImpostos().getImpostosFederais().setValorPis(Util.StringToDouble(vPIS, Util.ST_FMT_DOIS_DECIMAIS));
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 007. " + ex.getMessage());
        }
    }

    protected void informacaoServico(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 008 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            InformacaoServico info = new InformacaoServico();
            while (scanner.hasNext()) {
                CTeNormal cte;
                scanner.next();
                info.setDescricao(scanner.next());
                info.setQuantidadeCarga(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                if (this.obj instanceof CTeNormal) {
                    cte = (CTeNormal)this.obj;
                    cte.setInformacaoServico(info);
                }
                if (!(this.obj instanceof CTeSubstituto)) continue;
                cte = (CTeSubstituto)this.obj;
                cte.setInformacaoServico(info);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 008. " + ex.getMessage());
        }
    }

    protected void documentos(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 5) {
                throw new ParseException("A linha 009 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 5 campos.");
            }
            DocumentoReferenciado doc = new DocumentoReferenciado();
            while (scanner.hasNext()) {
                CTeNormal cte;
                scanner.next();
                doc.setNumero(scanner.next());
                doc.setSerie(scanner.next());
                doc.setSubSerie(scanner.next());
                doc.setDataEmissao(LocalDateSerializer.parseDate(scanner.next().replaceAll("-", "")));
                doc.setValorTransportado(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                if (this.obj instanceof CTeNormal) {
                    cte = (CTeNormal)this.obj;
                    cte.getDocumentoReferenciado().add(doc);
                }
                if (!(this.obj instanceof CTeSubstituto)) continue;
                cte = (CTeSubstituto)this.obj;
                cte.getDocumentoReferenciado().add(doc);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 009. " + ex.getMessage());
        }
    }

    protected void seguro(String aLine) throws ParseException {
        try {
            CTeNormal cte;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 3) {
                throw new ParseException("A linha 010 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 3 campos.");
            }
            Seguro seguro = new Seguro();
            while (scanner.hasNext()) {
                scanner.next();
                seguro.setResponsavelSeguro(ParseTXTEnvioCTEOSv100.valueToResponsavelSeguro(scanner.next()));
                seguro.setNomeSeguradora(scanner.next());
                seguro.setApolice(scanner.next());
            }
            if (this.obj instanceof CTeNormal) {
                cte = (CTeNormal)this.obj;
                cte.getSeguro().add(seguro);
            }
            if (this.obj instanceof CTeSubstituto) {
                cte = (CTeSubstituto)this.obj;
                cte.getSeguro().add(seguro);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 010. " + ex.getMessage());
        }
    }

    protected void cobranca(String aLine) throws ParseException {
        try {
            CTeNormal cte;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 011 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            Fatura fatura = new Fatura();
            while (scanner.hasNext()) {
                scanner.next();
                fatura.setNrFatura(scanner.next());
                fatura.setValorOriginal(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                fatura.setValorDesconto(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                fatura.setValorLiquido(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (this.obj instanceof CTeNormal) {
                cte = (CTeNormal)this.obj;
                cte.setFatura(fatura);
            }
            if (this.obj instanceof CTeSubstituto) {
                cte = (CTeSubstituto)this.obj;
                cte.setFatura(fatura);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 011. " + ex.getMessage());
        }
    }

    protected void duplicatas(String aLine) throws ParseException {
        try {
            CTeNormal cte;
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 3) {
                throw new ParseException("A linha 012 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 3 campos.");
            }
            Duplicata duplicata = new Duplicata();
            while (scanner.hasNext()) {
                scanner.next();
                duplicata.setNumero(scanner.next());
                duplicata.setData(LocalDateSerializer.parseDate(scanner.next().replaceAll("-", "")));
                duplicata.setValor(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (this.obj instanceof CTeNormal) {
                cte = (CTeNormal)this.obj;
                cte.getDuplicatas().add(duplicata);
            }
            if (this.obj instanceof CTeSubstituto) {
                cte = (CTeSubstituto)this.obj;
                cte.getDuplicatas().add(duplicata);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 012. " + ex.getMessage());
        }
    }

    protected void infoRodoviario(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 10) {
                throw new ParseException("A linha 013 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 10 campos.");
            }
            Rodoviario rodoviario = new Rodoviario();
            while (scanner.hasNext()) {
                CTeNormal cte;
                scanner.next();
                rodoviario.setTafRegistro(scanner.next());
                String placa = scanner.next();
                if (placa != null && !placa.trim().isEmpty()) {
                    rodoviario.setVeiculo(new Veiculo());
                    rodoviario.getVeiculo().setPlaca(placa);
                    rodoviario.getVeiculo().setNrRenavan(scanner.next());
                    rodoviario.getVeiculo().setUfLicencidado(scanner.next());
                    String cnpjCpfProp = scanner.next();
                    if (cnpjCpfProp != null && !cnpjCpfProp.trim().isEmpty()) {
                        rodoviario.getVeiculo().setProprietario(new Proprietario());
                        rodoviario.getVeiculo().getProprietario().setCnpjCpf(cnpjCpfProp);
                        rodoviario.getVeiculo().getProprietario().setTafRegistro(scanner.next());
                        rodoviario.getVeiculo().getProprietario().setRazaoSocial(scanner.next());
                        rodoviario.getVeiculo().getProprietario().setInscricaoEstadual(scanner.next());
                        rodoviario.getVeiculo().getProprietario().setUf(scanner.next());
                        rodoviario.getVeiculo().getProprietario().setTipoProprietario(ParseTXTEnvioCTEOSv100.valueToTipoProprietario(scanner.next()));
                    }
                }
                if (this.obj instanceof CTeNormal) {
                    cte = (CTeNormal)this.obj;
                    cte.setModal(rodoviario);
                }
                if (!(this.obj instanceof CTeSubstituto)) continue;
                cte = (CTeSubstituto)this.obj;
                cte.setModal(rodoviario);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 013. " + ex.getMessage());
        }
    }

    protected void informacoesCteSubstituto(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 11) {
                throw new ParseException("A linha 014 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 11 campos.");
            }
            CTeSubstituto cte = (CTeSubstituto)this.obj;
            while (scanner.hasNext()) {
                String refCte;
                String refNfe;
                scanner.next();
                cte.setNrChaveAcessoOriginal(scanner.next());
                String refCteAnu = scanner.next();
                if (refCteAnu != null && !refCteAnu.trim().isEmpty()) {
                    cte.setRefCteAnulado(refCteAnu);
                }
                if ((refNfe = scanner.next()) != null && !refNfe.trim().isEmpty()) {
                    cte.setNrChaveAcessoRefNFeEmitida(refNfe);
                }
                if ((refCte = scanner.next()) != null && !refCte.trim().isEmpty()) {
                    cte.setNrChaveAcessoRefCteEmitido(refCte);
                }
                String cnpjCpf = scanner.next();
                String mod = scanner.next();
                String serie = scanner.next();
                String subserie = scanner.next();
                String nro = scanner.next();
                String valor = scanner.next();
                String demi = scanner.next();
                if (cnpjCpf == null || cnpjCpf.trim().isEmpty()) continue;
                cte.setCnpj(cnpjCpf);
                cte.setModeloDocumento(mod);
                cte.setSerie(Short.valueOf(serie));
                if (subserie != null && !subserie.trim().isEmpty()) {
                    cte.setSubSerie(Short.valueOf(subserie));
                }
                cte.setNrDocumento(nro);
                cte.setValor(Util.StringToDouble(valor, Util.ST_FMT_DOIS_DECIMAIS));
                cte.setDataEmissaoSubstituto(LocalDateSerializer.parseDate(demi.replaceAll("-", "")));
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 014. " + ex.getMessage());
        }
    }

    protected void informacoesCteComplemento(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 015 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campos.");
            }
            scanner.useDelimiter("\\|");
            CTeComplemento cte = (CTeComplemento)this.obj;
            while (scanner.hasNext()) {
                scanner.next();
                cte.setChaveAcessoComplemento(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 015. " + ex.getMessage());
        }
    }

    protected void informacoesCteAnulado(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 016 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            scanner.useDelimiter("\\|");
            CTeAnulacao cte = (CTeAnulacao)this.obj;
            while (scanner.hasNext()) {
                scanner.next();
                cte.setNrChaveAcessoAnulacao(scanner.next());
                cte.setDataEmissaoAnulacao(LocalDateSerializer.parseDate(scanner.next().replaceAll("-", "")));
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 016. " + ex.getMessage());
        }
    }

    protected void autorizacaoXml(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 017 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            scanner.useDelimiter("\\|");
            if (this.obj.getPermitidos() != null) {
                this.obj.setPermitidos(new PermissaoDownload());
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.getPermitidos().getCnpjCpf().add(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 017. " + ex.getMessage());
        }
    }
}

