/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.cteos.v1;

import br.com.ophos.enumerations.TipoEventoCTE;
import br.com.ophos.evento.cteos.dto.DestinatarioGTV;
import br.com.ophos.evento.cteos.dto.EventoCTEOS;
import br.com.ophos.evento.cteos.dto.InfoEspecie;
import br.com.ophos.evento.cteos.dto.InfoGTV;
import br.com.ophos.evento.cteos.dto.RemetenteGTV;
import br.com.ophos.integracao.interfaces.cte.dto.evento.ElementoCCe;
import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.cteos.ParseTXTEventoCTEOSFactory;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.datatype.XMLGregorianCalendar;

public class ParseTXTEventoCTEOSv100
extends ParseTXTEventoCTEOSFactory {
    private EventoCTEOS obj = null;
    private static ParseTXTEventoCTEOSv100 instance;
    private TipoEventoCTE tipoEvento;
    private HashMap<String, InfoGTV> mapInfoGtv = new HashMap();
    private Collection<String> idsInfoGtv = new ArrayList<String>();

    public static ParseTXTEventoCTEOSv100 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEventoCTEOSv100();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventoCTEOS parse(InputStream is) throws ParseException {
        try (Scanner scanner = null;){
            scanner = new Scanner(is);
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String linha = null;
                linha = scanner.nextLine();
                this.lerLinhaEvento(linha + "|");
            }
        }
        if (!this.mapInfoGtv.isEmpty() && !this.idsInfoGtv.isEmpty()) {
            for (String id : this.idsInfoGtv) {
                this.obj.getInfoGtv().add(this.mapInfoGtv.get(id));
            }
        }
        return this.obj;
    }

    private void lerLinhaEvento(String linha) throws ParseException {
        Integer ID = Integer.parseInt(linha.substring(1, 3));
        switch (ID) {
            case 1: {
                this.dadosEvento(linha);
                break;
            }
            case 2: {
                this.dadosCartaCorrecao(linha);
                break;
            }
            case 3: {
                this.dadosCancelamento(linha);
                break;
            }
            case 4: {
                this.dadosGtv(linha);
                break;
            }
            case 5: {
                this.dadosEspecieGtv(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + ID + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    protected void dadosEvento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            this.obj = new EventoCTEOS();
            while (scanner.hasNext()) {
                String tipoEventoLido;
                scanner.next();
                switch (tipoEventoLido = scanner.next()) {
                    case "0": {
                        this.obj.setTipoEvento(TipoEventoCTE.CARTA_CORRECAO);
                        this.tipoEvento = TipoEventoCTE.CARTA_CORRECAO;
                        break;
                    }
                    case "1": {
                        this.obj.setTipoEvento(TipoEventoCTE.CANCELAMENTO);
                        this.tipoEvento = TipoEventoCTE.CANCELAMENTO;
                        break;
                    }
                    case "2": {
                        this.obj.setTipoEvento(TipoEventoCTE.GTV);
                        this.tipoEvento = TipoEventoCTE.GTV;
                        break;
                    }
                    default: {
                        throw new ParseException("N\u00e3o foi informado o tipo de evento esperado.");
                    }
                }
                this.obj.setCnpj(scanner.next());
                this.obj.setChaveAcesso(scanner.next());
                this.obj.setUsuario(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 001: " + ex.getMessage());
        }
    }

    protected void dadosCartaCorrecao(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                String elementoCampo = scanner.next();
                String elementoGrupo = scanner.next();
                String elementoValor = scanner.next();
                String elementoShort = scanner.next();
                ElementoCCe elemento = new ElementoCCe();
                elemento.setCampo(elementoCampo);
                elemento.setGrupo(elementoGrupo);
                elemento.setValor(elementoValor);
                if (elementoShort != null && !elementoShort.isEmpty()) {
                    elemento.setPosicao(Short.parseShort(elementoShort));
                }
                this.obj.getElementos().add(elemento);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    protected void dadosCancelamento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 003 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.setJustificativaCancelamento(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 003: " + ex.getMessage());
        }
    }

    protected void dadosGtv(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 18) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 18 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                String nrDoc = scanner.next();
                String id = scanner.next();
                String serie = scanner.next();
                String subserie = scanner.next();
                XMLGregorianCalendar dataEmissao = Util.StringToXMLCalendar(scanner.next());
                String numeroDv = scanner.next();
                Double quantidadeCarga = Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS);
                String placa = scanner.next();
                String uf = scanner.next();
                String rntrc = scanner.next();
                String cnpjCpfRem = scanner.next();
                String ieRem = scanner.next();
                String ufRem = scanner.next();
                String nomeRem = scanner.next();
                String cnpjCpfDest = scanner.next();
                String ieDest = scanner.next();
                String ufDest = scanner.next();
                String nomeDest = scanner.next();
                InfoGTV infoGTV = new InfoGTV();
                infoGTV.setNrDocumento(nrDoc);
                infoGTV.setIdentificador(id);
                if (serie != null && !serie.trim().isEmpty()) {
                    infoGTV.setSerie(serie);
                }
                if (subserie != null && !subserie.trim().isEmpty()) {
                    infoGTV.setSubserie(subserie);
                }
                infoGTV.setDataEmissao(dataEmissao);
                infoGTV.setNumeroDv(numeroDv);
                infoGTV.setqCarga(quantidadeCarga);
                if (placa != null && !placa.trim().isEmpty()) {
                    infoGTV.setPlaca(placa);
                }
                if (uf != null && !uf.trim().isEmpty()) {
                    infoGTV.setUf(uf);
                }
                if (rntrc != null && !rntrc.trim().isEmpty()) {
                    infoGTV.setRntrc(rntrc);
                }
                RemetenteGTV remetenteGTV = new RemetenteGTV();
                remetenteGTV.setCnpjCpf(cnpjCpfRem);
                if (ieRem != null && !ieRem.trim().isEmpty()) {
                    remetenteGTV.setInscricaoEstadual(ieRem);
                }
                remetenteGTV.setUf(ufRem);
                remetenteGTV.setNome(nomeRem);
                infoGTV.setRemetente(remetenteGTV);
                DestinatarioGTV destinatarioGTV = new DestinatarioGTV();
                destinatarioGTV.setCnpjCpf(cnpjCpfDest);
                if (ieDest != null && !ieDest.trim().isEmpty()) {
                    destinatarioGTV.setInscricaoEstadual(ieDest);
                }
                destinatarioGTV.setUf(ufDest);
                destinatarioGTV.setNome(nomeDest);
                infoGTV.setDestinatario(destinatarioGTV);
                this.mapInfoGtv.put(id, infoGTV);
                this.idsInfoGtv.add(id);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 004: " + ex.getMessage());
        }
    }

    protected void dadosEspecieGtv(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 005 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                InfoEspecie infoEspecie = new InfoEspecie();
                String id = scanner.next();
                infoEspecie.setTipo(ParseTXTEventoCTEOSv100.valueToTipoEspecieGtv(scanner.next()));
                infoEspecie.setValor(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                InfoGTV infoGTV = this.mapInfoGtv.get(id);
                if (infoGTV == null) {
                    throw new ParseException("ID da GTV n\u00e3o localizado para v\u00ednculo com Informa\u00e7\u00e3o de Esp\u00e9cie.");
                }
                infoGTV.getInfoEspecie().add(infoEspecie);
                this.mapInfoGtv.put(id, infoGTV);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 004: " + ex.getMessage());
        }
    }

    public TipoEventoCTE getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(TipoEventoCTE tipoEvento) {
        this.tipoEvento = tipoEvento;
    }
}

