/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.mdfe.v1;

import br.com.ophos.enumerations.TipoEvento;
import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.mdfe.factory.ParseTXTEventoMDFEFactory;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.evento.EventoMDFE;
import java.io.InputStream;
import java.util.Scanner;

public class ParseTXTEventoMDFEv100
extends ParseTXTEventoMDFEFactory {
    private EventoMDFE obj = null;
    private static ParseTXTEventoMDFEv100 instance;

    public static ParseTXTEventoMDFEv100 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEventoMDFEv100();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventoMDFE parse(InputStream is) throws ParseException {
        try (Scanner scanner = null;){
            scanner = new Scanner(is);
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String linha = null;
                linha = scanner.nextLine();
                this.lerLinhaEvento(linha + "|");
            }
        }
        return this.obj;
    }

    private void lerLinhaEvento(String linha) throws ParseException {
        Integer ID = Integer.parseInt(linha.substring(1, 3));
        switch (ID) {
            case 0: {
                this.dadosEvento(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + ID + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    private void dadosEvento(String linha) throws ParseException {
        try (Scanner scanner = new Scanner(linha);){
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 5) {
                throw new ParseException("A linha 000 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 6 campos.");
            }
            this.obj = new EventoMDFE();
            while (scanner.hasNext()) {
                scanner.next();
                String tipoEvento = scanner.next();
                if (tipoEvento.equals("1")) {
                    this.obj.setTipoEvento(TipoEvento.CANCELAMENTO);
                    this.obj.setChaveAcesso(scanner.next());
                    this.obj.setJustificativa(scanner.next());
                    scanner.next();
                    scanner.next();
                    continue;
                }
                if (tipoEvento.equals("2")) {
                    this.obj.setTipoEvento(TipoEvento.ENCERRAMENTO);
                    this.obj.setChaveAcesso(scanner.next());
                    scanner.next();
                    this.obj.setDataEncerramento(br.com.ophos.util.Util.parseData(scanner.next(), br.com.ophos.util.Util.FMTYYYYMMDD_2));
                    this.obj.setNrIbge(scanner.next());
                    continue;
                }
                throw new ParseException("N\u00e3o foi informado o tipo de evento.");
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 000: " + ex.getMessage());
        }
    }
}

