/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.mdfe.v1;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.mdfe.v1.ParseTXTEventoMDFEv102;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.envio.InfoPagamento;
import br.com.ophos.xml.mdfe.evento.EventoMDFE;
import br.com.ophos.xml.mdfe.evento.EventoPagamento;

public class ParseTXTEventoMDFEv103
extends ParseTXTEventoMDFEv102 {
    private EventoMDFE obj = null;
    private static ParseTXTEventoMDFEv103 instance;

    public static ParseTXTEventoMDFEv103 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEventoMDFEv103();
        }
        return instance;
    }

    @Override
    protected void dadosPagamento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 10) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 10 campo.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                InfoPagamento pag = new InfoPagamento();
                pag.setId(scanner.next());
                pag.setCnpjCpf(scanner.next());
                pag.setNome(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.setValorContrato(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                pag.setFormaPagamento(scanner.next());
                pag.setValorAdiantamento(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                pag.setBanco(new InfoPagamento.InfoBanco());
                pag.getBanco().setBanco(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.getBanco().setAgencia(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.getBanco().setCnpjIpef(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.getBanco().setPix(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                EventoPagamento e = (EventoPagamento)this.obj.getEvento();
                e.getInfoPagamento().add(pag);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }
}

