/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.mdfe.v2;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.ParseException2;
import br.com.ophos.parse.txt.mdfe.factory.ParseTXTEnvioMDFEFactory;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.envio.DocumentoCT;
import br.com.ophos.xml.mdfe.envio.DocumentoCTe;
import br.com.ophos.xml.mdfe.envio.DocumentoNF;
import br.com.ophos.xml.mdfe.envio.DocumentoNFe;
import br.com.ophos.xml.mdfe.envio.Emitente;
import br.com.ophos.xml.mdfe.envio.InfoAdicional;
import br.com.ophos.xml.mdfe.envio.InfoCarregamento;
import br.com.ophos.xml.mdfe.envio.InfoContribuinte;
import br.com.ophos.xml.mdfe.envio.InfoDescarregamento;
import br.com.ophos.xml.mdfe.envio.InfoModal;
import br.com.ophos.xml.mdfe.envio.InfoPercurso;
import br.com.ophos.xml.mdfe.envio.Lacres;
import br.com.ophos.xml.mdfe.envio.Mdfe;
import br.com.ophos.xml.mdfe.envio.Motorista;
import br.com.ophos.xml.mdfe.envio.MunicipioCarregamento;
import br.com.ophos.xml.mdfe.envio.MunicipioDescarregamento;
import br.com.ophos.xml.mdfe.envio.Permitidos;
import br.com.ophos.xml.mdfe.envio.ProdutoPerigoso;
import br.com.ophos.xml.mdfe.envio.Proprietario;
import br.com.ophos.xml.mdfe.envio.Reboque;
import br.com.ophos.xml.mdfe.envio.Rodoviario;
import br.com.ophos.xml.mdfe.envio.Seguro;
import br.com.ophos.xml.mdfe.envio.Totais;
import br.com.ophos.xml.mdfe.envio.UnidadeCarga;
import br.com.ophos.xml.mdfe.envio.UnidadeTransporte;
import br.com.ophos.xml.mdfe.envio.ValePedagio;
import br.com.ophos.xml.mdfe.envio.Veiculo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class ParseTXTEnvioMDFEv200
extends ParseTXTEnvioMDFEFactory {
    private static ParseTXTEnvioMDFEv200 instance;
    protected Mdfe obj = null;
    protected HashMap<Integer, MunicipioDescarregamento> mapMunicipio = new HashMap();
    protected HashMap<Integer, Object> mapDocumento = new HashMap();
    protected HashMap<Integer, UnidadeTransporte> mapUnidadeTransporte = new HashMap();
    protected HashMap<Integer, UnidadeCarga> mapUnidadeCarga = new HashMap();
    protected HashMap<Integer, Seguro> mapSeguro = new HashMap();

    public static ParseTXTEnvioMDFEv200 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioMDFEv200();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mdfe parse(InputStream is) throws ParseException2 {
        this.obj = new Mdfe();
        try (Scanner scanner = null;){
            ArrayList<Integer> linhasObrigatorias = new ArrayList<Integer>();
            linhasObrigatorias.add(0);
            linhasObrigatorias.add(1);
            linhasObrigatorias.add(9);
            linhasObrigatorias.add(10);
            linhasObrigatorias.add(11);
            ArrayList<String> linhasErro = new ArrayList<String>();
            ArrayList<Integer> linhasEncontradas = new ArrayList<Integer>();
            scanner = new Scanner(is);
            scanner.next();
            while (scanner.hasNextLine()) {
                String linha = null;
                linha = scanner.nextLine();
                if (linha.length() < 3) continue;
                Integer ID = Integer.parseInt(linha.substring(1, 3));
                linhasEncontradas.add(ID);
                try {
                    this.lerLinhaManifesto(linha + "|");
                }
                catch (ParseException parseException) {
                    linhasErro.add(parseException.getMessage());
                }
            }
            Object msgException = "";
            for (String string : linhasErro) {
                msgException = (String)msgException + string;
            }
            if (linhasErro.size() > 0) {
                throw new ParseException2("ERRO_LAYOUT: " + (String)msgException, this.obj);
            }
            for (Object e : linhasObrigatorias) {
                Integer id = (Integer)e;
                if (linhasEncontradas.contains(id)) continue;
                throw new ParseException2("Linha obrigat\u00f3ria: " + e.toString() + " n\u00e3o encontrada no arquivo texto.");
            }
        }
        return this.obj;
    }

    protected void lerLinhaManifesto(String linha) throws ParseException {
        Integer id = Integer.parseInt(linha.substring(1, 3));
        switch (id) {
            case 0: {
                this.dadosManifesto(linha);
                break;
            }
            case 1: {
                this.dadosEmitente(linha);
                break;
            }
            case 2: {
                this.dadosRodoviario(linha);
                break;
            }
            case 3: {
                this.dadosVeiculo(linha);
                break;
            }
            case 4: {
                this.dadosReboque(linha);
                break;
            }
            case 5: {
                this.dadosValePedagio(linha);
                break;
            }
            case 6: {
                this.dadosMotorista(linha);
                break;
            }
            case 7: {
                this.dadosLacreRodoviario(linha);
                break;
            }
            case 8: {
                this.dadosContratanteRodoviario(linha);
                break;
            }
            case 9: {
                this.dadosCarregamento(linha);
                break;
            }
            case 10: {
                this.dadosDescarregamento(linha);
                break;
            }
            case 11: {
                this.dadosDocumentos(linha);
                break;
            }
            case 12: {
                this.dadosLacres(linha);
                break;
            }
            case 13: {
                this.dadosUnidadesTransporte(linha);
                break;
            }
            case 14: {
                this.dadosUnidadesCarga(linha);
                break;
            }
            case 15: {
                this.dadosLacresTransporte(linha);
                break;
            }
            case 16: {
                this.dadosLacresCarga(linha);
                break;
            }
            case 17: {
                this.dadosProdutoPerigoso(linha);
                break;
            }
            case 18: {
                this.dadosSeguro(linha);
                break;
            }
            case 19: {
                this.dadosAverbacaoSeguro(linha);
                break;
            }
            case 20: {
                this.dadosAutorizacaoXML(linha);
                break;
            }
            case 21: {
                this.dadosPercurso(linha);
                break;
            }
            case 22: {
                this.dadosInfoContribuinte(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + id + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    protected void dadosManifesto(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 14) {
                throw new ParseException("A linha 000 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 14 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.setNumero(Integer.parseInt(scanner.next()));
                this.obj.setSerie(Short.parseShort(scanner.next()));
                this.obj.setDataEmissao(Util.StringToDateTime(scanner.next()));
                this.obj.setTipoModal(scanner.next());
                this.obj.setUfIni(scanner.next());
                this.obj.setUfFim(scanner.next());
                this.obj.setNrReferencia(scanner.next());
                if (this.obj.getTotais() == null) {
                    this.obj.setTotais(new Totais());
                }
                this.obj.getTotais().setPesoBruto(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setUnidadeMedida(scanner.next());
                this.obj.getTotais().setValorTotalCarga(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                if (this.obj.getInfoAdicional() == null) {
                    this.obj.setInfoAdicional(new InfoAdicional());
                }
                this.obj.getInfoAdicional().setInfoContribuinte(scanner.next());
                this.obj.getInfoAdicional().setInfoFisco(scanner.next());
                this.obj.setInicioViagem(Util.StringToDateTime(scanner.next()));
                String tipoTransportador = scanner.next();
                if (tipoTransportador == null || tipoTransportador.trim().isEmpty()) continue;
                this.obj.setTipoTransportador(tipoTransportador);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 000: " + ex.getMessage());
        }
    }

    protected void dadosEmitente(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 16) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 16 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getEmitente() == null) {
                    this.obj.setEmitente(new Emitente());
                }
                this.obj.getEmitente().setTipoEmitente(scanner.next());
                this.obj.getEmitente().setCnpj(scanner.next());
                this.obj.getEmitente().setInscricaoEstadual(scanner.next());
                this.obj.getEmitente().setRazaoSocial(scanner.next());
                this.obj.getEmitente().setFantasia(scanner.next());
                this.obj.getEmitente().setLogradouro(scanner.next());
                this.obj.getEmitente().setNumero(scanner.next());
                this.obj.getEmitente().setComplemento(scanner.next());
                this.obj.getEmitente().setBairro(scanner.next());
                this.obj.getEmitente().setNrIbgeMunicipio(Integer.parseInt(scanner.next()));
                this.obj.getEmitente().setMunicipio(scanner.next());
                this.obj.getEmitente().setCep(scanner.next());
                this.obj.getEmitente().setUf(scanner.next());
                this.obj.getEmitente().setNrIbgeUf(Short.parseShort(scanner.next()));
                this.obj.getEmitente().setTelefone(scanner.next());
                this.obj.getEmitente().setEmail(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 001: " + ex.getMessage());
        }
    }

    protected void dadosRodoviario(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getModal() == null) {
                    this.obj.setModal(new InfoModal());
                    this.obj.getModal().setRodoviario(new Rodoviario());
                }
                String rntrc = scanner.next();
                String ciot = scanner.next();
                String cnpjCpfCiot = scanner.next();
                String codigoAgendamento = scanner.next();
                if (rntrc != null && !rntrc.trim().isEmpty()) {
                    this.obj.getModal().getRodoviario().setRntrc(rntrc);
                }
                if (ciot != null && !ciot.trim().isEmpty()) {
                    this.obj.getModal().getRodoviario().setCiot(ciot);
                }
                if (cnpjCpfCiot != null && !cnpjCpfCiot.trim().isEmpty()) {
                    this.obj.getModal().getRodoviario().setCnpjCpfCiot(cnpjCpfCiot);
                }
                if (codigoAgendamento == null || codigoAgendamento.trim().isEmpty()) continue;
                this.obj.getModal().getRodoviario().setCodAgenPorto(codigoAgendamento);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    protected void dadosVeiculo(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 16) {
                throw new ParseException("A linha 003 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 16 campos.");
            }
            while (scanner.hasNext()) {
                String tipoProprietario;
                String capM3;
                scanner.next();
                if (this.obj.getModal().getRodoviario().getVeiculo() == null) {
                    this.obj.getModal().getRodoviario().setVeiculo(new Veiculo());
                }
                this.obj.getModal().getRodoviario().getVeiculo().setNrInterno(scanner.next());
                this.obj.getModal().getRodoviario().getVeiculo().setPlaca(scanner.next());
                this.obj.getModal().getRodoviario().getVeiculo().setTara(Integer.parseInt(scanner.next()));
                String capKG = scanner.next();
                if (capKG != null && !capKG.isEmpty()) {
                    this.obj.getModal().getRodoviario().getVeiculo().setCapacidadeKG(Integer.parseInt(capKG));
                }
                if ((capM3 = scanner.next()) != null && !capM3.isEmpty()) {
                    this.obj.getModal().getRodoviario().getVeiculo().setCapacidadeM3(Integer.parseInt(capM3));
                }
                this.obj.getModal().getRodoviario().getVeiculo().setTipoRodado(scanner.next());
                this.obj.getModal().getRodoviario().getVeiculo().setTipoCarroceria(scanner.next());
                this.obj.getModal().getRodoviario().getVeiculo().setUf(scanner.next());
                String renavam = scanner.next();
                if (renavam != null && !renavam.isEmpty()) {
                    this.obj.getModal().getRodoviario().getVeiculo().setRenavam(renavam);
                }
                if ((tipoProprietario = scanner.next()) != null && !tipoProprietario.isEmpty()) {
                    String cpf;
                    this.obj.getModal().getRodoviario().getVeiculo().setProprietario(new Proprietario());
                    this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setTipoProprietario(tipoProprietario);
                    String cnpj = scanner.next();
                    if (cnpj != null && !cnpj.isEmpty()) {
                        this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setCnpj(cnpj);
                    }
                    if ((cpf = scanner.next()) != null && !cpf.isEmpty()) {
                        this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setCpf(cpf);
                    }
                    this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setIe(scanner.next());
                    this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setNome(scanner.next());
                    this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setRntrc(scanner.next());
                    this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setUf(scanner.next());
                    continue;
                }
                for (int i = 1; i <= 6; ++i) {
                    scanner.next();
                }
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 003: " + ex.getMessage());
        }
    }

    protected void dadosReboque(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 15) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 15 campos.");
            }
            while (scanner.hasNext()) {
                String tipoProprietario;
                String capM3;
                Reboque reboque = new Reboque();
                scanner.next();
                reboque.setNrInterno(scanner.next());
                reboque.setPlaca(scanner.next());
                reboque.setTara(Integer.parseInt(scanner.next()));
                String capKG = scanner.next();
                if (capKG != null && !capKG.isEmpty()) {
                    reboque.setCapacidadeKG(Integer.parseInt(capKG));
                }
                if ((capM3 = scanner.next()) != null && !capM3.isEmpty()) {
                    reboque.setCapacidadeM3(Integer.parseInt(capM3));
                }
                reboque.setTipoCarroceria(scanner.next());
                reboque.setUf(scanner.next());
                String renavam = scanner.next();
                if (renavam != null && !renavam.isEmpty()) {
                    reboque.setRenavam(renavam);
                }
                if ((tipoProprietario = scanner.next()) != null && !tipoProprietario.isEmpty()) {
                    String cpf;
                    reboque.setProprietario(new Proprietario());
                    reboque.getProprietario().setTipoProprietario(tipoProprietario);
                    String cnpj = scanner.next();
                    if (cnpj != null && !cnpj.isEmpty()) {
                        reboque.getProprietario().setCnpj(cnpj);
                    }
                    if ((cpf = scanner.next()) != null && !cpf.isEmpty()) {
                        reboque.getProprietario().setCpf(cpf);
                    }
                    reboque.getProprietario().setIe(scanner.next());
                    reboque.getProprietario().setNome(scanner.next());
                    reboque.getProprietario().setRntrc(scanner.next());
                    reboque.getProprietario().setUf(scanner.next());
                } else {
                    for (int i = 1; i <= 6; ++i) {
                        scanner.next();
                    }
                }
                this.obj.getModal().getRodoviario().getReboque().add(reboque);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 004: " + ex.getMessage());
        }
    }

    protected void dadosValePedagio(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 005 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            while (scanner.hasNext()) {
                ValePedagio vale = new ValePedagio();
                scanner.next();
                vale.setCnpjFornecedor(scanner.next());
                vale.setCnpjRespPgto(scanner.next());
                vale.setNrComprovante(scanner.next());
                vale.setValor(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getModal().getRodoviario().getValePedagio().add(vale);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 005: " + ex.getMessage());
        }
    }

    protected void dadosMotorista(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 006 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (scanner.hasNext()) {
                Motorista motorista = new Motorista();
                scanner.next();
                motorista.setNome(scanner.next());
                motorista.setCpf(scanner.next());
                this.obj.getModal().getRodoviario().getMotorista().add(motorista);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 006: " + ex.getMessage());
        }
    }

    protected void dadosLacreRodoviario(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 007 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.getModal().getRodoviario().getNrLacre().add(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 007: " + ex.getMessage());
        }
    }

    protected void dadosContratanteRodoviario(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 008 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.getModal().getRodoviario().getCnpjCpfContratante().add(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 008: " + ex.getMessage());
        }
    }

    protected void dadosCarregamento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 009 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (scanner.hasNext()) {
                MunicipioCarregamento carregamento = new MunicipioCarregamento();
                scanner.next();
                if (this.obj.getInfoCarregamento() == null) {
                    this.obj.setInfoCarregamento(new InfoCarregamento());
                }
                carregamento.setNrMunicipio(Integer.parseInt(scanner.next()));
                carregamento.setMunicipio(scanner.next());
                this.obj.getInfoCarregamento().getMunicipio().add(carregamento);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 009: " + ex.getMessage());
        }
    }

    protected void dadosDescarregamento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 3) {
                throw new ParseException("A linha 010 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 3 campos.");
            }
            while (scanner.hasNext()) {
                MunicipioDescarregamento descarregamento = new MunicipioDescarregamento();
                scanner.next();
                if (this.obj.getInfoDescarregamento() == null) {
                    this.obj.setInfoDescarregamento(new InfoDescarregamento());
                }
                int id = Integer.parseInt(scanner.next());
                descarregamento.setNrMunicipio(Integer.parseInt(scanner.next()));
                descarregamento.setMunicipio(scanner.next());
                this.obj.getInfoDescarregamento().getMunicipio().add(descarregamento);
                this.mapMunicipio.put(id, descarregamento);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 010: " + ex.getMessage());
        }
    }

    protected void dadosDocumentos(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 9) {
                throw new ParseException("A linha 011 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 9 campos.");
            }
            if (scanner.hasNext()) {
                scanner.next();
                int id = Integer.parseInt(scanner.next());
                int idMunicipio = Integer.parseInt(scanner.next());
                MunicipioDescarregamento descarregamento = this.mapMunicipio.get(idMunicipio);
                int tipo = Integer.parseInt(scanner.next());
                switch (tipo) {
                    case 1: {
                        String reentregaCte;
                        DocumentoCTe cte = new DocumentoCTe();
                        cte.setChaveAcesso(scanner.next());
                        String chaveContingenciaCte = scanner.next();
                        if (chaveContingenciaCte != null && !chaveContingenciaCte.isEmpty()) {
                            cte.setChaveAcessoContingencia(chaveContingenciaCte);
                        }
                        if ((reentregaCte = scanner.next()) != null && !reentregaCte.trim().isEmpty() && reentregaCte.equals("1")) {
                            cte.setReentrega("1");
                        }
                        descarregamento.getCte().add(cte);
                        this.mapMunicipio.put(idMunicipio, descarregamento);
                        this.mapDocumento.put(id, cte);
                        break;
                    }
                    case 2: {
                        String reentregaNfe;
                        for (int i = 1; i <= 3; ++i) {
                            scanner.next();
                        }
                        DocumentoNFe nfe = new DocumentoNFe();
                        nfe.setChaveAcesso(scanner.next());
                        String chaveContingenciaNfe = scanner.next();
                        if (chaveContingenciaNfe != null && !chaveContingenciaNfe.isEmpty()) {
                            nfe.setChaveAcessoContingencia(chaveContingenciaNfe);
                        }
                        if ((reentregaNfe = scanner.next()) != null && !reentregaNfe.trim().isEmpty() && reentregaNfe.equals("1")) {
                            nfe.setReentrega("1");
                        }
                        descarregamento.getNfe().add(nfe);
                        this.mapMunicipio.put(idMunicipio, descarregamento);
                        this.mapDocumento.put(id, nfe);
                        break;
                    }
                    default: {
                        throw new ParseException("N\u00e3o foi informado um tipo v\u00e1lido de documento");
                    }
                }
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 011: " + ex.getMessage());
        }
    }

    protected void dadosLacres(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 012 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getLacres() == null) {
                    this.obj.setLacres(new Lacres());
                }
                this.obj.getLacres().getNrLacre().add(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 012: " + ex.getMessage());
        }
    }

    protected void dadosUnidadesTransporte(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 5) {
                throw new ParseException("A linha 013 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 5 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                int id = Integer.parseInt(scanner.next());
                int idDocumento = Integer.parseInt(scanner.next());
                Object documento = this.mapDocumento.get(idDocumento);
                UnidadeTransporte ut = new UnidadeTransporte();
                ut.setTipo(scanner.next());
                ut.setIdentificacao(scanner.next());
                ut.setQuantidadeRateada(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                if (documento instanceof DocumentoCT) {
                    DocumentoCT ct = (DocumentoCT)documento;
                    ct.getUnidadeTransporte().add(ut);
                    this.mapDocumento.put(id, ct);
                }
                if (documento instanceof DocumentoCTe) {
                    DocumentoCTe cte = (DocumentoCTe)documento;
                    cte.getUnidadeTransporte().add(ut);
                    this.mapDocumento.put(idDocumento, cte);
                }
                if (documento instanceof DocumentoNF) {
                    DocumentoNF nf = (DocumentoNF)documento;
                    nf.getUnidadeTransporte().add(ut);
                    this.mapDocumento.put(idDocumento, nf);
                }
                if (documento instanceof DocumentoNFe) {
                    DocumentoNFe nfe = (DocumentoNFe)documento;
                    nfe.getUnidadeTransporte().add(ut);
                    this.mapDocumento.put(idDocumento, nfe);
                }
                this.mapUnidadeTransporte.put(id, ut);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 013: " + ex.getMessage());
        }
    }

    protected void dadosUnidadesCarga(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 5) {
                throw new ParseException("A linha 014 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 5 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                int id = Integer.parseInt(scanner.next());
                int idTransporte = Integer.parseInt(scanner.next());
                UnidadeTransporte ut = this.mapUnidadeTransporte.get(idTransporte);
                UnidadeCarga uc = new UnidadeCarga();
                uc.setTipo(scanner.next());
                uc.setIdentificacao(scanner.next());
                uc.setQuantidadeRateada(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                ut.getUnidadeCarga().add(uc);
                this.mapUnidadeTransporte.put(idTransporte, ut);
                this.mapUnidadeCarga.put(id, uc);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 014: " + ex.getMessage());
        }
    }

    protected void dadosLacresTransporte(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 015 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                int idTransporte = Integer.parseInt(scanner.next());
                UnidadeTransporte ut = this.mapUnidadeTransporte.get(idTransporte);
                ut.setLacres(new Lacres());
                ut.getLacres().getNrLacre().add(scanner.next());
                this.mapUnidadeTransporte.put(idTransporte, ut);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 015: " + ex.getMessage());
        }
    }

    protected void dadosLacresCarga(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 016 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                int idCarga = Integer.parseInt(scanner.next());
                UnidadeCarga uc = this.mapUnidadeCarga.get(idCarga);
                uc.setLacres(new Lacres());
                uc.getLacres().getNrLacre().add(scanner.next());
                this.mapUnidadeCarga.put(idCarga, uc);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 016: " + ex.getMessage());
        }
    }

    protected void dadosProdutoPerigoso(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 7) {
                throw new ParseException("A linha 017 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 7 campos.");
            }
            while (scanner.hasNext()) {
                String quantidadeVolume;
                String quantidadeTotal;
                String grupoEmbalagem;
                String classeRisco;
                String nomeApropriado;
                String numeroOnu;
                ProdutoPerigoso produtoPerigoso;
                scanner.next();
                int idDocumento = Integer.parseInt(scanner.next());
                Object objDoc = this.mapDocumento.get(idDocumento);
                if (objDoc instanceof DocumentoCTe) {
                    DocumentoCTe docCte = (DocumentoCTe)objDoc;
                    produtoPerigoso = new ProdutoPerigoso();
                    numeroOnu = scanner.next();
                    nomeApropriado = scanner.next();
                    classeRisco = scanner.next();
                    grupoEmbalagem = scanner.next();
                    quantidadeTotal = scanner.next();
                    quantidadeVolume = scanner.next();
                    produtoPerigoso.setNumeroOnu(numeroOnu);
                    if (nomeApropriado != null && !nomeApropriado.isEmpty()) {
                        produtoPerigoso.setNomeApropriado(nomeApropriado);
                    }
                    if (classeRisco != null && !classeRisco.isEmpty()) {
                        produtoPerigoso.setClasseRisco(classeRisco);
                    }
                    if (grupoEmbalagem != null && !grupoEmbalagem.isEmpty()) {
                        produtoPerigoso.setGrupoEmbalagem(grupoEmbalagem);
                    }
                    if (quantidadeTotal != null && !quantidadeTotal.isEmpty()) {
                        produtoPerigoso.setQuantidadeTotal(quantidadeTotal);
                    }
                    if (quantidadeVolume != null && !quantidadeVolume.isEmpty()) {
                        produtoPerigoso.setQuantidadeVolume(quantidadeVolume);
                    }
                    docCte.getProdutoPerigoso().add(produtoPerigoso);
                    this.mapDocumento.put(idDocumento, docCte);
                    continue;
                }
                if (!(objDoc instanceof DocumentoNFe)) continue;
                DocumentoNFe docNfe = (DocumentoNFe)objDoc;
                produtoPerigoso = new ProdutoPerigoso();
                numeroOnu = scanner.next();
                nomeApropriado = scanner.next();
                classeRisco = scanner.next();
                grupoEmbalagem = scanner.next();
                quantidadeTotal = scanner.next();
                quantidadeVolume = scanner.next();
                produtoPerigoso.setNumeroOnu(numeroOnu);
                if (nomeApropriado != null && !nomeApropriado.isEmpty()) {
                    produtoPerigoso.setNomeApropriado(nomeApropriado);
                }
                if (classeRisco != null && !classeRisco.isEmpty()) {
                    produtoPerigoso.setClasseRisco(classeRisco);
                }
                if (grupoEmbalagem != null && !grupoEmbalagem.isEmpty()) {
                    produtoPerigoso.setGrupoEmbalagem(grupoEmbalagem);
                }
                if (quantidadeTotal != null && !quantidadeTotal.isEmpty()) {
                    produtoPerigoso.setQuantidadeTotal(quantidadeTotal);
                }
                if (quantidadeVolume != null && !quantidadeVolume.isEmpty()) {
                    produtoPerigoso.setQuantidadeVolume(quantidadeVolume);
                }
                docNfe.getProdutoPerigoso().add(produtoPerigoso);
                this.mapDocumento.put(idDocumento, docNfe);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 017: " + ex.getMessage());
        }
    }

    protected void dadosSeguro(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 6) {
                throw new ParseException("A linha 018 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 6 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                Seguro seguro = new Seguro();
                int id = Integer.parseInt(scanner.next());
                String responsavel = scanner.next();
                String cnpjCpf = scanner.next();
                String nomeSeguradora = scanner.next();
                String cnpjSeguradora = scanner.next();
                String numeroApolice = scanner.next();
                seguro.setResponsavelSeguro(responsavel);
                seguro.setCnpjCpf(cnpjCpf);
                if (nomeSeguradora != null && !nomeSeguradora.trim().isEmpty()) {
                    seguro.setNomeSeguradora(nomeSeguradora);
                }
                if (cnpjSeguradora != null && !cnpjSeguradora.trim().isEmpty()) {
                    seguro.setCnpjSeguradora(cnpjSeguradora);
                }
                if (numeroApolice != null && !numeroApolice.trim().isEmpty()) {
                    seguro.setNumeroApolice(numeroApolice);
                }
                this.obj.getSeguro().add(seguro);
                this.mapSeguro.put(id, seguro);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 018: " + ex.getMessage());
        }
    }

    protected void dadosAverbacaoSeguro(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 019 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                int idSeguro = Integer.parseInt(scanner.next());
                Seguro seguro = this.mapSeguro.get(idSeguro);
                if (seguro == null) {
                    throw new ParseException("Identificador de seguro informado na linha 019 n\u00e3o localizado.");
                }
                seguro.getNumeroAverbacao().add(scanner.next());
                this.mapSeguro.put(idSeguro, seguro);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 019: " + ex.getMessage());
        }
    }

    protected void dadosAutorizacaoXML(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 020 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.setPermitidos(new Permitidos());
                this.obj.getPermitidos().getCnpjCpf().add(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 020: " + ex.getMessage());
        }
    }

    protected void dadosPercurso(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 021 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campos.");
            }
            if (this.obj.getInfoPercurso() == null) {
                this.obj.setInfoPercurso(new InfoPercurso());
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.getInfoPercurso().getUf().add(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 021: " + ex.getMessage());
        }
    }

    protected void dadosInfoContribuinte(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 022 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (scanner.hasNext()) {
                InfoContribuinte info = new InfoContribuinte();
                scanner.next();
                info.setCampo(scanner.next());
                info.setDescricao(scanner.next());
                this.obj.getInfoAdicional().getInfoCpl().add(info);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 022: " + ex.getMessage());
        }
    }
}

