/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.mdfe.v2;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.mdfe.v2.ParseTXTEnvioMDFEv202;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.envio.InfoCIOT;
import br.com.ophos.xml.mdfe.envio.InfoModal;
import br.com.ophos.xml.mdfe.envio.Rodoviario;

public class ParseTXTEnvioMDFEv203
extends ParseTXTEnvioMDFEv202 {
    private static ParseTXTEnvioMDFEv203 instance;

    public static ParseTXTEnvioMDFEv203 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioMDFEv203();
        }
        return instance;
    }

    @Override
    protected void lerLinhaManifesto(String linha) throws ParseException {
        Integer id = Integer.parseInt(linha.substring(1, 3));
        switch (id) {
            case 0: {
                this.dadosManifesto(linha);
                break;
            }
            case 1: {
                this.dadosEmitente(linha);
                break;
            }
            case 2: {
                this.dadosRodoviario(linha);
                break;
            }
            case 3: {
                this.dadosVeiculo(linha);
                break;
            }
            case 4: {
                this.dadosReboque(linha);
                break;
            }
            case 5: {
                this.dadosValePedagio(linha);
                break;
            }
            case 6: {
                this.dadosMotorista(linha);
                break;
            }
            case 7: {
                this.dadosLacreRodoviario(linha);
                break;
            }
            case 8: {
                this.dadosContratanteRodoviario(linha);
                break;
            }
            case 9: {
                this.dadosCarregamento(linha);
                break;
            }
            case 10: {
                this.dadosDescarregamento(linha);
                break;
            }
            case 11: {
                this.dadosDocumentos(linha);
                break;
            }
            case 12: {
                this.dadosLacres(linha);
                break;
            }
            case 13: {
                this.dadosUnidadesTransporte(linha);
                break;
            }
            case 14: {
                this.dadosUnidadesCarga(linha);
                break;
            }
            case 15: {
                this.dadosLacresTransporte(linha);
                break;
            }
            case 16: {
                this.dadosLacresCarga(linha);
                break;
            }
            case 17: {
                this.dadosProdutoPerigoso(linha);
                break;
            }
            case 18: {
                this.dadosSeguro(linha);
                break;
            }
            case 19: {
                this.dadosAverbacaoSeguro(linha);
                break;
            }
            case 20: {
                this.dadosAutorizacaoXML(linha);
                break;
            }
            case 21: {
                this.dadosPercurso(linha);
                break;
            }
            case 22: {
                this.dadosInfoContribuinte(linha);
                break;
            }
            case 23: {
                this.dadosCiot(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + id + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    @Override
    protected void dadosRodoviario(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getModal() == null) {
                    this.obj.setModal(new InfoModal());
                    this.obj.getModal().setRodoviario(new Rodoviario());
                }
                String rntrc = scanner.next();
                String codigoAgendamento = scanner.next();
                if (rntrc != null && !rntrc.trim().isEmpty()) {
                    this.obj.getModal().getRodoviario().setRntrc(rntrc);
                }
                if (codigoAgendamento == null || codigoAgendamento.trim().isEmpty()) continue;
                this.obj.getModal().getRodoviario().setCodAgenPorto(codigoAgendamento);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    protected void dadosCiot(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 023 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getModal() == null) {
                    this.obj.setModal(new InfoModal());
                    this.obj.getModal().setRodoviario(new Rodoviario());
                }
                InfoCIOT info = new InfoCIOT();
                info.setCiot(scanner.next());
                info.setCnpjCpf(scanner.next());
                this.obj.getModal().getRodoviario().getInfoCiot().add(info);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 023: " + ex.getMessage());
        }
    }
}

