/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.mdfe.v2;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.mdfe.v2.ParseTXTEnvioMDFEv206;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.envio.InfoPagamento;
import br.com.ophos.xml.mdfe.envio.ValePedagio;

public class ParseTXTEnvioMDFEv207
extends ParseTXTEnvioMDFEv206 {
    private static ParseTXTEnvioMDFEv207 instance;

    public static ParseTXTEnvioMDFEv207 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioMDFEv207();
        }
        return instance;
    }

    @Override
    protected void lerLinhaManifesto(String linha) throws ParseException {
        Integer id = Integer.parseInt(linha.substring(1, 3));
        switch (id) {
            case 0: {
                this.dadosManifesto(linha);
                break;
            }
            case 1: {
                this.dadosEmitente(linha);
                break;
            }
            case 2: {
                this.dadosRodoviario(linha);
                break;
            }
            case 3: {
                this.dadosVeiculo(linha);
                break;
            }
            case 4: {
                this.dadosReboque(linha);
                break;
            }
            case 5: {
                this.dadosValePedagio(linha);
                break;
            }
            case 6: {
                this.dadosMotorista(linha);
                break;
            }
            case 7: {
                this.dadosLacreRodoviario(linha);
                break;
            }
            case 8: {
                this.dadosContratanteRodoviario(linha);
                break;
            }
            case 9: {
                this.dadosCarregamento(linha);
                break;
            }
            case 10: {
                this.dadosDescarregamento(linha);
                break;
            }
            case 11: {
                this.dadosDocumentos(linha);
                break;
            }
            case 12: {
                this.dadosLacres(linha);
                break;
            }
            case 13: {
                this.dadosUnidadesTransporte(linha);
                break;
            }
            case 14: {
                this.dadosUnidadesCarga(linha);
                break;
            }
            case 15: {
                this.dadosLacresTransporte(linha);
                break;
            }
            case 16: {
                this.dadosLacresCarga(linha);
                break;
            }
            case 17: {
                this.dadosProdutoPerigoso(linha);
                break;
            }
            case 18: {
                this.dadosSeguro(linha);
                break;
            }
            case 19: {
                this.dadosAverbacaoSeguro(linha);
                break;
            }
            case 20: {
                this.dadosAutorizacaoXML(linha);
                break;
            }
            case 21: {
                this.dadosPercurso(linha);
                break;
            }
            case 22: {
                this.dadosInfoContribuinte(linha);
                break;
            }
            case 23: {
                this.dadosCiot(linha);
                break;
            }
            case 24: {
                this.dadosLocalizacao(linha);
                break;
            }
            case 25: {
                this.dadosPagamento(linha);
                break;
            }
            case 26: {
                this.dadosComponenteFrete(linha);
                break;
            }
            case 27: {
                this.dadosParcelaFrete(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + id + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    @Override
    protected void dadosValePedagio(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 5) {
                throw new ParseException("A linha 005 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 5 campos.");
            }
            while (scanner.hasNext()) {
                ValePedagio vale = new ValePedagio();
                scanner.next();
                vale.setCnpjFornecedor(scanner.next());
                vale.setCnpjRespPgto(scanner.next());
                vale.setNrComprovante(scanner.next());
                vale.setValor(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                vale.setTipo(scanner.next());
                this.obj.getModal().getRodoviario().getValePedagio().add(vale);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 005: " + ex.getMessage());
        }
    }

    @Override
    protected void dadosPagamento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 11) {
                throw new ParseException("A linha 025 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 11 campo.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                InfoPagamento pag = new InfoPagamento();
                pag.setId(scanner.next());
                pag.setCnpjCpf(scanner.next());
                pag.setNome(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.setValorContrato(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                String altoDesempenho = scanner.next();
                String valorAdian = scanner.next();
                if (altoDesempenho != null) {
                    pag.setAltoDesempenho(altoDesempenho);
                }
                if (valorAdian != null) {
                    pag.setValorAdiantamento(Util.StringToDouble(valorAdian, Util.ST_FMT_DOIS_DECIMAIS));
                }
                pag.setFormaPagamento(scanner.next());
                pag.setBanco(new InfoPagamento.InfoBanco());
                pag.getBanco().setBanco(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.getBanco().setAgencia(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.getBanco().setCnpjIpef(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.getBanco().setPix(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                this.obj.getModal().getRodoviario().getInfoPagamento().add(pag);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 025: " + ex.getMessage());
        }
    }
}

