/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.nfse.v1;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.nfse.v1.ParseTXTEnvioNFSEV101;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.nfse.envio.v100.Intermediario;
import br.com.ophos.xml.nfse.envio.v100.Tomador;
import br.com.ophos.xml.nfse.envio.v100.Totais;

public class ParseTXTEnvioNFSEV102
extends ParseTXTEnvioNFSEV101 {
    private static ParseTXTEnvioNFSEV102 instance;

    public static ParseTXTEnvioNFSEV102 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioNFSEV102();
        }
        return instance;
    }

    @Override
    protected void dadosTomador(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 15;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getTomador() == null) {
                    this.obj.setTomador(new Tomador());
                }
                String cpfCnpj = scanner.next();
                String inscricaoMunicipal = scanner.next();
                String nome = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String municipio = scanner.next();
                String numeroIBGE = scanner.next();
                String uf = scanner.next();
                String cep = scanner.next();
                String telefone = scanner.next();
                String email = scanner.next();
                String tipoLogradouro = scanner.next();
                String inscricaoEstadual = scanner.next();
                this.obj.getTomador().setCpfCnpj(cpfCnpj);
                if (inscricaoMunicipal != null && !inscricaoMunicipal.trim().isEmpty()) {
                    this.obj.getTomador().setInscricaoMunicipal(inscricaoMunicipal);
                }
                this.obj.getTomador().setNome(nome);
                this.obj.getTomador().setLogradouro(logradouro);
                this.obj.getTomador().setNumero(numero);
                if (complemento != null && !complemento.trim().isEmpty()) {
                    this.obj.getTomador().setComplemento(complemento);
                }
                this.obj.getTomador().setBairro(bairro);
                this.obj.getTomador().setMunicipio(municipio);
                this.obj.getTomador().setNrIbgeMunicipio(numeroIBGE);
                this.obj.getTomador().setUf(uf);
                this.obj.getTomador().setCep(cep);
                if (telefone != null && !telefone.trim().isEmpty()) {
                    this.obj.getTomador().setTelefone(telefone);
                }
                if (email != null && !email.trim().isEmpty()) {
                    this.obj.getTomador().setEmail(email);
                }
                if (tipoLogradouro != null && !tipoLogradouro.trim().isEmpty()) {
                    this.obj.getTomador().setTipoLogradouro(tipoLogradouro);
                }
                if (inscricaoEstadual == null || inscricaoEstadual.trim().isEmpty()) continue;
                this.obj.getTomador().setInscricaoEstadual(inscricaoEstadual);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    @Override
    protected void dadosTotais(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 19;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getTotais() == null) {
                    this.obj.setTotais(new Totais());
                }
                this.obj.getTotais().setValorServicos(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorDeducoes(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorPis(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorCofins(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorInss(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorIr(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorCsll(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setIssRetido(Util.StringToInteger(scanner.next()));
                this.obj.getTotais().setValorIss(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorIssRetido(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setOutrasRetencoes(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setBaseCalculo(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setAliquota(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorLiquidoNfse(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setDescontoIncondicionado(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setDescontoCondicionado(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorTributacao(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setPercentualTributacao(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                String fonteTributacao = scanner.next();
                if (fonteTributacao == null || fonteTributacao.trim().isEmpty()) continue;
                this.obj.getTotais().setFonteTributacao(fonteTributacao);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 004: " + ex.getMessage());
        }
    }

    @Override
    protected void dadosIntermediario(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 4;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 005 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getIntermediario() == null) {
                    this.obj.setIntermediario(new Intermediario());
                }
                String cpfCnpj = scanner.next();
                String inscricaoMunicipal = scanner.next();
                String issRetido = scanner.next();
                String email = scanner.next();
                this.obj.getIntermediario().setCpfCnpj(cpfCnpj);
                if (inscricaoMunicipal != null && !inscricaoMunicipal.trim().isEmpty()) {
                    this.obj.getIntermediario().setInscricaoMunicipal(inscricaoMunicipal);
                }
                this.obj.getIntermediario().setIssRetido(Util.StringToInteger(issRetido));
                if (email == null || email.trim().isEmpty()) continue;
                this.obj.getIntermediario().setEmail(email);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 005: " + ex.getMessage());
        }
    }
}

