/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.nfse.v1;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.nfse.v1.ParseTXTEnvioNFSEV102;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.nfse.envio.v100.Totais;

public class ParseTXTEnvioNFSEV103
extends ParseTXTEnvioNFSEV102 {
    private static ParseTXTEnvioNFSEV103 instance;

    public static ParseTXTEnvioNFSEV103 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioNFSEV103();
        }
        return instance;
    }

    @Override
    protected void dadosTotais(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 26;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getTotais() == null) {
                    this.obj.setTotais(new Totais());
                }
                this.obj.getTotais().setValorServicos(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorDeducoes(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setAliquotaPis(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorPis(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setAliquotaCofins(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorCofins(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setAliquotaInss(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorInss(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setAliquotaIr(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorIr(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setAliquotaCsll(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorCsll(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setIssRetido(Util.StringToInteger(scanner.next()));
                this.obj.getTotais().setValorIss(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorIssRetido(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setOutrasRetencoes(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setBaseCalculo(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setAliquota(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorLiquidoNfse(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setDescontoIncondicionado(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setDescontoCondicionado(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorTributacao(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setPercentualTributacao(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                String fonteTributacao = scanner.next();
                if (fonteTributacao != null && !fonteTributacao.trim().isEmpty()) {
                    this.obj.getTotais().setFonteTributacao(fonteTributacao);
                }
                this.obj.getTotais().setAliquotaSimples(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                String descricaoDeducao = scanner.next();
                if (descricaoDeducao == null || descricaoDeducao.trim().isEmpty()) continue;
                this.obj.getTotais().setDescricaoDeducao(descricaoDeducao);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 004: " + ex.getMessage());
        }
    }
}

