/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.nfse.v1;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.nfse.v1.ParseTXTEnvioNFSEV103;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.nfse.envio.v100.CondicaoPagamento;
import br.com.ophos.xml.nfse.envio.v100.Intermediario;
import br.com.ophos.xml.nfse.envio.v100.RpsSubstituido;

public class ParseTXTEnvioNFSEV104
extends ParseTXTEnvioNFSEV103 {
    private static ParseTXTEnvioNFSEV104 instance;

    public static ParseTXTEnvioNFSEV104 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioNFSEV104();
        }
        return instance;
    }

    @Override
    protected void dadosRps(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 10;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 000 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.setNumero(Integer.parseInt(scanner.next()));
                this.obj.setSerie(scanner.next());
                this.obj.setTipo(Integer.parseInt(scanner.next()));
                this.obj.setDataEmissao(Util.StringToDateTime(scanner.next()));
                this.obj.setNaturezaOperacao(Integer.parseInt(scanner.next()));
                this.obj.setSituacao(Integer.parseInt(scanner.next()));
                this.obj.setOutrasInformacoes(scanner.next());
                String nrRpsSubstituto = scanner.next();
                String serieRpsSubstituto = scanner.next();
                String tipoRpsSubstituto = scanner.next();
                if (nrRpsSubstituto == null || nrRpsSubstituto.trim().isEmpty()) continue;
                this.obj.setSubstituicao(new RpsSubstituido());
                this.obj.getSubstituicao().setRps(Long.parseLong(nrRpsSubstituto));
                this.obj.getSubstituicao().setSerie(serieRpsSubstituto);
                this.obj.getSubstituicao().setTipo(Integer.parseInt(tipoRpsSubstituto));
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 000: " + ex.getMessage());
        }
    }

    @Override
    protected void dadosIntermediario(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 5;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 005 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getIntermediario() == null) {
                    this.obj.setIntermediario(new Intermediario());
                }
                String razaoSocial = scanner.next();
                String cpfCnpj = scanner.next();
                String inscricaoMunicipal = scanner.next();
                String issRetido = scanner.next();
                String email = scanner.next();
                this.obj.getIntermediario().setRazaoSocial(razaoSocial);
                this.obj.getIntermediario().setCpfCnpj(cpfCnpj);
                if (inscricaoMunicipal != null && !inscricaoMunicipal.trim().isEmpty()) {
                    this.obj.getIntermediario().setInscricaoMunicipal(inscricaoMunicipal);
                }
                this.obj.getIntermediario().setIssRetido(Util.StringToInteger(issRetido));
                if (email == null || email.trim().isEmpty()) continue;
                this.obj.getIntermediario().setEmail(email);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 005: " + ex.getMessage());
        }
    }

    @Override
    protected void dadosCondicaoPagamento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 5;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 006 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                String tipo = scanner.next();
                String nrParcela = scanner.next();
                String qtdParcela = scanner.next();
                String vencimento = scanner.next();
                String valor = scanner.next();
                CondicaoPagamento condicaoPagamento = new CondicaoPagamento();
                condicaoPagamento.setTipo(Integer.parseInt(tipo));
                condicaoPagamento.setNrParcela(Integer.parseInt(nrParcela));
                condicaoPagamento.setQuantidadeParcelas(Integer.parseInt(qtdParcela));
                condicaoPagamento.setVencimento(Util.StringToDateTime(vencimento));
                condicaoPagamento.setValor(Util.StringToDouble(valor, Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getCondicaoPagamento().add(condicaoPagamento);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 006: " + ex.getMessage());
        }
    }
}

