/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.nfse.v1;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.ParseException2;
import br.com.ophos.parse.txt.nfse.factory.ParseTXTEnvioNFSEFactory;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.nfse.envio.v100.Prestador;
import br.com.ophos.xml.nfse.envio.v100.Rps;
import br.com.ophos.xml.nfse.envio.v100.Servico;
import br.com.ophos.xml.nfse.envio.v100.Tomador;
import br.com.ophos.xml.nfse.envio.v100.Totais;
import java.io.InputStream;
import java.util.ArrayList;

public class ParseTXTEnvioNFSEv100
extends ParseTXTEnvioNFSEFactory {
    private static ParseTXTEnvioNFSEv100 instance;
    protected Rps obj = null;

    public static ParseTXTEnvioNFSEv100 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioNFSEv100();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rps parse(InputStream is) throws ParseException2 {
        this.obj = new Rps();
        try (Scanner scanner = null;){
            ArrayList<Integer> linhasObrigatorias = new ArrayList<Integer>();
            linhasObrigatorias.add(0);
            linhasObrigatorias.add(1);
            linhasObrigatorias.add(2);
            linhasObrigatorias.add(3);
            linhasObrigatorias.add(4);
            ArrayList<Integer> linhasErro = new ArrayList<Integer>();
            ArrayList<Integer> linhasEncontradas = new ArrayList<Integer>();
            scanner = new Scanner(is);
            scanner.next();
            while (scanner.hasNextLine()) {
                String linha = null;
                linha = scanner.nextLine();
                if (linha.length() < 3) continue;
                Integer ID = Integer.parseInt(linha.substring(1, 3));
                linhasEncontradas.add(ID);
                try {
                    this.lerLinhaRps(linha + "|");
                }
                catch (ParseException parseException) {
                    linhasErro.add(ID);
                }
            }
            Object msgException = "";
            for (Object e : linhasErro) {
                msgException = (String)msgException + e;
            }
            if (linhasErro.size() > 0) {
                throw new ParseException2("ERRO_LAYOUT: " + (String)msgException, this.obj);
            }
            for (Object e : linhasObrigatorias) {
                Integer id = (Integer)e;
                if (linhasEncontradas.contains(id)) continue;
                throw new ParseException2("Linha obrigat\u00f3ria: " + e.toString() + " n\u00e3o encontrada no arquivo texto.");
            }
        }
        return this.obj;
    }

    private void lerLinhaRps(String linha) throws ParseException {
        Integer ID = Integer.parseInt(linha.substring(1, 3));
        switch (ID) {
            case 0: {
                this.dadosRps(linha);
                break;
            }
            case 1: {
                this.dadosPrestador(linha);
                break;
            }
            case 2: {
                this.dadosTomador(linha);
                break;
            }
            case 3: {
                this.dadosServico(linha);
                break;
            }
            case 4: {
                this.dadosTotais(linha);
                break;
            }
            case 5: {
                this.dadosIntermediario(linha);
                break;
            }
            case 6: {
                this.dadosCondicaoPagamento(linha);
                break;
            }
            case 7: {
                this.dadosConstrucaoCivil(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + ID + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    protected void dadosRps(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 6;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 000 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                this.obj.setNumero(Integer.parseInt(scanner.next()));
                this.obj.setSerie(scanner.next());
                this.obj.setTipo(Integer.parseInt(scanner.next()));
                this.obj.setDataEmissao(Util.StringToDateTime(scanner.next()));
                this.obj.setNaturezaOperacao(Integer.parseInt(scanner.next()));
                this.obj.setSituacao(Integer.parseInt(scanner.next()));
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 000: " + ex.getMessage());
        }
    }

    protected void dadosPrestador(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 5;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getPrestador() == null) {
                    this.obj.setPrestador(new Prestador());
                }
                this.obj.getPrestador().setCnpj(scanner.next());
                this.obj.getPrestador().setInscricaoMunicipal(scanner.next());
                this.obj.getPrestador().setRegimeEspecial(Integer.parseInt(scanner.next()));
                this.obj.getPrestador().setOptanteSimplesNacional(Integer.parseInt(scanner.next()));
                this.obj.getPrestador().setIncentivadorCultural(Integer.parseInt(scanner.next()));
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 001: " + ex.getMessage());
        }
    }

    protected void dadosTomador(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 12;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getTomador() == null) {
                    this.obj.setTomador(new Tomador());
                }
                this.obj.getTomador().setCpfCnpj(scanner.next());
                this.obj.getTomador().setNome(scanner.next());
                this.obj.getTomador().setLogradouro(scanner.next());
                this.obj.getTomador().setNumero(scanner.next());
                this.obj.getTomador().setComplemento(scanner.next());
                this.obj.getTomador().setBairro(scanner.next());
                this.obj.getTomador().setMunicipio(scanner.next());
                this.obj.getTomador().setNrIbgeMunicipio(scanner.next());
                this.obj.getTomador().setUf(scanner.next());
                this.obj.getTomador().setCep(scanner.next());
                this.obj.getTomador().setTelefone(scanner.next());
                this.obj.getTomador().setEmail(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    protected void dadosServico(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 7;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 003 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getServico() == null) {
                    this.obj.setServico(new Servico());
                }
                this.obj.getServico().setCodigoServico(scanner.next());
                this.obj.getServico().setCodigoCnae(scanner.next());
                this.obj.getServico().setCodigoTributacaoMunicipio(scanner.next());
                this.obj.getServico().setDescricao(scanner.next());
                this.obj.getServico().setMunicipio(scanner.next());
                this.obj.getServico().setNrIbgeMunicipio(scanner.next());
                this.obj.getServico().setUf(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 003: " + ex.getMessage());
        }
    }

    protected void dadosTotais(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 15;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada + " campos.");
            }
            while (scanner.hasNext()) {
                scanner.next();
                if (this.obj.getTotais() == null) {
                    this.obj.setTotais(new Totais());
                }
                this.obj.getTotais().setValorServicos(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorDeducoes(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorPis(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorCofins(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorInss(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorIr(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorCsll(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setIssRetido(Util.StringToInteger(scanner.next()));
                this.obj.getTotais().setValorIss(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorIssRetido(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setOutrasRetencoes(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setBaseCalculo(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setAliquota(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorLiquidoNfse(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setDescontoIncondicionado(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 004: " + ex.getMessage());
        }
    }

    protected void dadosIntermediario(String linha) throws ParseException {
        throw new ParseException("Ocorreu um erro ao ler a linha ID = 005. Informar a vers\u00e3o do TXT: {1.02}");
    }

    protected void dadosCondicaoPagamento(String linha) throws ParseException {
        throw new ParseException("Ocorreu um erro ao ler a linha ID = 006. Informar a vers\u00e3o do TXT: {1.04}");
    }

    protected void dadosConstrucaoCivil(String linha) throws ParseException {
        throw new ParseException("Ocorreu um erro ao ler a linha ID = 007. Informar a vers\u00e3o do TXT: {1.05}");
    }
}

