/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.xml.cte.v4;

import br.com.ophos.enumerations.SituacaoTributariaIBSCBS;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Aereo;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Aquaviario;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Balsa;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTe;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTeAnulacao;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTeComplemento;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTeNormal;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTeSubstituto;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ComponentePrestacao;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Destinatario;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoCTe;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoDCe;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoNF;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoNFe;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoOutro;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoPapel;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Duplicata;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Emitente;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.EmitenteDocAnterior;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Entrega;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.EscolhaSN;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Expedidor;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Fatura;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.FluxoCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.IBSCBS;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMS;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN00;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN20;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN40;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN41;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN51;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN60;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN90;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSOutraUF;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSSN;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSUFDestino;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Impostos;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.InfoContribuinte;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.InfoFisco;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.InformacaoAdicional;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.InformacaoCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Lacre;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ManuseioCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.MultiModal;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.NaturezaCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.OrdemColeta;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.PermissaoDownload;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.PontoPassagem;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ProdutoPerigosoAereo;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.QuantidadeCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Recebedor;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Remetente;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Rodoviario;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.SeguroMultimodal;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Tarifa;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.TipoConhecimento;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.TipoICMSTomador;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.TipoTomador;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Tomador;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.UnidadeCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.UnidadeProdutoPerigoso;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.UnidadeTransporte;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.VeiculoNovo;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalDateSerializer;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalDateTimeSerializer;
import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.xml.cte.factory.ParseXMLFactoryCTe;
import br.com.ophos.util.Util;
import br.com.ophos.xml.cte.v400.Aereo;
import br.com.ophos.xml.cte.v400.Aquav;
import br.com.ophos.xml.cte.v400.Multimodal;
import br.com.ophos.xml.cte.v400.Rodo;
import br.com.ophos.xml.cte.v400.TCIBS;
import br.com.ophos.xml.cte.v400.TCTe;
import br.com.ophos.xml.cte.v400.TDevTrib;
import br.com.ophos.xml.cte.v400.TRed;
import br.com.ophos.xml.cte.v400.TTribCTe;
import br.com.ophos.xml.cte.v400.TUnidCarga;
import br.com.ophos.xml.cte.v400.TUnidadeTransp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;

public class ParseXMLEnvioCTEv400
extends ParseXMLFactoryCTe {
    private CTe obj = null;
    private static ParseXMLEnvioCTEv400 instance;

    public ParseXMLEnvioCTEv400(String charQuebraLinha) {
    }

    public static ParseXMLEnvioCTEv400 getInstance(String charQuebraLinha) {
        if (instance == null) {
            instance = new ParseXMLEnvioCTEv400(charQuebraLinha);
        }
        return instance;
    }

    private InputStream GetInputStream(byte[] xml) {
        Object retorno = "";
        try {
            String arquivoXML = new String(xml);
            Integer inicio = arquivoXML.indexOf("<infCte ", 0);
            Integer fim = arquivoXML.indexOf("</infCte>", 0) + 9;
            retorno = "<CTe>" + arquivoXML.substring(inicio, fim) + "</CTe>";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ByteArrayInputStream(((String)retorno).getBytes());
    }

    private Double StringToDouble(String valor, int casasDecimais) throws ParseException {
        return br.com.ophos.util.cte.Util.StringToDouble(valor.replaceAll("\\.", ""), casasDecimais);
    }

    private XMLGregorianCalendar StringToDate(String valor) throws ParseException {
        return br.com.ophos.util.cte.Util.StringToDate(valor.replaceAll("-", "").replaceAll("T", "").replaceAll(":", ""));
    }

    @Override
    public CTe parse(JAXBContext ctx, byte[] xml) throws ParseException {
        InputStream in = this.GetInputStream(xml);
        try {
            this.obj = new CTe();
            this.obj.setInfoAdicional(new InformacaoAdicional());
            this.obj.getInfoAdicional().setFluxoCarga(new FluxoCarga());
            this.obj.setImpostos(new Impostos());
            this.obj.setInfoCte(new CTeNormal());
            this.obj.setTipo(TipoConhecimento.NORMAL);
            Unmarshaller um = ctx.createUnmarshaller();
            TCTe objXMLCTe = (TCTe)um.unmarshal(in);
            TCTe.InfCte objXML = objXMLCTe.getInfCte();
            if (objXMLCTe.getInfCte().getId().toLowerCase().startsWith("cte") && objXMLCTe.getInfCte().getId().length() == 47) {
                this.obj.setNrChaveAcesso(objXMLCTe.getInfCte().getId().substring(3, 47));
            }
            this.infoCTe(objXML.getIde());
            this.infoAdicional(objXML.getCompl());
            this.tomador(objXML);
            this.emitente(objXML.getEmit());
            this.obj.getEmitente().setNrUF(Short.valueOf(objXML.getIde().getCUF()));
            this.remetente(objXML.getRem());
            this.valores(objXML.getVPrest());
            this.imposto(objXML.getImp());
            if (objXML.getInfCTeNorm() != null) {
                if (objXML.getInfCTeNorm().getInfModal().getRodo() != null) {
                    this.modalRodoviario(objXML.getInfCTeNorm().getInfModal().getRodo());
                }
                if (objXML.getInfCTeNorm().getInfModal().getMulti() != null) {
                    this.modalMultiModal(objXML.getInfCTeNorm().getInfModal().getMulti());
                }
                if (objXML.getInfCTeNorm().getInfModal().getAquav() != null) {
                    this.modalAquaviario(objXML.getInfCTeNorm().getInfModal().getAquav());
                }
                if (objXML.getInfCTeNorm().getInfModal().getAereo() != null) {
                    this.modalAereo(objXML.getInfCTeNorm().getInfModal().getAereo());
                }
                this.infoCarga(objXML.getInfCTeNorm().getInfCarga());
                if (objXML.getInfCTeNorm().getInfCteSub() != null) {
                    this.substituicao(objXML.getInfCTeNorm().getInfCteSub());
                }
                if (objXML.getInfCTeNorm().getInfDoc() != null) {
                    if (objXML.getInfCTeNorm().getInfDoc().getInfNF() != null && !objXML.getInfCTeNorm().getInfDoc().getInfNF().isEmpty()) {
                        for (TCTe.InfCte.InfCTeNorm.InfDoc.InfNF infNF : objXML.getInfCTeNorm().getInfDoc().getInfNF()) {
                            this.docNF(infNF);
                        }
                    }
                    if (objXML.getInfCTeNorm().getInfDoc().getInfNFe() != null && !objXML.getInfCTeNorm().getInfDoc().getInfNFe().isEmpty()) {
                        for (TCTe.InfCte.InfCTeNorm.InfDoc.InfNFe infNFe : objXML.getInfCTeNorm().getInfDoc().getInfNFe()) {
                            this.docNFe(infNFe);
                        }
                    }
                    if (objXML.getInfCTeNorm().getInfDoc().getInfOutros() != null && !objXML.getInfCTeNorm().getInfDoc().getInfOutros().isEmpty()) {
                        for (TCTe.InfCte.InfCTeNorm.InfDoc.InfOutros infOutros : objXML.getInfCTeNorm().getInfDoc().getInfOutros()) {
                            this.docOutros(infOutros);
                        }
                    }
                    if (objXML.getInfCTeNorm().getInfDoc().getInfDCe() != null && !objXML.getInfCTeNorm().getInfDoc().getInfDCe().isEmpty()) {
                        for (TCTe.InfCte.InfCTeNorm.InfDoc.InfDCe infDCe : objXML.getInfCTeNorm().getInfDoc().getInfDCe()) {
                            this.docDCe(infDCe);
                        }
                    }
                }
                if (objXML.getInfCTeNorm().getDocAnt() != null) {
                    for (TCTe.InfCte.InfCTeNorm.DocAnt.EmiDocAnt emiDocAnt : objXML.getInfCTeNorm().getDocAnt().getEmiDocAnt()) {
                        this.emitenteAnterior(emiDocAnt);
                    }
                }
                if (objXML.getInfCTeNorm().getVeicNovos() != null && !objXML.getInfCTeNorm().getVeicNovos().isEmpty()) {
                    for (TCTe.InfCte.InfCTeNorm.VeicNovos veicNovos : objXML.getInfCTeNorm().getVeicNovos()) {
                        this.veiculoNovo(veicNovos);
                    }
                }
                if (objXML.getInfCTeNorm().getCobr() != null) {
                    if (objXML.getInfCTeNorm().getCobr().getFat() != null) {
                        this.cobranca(objXML.getInfCTeNorm().getCobr().getFat());
                    }
                    if (objXML.getInfCTeNorm().getCobr().getDup() != null && !objXML.getInfCTeNorm().getCobr().getDup().isEmpty()) {
                        for (TCTe.InfCte.InfCTeNorm.Cobr.Dup dup : objXML.getInfCTeNorm().getCobr().getDup()) {
                            this.duplicata(dup);
                        }
                    }
                }
                if (objXML.getInfCTeNorm().getInfGlobalizado() != null) {
                    this.informacoesCteGlobalizado(objXML);
                }
                if (objXML.getInfCTeNorm().getInfServVinc() != null) {
                    this.chaveAcessoVinculadaMultimodal(objXML);
                }
            }
            if (objXML.getExped() != null) {
                this.expedidor(objXML.getExped());
            }
            if (objXML.getReceb() != null) {
                this.recebedor(objXML.getReceb());
            }
            if (objXML.getDest() != null) {
                this.destinatario(objXML.getDest());
            }
            if (objXML.getInfCteComp() != null && !objXML.getInfCteComp().isEmpty()) {
                this.complemento(objXML.getInfCteComp());
            }
            if (objXML.getAutXML() != null) {
                this.obj.setPermitidos(new PermissaoDownload());
                for (TCTe.InfCte.AutXML autXML : objXML.getAutXML()) {
                    this.autorizacaoXML(autXML);
                }
            }
            in.close();
            return this.obj;
        }
        catch (ParseException | IOException | NumberFormatException | JAXBException ex) {
            try {
                in.close();
                throw new ParseException(ex.getMessage(), this.obj);
            }
            catch (IOException iOException) {
                if (ex.getCause() != null) {
                    throw new ParseException("Ocorreu um erro ao fazer o bind do XML para o OBJ CTe " + ex.getMessage() + ex.getCause().getMessage());
                }
                throw new ParseException("Ocorreu um erro ao fazer o bind do XML para o OBJ CTe " + ex.getMessage());
            }
        }
    }

    private void infoCTe(TCTe.InfCte.Ide objXML) throws ParseException {
        try {
            if (objXML.getCDV() != null && !objXML.getCDV().isEmpty()) {
                this.obj.setDigitoVerificador(Short.valueOf(objXML.getCDV()));
            }
            if (objXML.getCCT() != null && !objXML.getCCT().isEmpty()) {
                this.obj.setNrAleatorio(objXML.getCCT());
            }
            this.obj.setCfop(br.com.ophos.util.cte.Util.StringToShort(objXML.getCFOP()));
            this.obj.setNaturezaOperacao(objXML.getNatOp());
            this.obj.setSerie(br.com.ophos.util.cte.Util.StringToShort(objXML.getSerie()));
            this.obj.setNumero(br.com.ophos.util.cte.Util.StringToInteger(objXML.getNCT()));
            this.obj.setDataEmissao(LocalDateTimeSerializer.parseDateTimeXML(objXML.getDhEmi()));
            if ("1".equals(objXML.getIndGlobalizado())) {
                this.obj.setIndicadorGlobalizado(Boolean.TRUE);
            }
            this.obj.setTipo(br.com.ophos.util.cte.Util.valueToTipoConhecimento(objXML.getTpCTe()));
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                this.obj.setInfoCte(new CTeSubstituto());
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.ANULACAO_VALORES)) {
                this.obj.setInfoCte(new CTeAnulacao());
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.COMPLEMENTO_VALOR)) {
                this.obj.setInfoCte(new CTeComplemento());
            }
            this.obj.setNrMunicipioEmissao(br.com.ophos.util.cte.Util.StringToInteger(objXML.getCMunEnv()));
            this.obj.setMunicipioEmissao(objXML.getXMunEnv());
            this.obj.setUfEmissao(objXML.getUFEnv().value());
            this.obj.setTipoModal(br.com.ophos.util.cte.Util.valueToTipoModalSefaz(objXML.getModal()));
            this.obj.setTipoServico(br.com.ophos.util.cte.Util.valueToTipoServico(objXML.getTpServ()));
            this.obj.setNrMunicipioInicio(br.com.ophos.util.cte.Util.StringToInteger(objXML.getCMunIni()));
            this.obj.setMunicipioInicio(objXML.getXMunIni());
            this.obj.setUfInicio(objXML.getUFIni().value());
            this.obj.setNrMunicipioFim(br.com.ophos.util.cte.Util.StringToInteger(objXML.getCMunFim()));
            this.obj.setMunicipioFim(objXML.getXMunFim());
            this.obj.setUfFim(objXML.getUFFim().value());
            this.obj.setRetira(br.com.ophos.util.cte.Util.valueEscolhaSN(objXML.getRetira()));
            this.obj.setDetalheRetira(objXML.getXDetRetira());
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es b\u00e1sicas do Ct-e " + ex.getMessage());
        }
    }

    private void infoAdicional(TCTe.InfCte.Compl objXML) throws ParseException {
        try {
            this.obj.getInfoAdicional().setCaracteristicaTransporte(objXML.getXCaracAd());
            this.obj.getInfoAdicional().setCaracteristicaServico(objXML.getXCaracSer());
            this.obj.setUsuarioEmitente(objXML.getXEmi());
            if (objXML.getFluxo() != null) {
                this.obj.getInfoAdicional().getFluxoCarga().setOrigem(objXML.getFluxo().getXOrig());
                this.obj.getInfoAdicional().getFluxoCarga().setDestino(objXML.getFluxo().getXDest());
                this.obj.getInfoAdicional().getFluxoCarga().setRota(objXML.getFluxo().getXRota());
                if (objXML.getFluxo().getPass() != null) {
                    for (TCTe.InfCte.Compl.Fluxo.Pass pass : objXML.getFluxo().getPass()) {
                        PontoPassagem ponto = new PontoPassagem();
                        ponto.setIdentificacao(pass.getXPass());
                        this.obj.getInfoAdicional().getFluxoCarga().getPontoPassagem().add(ponto);
                    }
                }
            }
            this.obj.getInfoAdicional().setOrigemCalculo(objXML.getOrigCalc());
            this.obj.getInfoAdicional().setDestinoCalculo(objXML.getDestCalc());
            this.obj.setObservacao(objXML.getXObs());
            if (objXML.getObsCont() != null) {
                for (TCTe.InfCte.Compl.ObsCont obsCont : objXML.getObsCont()) {
                    this.infoContribuinte(obsCont);
                }
            }
            if (objXML.getObsFisco() != null) {
                for (TCTe.InfCte.Compl.ObsFisco obsFisco : objXML.getObsFisco()) {
                    this.infoFisco(obsFisco);
                }
            }
            if (objXML.getEntrega() != null) {
                String string;
                String string2;
                Entrega entrega = new Entrega();
                if (objXML.getEntrega().getSemData() != null && !(string2 = objXML.getEntrega().getSemData().getTpPer()).equals("")) {
                    entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoData(string2));
                }
                if (objXML.getEntrega().getComData() != null) {
                    String string3 = objXML.getEntrega().getComData().getTpPer();
                    String grp2Dprog = objXML.getEntrega().getComData().getDProg();
                    if (!grp2Dprog.equals("")) {
                        entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoHora(string3));
                    }
                }
                if (objXML.getEntrega().getNoPeriodo() != null) {
                    String string4 = objXML.getEntrega().getNoPeriodo().getTpPer();
                    objXML.getEntrega().getNoPeriodo().getDIni();
                    objXML.getEntrega().getNoPeriodo().getDFim();
                    if (!string4.equals("")) {
                        entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoData(string4));
                    }
                }
                if (objXML.getEntrega().getSemHora() != null && !(string = objXML.getEntrega().getSemHora().getTpHor()).equals("")) {
                    entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoHora(string));
                }
                if (objXML.getEntrega().getComHora() != null) {
                    String string5 = objXML.getEntrega().getComHora().getTpHor();
                    objXML.getEntrega().getComHora().getHProg();
                    if (!string5.equals("")) {
                        entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoHora(string5));
                    }
                }
                if (objXML.getEntrega().getNoInter() != null) {
                    String string6 = objXML.getEntrega().getNoInter().getTpHor();
                    objXML.getEntrega().getNoInter().getHIni();
                    objXML.getEntrega().getNoInter().getHFim();
                    if (!string6.equals("")) {
                        entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoHora(string6));
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es complementares do Ct-e " + ex.getMessage());
        }
    }

    private void infoContribuinte(TCTe.InfCte.Compl.ObsCont objXML) throws ParseException {
        try {
            InfoContribuinte info = new InfoContribuinte();
            info.setCampo(objXML.getXCampo());
            info.setDescricao(objXML.getXTexto());
            this.obj.getInfoAdicional().getCamposAdicionais().add(info);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es do Contribuinte do Ct-e " + ex.getMessage());
        }
    }

    private void infoFisco(TCTe.InfCte.Compl.ObsFisco objXML) throws ParseException {
        try {
            InfoFisco info = new InfoFisco();
            info.setCampo(objXML.getXCampo());
            info.setDescricao(objXML.getXTexto());
            this.obj.getInfoAdicional().getCamposAdicionais().add(info);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es do Contribuinte do Ct-e " + ex.getMessage());
        }
    }

    private void tomador(TCTe.InfCte objXML) throws ParseException {
        try {
            Tomador tomador = new Tomador();
            switch (objXML.getIde().getIndIEToma()) {
                case "1": {
                    tomador.setTipoIcmsTomador(TipoICMSTomador.CONTRIBUINTE);
                    break;
                }
                case "2": {
                    tomador.setTipoIcmsTomador(TipoICMSTomador.ISENTO);
                    break;
                }
                case "9": {
                    tomador.setTipoIcmsTomador(TipoICMSTomador.NAO_CONTRIBUINTE);
                }
            }
            if (objXML.getIde().getToma4() != null) {
                tomador.setTipo(TipoTomador.OUTROS);
                if (objXML.getIde().getToma4().getCNPJ() != null) {
                    tomador.setCnpjCpf(objXML.getIde().getToma4().getCNPJ());
                } else if (objXML.getIde().getToma4().getCPF() != null) {
                    tomador.setCnpjCpf(objXML.getIde().getToma4().getCPF());
                }
                tomador.setInscricaoEstadual(objXML.getIde().getToma4().getIE());
                tomador.setRazaoSocial(objXML.getIde().getToma4().getXNome());
                tomador.setNomeFantasia(objXML.getIde().getToma4().getXFant());
                tomador.setLogradouro(objXML.getIde().getToma4().getEnderToma().getXLgr());
                tomador.setNumero(objXML.getIde().getToma4().getEnderToma().getNro());
                tomador.setComplemento(objXML.getIde().getToma4().getEnderToma().getXCpl());
                tomador.setBairro(objXML.getIde().getToma4().getEnderToma().getXBairro());
                tomador.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(objXML.getIde().getToma4().getEnderToma().getCMun()));
                tomador.setMunicipio(objXML.getIde().getToma4().getEnderToma().getXMun());
                tomador.setCep(objXML.getIde().getToma4().getEnderToma().getCEP());
                tomador.setUf(objXML.getIde().getToma4().getEnderToma().getUF().value());
                tomador.setNrPais(br.com.ophos.util.cte.Util.StringToShort(objXML.getIde().getToma4().getEnderToma().getCPais()));
                tomador.setPais(objXML.getIde().getToma4().getEnderToma().getXPais());
                tomador.setEmail(objXML.getIde().getToma4().getEmail());
                tomador.setTelefone(objXML.getIde().getToma4().getFone());
                this.obj.setTomador(tomador);
            } else if (objXML.getIde().getToma3() != null) {
                switch (objXML.getIde().getToma3().getToma()) {
                    case "0": {
                        tomador.setTipo(TipoTomador.REMETENTE);
                        TCTe.InfCte.Rem objRem = objXML.getRem();
                        if (objRem.getCNPJ() != null) {
                            tomador.setCnpjCpf(objRem.getCNPJ());
                        } else if (objRem.getCPF() != null) {
                            tomador.setCnpjCpf(objRem.getCPF());
                        }
                        tomador.setInscricaoEstadual(objRem.getIE());
                        tomador.setRazaoSocial(objRem.getXNome());
                        tomador.setNomeFantasia(objRem.getXFant());
                        tomador.setLogradouro(objRem.getEnderReme().getXLgr());
                        tomador.setNumero(objRem.getEnderReme().getNro());
                        tomador.setComplemento(objRem.getEnderReme().getXCpl());
                        tomador.setBairro(objRem.getEnderReme().getXBairro());
                        tomador.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(objRem.getEnderReme().getCMun()));
                        tomador.setMunicipio(objRem.getEnderReme().getXMun());
                        tomador.setCep(objRem.getEnderReme().getCEP());
                        tomador.setUf(objRem.getEnderReme().getUF().value());
                        tomador.setNrPais(br.com.ophos.util.cte.Util.StringToShort(objRem.getEnderReme().getCPais()));
                        tomador.setPais(objRem.getEnderReme().getXPais());
                        tomador.setEmail(objRem.getEmail());
                        tomador.setTelefone(objRem.getFone());
                        this.obj.setTomador(tomador);
                        break;
                    }
                    case "1": {
                        tomador.setTipo(TipoTomador.EXPEDIDOR);
                        TCTe.InfCte.Exped objToma = objXML.getExped();
                        if (objToma.getCNPJ() != null) {
                            tomador.setCnpjCpf(objToma.getCNPJ());
                        } else if (objToma.getCPF() != null) {
                            tomador.setCnpjCpf(objToma.getCPF());
                        }
                        tomador.setInscricaoEstadual(objToma.getIE());
                        tomador.setRazaoSocial(objToma.getXNome());
                        tomador.setLogradouro(objToma.getEnderExped().getXLgr());
                        tomador.setNumero(objToma.getEnderExped().getNro());
                        tomador.setComplemento(objToma.getEnderExped().getXCpl());
                        tomador.setBairro(objToma.getEnderExped().getXBairro());
                        tomador.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(objToma.getEnderExped().getCMun()));
                        tomador.setMunicipio(objToma.getEnderExped().getXMun());
                        tomador.setCep(objToma.getEnderExped().getCEP());
                        tomador.setUf(objToma.getEnderExped().getUF().value());
                        tomador.setNrPais(br.com.ophos.util.cte.Util.StringToShort(objToma.getEnderExped().getCPais()));
                        tomador.setPais(objToma.getEnderExped().getXPais());
                        tomador.setEmail(objToma.getEmail());
                        tomador.setTelefone(objToma.getFone());
                        this.obj.setTomador(tomador);
                        break;
                    }
                    case "2": {
                        tomador.setTipo(TipoTomador.RECEBEDOR);
                        TCTe.InfCte.Receb objToma = objXML.getReceb();
                        if (objToma.getCNPJ() != null) {
                            tomador.setCnpjCpf(objToma.getCNPJ());
                        } else if (objToma.getCPF() != null) {
                            tomador.setCnpjCpf(objToma.getCPF());
                        }
                        tomador.setInscricaoEstadual(objToma.getIE());
                        tomador.setRazaoSocial(objToma.getXNome());
                        tomador.setLogradouro(objToma.getEnderReceb().getXLgr());
                        tomador.setNumero(objToma.getEnderReceb().getNro());
                        tomador.setComplemento(objToma.getEnderReceb().getXCpl());
                        tomador.setBairro(objToma.getEnderReceb().getXBairro());
                        tomador.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(objToma.getEnderReceb().getCMun()));
                        tomador.setMunicipio(objToma.getEnderReceb().getXMun());
                        tomador.setCep(objToma.getEnderReceb().getCEP());
                        tomador.setUf(objToma.getEnderReceb().getUF().value());
                        tomador.setNrPais(br.com.ophos.util.cte.Util.StringToShort(objToma.getEnderReceb().getCPais()));
                        tomador.setPais(objToma.getEnderReceb().getXPais());
                        tomador.setEmail(objToma.getEmail());
                        tomador.setTelefone(objToma.getFone());
                        this.obj.setTomador(tomador);
                        break;
                    }
                    case "3": {
                        tomador.setTipo(TipoTomador.DESTINATARIO);
                        TCTe.InfCte.Dest objToma = objXML.getDest();
                        if (objToma.getCNPJ() != null) {
                            tomador.setCnpjCpf(objToma.getCNPJ());
                        } else if (objToma.getCPF() != null) {
                            tomador.setCnpjCpf(objToma.getCPF());
                        }
                        tomador.setInscricaoEstadual(objToma.getIE());
                        tomador.setRazaoSocial(objToma.getXNome());
                        tomador.setLogradouro(objToma.getEnderDest().getXLgr());
                        tomador.setNumero(objToma.getEnderDest().getNro());
                        tomador.setComplemento(objToma.getEnderDest().getXCpl());
                        tomador.setBairro(objToma.getEnderDest().getXBairro());
                        tomador.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(objToma.getEnderDest().getCMun()));
                        tomador.setMunicipio(objToma.getEnderDest().getXMun());
                        tomador.setCep(objToma.getEnderDest().getCEP());
                        tomador.setUf(objToma.getEnderDest().getUF().value());
                        tomador.setNrPais(br.com.ophos.util.cte.Util.StringToShort(objToma.getEnderDest().getCPais()));
                        tomador.setPais(objToma.getEnderDest().getXPais());
                        tomador.setEmail(objToma.getEmail());
                        tomador.setTelefone(objToma.getFone());
                        this.obj.setTomador(tomador);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o tomador do Ct-e " + ex.getMessage());
        }
    }

    private void emitente(TCTe.InfCte.Emit objXML) throws ParseException {
        try {
            Emitente emitente = new Emitente();
            emitente.setCnpj(objXML.getCNPJ());
            emitente.setInscricaoEstadual(objXML.getIE());
            emitente.setInscricaoEstadualSt(objXML.getIEST());
            emitente.setRazaoSocial(objXML.getXNome());
            emitente.setFantasia(objXML.getXFant());
            emitente.setLogradouro(objXML.getEnderEmit().getXLgr());
            emitente.setNumero(objXML.getEnderEmit().getNro());
            emitente.setComplemento(objXML.getEnderEmit().getXCpl());
            emitente.setBairro(objXML.getEnderEmit().getXBairro());
            emitente.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(objXML.getEnderEmit().getCMun()));
            emitente.setMunicipio(objXML.getEnderEmit().getXMun());
            emitente.setCep(objXML.getEnderEmit().getCEP());
            emitente.setUf(objXML.getEnderEmit().getUF().value());
            emitente.setTelefone(objXML.getEnderEmit().getFone());
            this.obj.setEmitente(emitente);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o emitente do Ct-e " + ex.getMessage());
        }
    }

    private void remetente(TCTe.InfCte.Rem objXML) throws ParseException {
        try {
            Remetente remetente = new Remetente();
            if (objXML.getCNPJ() != null) {
                remetente.setCnpjCpf(objXML.getCNPJ());
            }
            if (objXML.getCPF() != null) {
                remetente.setCnpjCpf(objXML.getCPF());
            }
            remetente.setInscricaoEstadual(objXML.getIE());
            remetente.setRazaoSocial(objXML.getXNome());
            remetente.setNomeFantasia(objXML.getXFant());
            remetente.setLogradouro(objXML.getEnderReme().getXLgr());
            remetente.setNumero(objXML.getEnderReme().getNro());
            remetente.setComplemento(objXML.getEnderReme().getXCpl());
            remetente.setBairro(objXML.getEnderReme().getXBairro());
            remetente.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(objXML.getEnderReme().getCMun()));
            remetente.setMunicipio(objXML.getEnderReme().getXMun());
            remetente.setCep(objXML.getEnderReme().getCEP());
            remetente.setUf(objXML.getEnderReme().getUF().value());
            remetente.setNrPais(br.com.ophos.util.cte.Util.StringToShort(objXML.getEnderReme().getCPais()));
            remetente.setPais(objXML.getEnderReme().getXPais());
            remetente.setEmail(objXML.getEmail());
            remetente.setTelefone(objXML.getFone());
            this.obj.setRemetente(remetente);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o remetente do Ct-e " + ex.getMessage());
        }
    }

    private void valores(TCTe.InfCte.VPrest objXML) throws ParseException {
        try {
            this.obj.setValorTotalPrestacao(this.StringToDouble(objXML.getVTPrest(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            this.obj.setValorReceber(this.StringToDouble(objXML.getVRec(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            if (objXML.getComp() != null) {
                for (TCTe.InfCte.VPrest.Comp comp : objXML.getComp()) {
                    ComponentePrestacao compObj = new ComponentePrestacao();
                    compObj.setDescricao(comp.getXNome());
                    compObj.setValor(this.StringToDouble(comp.getVComp(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    this.obj.getComponentePrestacao().add(compObj);
                }
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler os valores do Ct-e " + ex.getMessage());
        }
    }

    private void imposto(TCTe.InfCte.Imp objXML) throws ParseException {
        try {
            String grpIndSN;
            String grp40situacaoTrib;
            this.obj.getImpostos().setObservacaoFisco(objXML.getInfAdFisco());
            ICMS icms = null;
            if (objXML.getICMS().getICMS00() != null) {
                String grp00vlBcIcms = objXML.getICMS().getICMS00().getVBC();
                String grp00vlAliqIcms = objXML.getICMS().getICMS00().getPICMS();
                String grp00vlIcms = objXML.getICMS().getICMS00().getVICMS();
                if (!grp00vlIcms.equals("")) {
                    icms = new ICMSN00();
                    icms.setValorBC(this.StringToDouble(grp00vlBcIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    icms.setAliquota(this.StringToDouble(grp00vlAliqIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    icms.setValor(this.StringToDouble(grp00vlIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                }
            }
            if (objXML.getICMS().getICMS20() != null) {
                String grp20vlRedBCIcms = objXML.getICMS().getICMS20().getPRedBC();
                String grp20vlBcIcms = objXML.getICMS().getICMS20().getVBC();
                String grp20vlAliqIcms = objXML.getICMS().getICMS20().getPICMS();
                String grp20vlIcms = objXML.getICMS().getICMS20().getVICMS();
                String grgrp20vlIcmsDesen = objXML.getICMS().getICMS20().getVICMSDeson();
                String grgrp20CodBenef = objXML.getICMS().getICMS20().getCBenef();
                if (!grp20vlIcms.equals("")) {
                    icms = new ICMSN20();
                    ((ICMSN20)icms).setReducaoBC(this.StringToDouble(grp20vlRedBCIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN20)icms).setValorBC(this.StringToDouble(grp20vlBcIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN20)icms).setAliquota(this.StringToDouble(grp20vlAliqIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN20)icms).setValor(this.StringToDouble(grp20vlIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN20)icms).setValorDesonerado(this.StringToDouble(grgrp20vlIcmsDesen, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN20)icms).setCodigoBeneficio(grgrp20CodBenef);
                }
            }
            if (objXML.getICMS().getICMS45() != null && !(grp40situacaoTrib = objXML.getICMS().getICMS45().getCST()).equals("")) {
                if (grp40situacaoTrib.equals("40")) {
                    icms = new ICMSN40();
                    ((ICMSN40)icms).setValorDesonerado(this.StringToDouble(objXML.getICMS().getICMS45().getVICMSDeson(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN40)icms).setCodigoBeneficio(objXML.getICMS().getICMS45().getCBenef());
                }
                if (grp40situacaoTrib.equals("41")) {
                    icms = new ICMSN41();
                    ((ICMSN41)icms).setValorDesonerado(this.StringToDouble(objXML.getICMS().getICMS45().getVICMSDeson(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN41)icms).setCodigoBeneficio(objXML.getICMS().getICMS45().getCBenef());
                }
                if (grp40situacaoTrib.equals("51")) {
                    icms = new ICMSN51();
                    ((ICMSN51)icms).setValorDesonerado(this.StringToDouble(objXML.getICMS().getICMS45().getVICMSDeson(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN51)icms).setCodigoBeneficio(objXML.getICMS().getICMS45().getCBenef());
                }
            }
            if (objXML.getICMS().getICMS60() != null) {
                String grp60vlBcRetIcms = objXML.getICMS().getICMS60().getVBCSTRet();
                String grp60vlRetIcms = objXML.getICMS().getICMS60().getVICMSSTRet();
                String grp60vlAliqRetIcms = objXML.getICMS().getICMS60().getPICMSSTRet();
                String grp60vlCredRetIcms = objXML.getICMS().getICMS60().getVCred();
                String grp60vlIcmsDeson = objXML.getICMS().getICMS60().getVICMSDeson();
                String grp60CodBenef = objXML.getICMS().getICMS60().getCBenef();
                if (!grp60vlRetIcms.equals("")) {
                    icms = new ICMSN60();
                    ((ICMSN60)icms).setValorBC(this.StringToDouble(grp60vlBcRetIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN60)icms).setAliquota(this.StringToDouble(grp60vlAliqRetIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN60)icms).setValor(this.StringToDouble(grp60vlRetIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    if (grp60vlCredRetIcms != null) {
                        ((ICMSN60)icms).setValorCredito(this.StringToDouble(grp60vlCredRetIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    ((ICMSN60)icms).setValorDesonerado(this.StringToDouble(grp60vlIcmsDeson, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN60)icms).setCodigoBeneficio(grp60CodBenef);
                }
            }
            if (objXML.getICMS().getICMS90() != null) {
                String grp90vlBcRedIcms = objXML.getICMS().getICMS90().getPRedBC();
                String grp90vlBcIcms = objXML.getICMS().getICMS90().getVBC();
                String grp90vlAliqIcms = objXML.getICMS().getICMS90().getPICMS();
                String grp90vlIcms = objXML.getICMS().getICMS90().getVICMS();
                String grp90vlCtedIcms = objXML.getICMS().getICMS90().getVCred();
                String grp90vlIcmsDeson = objXML.getICMS().getICMS90().getVICMSDeson();
                String grp90CodBenef = objXML.getICMS().getICMS90().getCBenef();
                if (!grp90vlIcms.equals("")) {
                    icms = new ICMSN90();
                    ((ICMSN90)icms).setReducaoBC(this.StringToDouble(grp90vlBcRedIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN90)icms).setValorBC(this.StringToDouble(grp90vlBcIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN90)icms).setAliquota(this.StringToDouble(grp90vlAliqIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN90)icms).setValor(this.StringToDouble(grp90vlIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN90)icms).setValorCredito(this.StringToDouble(grp90vlCtedIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN90)icms).setValorDesonerado(this.StringToDouble(grp90vlIcmsDeson, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSN90)icms).setCodigoBeneficio(grp90CodBenef);
                }
            }
            if (objXML.getICMS().getICMSOutraUF() != null) {
                String grpOutrasUFvlBcRedIcms = objXML.getICMS().getICMSOutraUF().getPRedBCOutraUF();
                String grpOutrasUFvlBcIcms = objXML.getICMS().getICMSOutraUF().getVBCOutraUF();
                String grpOutrasUFvlAliqIcms = objXML.getICMS().getICMSOutraUF().getPICMSOutraUF();
                String grpOutrasUFvlIcms = objXML.getICMS().getICMSOutraUF().getVICMSOutraUF();
                String grpOutrasUFvlIcmsDeson = objXML.getICMS().getICMSOutraUF().getVICMSDeson();
                String grpOutrasUFCodBenef = objXML.getICMS().getICMSOutraUF().getCBenef();
                if (!grpOutrasUFvlIcms.equals("")) {
                    icms = new ICMSOutraUF();
                    ((ICMSOutraUF)icms).setReducaoBC(this.StringToDouble(grpOutrasUFvlBcRedIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSOutraUF)icms).setValorBC(this.StringToDouble(grpOutrasUFvlBcIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSOutraUF)icms).setAliquota(this.StringToDouble(grpOutrasUFvlAliqIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSOutraUF)icms).setValor(this.StringToDouble(grpOutrasUFvlIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSOutraUF)icms).setValorDesonerado(this.StringToDouble(grpOutrasUFvlIcmsDeson, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((ICMSOutraUF)icms).setCodigoBeneficio(grpOutrasUFCodBenef);
                }
            }
            if (objXML.getICMS().getICMSSN() != null && (grpIndSN = objXML.getICMS().getICMSSN().getIndSN()).equals("1")) {
                icms = new ICMSSN();
            }
            if (objXML.getVTotTrib() != null && !objXML.getVTotTrib().isEmpty()) {
                this.obj.getImpostos().setValorTotalTributos(this.StringToDouble(objXML.getVTotTrib(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (objXML.getICMSUFFim() != null) {
                ICMSUFDestino icmsufdestino = new ICMSUFDestino();
                icmsufdestino.setBaseCalculoDest(this.StringToDouble(objXML.getICMSUFFim().getVBCUFFim(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                icmsufdestino.setPercentualFCP(this.StringToDouble(objXML.getICMSUFFim().getPFCPUFFim(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                icmsufdestino.setAliquotaInterna(this.StringToDouble(objXML.getICMSUFFim().getPICMSUFFim(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                icmsufdestino.setAliquotaInterestadual(this.StringToDouble(objXML.getICMSUFFim().getPICMSInter(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                icmsufdestino.setValorFCPDest(this.StringToDouble(objXML.getICMSUFFim().getVFCPUFFim(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                icmsufdestino.setValorICMSDest(this.StringToDouble(objXML.getICMSUFFim().getVICMSUFFim(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                icmsufdestino.setValorICMSRem(this.StringToDouble(objXML.getICMSUFFim().getVICMSUFIni(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getImpostos().setIcmsufdestino(icmsufdestino);
            }
            this.obj.getImpostos().setIcms(icms);
            if (objXML.getIBSCBS() != null) {
                this.comporIbsCbs(this.obj.getImpostos(), objXML.getIBSCBS());
                this.obj.getImpostos().setValorTotalDfe(this.StringToDouble(objXML.getVTotDFe(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler os impostos do Ct-e " + ex.getMessage());
        }
    }

    private void comporIbsCbs(Impostos impostos, TTribCTe imp) throws ParseException {
        try {
            if (imp != null) {
                impostos.setSituacaoTributaria(Util.valueToEnum(SituacaoTributariaIBSCBS.class, imp.getCST()));
                impostos.setClassificacaoTributaria(imp.getCClassTrib());
                if (imp.getGIBSCBS() != null) {
                    TCIBS tcibs = imp.getGIBSCBS();
                    IBSCBS ibsCbs = new IBSCBS();
                    ibsCbs.setBaseCalculo(this.StringToDouble(tcibs.getVBC(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    if (tcibs.getGIBSUF() != null) {
                        IBSCBS.IBS uf = new IBSCBS.IBS();
                        uf.setAliquota(this.StringToDouble(tcibs.getGIBSUF().getPIBSUF(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        this.comporDevolucao(uf, tcibs.getGIBSUF().getGDevTrib());
                        this.comporReducao(uf, tcibs.getGIBSUF().getGRed());
                        uf.setValor(this.StringToDouble(tcibs.getGIBSUF().getVIBSUF(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        ibsCbs.setUf(uf);
                    }
                    if (tcibs.getGIBSMun() != null) {
                        IBSCBS.IBS mun = new IBSCBS.IBS();
                        mun.setAliquota(this.StringToDouble(tcibs.getGIBSMun().getPIBSMun(), 0));
                        this.comporDevolucao(mun, tcibs.getGIBSMun().getGDevTrib());
                        this.comporReducao(mun, tcibs.getGIBSMun().getGRed());
                        mun.setValor(this.StringToDouble(tcibs.getGIBSMun().getVIBSMun(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        ibsCbs.setMunicipal(mun);
                    }
                    if (tcibs.getGIBSUF() != null && tcibs.getGIBSMun() != null) {
                        ibsCbs.setValorTotalIbs(this.StringToDouble(tcibs.getVIBS(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (tcibs.getGCBS() != null) {
                        IBSCBS.CBS cbs = new IBSCBS.CBS();
                        cbs.setAliquota(this.StringToDouble(tcibs.getGCBS().getPCBS(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        if (tcibs.getGCBS().getGDevTrib() != null) {
                            cbs.setDevolucao(this.StringToDouble(tcibs.getGCBS().getGDevTrib().getVDevTrib(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        }
                        if (tcibs.getGCBS().getGRed() != null) {
                            cbs.setPercentualReducao(this.StringToDouble(tcibs.getGCBS().getGRed().getPRedAliq(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                            cbs.setAliquotaEfetiva(this.StringToDouble(tcibs.getGCBS().getGRed().getPAliqEfet(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        }
                        cbs.setValor(this.StringToDouble(tcibs.getGCBS().getVCBS(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        ibsCbs.setFederal(cbs);
                    }
                    impostos.setIbsCbs(ibsCbs);
                }
            }
        }
        catch (Exception e) {
            throw new ParseException("Ocorreu um erro ao compor IBSCBS " + e.getMessage());
        }
    }

    private void comporDevolucao(IBSCBS.IBS ibs, TDevTrib gDevTrib) throws ParseException {
        try {
            if (gDevTrib != null) {
                ibs.setDevolucao(this.StringToDouble(gDevTrib.getVDevTrib(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
        }
        catch (Exception e) {
            throw new ParseException("Ocorreu um erro ao compor Devolu\u00e7\u00e3o " + e.getMessage());
        }
    }

    private void comporReducao(IBSCBS.IBS ibs, TRed gRed) throws ParseException {
        try {
            if (gRed != null) {
                ibs.setPercentualReducao(this.StringToDouble(gRed.getPRedAliq(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                ibs.setAliquotaEfetiva(this.StringToDouble(gRed.getPAliqEfet(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
        }
        catch (Exception e) {
            throw new ParseException("Ocorreu um erro ao compor Redu\u00e7\u00e3o " + e.getMessage());
        }
    }

    private void modalRodoviario(Rodo objXML) throws ParseException {
        try {
            Rodoviario rod = new Rodoviario();
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setModal(rod);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setModal(rod);
            }
            rod.setNrRNTRC(objXML.getRNTRC());
            if (objXML.getOcc() != null) {
                for (Rodo.Occ objX : objXML.getOcc()) {
                    this.ordemColeta(objX);
                }
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es do modal rodovi\u00e1rio do Ct-e " + ex.getMessage());
        }
    }

    private void ordemColeta(Rodo.Occ objXML) throws ParseException {
        try {
            OrdemColeta ordem = new OrdemColeta();
            ordem.setNrSerie(objXML.getSerie());
            ordem.setNrOrdem(br.com.ophos.util.cte.Util.StringToInteger(objXML.getNOcc()));
            ordem.setDataEmissao(LocalDateSerializer.parseDate(objXML.getDEmi().replaceAll("-", "")));
            if (objXML.getEmiOcc() != null) {
                ordem.setCnpj(objXML.getEmiOcc().getCNPJ());
                ordem.setNrInterno(objXML.getEmiOcc().getCInt());
                ordem.setNrIE(objXML.getEmiOcc().getIE());
                ordem.setUf(objXML.getEmiOcc().getUF().value());
                ordem.setTelefone(objXML.getEmiOcc().getFone());
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((Rodoviario)((CTeNormal)this.obj.getInfoCte()).getModal()).getOrdemColeta().add(ordem);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((Rodoviario)((CTeSubstituto)this.obj.getInfoCte()).getModal()).getOrdemColeta().add(ordem);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es de OCC do Ct-e " + ex.getMessage());
        }
    }

    private void modalMultiModal(Multimodal objXML) throws ParseException {
        try {
            MultiModal multi = new MultiModal();
            multi.setCOTM(objXML.getCOTM());
            multi.setIndicadorNegociavel(br.com.ophos.util.cte.Util.valueToIndicadorNegociavel(objXML.getIndNegociavel()));
            if (objXML.getSeg() != null) {
                SeguroMultimodal seguroMultimodal = new SeguroMultimodal();
                seguroMultimodal.setCnpjSeguradora(objXML.getSeg().getInfSeg().getCNPJ());
                seguroMultimodal.setNomeSeguradora(objXML.getSeg().getInfSeg().getXSeg());
                seguroMultimodal.setNumeroApolice(objXML.getSeg().getNApol());
                seguroMultimodal.setNumeroAverbacao(objXML.getSeg().getNAver());
                multi.setSeguro(seguroMultimodal);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setModal(multi);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setModal(multi);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es do multimodal do Ct-e " + ex.getMessage());
        }
    }

    private void modalAquaviario(Aquav objXML) throws ParseException {
        try {
            Aquaviario aqua = new Aquaviario();
            aqua.setValorPrestacao(this.StringToDouble(objXML.getVPrest(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            aqua.setValorAFRMM(this.StringToDouble(objXML.getVAFRMM(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            aqua.setDescricaoNavio(objXML.getXNavio());
            if (objXML.getBalsa() != null && !objXML.getBalsa().isEmpty()) {
                for (Aquav.Balsa balsa : objXML.getBalsa()) {
                    Balsa b = new Balsa();
                    b.setDescricaoBalsa(balsa.getXBalsa());
                    aqua.getBalsas().add(b);
                }
            }
            if (objXML.getNViag() != null && !objXML.getNViag().isEmpty()) {
                aqua.setnViagem(objXML.getNViag());
            }
            aqua.setTipoDirecaoViagem(br.com.ophos.util.cte.Util.valueToTipoDirecaoViagem(objXML.getDirec()));
            aqua.setIrin(objXML.getIrin());
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setModal(aqua);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setModal(aqua);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es do modal aquaviario do Ct-e " + ex.getMessage());
        }
    }

    private void modalAereo(br.com.ophos.xml.cte.v400.Aereo objXML) throws ParseException {
        try {
            Aereo aereo = new Aereo();
            if (objXML.getNMinu() != null && !objXML.getNMinu().isEmpty()) {
                aereo.setnMinu(objXML.getNMinu());
            }
            if (objXML.getNOCA() != null && !objXML.getNOCA().isEmpty()) {
                aereo.setnOCA(objXML.getNOCA());
            }
            aereo.setDataPrevista(LocalDateSerializer.parseDate(objXML.getDPrevAereo().replaceAll("-", "")));
            if (objXML.getTarifa() != null) {
                Tarifa tarifa = new Tarifa();
                tarifa.setClasseTarifa(br.com.ophos.util.cte.Util.valueToTipoClasseTarifa(objXML.getTarifa().getCL()));
                if (objXML.getTarifa().getCTar() != null && !objXML.getTarifa().getCTar().isEmpty()) {
                    tarifa.setCodigoTarifa(objXML.getTarifa().getCTar());
                }
                tarifa.setValorTarifa(this.StringToDouble(objXML.getTarifa().getVTar(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                aereo.setTarifa(tarifa);
            }
            if (objXML.getNatCarga() != null) {
                NaturezaCarga naturezaCarga = new NaturezaCarga();
                if (objXML.getNatCarga().getXDime() != null && !objXML.getNatCarga().getXDime().isEmpty()) {
                    naturezaCarga.setDimensao(objXML.getNatCarga().getXDime());
                }
                if (objXML.getNatCarga().getCInfManu() != null && !objXML.getNatCarga().getCInfManu().isEmpty()) {
                    ManuseioCarga manuseio = new ManuseioCarga();
                    for (String m : objXML.getNatCarga().getCInfManu()) {
                        manuseio.setTipoManuseio(br.com.ophos.util.cte.Util.valueToTipoManuseioCarga(m));
                        naturezaCarga.getManuseioCarga().add(manuseio);
                    }
                }
                aereo.setNaturezaCarga(naturezaCarga);
            }
            if (objXML.getPeri() != null && !objXML.getPeri().isEmpty()) {
                for (Aereo.Peri peri : objXML.getPeri()) {
                    ProdutoPerigosoAereo perigosoAereo = new ProdutoPerigosoAereo();
                    perigosoAereo.setNrOnu(peri.getNONU());
                    perigosoAereo.setQuantidadeEmbalagem(peri.getQTotEmb());
                    perigosoAereo.setQuantidadeTotal(this.StringToDouble(peri.getInfTotAP().getQTotProd(), br.com.ophos.util.cte.Util.ST_FMT_QUATRO_DECIMAIS));
                    switch (peri.getInfTotAP().getUniAP()) {
                        case "1": {
                            perigosoAereo.setUnidadeMedida(UnidadeProdutoPerigoso.KG);
                            break;
                        }
                        case "2": {
                            perigosoAereo.setUnidadeMedida(UnidadeProdutoPerigoso.KG_G);
                            break;
                        }
                        case "3": {
                            perigosoAereo.setUnidadeMedida(UnidadeProdutoPerigoso.LITROS);
                            break;
                        }
                        case "4": {
                            perigosoAereo.setUnidadeMedida(UnidadeProdutoPerigoso.TI);
                            break;
                        }
                        case "5": {
                            perigosoAereo.setUnidadeMedida(UnidadeProdutoPerigoso.UN);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es do modal a\u00e9reo do Ct-e " + ex.getMessage());
        }
    }

    private void infoCarga(TCTe.InfCte.InfCTeNorm.InfCarga objXML) throws ParseException {
        try {
            InformacaoCarga info = new InformacaoCarga();
            info.setValorTotalCarga(this.StringToDouble(objXML.getVCarga(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            info.setProdutoPredominante(objXML.getProPred());
            info.setOutraCaracteristica(objXML.getXOutCat());
            if (objXML.getVCargaAverb() != null && !objXML.getVCargaAverb().trim().isEmpty()) {
                info.setValorAverbacao(this.StringToDouble(objXML.getVCargaAverb(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (objXML.getInfQ() != null) {
                for (TCTe.InfCte.InfCTeNorm.InfCarga.InfQ objX : objXML.getInfQ()) {
                    this.infoQCarga(info, objX);
                }
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setInformacaoCarga(info);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setInformacaoCarga(info);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a informa\u00e7\u00e3o da carga do Ct-e " + ex.getMessage());
        }
    }

    private void infoQCarga(InformacaoCarga infoCarga, TCTe.InfCte.InfCTeNorm.InfCarga.InfQ objXML) throws ParseException {
        try {
            QuantidadeCarga qtde = new QuantidadeCarga();
            qtde.setNrUM(br.com.ophos.util.cte.Util.valueToUnidadeMedida(objXML.getCUnid()));
            qtde.setDescricaoUN(objXML.getTpMed());
            qtde.setQuantidade(this.StringToDouble(objXML.getQCarga(), br.com.ophos.util.cte.Util.ST_FMT_QUATRO_DECIMAIS));
            infoCarga.getQuantidadeCarga().add(qtde);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a informa\u00e7\u00e3o da QTD carga do Ct-e " + ex.getMessage());
        }
    }

    private void substituicao(TCTe.InfCte.InfCTeNorm.InfCteSub objXML) throws ParseException {
        try {
            this.obj.setTipo(TipoConhecimento.SUBSTITUTO);
            ((CTeSubstituto)this.obj.getInfoCte()).setNrChaveAcesso(objXML.getChCte());
            if ("1".equals(objXML.getIndAlteraToma())) {
                ((CTeSubstituto)this.obj.getInfoCte()).setAlteracaoTomador(EscolhaSN.SIM);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es de Anula\u00e7\u00e3o do Ct-e " + ex.getMessage());
        }
    }

    private void docNF(TCTe.InfCte.InfCTeNorm.InfDoc.InfNF objXML) throws ParseException {
        try {
            Lacre lacre;
            DocumentoNF doc = new DocumentoNF();
            String grpNFromaneo = objXML.getNRoma();
            String grpNFnrPedido = objXML.getNPed();
            String grpMod = objXML.getMod();
            String grpNFnrSerie = objXML.getSerie();
            String grpNFnrDocumento = objXML.getNDoc();
            String grpNFdtEmissao = objXML.getDEmi();
            String grpNFvlBC = objXML.getVBC();
            String grpNFvlICMS = objXML.getVICMS();
            String grpNFvlBCST = objXML.getVBCST();
            String grpNFvlST = objXML.getVST();
            String grpNFvlProd = objXML.getVProd();
            String grpNFvlNF = objXML.getVNF();
            String grpNFnrCFOP = objXML.getNCFOP();
            String grpNFpeso = objXML.getNPeso();
            String grpNFsuframa = objXML.getPIN();
            String grpNFDataPrevista = objXML.getDPrev();
            if (!grpNFnrDocumento.equals("")) {
                doc.setNrRomaneo(grpNFromaneo);
                doc.setNrPedido(grpNFnrPedido);
                doc.setModelo(br.com.ophos.util.cte.Util.valueToTipoDocNF(grpMod));
                doc.setNrSerie(grpNFnrSerie);
                doc.setNrDocumento(grpNFnrDocumento);
                doc.setDataEmissao(LocalDateSerializer.parseDate(grpNFdtEmissao.replaceAll("-", "")));
                doc.setBaseCalculo(this.StringToDouble(grpNFvlBC, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                doc.setValorICMS(this.StringToDouble(grpNFvlICMS, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                doc.setBaseCalculoST(this.StringToDouble(grpNFvlBCST, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                doc.setValorICMSST(this.StringToDouble(grpNFvlST, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                doc.setValorTotalProduto(this.StringToDouble(grpNFvlProd, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                doc.setValorTotal(this.StringToDouble(grpNFvlNF, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                doc.setCfopPredomina(br.com.ophos.util.cte.Util.StringToShort(grpNFnrCFOP));
                if (grpNFpeso != null && !grpNFpeso.isEmpty()) {
                    doc.setNrPeso(this.StringToDouble(grpNFpeso, br.com.ophos.util.cte.Util.ST_FMT_TRES_DECIMAIS));
                }
                doc.setNrPIN(grpNFsuframa);
                if (grpNFDataPrevista != null && !grpNFDataPrevista.isEmpty()) {
                    doc.setDataPrevista(LocalDateSerializer.parseDate(grpNFDataPrevista.replaceAll("-", "")));
                }
            }
            if (objXML.getInfUnidTransp() != null && !objXML.getInfUnidTransp().isEmpty()) {
                for (TUnidadeTransp ut : objXML.getInfUnidTransp()) {
                    UnidadeTransporte unidadeTransporte = new UnidadeTransporte();
                    unidadeTransporte.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeTransporte(ut.getTpUnidTransp()));
                    unidadeTransporte.setIdentificacao(ut.getIdUnidTransp());
                    if (ut.getLacUnidTransp() != null && !ut.getLacUnidTransp().isEmpty()) {
                        for (TUnidadeTransp.LacUnidTransp lacUnidTransp : ut.getLacUnidTransp()) {
                            lacre = new Lacre();
                            lacre.setNrLacre(lacUnidTransp.getNLacre());
                            unidadeTransporte.getLacres().add(lacre);
                        }
                    }
                    if (ut.getInfUnidCarga() != null && !ut.getInfUnidCarga().isEmpty()) {
                        for (TUnidCarga tUnidCarga : ut.getInfUnidCarga()) {
                            UnidadeCarga unidadeCarga = new UnidadeCarga();
                            unidadeCarga.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeCarga(tUnidCarga.getTpUnidCarga()));
                            unidadeCarga.setIdentificacao(tUnidCarga.getIdUnidCarga());
                            if (tUnidCarga.getLacUnidCarga() != null && !tUnidCarga.getLacUnidCarga().isEmpty()) {
                                for (TUnidCarga.LacUnidCarga l : tUnidCarga.getLacUnidCarga()) {
                                    Lacre lacre2 = new Lacre();
                                    lacre2.setNrLacre(l.getNLacre());
                                    unidadeCarga.getLacres().add(lacre2);
                                }
                            }
                            if (tUnidCarga.getQtdRat() != null && !tUnidCarga.getQtdRat().isEmpty()) {
                                unidadeCarga.setQuantidadeRateada(this.StringToDouble(tUnidCarga.getQtdRat(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            unidadeTransporte.getUnidadeCarga().add(unidadeCarga);
                        }
                    }
                    if (ut.getQtdRat() != null && !ut.getQtdRat().isEmpty()) {
                        unidadeTransporte.setQuantidadeRateada(this.StringToDouble(ut.getQtdRat(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    doc.getUnidadesTransporte().add(unidadeTransporte);
                }
            }
            if (objXML.getInfUnidCarga() != null && !objXML.getInfUnidCarga().isEmpty()) {
                for (TUnidCarga uc : objXML.getInfUnidCarga()) {
                    UnidadeCarga unidadeCarga = new UnidadeCarga();
                    unidadeCarga.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeCarga(uc.getTpUnidCarga()));
                    unidadeCarga.setIdentificacao(uc.getIdUnidCarga());
                    if (uc.getLacUnidCarga() != null && !uc.getLacUnidCarga().isEmpty()) {
                        for (TUnidCarga.LacUnidCarga lacUnidCarga : uc.getLacUnidCarga()) {
                            lacre = new Lacre();
                            lacre.setNrLacre(lacUnidCarga.getNLacre());
                            unidadeCarga.getLacres().add(lacre);
                        }
                    }
                    if (uc.getQtdRat() != null && !uc.getQtdRat().isEmpty()) {
                        unidadeCarga.setQuantidadeRateada(this.StringToDouble(uc.getQtdRat(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    doc.getUnidadesCarga().add(unidadeCarga);
                }
            }
            if (doc != null) {
                if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                    ((CTeNormal)this.obj.getInfoCte()).getDocumentos().add(doc);
                }
                if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                    ((CTeSubstituto)this.obj.getInfoCte()).getDocumentos().add(doc);
                }
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o infNF do Ct-e " + ex.getMessage());
        }
    }

    private void docNFe(TCTe.InfCte.InfCTeNorm.InfDoc.InfNFe objXML) throws ParseException {
        try {
            DocumentoNFe doc = new DocumentoNFe();
            String grpNFeChaveAcesso = objXML.getChave();
            String grpNFeSuframa = objXML.getPIN();
            String grpNFeDataPrevista = objXML.getDPrev();
            if (!grpNFeChaveAcesso.equals("")) {
                Lacre lacre;
                doc = new DocumentoNFe();
                doc.setChaveAcesso(grpNFeChaveAcesso);
                doc.setNrPIN(grpNFeSuframa);
                if (grpNFeDataPrevista != null && !grpNFeDataPrevista.isEmpty()) {
                    doc.setDataPrevista(LocalDateSerializer.parseDate(grpNFeDataPrevista.replaceAll("-", "")));
                }
                if (objXML.getInfUnidTransp() != null && !objXML.getInfUnidTransp().isEmpty()) {
                    for (TUnidadeTransp ut : objXML.getInfUnidTransp()) {
                        UnidadeTransporte unidadeTransporte = new UnidadeTransporte();
                        unidadeTransporte.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeTransporte(ut.getTpUnidTransp()));
                        unidadeTransporte.setIdentificacao(ut.getIdUnidTransp());
                        if (ut.getLacUnidTransp() != null && !ut.getLacUnidTransp().isEmpty()) {
                            for (TUnidadeTransp.LacUnidTransp lacUnidTransp : ut.getLacUnidTransp()) {
                                lacre = new Lacre();
                                lacre.setNrLacre(lacUnidTransp.getNLacre());
                                unidadeTransporte.getLacres().add(lacre);
                            }
                        }
                        if (ut.getInfUnidCarga() != null && !ut.getInfUnidCarga().isEmpty()) {
                            for (TUnidCarga tUnidCarga : ut.getInfUnidCarga()) {
                                UnidadeCarga unidadeCarga = new UnidadeCarga();
                                unidadeCarga.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeCarga(tUnidCarga.getTpUnidCarga()));
                                unidadeCarga.setIdentificacao(tUnidCarga.getIdUnidCarga());
                                if (tUnidCarga.getLacUnidCarga() != null && !tUnidCarga.getLacUnidCarga().isEmpty()) {
                                    for (TUnidCarga.LacUnidCarga l : tUnidCarga.getLacUnidCarga()) {
                                        Lacre lacre2 = new Lacre();
                                        lacre2.setNrLacre(l.getNLacre());
                                        unidadeCarga.getLacres().add(lacre2);
                                    }
                                }
                                if (tUnidCarga.getQtdRat() != null && !tUnidCarga.getQtdRat().isEmpty()) {
                                    unidadeCarga.setQuantidadeRateada(this.StringToDouble(tUnidCarga.getQtdRat(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                                }
                                unidadeTransporte.getUnidadeCarga().add(unidadeCarga);
                            }
                        }
                        if (ut.getQtdRat() != null && !ut.getQtdRat().isEmpty()) {
                            unidadeTransporte.setQuantidadeRateada(this.StringToDouble(ut.getQtdRat(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        }
                        doc.getUnidadesTransporte().add(unidadeTransporte);
                    }
                }
                if (objXML.getInfUnidCarga() != null && !objXML.getInfUnidCarga().isEmpty()) {
                    for (TUnidCarga uc : objXML.getInfUnidCarga()) {
                        UnidadeCarga unidadeCarga = new UnidadeCarga();
                        unidadeCarga.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeCarga(uc.getTpUnidCarga()));
                        unidadeCarga.setIdentificacao(uc.getIdUnidCarga());
                        if (uc.getLacUnidCarga() != null && !uc.getLacUnidCarga().isEmpty()) {
                            for (TUnidCarga.LacUnidCarga lacUnidCarga : uc.getLacUnidCarga()) {
                                lacre = new Lacre();
                                lacre.setNrLacre(lacUnidCarga.getNLacre());
                                unidadeCarga.getLacres().add(lacre);
                            }
                        }
                        if (uc.getQtdRat() != null && !uc.getQtdRat().isEmpty()) {
                            unidadeCarga.setQuantidadeRateada(this.StringToDouble(uc.getQtdRat(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        }
                        doc.getUnidadesCarga().add(unidadeCarga);
                    }
                }
                if (doc != null) {
                    if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                        ((CTeNormal)this.obj.getInfoCte()).getDocumentos().add(doc);
                    }
                    if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                        ((CTeSubstituto)this.obj.getInfoCte()).getDocumentos().add(doc);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o infNFe do Ct-e " + ex.getMessage());
        }
    }

    private void docOutros(TCTe.InfCte.InfCTeNorm.InfDoc.InfOutros objXML) throws ParseException {
        try {
            Lacre lacre;
            DocumentoOutro doc = new DocumentoOutro();
            String grpOutrosTipoDoc = objXML.getTpDoc();
            String grpOutrosDescOutro = objXML.getDescOutros();
            String grpOutrosNdoc = objXML.getNDoc();
            String grpOutrosDemi = objXML.getDEmi();
            String grpOutrosVdoFisc = objXML.getVDocFisc();
            String grpOutrosDataPrevista = objXML.getDPrev();
            if (!grpOutrosTipoDoc.equals("")) {
                doc = new DocumentoOutro();
                doc.setTipo(br.com.ophos.util.cte.Util.valueToTipoDocumentoOutro(grpOutrosTipoDoc));
                doc.setDescricao(grpOutrosDescOutro);
                doc.setNrDocumento(grpOutrosNdoc);
                if (grpOutrosDemi != null && !grpOutrosDemi.isEmpty()) {
                    doc.setDataEmissao(LocalDateSerializer.parseDate(grpOutrosDemi.replaceAll("-", "")));
                }
                if (grpOutrosVdoFisc != null && !grpOutrosVdoFisc.isEmpty()) {
                    doc.setValor(this.StringToDouble(grpOutrosVdoFisc, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (grpOutrosDataPrevista != null) {
                    doc.setDataPrevista(LocalDateSerializer.parseDate(grpOutrosDataPrevista.replaceAll("-", "")));
                }
            }
            if (objXML.getInfUnidTransp() != null && !objXML.getInfUnidTransp().isEmpty()) {
                for (TUnidadeTransp ut : objXML.getInfUnidTransp()) {
                    UnidadeTransporte unidadeTransporte = new UnidadeTransporte();
                    unidadeTransporte.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeTransporte(ut.getTpUnidTransp()));
                    unidadeTransporte.setIdentificacao(ut.getIdUnidTransp());
                    if (ut.getLacUnidTransp() != null && !ut.getLacUnidTransp().isEmpty()) {
                        for (TUnidadeTransp.LacUnidTransp lacUnidTransp : ut.getLacUnidTransp()) {
                            lacre = new Lacre();
                            lacre.setNrLacre(lacUnidTransp.getNLacre());
                            unidadeTransporte.getLacres().add(lacre);
                        }
                    }
                    if (ut.getInfUnidCarga() != null && !ut.getInfUnidCarga().isEmpty()) {
                        for (TUnidCarga tUnidCarga : ut.getInfUnidCarga()) {
                            UnidadeCarga unidadeCarga = new UnidadeCarga();
                            unidadeCarga.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeCarga(tUnidCarga.getTpUnidCarga()));
                            unidadeCarga.setIdentificacao(tUnidCarga.getIdUnidCarga());
                            if (tUnidCarga.getLacUnidCarga() != null && !tUnidCarga.getLacUnidCarga().isEmpty()) {
                                for (TUnidCarga.LacUnidCarga l : tUnidCarga.getLacUnidCarga()) {
                                    Lacre lacre2 = new Lacre();
                                    lacre2.setNrLacre(l.getNLacre());
                                    unidadeCarga.getLacres().add(lacre2);
                                }
                            }
                            if (tUnidCarga.getQtdRat() != null && !tUnidCarga.getQtdRat().isEmpty()) {
                                unidadeCarga.setQuantidadeRateada(this.StringToDouble(tUnidCarga.getQtdRat(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                            }
                            unidadeTransporte.getUnidadeCarga().add(unidadeCarga);
                        }
                    }
                    if (ut.getQtdRat() != null && !ut.getQtdRat().isEmpty()) {
                        unidadeTransporte.setQuantidadeRateada(this.StringToDouble(ut.getQtdRat(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    doc.getUnidadesTransporte().add(unidadeTransporte);
                }
            }
            if (objXML.getInfUnidCarga() != null && !objXML.getInfUnidCarga().isEmpty()) {
                for (TUnidCarga uc : objXML.getInfUnidCarga()) {
                    UnidadeCarga unidadeCarga = new UnidadeCarga();
                    unidadeCarga.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeCarga(uc.getTpUnidCarga()));
                    unidadeCarga.setIdentificacao(uc.getIdUnidCarga());
                    if (uc.getLacUnidCarga() != null && !uc.getLacUnidCarga().isEmpty()) {
                        for (TUnidCarga.LacUnidCarga lacUnidCarga : uc.getLacUnidCarga()) {
                            lacre = new Lacre();
                            lacre.setNrLacre(lacUnidCarga.getNLacre());
                            unidadeCarga.getLacres().add(lacre);
                        }
                    }
                    if (uc.getQtdRat() != null && !uc.getQtdRat().isEmpty()) {
                        unidadeCarga.setQuantidadeRateada(this.StringToDouble(uc.getQtdRat(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    doc.getUnidadesCarga().add(unidadeCarga);
                }
            }
            if (doc != null) {
                if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                    ((CTeNormal)this.obj.getInfoCte()).getDocumentos().add(doc);
                }
                if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                    ((CTeSubstituto)this.obj.getInfoCte()).getDocumentos().add(doc);
                }
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o infOutros do Ct-e " + ex.getMessage());
        }
    }

    private void docDCe(TCTe.InfCte.InfCTeNorm.InfDoc.InfDCe objXML) throws ParseException {
        try {
            DocumentoDCe docDce = new DocumentoDCe();
            if (!objXML.getChave().equals("")) {
                docDce = new DocumentoDCe();
                docDce.setChaveAcesso(objXML.getChave());
                if (docDce != null && this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                    ((CTeNormal)this.obj.getInfoCte()).getDocumentos().add(docDce);
                }
            }
        }
        catch (Exception e) {
            throw new ParseException("Ocorreu um erro ao ler o infDCe do Ct-e " + e.getMessage());
        }
    }

    private void emitenteAnterior(TCTe.InfCte.InfCTeNorm.DocAnt.EmiDocAnt objXML) throws ParseException {
        try {
            EmitenteDocAnterior emitenteAnterior = new EmitenteDocAnterior();
            if (objXML.getCNPJ() != null) {
                emitenteAnterior.setCnpjCpf(objXML.getCNPJ());
            }
            if (objXML.getCPF() != null) {
                emitenteAnterior.setCnpjCpf(objXML.getCPF());
            }
            emitenteAnterior.setInscricaoEstadual(objXML.getIE());
            emitenteAnterior.setUf(objXML.getUF().value());
            emitenteAnterior.setNome(objXML.getXNome());
            if (objXML.getIdDocAnt() != null) {
                for (TCTe.InfCte.InfCTeNorm.DocAnt.EmiDocAnt.IdDocAnt objX : objXML.getIdDocAnt()) {
                    this.docAnterior(emitenteAnterior, objX);
                }
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).getEmitenteDocumentoAnterior().add(emitenteAnterior);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).getEmitenteDocumentoAnterior().add(emitenteAnterior);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o emitente anterior do Ct-e " + ex.getMessage());
        }
    }

    private void docAnterior(EmitenteDocAnterior emitenteAnterior, TCTe.InfCte.InfCTeNorm.DocAnt.EmiDocAnt.IdDocAnt objXML) throws ParseException {
        try {
            if (objXML.getIdDocAntEle() != null) {
                for (TCTe.InfCte.InfCTeNorm.DocAnt.EmiDocAnt.IdDocAnt.IdDocAntEle idDocAntEle : objXML.getIdDocAntEle()) {
                    this.docAnteriorEletronico(emitenteAnterior, idDocAntEle);
                }
            }
            if (objXML.getIdDocAntPap() != null) {
                for (TCTe.InfCte.InfCTeNorm.DocAnt.EmiDocAnt.IdDocAnt.IdDocAntPap idDocAntPap : objXML.getIdDocAntPap()) {
                    this.docAnteriorPapel(emitenteAnterior, idDocAntPap);
                }
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o documento anterior do Ct-e " + ex.getMessage());
        }
    }

    private void docAnteriorEletronico(EmitenteDocAnterior emitenteAnterior, TCTe.InfCte.InfCTeNorm.DocAnt.EmiDocAnt.IdDocAnt.IdDocAntEle objXML) throws ParseException {
        try {
            DocumentoCTe documentoAnterior = null;
            documentoAnterior = new DocumentoCTe();
            documentoAnterior.setChaveAcesso(objXML.getChCTe());
            emitenteAnterior.getDocumentos().add(documentoAnterior);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o documento anterior (eletr\u00f4nico) do Ct-e " + ex.getMessage());
        }
    }

    private void docAnteriorPapel(EmitenteDocAnterior emitenteAnterior, TCTe.InfCte.InfCTeNorm.DocAnt.EmiDocAnt.IdDocAnt.IdDocAntPap objXML) throws ParseException {
        try {
            DocumentoPapel documentoAnterior = null;
            documentoAnterior = new DocumentoPapel();
            documentoAnterior.setTipo(br.com.ophos.util.cte.Util.valueToTipoDocumento(objXML.getTpDoc()));
            documentoAnterior.setNrSerie(objXML.getSerie());
            documentoAnterior.setNrSubSerie(objXML.getSubser());
            documentoAnterior.setNrDocumento(objXML.getNDoc());
            documentoAnterior.setDataEmissao(LocalDateSerializer.parseDate(objXML.getDEmi().replaceAll("-", "")));
            emitenteAnterior.getDocumentos().add(documentoAnterior);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o documento anterior (Papel) do Ct-e " + ex.getMessage());
        }
    }

    private void veiculoNovo(TCTe.InfCte.InfCTeNorm.VeicNovos objXML) throws ParseException {
        try {
            VeiculoNovo veiculoNovo = new VeiculoNovo();
            veiculoNovo.setChassi(objXML.getChassi());
            veiculoNovo.setNrCor(objXML.getCCor());
            veiculoNovo.setDescCor(objXML.getXCor());
            veiculoNovo.setModelo(objXML.getCMod());
            veiculoNovo.setValorUnitario(this.StringToDouble(objXML.getVUnit(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            veiculoNovo.setValorFrete(this.StringToDouble(objXML.getVFrete(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).getVeiculoNovo().add(veiculoNovo);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).getVeiculoNovo().add(veiculoNovo);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler os ve\u00edculos novos do Ct-e " + ex.getMessage());
        }
    }

    private void cobranca(TCTe.InfCte.InfCTeNorm.Cobr.Fat objXML) throws ParseException {
        try {
            Fatura fatura = new Fatura();
            fatura.setNumero(objXML.getNFat());
            if (objXML.getVOrig() != null) {
                fatura.setValorOriginal(this.StringToDouble(objXML.getVOrig(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (objXML.getVDesc() != null) {
                fatura.setValorDesconto(this.StringToDouble(objXML.getVDesc(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (objXML.getVLiq() != null) {
                fatura.setValorLiquido(this.StringToDouble(objXML.getVLiq(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setFatura(fatura);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setFatura(fatura);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es de cobran\u00e7a do Ct-e " + ex.getMessage());
        }
    }

    private void duplicata(TCTe.InfCte.InfCTeNorm.Cobr.Dup objXML) throws ParseException {
        try {
            Duplicata duplicata = new Duplicata();
            duplicata.setNumero(objXML.getNDup());
            duplicata.setData(LocalDateSerializer.parseDate(objXML.getDVenc().replaceAll("-", "")));
            duplicata.setValor(this.StringToDouble(objXML.getVDup(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).getDuplicatas().add(duplicata);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).getDuplicatas().add(duplicata);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es de duplicata do Ct-e " + ex.getMessage());
        }
    }

    private void informacoesCteGlobalizado(TCTe.InfCte objXML) {
        String observacoesGlobalizado = objXML.getInfCTeNorm().getInfGlobalizado().getXObs();
        if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
            ((CTeNormal)this.obj.getInfoCte()).setInfoGlobalizado(observacoesGlobalizado);
        }
        if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
            ((CTeSubstituto)this.obj.getInfoCte()).setInfoGlobalizado(observacoesGlobalizado);
        }
    }

    private void chaveAcessoVinculadaMultimodal(TCTe.InfCte objXML) {
        for (TCTe.InfCte.InfCTeNorm.InfServVinc.InfCTeMultimodal infCTeMultimodal : objXML.getInfCTeNorm().getInfServVinc().getInfCTeMultimodal()) {
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).getChaveAcessoMultimodal().add(infCTeMultimodal.getChCTeMultimodal());
            }
            if (!this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) continue;
            ((CTeSubstituto)this.obj.getInfoCte()).getChaveAcessoMultimodal().add(infCTeMultimodal.getChCTeMultimodal());
        }
    }

    private void recebedor(TCTe.InfCte.Receb objXML) throws ParseException {
        try {
            Recebedor recebedor = new Recebedor();
            if (objXML.getCNPJ() != null) {
                recebedor.setCnpjCpf(objXML.getCNPJ());
            }
            if (objXML.getCPF() != null) {
                recebedor.setCnpjCpf(objXML.getCPF());
            }
            recebedor.setInscricaoEstadual(objXML.getIE());
            recebedor.setRazaoSocial(objXML.getXNome());
            recebedor.setLogradouro(objXML.getEnderReceb().getXLgr());
            recebedor.setNumero(objXML.getEnderReceb().getNro());
            recebedor.setComplemento(objXML.getEnderReceb().getXCpl());
            recebedor.setBairro(objXML.getEnderReceb().getXBairro());
            recebedor.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(objXML.getEnderReceb().getCMun()));
            recebedor.setMunicipio(objXML.getEnderReceb().getXMun());
            recebedor.setCep(objXML.getEnderReceb().getCEP());
            recebedor.setUf(objXML.getEnderReceb().getUF().value());
            recebedor.setNrPais(br.com.ophos.util.cte.Util.StringToShort(objXML.getEnderReceb().getCPais()));
            recebedor.setPais(objXML.getEnderReceb().getXPais());
            recebedor.setTelefone(objXML.getFone());
            recebedor.setEmail(objXML.getEmail());
            this.obj.setRecebedor(recebedor);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o recebedor do Ct-e " + ex.getMessage());
        }
    }

    private void expedidor(TCTe.InfCte.Exped objXML) throws ParseException {
        try {
            Expedidor expedidor = new Expedidor();
            if (objXML.getCNPJ() != null) {
                expedidor.setCnpjCpf(objXML.getCNPJ());
            }
            if (objXML.getCPF() != null) {
                expedidor.setCnpjCpf(objXML.getCPF());
            }
            expedidor.setInscricaoEstadual(objXML.getIE());
            expedidor.setRazaoSocial(objXML.getXNome());
            expedidor.setLogradouro(objXML.getEnderExped().getXLgr());
            expedidor.setNumero(objXML.getEnderExped().getNro());
            expedidor.setComplemento(objXML.getEnderExped().getXCpl());
            expedidor.setBairro(objXML.getEnderExped().getXBairro());
            expedidor.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(objXML.getEnderExped().getCMun()));
            expedidor.setMunicipio(objXML.getEnderExped().getXMun());
            expedidor.setCep(objXML.getEnderExped().getCEP());
            expedidor.setUf(objXML.getEnderExped().getUF().value());
            expedidor.setNrPais(br.com.ophos.util.cte.Util.StringToShort(objXML.getEnderExped().getCPais()));
            expedidor.setPais(objXML.getEnderExped().getXPais());
            expedidor.setTelefone(objXML.getFone());
            expedidor.setEmail(objXML.getEmail());
            this.obj.setExpedidor(expedidor);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o expedidor do Ct-e " + ex.getMessage());
        }
    }

    private void destinatario(TCTe.InfCte.Dest objXML) throws ParseException {
        try {
            Destinatario destinatario = new Destinatario();
            if (objXML.getCNPJ() != null) {
                destinatario.setCnpjCpf(objXML.getCNPJ());
            }
            if (objXML.getCPF() != null) {
                destinatario.setCnpjCpf(objXML.getCPF());
            }
            destinatario.setInscricaoEstadual(objXML.getIE());
            destinatario.setRazaoSocial(objXML.getXNome());
            destinatario.setLogradouro(objXML.getEnderDest().getXLgr());
            destinatario.setNumero(objXML.getEnderDest().getNro());
            destinatario.setComplemento(objXML.getEnderDest().getXCpl());
            destinatario.setBairro(objXML.getEnderDest().getXBairro());
            destinatario.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(objXML.getEnderDest().getCMun()));
            destinatario.setMunicipio(objXML.getEnderDest().getXMun());
            destinatario.setCep(objXML.getEnderDest().getCEP());
            destinatario.setUf(objXML.getEnderDest().getUF().value());
            destinatario.setNrPais(br.com.ophos.util.cte.Util.StringToShort(objXML.getEnderDest().getCPais()));
            destinatario.setPais(objXML.getEnderDest().getXPais());
            destinatario.setTelefone(objXML.getFone());
            destinatario.setInscricaoSuframa(objXML.getISUF());
            destinatario.setEmail(objXML.getEmail());
            this.obj.setDestinatario(destinatario);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler o destinatario do Ct-e " + ex.getMessage());
        }
    }

    private void autorizacaoXML(TCTe.InfCte.AutXML objXML) throws ParseException {
        try {
            if (objXML.getCNPJ() != null && !objXML.getCNPJ().isEmpty()) {
                this.obj.getPermitidos().getCnpjCpf().add(objXML.getCNPJ());
            }
            if (objXML.getCPF() != null && !objXML.getCPF().isEmpty()) {
                this.obj.getPermitidos().getCnpjCpf().add(objXML.getCPF());
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es da autoriza\u00e7\u00e3o de download do XML do Ct-e " + ex.getMessage());
        }
    }

    private void complemento(List<TCTe.InfCte.InfCteComp> objXML) throws ParseException {
        try {
            this.obj.setTipo(TipoConhecimento.COMPLEMENTO_VALOR);
            CTeComplemento c = new CTeComplemento();
            objXML.forEach(cteComp -> c.getChaves().add(cteComp.getChCTe()));
            if (c.getChaves().size() > 10) {
                throw new ParseException("Limite de chaves de acesso complementado = 10");
            }
            this.obj.setInfoCte(c);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler as informa\u00e7\u00f5es do CT-e de Complemento " + ex.getMessage());
        }
    }
}

