/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.retorno;

import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.ObjectFactory;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.RetEnvioNFeXML;
import br.com.ophos.integracao.parse.nfe.xml.v2.sefaz.TProtNFe;
import br.com.ophos.status.StatusNFE;
import br.com.ophos.util.Parametros;
import br.com.ophos.util.nfe.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class RetEnvioNFe {
    private String ambiente;
    private String nrDocumentoReferente;
    private String nrCNPJEmitente;
    private StatusNFE status;
    private String msg;
    private String nrDocumento;
    private Integer nrSerie;
    private String chaveAcesso;
    private String nrProtocolo;
    private Date dataAutorizacao;
    private String codAmbiente;
    private Parametros param;

    public String getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
    }

    public String getNrDocumentoReferente() {
        if (this.nrDocumentoReferente != null) {
            return this.nrDocumentoReferente;
        }
        return "";
    }

    public void setNrDocumentoReferente(String NrDocumentoReferente) {
        this.nrDocumentoReferente = NrDocumentoReferente;
    }

    public String getStatus() {
        try {
            return Integer.toString(this.status.getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setStatus(StatusNFE status) {
        this.status = status;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getNrDocumento() {
        return this.nrDocumento;
    }

    public void setNrDocumento(String nrDocumento) {
        this.nrDocumento = nrDocumento;
    }

    public Integer getNrSerie() {
        return this.nrSerie;
    }

    public void setNrSerie(Integer nrSerie) {
        this.nrSerie = nrSerie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gerarTXT(String path, String nomeArquivo) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            writer.println("001|" + this.getAmbiente() + "|" + this.getNrCNPJEmitente() + "|" + this.getNrDocumentoReferente() + "|" + this.getStatus() + "|" + this.getMsg());
            if (this.status != null && this.status == StatusNFE.AUTORIZADA) {
                writer.println("002|" + this.getChaveAcesso() + "|" + this.getNrProtocolo() + "|" + Util.formataData(this.getDataAutorizacao(), Util.FMTYYYYMMDDhhmmss));
            }
        }
    }

    public String getXmlRetEnvioIntegra() {
        ObjectFactory fac = new ObjectFactory();
        RetEnvioNFeXML ret = fac.createRetEnvioNFe();
        ret.setRetorno(new RetEnvioNFeXML.Retorno());
        String newMsg = this.getMsg();
        ret.getRetorno().setAmbiente(this.getAmbiente());
        ret.getRetorno().setCnpjEmitente(this.getNrCNPJEmitente());
        ret.getRetorno().setNrrefsis(this.getNrDocumentoReferente());
        ret.getRetorno().setNrDocumento(this.getNrDocumento());
        if (this.getNrSerie() != null) {
            ret.getRetorno().setNrSerie(this.getNrSerie().toString());
        } else {
            ret.getRetorno().setMsg(newMsg + " - S\u00e9rie n\u00e3o informada ou inv\u00e1lida.");
        }
        ret.getRetorno().setStatus(this.getStatus());
        ret.getRetorno().setMsg(this.getMsg());
        if (this.getChaveAcesso() != null) {
            ret.setAutorizacao(new RetEnvioNFeXML.Autorizacao());
            ret.getAutorizacao().setChaveAcesso(this.getChaveAcesso());
            ret.getAutorizacao().setNumeroProtocolo(this.getNrProtocolo());
            ret.getAutorizacao().setDataAutorizacao(Util.formataData(this.getDataAutorizacao(), Util.FMTYYYYMMDDhhmmss));
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RetEnvioNFeXML.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)"iso-8859-1");
            StringWriter writer = new StringWriter();
            m.marshal((Object)ret, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getXmlRetEnvioIntegraSEFAZ() {
        TProtNFe.InfProt infProt = new TProtNFe.InfProt();
        SimpleDateFormat formatDate2 = new SimpleDateFormat("yyyyMMdd");
        try {
            Date data;
            GregorianCalendar calendar;
            if (this.status != null && this.status == StatusNFE.AUTORIZADA) {
                infProt.setCStat("100");
                infProt.setChNFe(this.getChaveAcesso());
                calendar = new GregorianCalendar();
                data = calendar.getTime();
                infProt.setDhRecbto(Util.StringToXMLCalendar(formatDate2.format(data)));
                infProt.setDigVal(new String("PRAsGWN7N1RGDZ5qRwQCnzK+KPc=").getBytes());
                infProt.setId("NFe" + this.getNrProtocolo());
                infProt.setVerAplic(this.param.getVersaoIntegrador());
                infProt.setNProt(this.getNrProtocolo());
                infProt.setTpAmb(this.getAmbiente());
                infProt.setXMotivo("Autorizado o uso da NF-e");
            } else {
                infProt.setCStat("999");
                infProt.setChNFe(this.getChaveAcesso());
                calendar = new GregorianCalendar();
                data = calendar.getTime();
                infProt.setDhRecbto(Util.StringToXMLCalendar(formatDate2.format(data)));
                infProt.setDigVal(new String("PRAsGWN7N1RGDZ5qRwQCnzK+KPc=").getBytes());
                infProt.setId("NFe000000000000");
                infProt.setVerAplic(this.param.getVersaoIntegrador());
                infProt.setNProt("000000000000");
                infProt.setTpAmb(this.getCodAmbiente());
                infProt.setXMotivo(this.getMsg());
            }
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TProtNFe.InfProt.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)false);
            m.setProperty("jaxb.encoding", (Object)"iso-8859-1");
            StringWriter writer = new StringWriter();
            m.marshal((Object)infProt, (Writer)writer);
            return writer.toString();
        }
        catch (Exception ex) {
            Util.readStackTrace(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gerarXML(String path, String nomeArquivo) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            writer.println(this.getXmlRetEnvioIntegra());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gerarXML_SEFAZ(String path, String nomeArquivo) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            writer.println(this.getXmlRetEnvioIntegraSEFAZ());
        }
    }

    public String getChaveAcesso() {
        return this.chaveAcesso;
    }

    public void setChaveAcesso(String chaveAcesso) {
        this.chaveAcesso = chaveAcesso;
    }

    public String getNrProtocolo() {
        return this.nrProtocolo;
    }

    public void setNrProtocolo(String nrProtocolo) {
        this.nrProtocolo = nrProtocolo;
    }

    public Date getDataAutorizacao() {
        return this.dataAutorizacao;
    }

    public void setDataAutorizacao(Date dataAutorizacao) {
        this.dataAutorizacao = dataAutorizacao;
    }

    public String getNrCNPJEmitente() {
        return this.nrCNPJEmitente;
    }

    public void setNrCNPJEmitente(String nrCNPJEmitente) {
        this.nrCNPJEmitente = nrCNPJEmitente;
    }

    public Parametros getParam() {
        return this.param;
    }

    public void setParam(Parametros param) {
        this.param = param;
    }

    public String getCodAmbiente() {
        return this.codAmbiente;
    }

    public void setCodAmbiente(String codAmbiente) {
        this.codAmbiente = codAmbiente;
    }
}

