/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.retorno;

import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.ObjectFactory;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.RetCancNFeXML;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.TRetCancNFe;
import br.com.ophos.status.StatusCancelamentoNFE;
import br.com.ophos.util.nfe.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class RetRecepcaoNFe {
    private String nrCNPJEmitente;
    private String nrDocumentoReferente;
    private String nrDocumento;
    private Short nrSerie;
    private StatusCancelamentoNFE status;
    private String msg;
    private String ambiente;
    private String nrProtocolo;
    private Date dataCancelamento;
    private String chaveAcesso;

    public String getNrCNPJEmitente() {
        if (this.nrCNPJEmitente == null) {
            return "";
        }
        return this.nrCNPJEmitente;
    }

    public void setNrCNPJEmitente(String nrCNPJEmitente) {
        this.nrCNPJEmitente = nrCNPJEmitente;
    }

    public String getNrDocumentoReferente() {
        return this.nrDocumentoReferente;
    }

    public void setNrDocumentoReferente(String nrDocumentoReferente) {
        this.nrDocumentoReferente = nrDocumentoReferente;
    }

    public String getNrDocumento() {
        return this.nrDocumento;
    }

    public void setNrDocumento(String nrDocumento) {
        this.nrDocumento = nrDocumento;
    }

    public Short getNrSerie() {
        return this.nrSerie;
    }

    public void setNrSerie(Short nrSerie) {
        this.nrSerie = nrSerie;
    }

    public String getStatus() {
        try {
            return Integer.toString(this.status.getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setStatus(StatusCancelamentoNFE status) {
        this.status = status;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getXmlRetCancelIntegra() {
        ObjectFactory fac = new ObjectFactory();
        RetCancNFeXML ret = fac.createRetCancNFeXML();
        ret.setRetorno(new RetCancNFeXML.Retorno());
        ret.getRetorno().setCnpjEmitente(this.getNrCNPJEmitente());
        ret.getRetorno().setNrrefsis(this.getNrDocumentoReferente());
        ret.getRetorno().setNrDocumento(this.getNrDocumento());
        ret.getRetorno().setNrSerie(this.getNrSerie().toString());
        ret.getRetorno().setStatus(this.getStatus());
        ret.getRetorno().setMsg(this.getMsg());
        if (this.getNrProtocolo() != null) {
            ret.setComprovante(new RetCancNFeXML.Comprovante());
            ret.getComprovante().setAmbiente(this.getAmbiente());
            ret.getComprovante().setNumeroProtocolo(this.getNrProtocolo());
            ret.getComprovante().setDatacancelamento(Util.formataData(this.getDataCancelamento(), Util.FMTYYYYMMDDhhmmss));
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RetCancNFeXML.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)"iso-8859-1");
            StringWriter writer = new StringWriter();
            m.marshal((Object)ret, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getXmlRetCancelIntegraSEFAZ() {
        TRetCancNFe.InfCanc infCanc = new TRetCancNFe.InfCanc();
        SimpleDateFormat formatDate2 = new SimpleDateFormat("yyyyMMdd");
        try {
            Date data;
            GregorianCalendar calendar;
            if (this.status != null && this.status == StatusCancelamentoNFE.SUCESSO) {
                infCanc.setCStat("101");
                infCanc.setCUF(this.getNrDocumentoReferente().substring(0, 2));
                infCanc.setChNFe(this.getNrDocumentoReferente());
                calendar = new GregorianCalendar();
                data = calendar.getTime();
                infCanc.setDhRecbto(Util.StringToXMLCalendar(formatDate2.format(data)));
                infCanc.setNProt(this.getNrProtocolo());
                infCanc.setTpAmb(this.getAmbiente());
                infCanc.setVerAplic("2.20");
                infCanc.setXMotivo(this.getMsg());
            } else {
                infCanc.setCStat("999");
                if (this.getNrDocumentoReferente() != null) {
                    infCanc.setCUF(this.getNrDocumentoReferente().substring(0, 2));
                    infCanc.setChNFe(this.getNrDocumentoReferente());
                } else {
                    infCanc.setCUF("");
                    infCanc.setChNFe("");
                }
                calendar = new GregorianCalendar();
                data = calendar.getTime();
                infCanc.setDhRecbto(Util.StringToXMLCalendar(formatDate2.format(data)));
                infCanc.setNProt("000000000");
                infCanc.setTpAmb(this.getAmbiente());
                infCanc.setVerAplic("2.20");
                infCanc.setXMotivo(this.getMsg());
            }
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TRetCancNFe.InfCanc.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)false);
            StringWriter writer = new StringWriter();
            m.marshal((Object)infCanc, (Writer)writer);
            return writer.toString();
        }
        catch (Exception ex) {
            Util.readStackTrace(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gerarXML(String path, String nomeArquivo) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            writer.println(this.getXmlRetCancelIntegra());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gerarXML_SEFAZ(String path, String nomeArquivo, String xmlEnvio) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            Object xmlRetorno = this.getXmlRetCancelIntegraSEFAZ();
            Integer inicio = xmlEnvio.indexOf("<cancNFe", 0);
            Integer fim = xmlEnvio.indexOf("</cancNFe>", 0) + 10;
            xmlEnvio = xmlEnvio.substring(inicio, fim);
            Integer inicio2 = ((String)xmlRetorno).indexOf("<infCanc", 0);
            Integer fim2 = ((String)xmlRetorno).indexOf("</infCanc>", 0) + 10;
            xmlRetorno = ((String)xmlRetorno).substring(inicio2, fim2);
            xmlRetorno = "<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"yes\" ?><procCancNFe versao=\"1.07\" xmlns=\"http://www.portalfiscal.inf.br/nfe\">" + xmlEnvio + "<retCancNFe versao=\"1.07\" xmlns=\"http://www.portalfiscal.inf.br/nfe\">" + (String)xmlRetorno + "</retCancNFe></procCancNFe>";
            writer.println((String)xmlRetorno);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gerarTXT(String path, String nomeArquivo) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            writer.println("001|" + this.getNrCNPJEmitente() + "|" + this.getNrDocumentoReferente() + "|" + this.getNrDocumento() + "|" + Short.toString(this.getNrSerie()) + "|" + this.getStatus() + "|" + this.getMsg());
            if (this.status != null && this.status == StatusCancelamentoNFE.SUCESSO) {
                writer.println("002|" + this.getAmbiente() + "|" + this.getNrProtocolo() + "|" + Util.formataData(this.getDataCancelamento(), Util.FMTYYYYMMDDhhmmss));
            }
        }
    }

    public String getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
    }

    public String getNrProtocolo() {
        return this.nrProtocolo;
    }

    public void setNrProtocolo(String nrProtocolo) {
        this.nrProtocolo = nrProtocolo;
    }

    public Date getDataCancelamento() {
        return this.dataCancelamento;
    }

    public void setDataCancelamento(Date dataAutorizacao) {
        this.dataCancelamento = dataAutorizacao;
    }

    public String getChaveAcesso() {
        return this.chaveAcesso;
    }

    public void setChaveAcesso(String chaveAcesso) {
        this.chaveAcesso = chaveAcesso;
    }
}

