/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.util;

import br.com.ophos.enumerations.TipoOBJ;
import br.com.ophos.util.Adapter;
import br.com.ophos.util.Builder;
import br.com.ophos.util.Parametros;
import br.com.ophos.util.PropertiesAdapter;
import br.com.ophos.util.Propriedade;
import java.lang.reflect.Field;
import java.util.Properties;

public class ParametrosBuilder
implements Builder<Parametros, Properties> {
    private String prefix;

    @Override
    public Parametros load(Properties p) throws Exception {
        Field[] fields;
        Parametros parametros = null;
        if (this.getPrefix().toUpperCase().equals("NFE.")) {
            parametros = new Parametros(TipoOBJ.NFE);
        }
        if (this.getPrefix().toUpperCase().equals("CTE.")) {
            parametros = new Parametros(TipoOBJ.CTE);
        }
        if (this.getPrefix().toUpperCase().equals("MDFE.")) {
            parametros = new Parametros(TipoOBJ.MDFE);
        }
        if (this.getPrefix().toUpperCase().equals("NFSE.")) {
            parametros = new Parametros(TipoOBJ.NFSE);
        }
        if (this.getPrefix().toUpperCase().equals("CTEOS.")) {
            parametros = new Parametros(TipoOBJ.CTEOS);
        }
        for (Field f : fields = parametros.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.isAnnotationPresent(Propriedade.class)) {
                Propriedade propriedade = f.getAnnotation(Propriedade.class);
                String value = p.getProperty(this.getPrefix() + propriedade.key());
                if (value != null) {
                    if (f.getType().equals(Integer.class)) {
                        f.set(parametros, Integer.parseInt(value));
                    } else if (f.getType().equals(Boolean.class)) {
                        f.set(parametros, Boolean.parseBoolean(value));
                    } else {
                        f.set(parametros, value);
                    }
                    if (f.isAnnotationPresent(Adapter.class)) {
                        try {
                            Adapter adapter = f.getAnnotation(Adapter.class);
                            Object obj = adapter.value().newInstance();
                            PropertiesAdapter prop = (PropertiesAdapter)obj;
                            f.set(parametros, prop.unmarshal(f.get(parametros)));
                        }
                        catch (ClassCastException e) {
                            throw new IllegalArgumentException("Adaptador inv\u00e1lido!!");
                        }
                    }
                }
            }
            f.setAccessible(false);
        }
        return parametros;
    }

    @Override
    public Properties build(Parametros obj) throws Exception {
        Field[] fields;
        Properties properties = new Properties();
        for (Field f : fields = obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.isAnnotationPresent(Propriedade.class)) {
                Propriedade p = f.getAnnotation(Propriedade.class);
                Object value = f.get(obj);
                if (value != null) {
                    properties.setProperty(this.getPrefix() + p.key(), String.valueOf(value));
                    if (f.isAnnotationPresent(Adapter.class)) {
                        try {
                            Adapter adapter = f.getAnnotation(Adapter.class);
                            Object ad = adapter.value().newInstance();
                            PropertiesAdapter prop = (PropertiesAdapter)ad;
                            properties.setProperty(this.getPrefix() + p.key(), String.valueOf(prop.marshal(value)));
                        }
                        catch (ClassCastException e) {
                            throw new IllegalArgumentException("Adaptador inv\u00e1lido!!");
                        }
                    }
                }
            }
            f.setAccessible(false);
        }
        return properties;
    }

    public static ParametrosBuilder newInstance(String prefix) {
        return new ParametrosBuilder(prefix);
    }

    public ParametrosBuilder(String prefix) {
        this.prefix = prefix;
        if (this.prefix != null) {
            this.prefix = this.prefix + ".";
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

