/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.util.nfe;

import br.com.ophos.integracao.interfaces.cte.dto.evento.ElementoCCe;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.AmbienteSistema;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.CondicaoVeiculo;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.Crt;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.DestinoOperacao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.EscolhaSN;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.FinalidadeEmissao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.FormaPagamento;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.IncentivoFiscal;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.IndicadorISS;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.ItemCompoeTotal;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.ModalidadeBCICMS;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.ModalidadeBCICMSST;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.ModalidadeFrete;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.MotivoDesoneracao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.OrigemMercadoria;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.OrigemProcesso;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.PresencaComprador;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RegimeEspecial;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetConsultaEnvio;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetEnvio;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaCFAliq;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaCFNT;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaICMS;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaICMSST;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaIPINT;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaIPITrib;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaISSQN;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaPISAliq;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.SituacaoTributariaPISNT;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.StatusConsulta;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.StatusEnvio;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.StatusServico;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.TipoArma;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.TipoAtoConcessionario;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.TipoBandeira;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.TipoDocumento;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.TipoInscricaoEstadual;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.TipoIntegracao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.TipoIntermedio;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.TipoOperacao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.TipoPagamento;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.TipoRestricao;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.ViaTransporte;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.VinVeiculo;
import br.com.ophos.integracao.interfaces.nfe.dto.evento.StatusEvento;
import br.com.ophos.integracao.interfaces.nfe.dto.evento.TipoEvento;
import br.com.ophos.parse.ParseException;
import br.com.ophos.util.FormatoImpressao;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class Util {
    public static String FMTYYYYMMDD = "yyyyMMdd";
    public static String FMTYYYY_MM_DD = "yyyy-MM-dd";
    public static String FMTYYYYMMDDhhmmss = "yyyyMMddHHmmss";
    public static String FMTYYYY_MM_DDhhmmss = "yyyy-MM-dd HH:mm:ss";
    public static int ST_FMT_ZERO_DECIMAIS = 0;
    public static int ST_FMT_DOIS_DECIMAIS = 2;
    public static int ST_FMT_TRES_DECIMAIS = 3;
    public static int ST_FMT_QUATRO_DECIMAIS = 4;
    public static int ST_FMT_DEZ_DECIMAIS = 10;

    public static Integer GetQtdDelimiter(String line, String delimiter) {
        Integer qtdRetorno = 0;
        char[] caracters = line.toCharArray();
        for (int i = 0; i < caracters.length; ++i) {
            String charac = String.valueOf(caracters[i]);
            if (!charac.equals(delimiter)) continue;
            qtdRetorno = qtdRetorno + 1;
        }
        return qtdRetorno;
    }

    public static String limpaString(String str, String charsToKeep) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (charsToKeep.indexOf(ch) > -1) {
                buffer.append(ch);
                continue;
            }
            if (ch == '\r') {
                buffer.append("\r");
                continue;
            }
            if (ch == '\n') {
                buffer.append("\n");
                continue;
            }
            System.out.println("Caractere especial encontrado: " + ch + " na string: " + str);
        }
        return buffer.toString();
    }

    public static String retiraCaracteres(String str) {
        if (str != null) {
            String[] strAcentuada = new String[]{"\u00e7", "\u00c7", "\u00e1", "\u00c1", "\u00e3", "\u00c3", "\u00e9", "\u00c9", "\u00ed", "\u00cd", "\u00f3", "\u00d3", "\u00f4", "\u00d4", "\u00f5", "\u00d5", "\u00fa", "\u00da", "\u00ba", "&", "#13", "\u00ea", "\u00ca", "\u00a7", "\u00aa", "\u00c2", "\u00c4", "\u00dc", "\u00b4", "\u00b0", "\u00bf", "\u00e2", "\u00d8", "`", "\u00c0", "\u00d1", "\u00f1", "\u00e0", "\u20ac", "\u00b5", "\u00c5", "\u2021", "\u2013", "\u00a6", "\u00f9", "\u00d9", "\u00af", "\u00b2", "\u00b3"};
            List<String> lsAcentuada = Arrays.asList(strAcentuada);
            String[] strTrocada = new String[]{"c", "C", "a", "A", "a", "A", "e", "e", "i", "I", "o", "O", "o", "O", "o", "O", "u", "U", ".", " ", " ", "e", "E", " ", " ", "A", "A", "U", " ", " ", " ", "a", "d", " ", "A", "N", "n", "a", " ", " ", "I", " ", " ", " ", "u", "U", " ", "2", "3"};
            List<String> lsTrocada = Arrays.asList(strTrocada);
            Object words = str;
            for (int i = 0; i < ((String)words).length(); ++i) {
                char letra = ((String)words).charAt(i);
                String sLetra = String.valueOf(letra);
                if (lsAcentuada.indexOf(sLetra) == -1) continue;
                words = ((String)words).substring(0, i) + lsTrocada.get(lsAcentuada.indexOf(sLetra)) + ((String)words).substring(i + 1, ((String)words).length());
            }
            return ((String)words).trim();
        }
        return str;
    }

    public static void retiraCaracteres(Object obj, String caracteresPermitidos) throws Exception {
        Field[] fields;
        for (Field f : fields = obj.getClass().getDeclaredFields()) {
            ArrayList<String> values;
            f.setAccessible(true);
            if (f.getType().getName().startsWith("java.lang.String")) {
                Object value = f.get(obj);
                if (value != null) {
                    String strLimpa = Util.limpaString(value.toString(), caracteresPermitidos);
                    f.set(obj, strLimpa);
                }
            } else if (f.getType().toString().startsWith("class ws.") || f.getType().toString().startsWith("class br.")) {
                Object objValue = f.get(obj);
                if (objValue != null && !f.getType().isEnum()) {
                    Util.retiraCaracteres(objValue, caracteresPermitidos);
                }
            } else if (f.getType().getName().startsWith("java.util.List") && (values = (ArrayList<String>)f.get(obj)) != null) {
                if (values.get(0) instanceof String) {
                    ArrayList interar = new ArrayList(values);
                    values = new ArrayList<String>();
                    for (String item : interar) {
                        values.add(Util.limpaString(item, caracteresPermitidos));
                    }
                    f.set(obj, values);
                } else {
                    for (Object e : values) {
                        Util.retiraCaracteres(e, caracteresPermitidos);
                    }
                }
            }
            f.setAccessible(false);
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        return Util.getBytesFromFile(is);
    }

    public static byte[] getBytesFromFile(InputStream is) throws IOException {
        int offset;
        long length = is.available();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file ");
        }
        is.close();
        return bytes;
    }

    public static Integer StringToInteger(String txt) {
        try {
            txt = txt.trim();
            return Integer.parseInt(txt);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Short StringToShort(String txt) {
        try {
            return Short.parseShort(txt);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Byte StringToByte(String txt) {
        try {
            return Byte.parseByte(txt);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String IntegerToString(Integer num) {
        try {
            return num.toString();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static XMLGregorianCalendar StringToDateTimeWithoutTz(String txt) throws ParseException {
        XMLGregorianCalendar cal = null;
        if (txt != null && !txt.trim().equals("")) {
            try {
                if (txt.length() != 25) {
                    throw new ParseException("A data e hora informada est\u00e1 incorreta. Valor = " + txt);
                }
                DatatypeFactory fac = DatatypeFactory.newInstance();
                GregorianCalendar gc = new GregorianCalendar();
                gc.set(Integer.parseInt(txt.substring(0, 4)), Integer.parseInt(txt.substring(5, 7)), Integer.parseInt(txt.substring(8, 10)), Integer.parseInt(txt.substring(11, 13)), Integer.parseInt(txt.substring(14, 16)), Integer.parseInt(txt.substring(17, 19)));
                cal = fac.newXMLGregorianCalendar(gc);
            }
            catch (Exception e) {
                throw new ParseException("A data e hora informada est\u00e1 incorreta. Valor = " + txt);
            }
        }
        return cal;
    }

    public static XMLGregorianCalendar StringToDateTime(String txt) throws ParseException {
        XMLGregorianCalendar cal = null;
        if (txt != null && !txt.trim().equals("")) {
            try {
                if (txt.length() != 14) {
                    throw new ParseException("A data e hora informada est\u00e1 incorreta. Valor = " + txt);
                }
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddhhmmss");
                DatatypeFactory fac = DatatypeFactory.newInstance();
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTime(fmt.parse(txt));
                cal = fac.newXMLGregorianCalendar(gc);
            }
            catch (Exception e) {
                throw new ParseException("A data e hora informada est\u00e1 incorreta. Valor = " + txt);
            }
        }
        return cal;
    }

    public static Date StringToDate(String txt) throws ParseException {
        return br.com.ophos.util.Util.parseData(txt, FMTYYYYMMDD);
    }

    public static XMLGregorianCalendar StringToXMLCalendar(String txt) throws ParseException {
        XMLGregorianCalendar cal = null;
        if (txt != null && !txt.trim().equals("")) {
            try {
                if (txt.length() != 8) {
                    throw new ParseException("A data informada est\u00e1 incorreta. Valor = " + txt);
                }
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
                DatatypeFactory fac = DatatypeFactory.newInstance();
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTime(fmt.parse(txt));
                cal = fac.newXMLGregorianCalendar(gc);
            }
            catch (Exception e) {
                throw new ParseException("A data informada est\u00e1 incorreta. Valor = " + txt);
            }
        }
        return cal;
    }

    public static Double StringToDouble(String txt) throws ParseException {
        Double obj = null;
        if (txt != null && !txt.trim().isEmpty()) {
            obj = Double.parseDouble(txt);
            return obj;
        }
        return null;
    }

    public static Double StringToDouble(String txt, int casasDecimais) throws ParseException {
        Double ret = null;
        if (txt != null && !txt.trim().equals("")) {
            try {
                Object aux = txt.trim();
                int tam = txt.trim().length();
                aux = tam <= casasDecimais ? "0." + Util.preencheZeroEsquerda((String)aux, casasDecimais) : ((String)aux).substring(0, tam - casasDecimais) + "." + ((String)aux).substring(tam - casasDecimais, tam);
                return Double.parseDouble((String)aux);
            }
            catch (NumberFormatException e) {
                throw new ParseException("O valor " + txt + " informado est\u00e1 incorreto.");
            }
        }
        return ret;
    }

    public static Float StringToFloat(String txt, int casasDecimais) throws ParseException {
        Float ret = null;
        if (txt != null && !txt.trim().equals("")) {
            try {
                Object aux = txt.trim();
                int tam = txt.trim().length();
                aux = tam <= casasDecimais ? "0." + Util.preencheZeroEsquerda((String)aux, casasDecimais) : ((String)aux).substring(0, tam - casasDecimais) + "." + ((String)aux).substring(tam - casasDecimais, tam);
                return Float.valueOf(Float.parseFloat((String)aux));
            }
            catch (NumberFormatException e) {
                throw new ParseException("O valor " + txt + " informado est\u00e1 incorreto.");
            }
        }
        return ret;
    }

    public static Integer enumToInteger(Enum e) {
        try {
            Class<?> classe = Class.forName(e.getClass().getName());
            Class<?>[] Parametros2 = null;
            Method metodo = classe.getMethod("getValue", Parametros2);
            Object valorEnum = metodo.invoke((Object)e, (Object[])Parametros2);
            return (Integer)valorEnum;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String enumToString(Enum e) {
        try {
            Class<?> classe = Class.forName(e.getClass().getName());
            Class<?>[] Parametros2 = null;
            Method metodo = classe.getMethod("getValue", Parametros2);
            Object valorEnum = metodo.invoke((Object)e, (Object[])Parametros2);
            return (String)valorEnum;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static FormaPagamento valueToFormaPagamento(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return FormaPagamento.AVISTA;
                    }
                    case 1: {
                        return FormaPagamento.APRAZO;
                    }
                    case 2: {
                        return FormaPagamento.OUTROS;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoDocumento valueToTipoDocumento(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return TipoDocumento.ENTRADA;
                    }
                    case 1: {
                        return TipoDocumento.SAIDA;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static FormatoImpressao valueToFormatoImpressao(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return FormatoImpressao.RETRATO;
                    }
                    case 1: {
                        return FormatoImpressao.PAISAGEM;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static AmbienteSistema valueToAmbienteSistema(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return AmbienteSistema.PRODUCAO;
                    }
                    case 1: {
                        return AmbienteSistema.HOMOLOGACAO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static FinalidadeEmissao valueToFinalidadeEmissao(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return FinalidadeEmissao.NORMAL;
                    }
                    case 1: {
                        return FinalidadeEmissao.COMPLEMENTAR;
                    }
                    case 2: {
                        return FinalidadeEmissao.AJUSTE;
                    }
                    case 3: {
                        return FinalidadeEmissao.DEVOLUCAO;
                    }
                    case 4: {
                        return FinalidadeEmissao.NOTA_CREDITO;
                    }
                    case 5: {
                        return FinalidadeEmissao.NOTA_DEBITO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static ModalidadeFrete valueToModalidadeFrete(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return ModalidadeFrete.PORCONTAEMITENTE;
                    }
                    case 1: {
                        return ModalidadeFrete.PORCONTADESTINATARIO;
                    }
                    case 2: {
                        return ModalidadeFrete.PORCONTATERCEIRO;
                    }
                    case 3: {
                        return ModalidadeFrete.TRANSPORTE_PROPRIO_REMETENTE;
                    }
                    case 4: {
                        return ModalidadeFrete.TRANSPORTE_PROPRIO_DESTINATARIO;
                    }
                    case 9: {
                        return ModalidadeFrete.SEMFRETE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaICMS valueToSituacaoTributariaICMS(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return SituacaoTributariaICMS.ST_00;
                    }
                    case 1: {
                        return SituacaoTributariaICMS.ST_10;
                    }
                    case 2: {
                        return SituacaoTributariaICMS.ST_20;
                    }
                    case 3: {
                        return SituacaoTributariaICMS.ST_30;
                    }
                    case 4: {
                        return SituacaoTributariaICMS.ST_40;
                    }
                    case 5: {
                        return SituacaoTributariaICMS.ST_41;
                    }
                    case 6: {
                        return SituacaoTributariaICMS.ST_50;
                    }
                    case 7: {
                        return SituacaoTributariaICMS.ST_51;
                    }
                    case 8: {
                        return SituacaoTributariaICMS.ST_60;
                    }
                    case 9: {
                        return SituacaoTributariaICMS.ST_70;
                    }
                    case 10: {
                        return SituacaoTributariaICMS.ST_90;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static OrigemMercadoria valueToOrigemMercadoria(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return OrigemMercadoria.NACIONAL;
                    }
                    case 1: {
                        return OrigemMercadoria.IMPORTACAO_DIRETA;
                    }
                    case 2: {
                        return OrigemMercadoria.ADQUIRIDA_MERCADO_INTERNO;
                    }
                    case 3: {
                        return OrigemMercadoria.NACIONAL_SUPERIOR_40;
                    }
                    case 4: {
                        return OrigemMercadoria.NACIONAL_PROCESSO_BASICO;
                    }
                    case 5: {
                        return OrigemMercadoria.NACIONAL_INFERIOR_40;
                    }
                    case 6: {
                        return OrigemMercadoria.IMPORTACAO_DIRETA_SEM_SIMILAR;
                    }
                    case 7: {
                        return OrigemMercadoria.ADQUIRIDA_MERCADO_INTERNO_SEM_SIMILAR;
                    }
                    case 8: {
                        return OrigemMercadoria.NACIONAL_CONTEUDO_IMPORTACAO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static ModalidadeBCICMS valueToModalidadeBCICMS(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return ModalidadeBCICMS.MARGEM_AGREGADO;
                    }
                    case 1: {
                        return ModalidadeBCICMS.PAUTA;
                    }
                    case 2: {
                        return ModalidadeBCICMS.PRECO_TABELADO;
                    }
                    case 3: {
                        return ModalidadeBCICMS.VALOR_OPERACAO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static ModalidadeBCICMSST valueToModalidadeBCICMSST(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return ModalidadeBCICMSST.PRECO_TABELADO;
                    }
                    case 1: {
                        return ModalidadeBCICMSST.LISTA_NEGATIVA;
                    }
                    case 2: {
                        return ModalidadeBCICMSST.LISTA_POSITIVA;
                    }
                    case 3: {
                        return ModalidadeBCICMSST.LISTA_NEUTRA;
                    }
                    case 4: {
                        return ModalidadeBCICMSST.VALOR_AGREGADO;
                    }
                    case 5: {
                        return ModalidadeBCICMSST.PAUTA;
                    }
                    case 6: {
                        return ModalidadeBCICMSST.VALOR_OPERACAO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaIPITrib valueToSituacaoTributariaIPITrib(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return SituacaoTributariaIPITrib.ST_00;
                    }
                    case 6: {
                        return SituacaoTributariaIPITrib.ST_49;
                    }
                    case 7: {
                        return SituacaoTributariaIPITrib.ST_50;
                    }
                    case 13: {
                        return SituacaoTributariaIPITrib.ST_99;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaIPINT valueToSituacaoTributariaIPINT(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return SituacaoTributariaIPINT.ST_01;
                    }
                    case 2: {
                        return SituacaoTributariaIPINT.ST_02;
                    }
                    case 3: {
                        return SituacaoTributariaIPINT.ST_03;
                    }
                    case 4: {
                        return SituacaoTributariaIPINT.ST_04;
                    }
                    case 5: {
                        return SituacaoTributariaIPINT.ST_05;
                    }
                    case 8: {
                        return SituacaoTributariaIPINT.ST_51;
                    }
                    case 9: {
                        return SituacaoTributariaIPINT.ST_52;
                    }
                    case 10: {
                        return SituacaoTributariaIPINT.ST_53;
                    }
                    case 11: {
                        return SituacaoTributariaIPINT.ST_54;
                    }
                    case 12: {
                        return SituacaoTributariaIPINT.ST_55;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaPISAliq valueToSituacaoTributariaPISAliq(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return SituacaoTributariaPISAliq.ST_01;
                    }
                    case 1: {
                        return SituacaoTributariaPISAliq.ST_02;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaPISNT valueToSituacaoTributariaPISNT(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 3: {
                        return SituacaoTributariaPISNT.ST_04;
                    }
                    case 4: {
                        return SituacaoTributariaPISNT.ST_06;
                    }
                    case 5: {
                        return SituacaoTributariaPISNT.ST_07;
                    }
                    case 6: {
                        return SituacaoTributariaPISNT.ST_08;
                    }
                    case 7: {
                        return SituacaoTributariaPISNT.ST_09;
                    }
                    case 8: {
                        return SituacaoTributariaPISNT.ST_05;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaCFAliq valueToSituacaoTributariaCFAliq(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return SituacaoTributariaCFAliq.ST_01;
                    }
                    case 1: {
                        return SituacaoTributariaCFAliq.ST_02;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaCFNT valueToSituacaoTributariaCFNT(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 3: {
                        return SituacaoTributariaCFNT.ST_04;
                    }
                    case 4: {
                        return SituacaoTributariaCFNT.ST_06;
                    }
                    case 5: {
                        return SituacaoTributariaCFNT.ST_07;
                    }
                    case 6: {
                        return SituacaoTributariaCFNT.ST_08;
                    }
                    case 7: {
                        return SituacaoTributariaCFNT.ST_09;
                    }
                    case 8: {
                        return SituacaoTributariaCFNT.ST_05;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoOperacao valueToTipoOperacao(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return TipoOperacao.VENDA_CONCESSIONARIA;
                    }
                    case 1: {
                        return TipoOperacao.FATURA_DIRETA;
                    }
                    case 2: {
                        return TipoOperacao.VENDA_DIRETA;
                    }
                    case 3: {
                        return TipoOperacao.OUTROS;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoOperacao valueToTipoOperacaoXMLSEFAZ(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return TipoOperacao.OUTROS;
                    }
                    case 1: {
                        return TipoOperacao.VENDA_CONCESSIONARIA;
                    }
                    case 2: {
                        return TipoOperacao.FATURA_DIRETA;
                    }
                    case 3: {
                        return TipoOperacao.VENDA_DIRETA;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CondicaoVeiculo valueToCondicaoVeiculo(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return CondicaoVeiculo.ACABADO;
                    }
                    case 1: {
                        return CondicaoVeiculo.INACABADO;
                    }
                    case 2: {
                        return CondicaoVeiculo.SEMI_ACABADO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CondicaoVeiculo valueToCondicaoVeiculoXMLSEFAZ(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return CondicaoVeiculo.ACABADO;
                    }
                    case 2: {
                        return CondicaoVeiculo.INACABADO;
                    }
                    case 3: {
                        return CondicaoVeiculo.SEMI_ACABADO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoArma valueToTipoArma(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return TipoArma.USO_PERMITIDO;
                    }
                    case 1: {
                        return TipoArma.USO_RESTRITO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Crt valueToCrt(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return Crt.SIMPLES_NACIONAL;
                    }
                    case 2: {
                        return Crt.SIMPLES_NACIONAL_EXCESSO;
                    }
                    case 3: {
                        return Crt.REGIME_NORMAL;
                    }
                    case 4: {
                        return Crt.SIMPLES_NACIONAL_MEI;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static ItemCompoeTotal valueToCompoeTotal(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return ItemCompoeTotal.NAO_COMPOE_TOTAL;
                    }
                    case 1: {
                        return ItemCompoeTotal.COMPOE_TOTAL;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static MotivoDesoneracao valueToMotivoDesoneracao(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return MotivoDesoneracao.TAXI;
                    }
                    case 2: {
                        return MotivoDesoneracao.DEFICIENTE_FISICO;
                    }
                    case 3: {
                        return MotivoDesoneracao.PRODUTOR;
                    }
                    case 4: {
                        return MotivoDesoneracao.FROTISTA;
                    }
                    case 5: {
                        return MotivoDesoneracao.DIPLOMATICO;
                    }
                    case 6: {
                        return MotivoDesoneracao.UTILITARIOS;
                    }
                    case 7: {
                        return MotivoDesoneracao.SUFRAMA;
                    }
                    case 9: {
                        return MotivoDesoneracao.OUTROS;
                    }
                    case 12: {
                        return MotivoDesoneracao.ORGAO_FOMENTO_DESENVOLVIMETO_AGROPECURARIO;
                    }
                    case 16: {
                        return MotivoDesoneracao.RIO_2016;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaISSQN valueToSituacaoTribISSQN(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return SituacaoTributariaISSQN.NORMAL;
                    }
                    case 1: {
                        return SituacaoTributariaISSQN.RETIDA;
                    }
                    case 2: {
                        return SituacaoTributariaISSQN.SUBSTITUTA;
                    }
                    case 3: {
                        return SituacaoTributariaISSQN.ISENTA;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaISSQN valueToSituacaoTribISS(String valor) {
        if (valor != null && !valor.trim().isEmpty()) {
            if (valor.equals("N")) {
                return SituacaoTributariaISSQN.NORMAL;
            }
            if (valor.equals("R")) {
                return SituacaoTributariaISSQN.RETIDA;
            }
            if (valor.equals("S")) {
                return SituacaoTributariaISSQN.SUBSTITUTA;
            }
            if (valor.equals("I")) {
                return SituacaoTributariaISSQN.ISENTA;
            }
        }
        return null;
    }

    public static SituacaoTributariaICMS valueToSituacaoTribIcmsPartilha(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return SituacaoTributariaICMS.ST_10;
                    }
                    case 1: {
                        return SituacaoTributariaICMS.ST_90;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaICMS valueToSituacaoTribIcmsST(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return SituacaoTributariaICMS.ST_41;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoRestricao valueToTipoRestricao(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return TipoRestricao.NAO_HA;
                    }
                    case 1: {
                        return TipoRestricao.ALIENACAO_FIDUCIARIA;
                    }
                    case 2: {
                        return TipoRestricao.ARRENDAMENTO_MERCANTIL;
                    }
                    case 3: {
                        return TipoRestricao.RESERVA_DOMINIO;
                    }
                    case 4: {
                        return TipoRestricao.PENHOR_VEICULO;
                    }
                    case 9: {
                        return TipoRestricao.OUTRAS;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static VinVeiculo valueToVinVeiculo(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                if (valor.equals("R")) {
                    return VinVeiculo.REMARCADO;
                }
                if (valor.equals("N")) {
                    return VinVeiculo.NORMAL;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String preencheZeroEsquerda(String num, int tamanho) {
        if (((String)num).length() == tamanho) {
            return num;
        }
        while (((String)num).length() < tamanho) {
            num = "0" + (String)num;
        }
        return num;
    }

    public static File[] listaArquivos(String dir, final String filtro) throws Exception {
        File directory = new File(dir);
        if (!directory.exists()) {
            throw new Exception("Diretorio: " + dir + " nao encontrado");
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().matches(filtro);
            }
        };
        return directory.listFiles(filter);
    }

    public static String formataData(Date data, String formato) {
        SimpleDateFormat fmt = new SimpleDateFormat(formato);
        return fmt.format(data);
    }

    public static String readStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static StatusEnvio valueToStatusEnvioNFe(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 11: {
                        return StatusEnvio.ERRO_VALIDACAO;
                    }
                    case 12: {
                        return StatusEnvio.ERRO_XML;
                    }
                    case 13: {
                        return StatusEnvio.ERRO_ASSINATURA;
                    }
                    case 99: {
                        return StatusEnvio.ERRO_GERAL;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String statusEnvioToValue(RetEnvio.StatusEnvio status) {
        if (status != null) {
            try {
                switch (status) {
                    case ERRO_ASSINATURA: {
                        return "13";
                    }
                    case ERRO_GERAL: {
                        return "99";
                    }
                    case ERRO_NF_JA_AUTORIZADA: {
                        return "20";
                    }
                    case ERRO_VALIDACAO: {
                        return "11";
                    }
                    case ERRO_XML: {
                        return "12";
                    }
                    case SUCESSO: {
                        return "1";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String statusConsultaNFeToValue2(StatusConsulta status) {
        if (status != null) {
            try {
                switch (status) {
                    case AUTORIZADA: {
                        return "1";
                    }
                    case CANCELADA: {
                        return "2";
                    }
                    case EM_CONTINGENCIA: {
                        return "4";
                    }
                    case DENEGADA: {
                        return "3";
                    }
                    case EM_PROCESSAMENTO: {
                        return "5";
                    }
                    case INUTILIZADA: {
                        return "6";
                    }
                    case NAO_ENCONTRADO: {
                        return "7";
                    }
                    case ERRO_GERAL: {
                        return "99";
                    }
                    case REJEITADA: {
                        return "8";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String statusConsultaNFeToValue(RetConsultaEnvio.StatusConsultaEnvio status) {
        if (status != null) {
            try {
                switch (status) {
                    case AUTORIZADA: {
                        return "1";
                    }
                    case CONTINGENCIA_ENVIO: {
                        return "23";
                    }
                    case CONTINGENCIA_RETORNO: {
                        return "24";
                    }
                    case DENEGADA: {
                        return "2";
                    }
                    case EM_PROCESSAMENTO: {
                        return "22";
                    }
                    case ERRO_PROCESSAMENTO: {
                        return "99";
                    }
                    case ERRO_VALIDACAO: {
                        return "11";
                    }
                    case NAO_ENCONTRADO: {
                        return "25";
                    }
                    case REJEITADA: {
                        return "3";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String statusEnvioNfeToValue(RetEnvio.StatusEnvio valor) {
        if (valor != null) {
            switch (valor) {
                case ERRO_ASSINATURA: {
                    return "13";
                }
                case ERRO_NF_JA_AUTORIZADA: {
                    return "1";
                }
                case ERRO_GERAL: {
                    return "99";
                }
                case ERRO_VALIDACAO: {
                    return "11";
                }
                case ERRO_XML: {
                    return "12";
                }
                case SUCESSO: {
                    return "22";
                }
            }
        } else {
            return "10";
        }
        return "";
    }

    public static String statusCancelamentoToValue(StatusEvento status) {
        if (status != null) {
            try {
                switch (status) {
                    case ERRO_REGISTRO: {
                        return "12";
                    }
                    case ERRO_DUPLICIDADE: {
                        return "13";
                    }
                    case ERRO_VALIDACAO: {
                        return "11";
                    }
                    case SUCESSO: {
                        return "1";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String statusConsultaStatusServicoToValue(StatusServico status) {
        if (status != null) {
            try {
                switch (status) {
                    case ERRO_GERAL: {
                        return "99";
                    }
                    case SERVICO_OPERACIONAL: {
                        return "1";
                    }
                    case SERVICO_PARALISADO_M: {
                        return "2";
                    }
                    case SERVICO_PARALISADO_SP: {
                        return "3";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String statusAmbienteSistemaToValue(AmbienteSistema status) {
        if (status != null) {
            try {
                switch (status) {
                    case HOMOLOGACAO: {
                        return "1";
                    }
                    case PRODUCAO: {
                        return "0";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String statusAmbienteSistemaEventoToValue(AmbienteSistema status) {
        if (status != null) {
            try {
                switch (status) {
                    case HOMOLOGACAO: {
                        return "1";
                    }
                    case PRODUCAO: {
                        return "0";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoEvento valueToTipoManifestacao(String valor) throws Exception {
        if (valor != null && !valor.trim().equals("")) {
            switch (Integer.parseInt(valor)) {
                case 1: {
                    return TipoEvento.CONFIRMACAO_OPERACAO;
                }
                case 2: {
                    return TipoEvento.CIENCIA_OPERACAO;
                }
                case 3: {
                    return TipoEvento.DESCONHECIMENTO_OPERACAO;
                }
                case 4: {
                    return TipoEvento.OPERACAO_NAO_REALIZADA;
                }
                case 999: {
                    return TipoEvento.CANCELAMENTO;
                }
                case 0: {
                    return TipoEvento.CARTA_CORRECAO;
                }
            }
            throw new Exception("Tipo de manifesta\u00e7\u00e3o inv\u00e1lida ou n\u00e3o informada.");
        }
        return null;
    }

    public static TipoEvento valueToTipoManifestacaoXML(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                if (valor.equals("210200")) {
                    return TipoEvento.CONFIRMACAO_OPERACAO;
                }
                if (valor.equals("210210")) {
                    return TipoEvento.CIENCIA_OPERACAO;
                }
                if (valor.equals("210220")) {
                    return TipoEvento.DESCONHECIMENTO_OPERACAO;
                }
                if (valor.equals("210240")) {
                    return TipoEvento.OPERACAO_NAO_REALIZADA;
                }
                if (valor.equals("110111")) {
                    return TipoEvento.CANCELAMENTO;
                }
                if (valor.equals("110110")) {
                    return TipoEvento.CARTA_CORRECAO;
                }
                throw new Exception("Tipo de manifesta\u00e7\u00e3o inv\u00e1lida ou n\u00e3o informada.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String statusRetornoEventoToString(StatusEvento status) {
        if (status != null) {
            try {
                switch (status) {
                    case SUCESSO: {
                        return "0";
                    }
                    case ERRO_DUPLICIDADE: {
                        return "1";
                    }
                    case ERRO_VALIDACAO: {
                        return "2";
                    }
                    case ERRO_REGISTRO: {
                        return "3";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static RegimeEspecial valueToRegimeEspecial(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return RegimeEspecial.MICROEMPRESA_MUNICIPAL;
                    }
                    case 2: {
                        return RegimeEspecial.ESTIMATIVA;
                    }
                    case 3: {
                        return RegimeEspecial.SOCIEDADE_PROFISSIONAIS;
                    }
                    case 4: {
                        return RegimeEspecial.COOPERATIVA;
                    }
                    case 5: {
                        return RegimeEspecial.MEI;
                    }
                    case 6: {
                        return RegimeEspecial.ME_EPP;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static DestinoOperacao valueToDestinoOperacao(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return DestinoOperacao.INTERNA;
                    }
                    case 2: {
                        return DestinoOperacao.INTERESTADUAL;
                    }
                    case 3: {
                        return DestinoOperacao.EXTERIOR;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static EscolhaSN valueToEscolhaSN(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return EscolhaSN.NAO;
                    }
                    case 1: {
                        return EscolhaSN.SIM;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static PresencaComprador valueToPresencaComprador(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return PresencaComprador.NAO_APLICAVEL;
                    }
                    case 1: {
                        return PresencaComprador.PRESENCIAL;
                    }
                    case 2: {
                        return PresencaComprador.INTERNET;
                    }
                    case 3: {
                        return PresencaComprador.TELEATENDIMENTO;
                    }
                    case 4: {
                        return PresencaComprador.NFCE_ENTREGA_DOMICILIO;
                    }
                    case 5: {
                        return PresencaComprador.PRESENCIAL_FORA_ESTABELECIMENTO;
                    }
                    case 9: {
                        return PresencaComprador.NAO_PRESENCIAL_OUTROS;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoInscricaoEstadual valueToInscricaoDestinatario(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return TipoInscricaoEstadual.CONTRIBUINTE_ICMS;
                    }
                    case 2: {
                        return TipoInscricaoEstadual.CONTRIBUINTE_ISENTO;
                    }
                    case 9: {
                        return TipoInscricaoEstadual.NAO_CONTRIBUINTE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static IncentivoFiscal valueToIncentivoFiscal(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return IncentivoFiscal.SIM;
                    }
                    case 2: {
                        return IncentivoFiscal.NAO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static IndicadorISS valueToIndicadorISS(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return IndicadorISS.EXIGIVEL;
                    }
                    case 2: {
                        return IndicadorISS.NAO_INCIDENCIA;
                    }
                    case 3: {
                        return IndicadorISS.ISENCAO;
                    }
                    case 4: {
                        return IndicadorISS.EXPORTACAO;
                    }
                    case 5: {
                        return IndicadorISS.IMUNIDADE;
                    }
                    case 6: {
                        return IndicadorISS.EXIGIBILIDADE_SUSPENSA_DECISAO_JUDICIAL;
                    }
                    case 7: {
                        return IndicadorISS.EXIGIBILIDADE_SUSPENSA_PROCESSO_ADM;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoIntermedio valueToTipoIntermedio(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return TipoIntermedio.CONTA_PROPRIA;
                    }
                    case 2: {
                        return TipoIntermedio.CONTA_ORDEM;
                    }
                    case 3: {
                        return TipoIntermedio.ENCOMENDA;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static OrigemProcesso valueToOrigemProcesso(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 0: {
                        return OrigemProcesso.SEFAZ;
                    }
                    case 1: {
                        return OrigemProcesso.JUSTICA_FEDERAL;
                    }
                    case 2: {
                        return OrigemProcesso.JUSTICA_ESTADUAL;
                    }
                    case 3: {
                        return OrigemProcesso.SECEX_RFB;
                    }
                    case 4: {
                        return OrigemProcesso.CONFAZ;
                    }
                    case 9: {
                        return OrigemProcesso.OUTROS;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoAtoConcessionario valueToTipoAtoConcessionario(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 8: {
                        return TipoAtoConcessionario.TERMO_ACORDO;
                    }
                    case 10: {
                        return TipoAtoConcessionario.REGIME_ESPECIAL;
                    }
                    case 12: {
                        return TipoAtoConcessionario.AUTORIZACAO_ESPECIFICA;
                    }
                    case 14: {
                        return TipoAtoConcessionario.AJUSTE_SINIEF;
                    }
                    case 15: {
                        return TipoAtoConcessionario.CONVENIO_ICMS;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static ViaTransporte valueToViaTransporte(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return ViaTransporte.MARITIMA;
                    }
                    case 2: {
                        return ViaTransporte.FLUVIAL;
                    }
                    case 3: {
                        return ViaTransporte.LACUSTRE;
                    }
                    case 4: {
                        return ViaTransporte.AEREA;
                    }
                    case 5: {
                        return ViaTransporte.POSTAL;
                    }
                    case 6: {
                        return ViaTransporte.FERROVIARIA;
                    }
                    case 7: {
                        return ViaTransporte.RODOVIARIA;
                    }
                    case 8: {
                        return ViaTransporte.CONDUTO_REDE_TRANSMISSAO;
                    }
                    case 9: {
                        return ViaTransporte.MEIOS_PROPRIOS;
                    }
                    case 10: {
                        return ViaTransporte.ENTRADA_SAIDA_FICTA;
                    }
                    case 11: {
                        return ViaTransporte.COURIER;
                    }
                    case 12: {
                        return ViaTransporte.EM_MAOS;
                    }
                    case 13: {
                        return ViaTransporte.POR_REBOQUE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoPagamento valueToTipoPagamento(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return TipoPagamento.DINHEIRO;
                    }
                    case 2: {
                        return TipoPagamento.CHEQUE;
                    }
                    case 3: {
                        return TipoPagamento.CARTAO_CREDITO;
                    }
                    case 4: {
                        return TipoPagamento.CARTAO_DEBITO;
                    }
                    case 5: {
                        return TipoPagamento.CREDITO_LOJA;
                    }
                    case 10: {
                        return TipoPagamento.VALE_ALIMENTACAO;
                    }
                    case 11: {
                        return TipoPagamento.VALE_REFEICAO;
                    }
                    case 12: {
                        return TipoPagamento.VALE_PRESENTE;
                    }
                    case 13: {
                        return TipoPagamento.VALE_COMBUSTIVEL;
                    }
                    case 14: {
                        return TipoPagamento.DUPLICATA_MERCANTIL;
                    }
                    case 15: {
                        return TipoPagamento.BOLETO_BANCARIO;
                    }
                    case 16: {
                        return TipoPagamento.DEPOSITO_BANCARIO;
                    }
                    case 17: {
                        return TipoPagamento.PIX;
                    }
                    case 18: {
                        return TipoPagamento.CARTEIRA_DIGITAL;
                    }
                    case 19: {
                        return TipoPagamento.CASHBACK;
                    }
                    case 99: {
                        return TipoPagamento.OUTROS;
                    }
                    case 90: {
                        return TipoPagamento.SEM_PAGAMENTO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoBandeira valueToTipoBandeira(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return TipoBandeira.VISA;
                    }
                    case 2: {
                        return TipoBandeira.MASTERCARD;
                    }
                    case 3: {
                        return TipoBandeira.AMERICAN_EXPRESS;
                    }
                    case 4: {
                        return TipoBandeira.SOROCRED;
                    }
                    case 5: {
                        return TipoBandeira.DINERS;
                    }
                    case 6: {
                        return TipoBandeira.ELO;
                    }
                    case 7: {
                        return TipoBandeira.HIPERCARD;
                    }
                    case 8: {
                        return TipoBandeira.AURA;
                    }
                    case 9: {
                        return TipoBandeira.CABAL;
                    }
                    case 10: {
                        return TipoBandeira.ALELO;
                    }
                    case 11: {
                        return TipoBandeira.BANES_CARD;
                    }
                    case 12: {
                        return TipoBandeira.CALCARD;
                    }
                    case 13: {
                        return TipoBandeira.CREDZ;
                    }
                    case 14: {
                        return TipoBandeira.DISCOVER;
                    }
                    case 15: {
                        return TipoBandeira.GOODCARD;
                    }
                    case 16: {
                        return TipoBandeira.GREENCARD;
                    }
                    case 17: {
                        return TipoBandeira.HIPER;
                    }
                    case 18: {
                        return TipoBandeira.JCB;
                    }
                    case 19: {
                        return TipoBandeira.MAIS;
                    }
                    case 20: {
                        return TipoBandeira.MAXVAN;
                    }
                    case 21: {
                        return TipoBandeira.POLICARD;
                    }
                    case 22: {
                        return TipoBandeira.REDECOMPRAS;
                    }
                    case 23: {
                        return TipoBandeira.SOXDEXO;
                    }
                    case 24: {
                        return TipoBandeira.VALECARD;
                    }
                    case 25: {
                        return TipoBandeira.VEROCHEQUE;
                    }
                    case 26: {
                        return TipoBandeira.VR;
                    }
                    case 27: {
                        return TipoBandeira.TICKET;
                    }
                    case 99: {
                        return TipoBandeira.OUTROS;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TipoIntegracao valueToTipoIntegracao(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (Integer.parseInt(valor)) {
                    case 1: {
                        return TipoIntegracao.INTEGRADO;
                    }
                    case 2: {
                        return TipoIntegracao.NAO_INTEGRADO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static EscolhaSN valueToProducaoEscala(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (valor) {
                    case "0": {
                        return EscolhaSN.SIM;
                    }
                    case "1": {
                        return EscolhaSN.NAO;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static SituacaoTributariaICMSST valueToSituacaoTributariaICMSST(String valor) {
        if (valor != null && !valor.trim().equals("")) {
            try {
                switch (valor) {
                    case "0": {
                        return SituacaoTributariaICMSST.ST_41;
                    }
                    case "1": {
                        return SituacaoTributariaICMSST.ST_60;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static class EnvInutilizacaoV200
    extends EnvInutilizacao {
        public String nrIe;
    }

    public static class EnvInutilizacao {
        public String cnpjEmitente;
        public String nrAno;
        public String nrSerie;
        public String nrIni;
        public String nrFim;
        public String justificativa;
        public String usuario;
        public String ambiente;
    }

    public static class EnvCancelamentoV200
    extends EnvCancelamento {
        public String nrIE;
    }

    public static class EnvCancelamento {
        public String cnpjEmitente;
        public String nrReferente;
        public String nrDocumento;
        public String nrSerie;
        public String justificativa;
        public TipoEvento tpManifestacao;
        public String usuario;
    }

    public static class EnvConsultaStatus {
        public String cnpjEmitente;
        public String nrIe;
    }

    public static class EnvEvento200
    extends EnvEvento101 {
        public List<ElementoCCe> elementos;
    }

    public static class EnvEvento102
    extends EnvEvento {
        public String cnpjEmitente;
        public String ieEmitente;
        public String DescricaoCC;
        public TipoEvento tpManifestacao;
    }

    public static class EnvEvento101
    extends EnvEvento {
        public String cnpjEmitente;
        public String ieEmitente;
        public TipoEvento tpManifestacao;
        public Object obj;
    }

    public static class EnvEvento {
        public String chaveAcesso;
        public String tpEvento;
        public String dsDescricao;
        public String usuario;
    }
}

