/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    public static void compress(String sourceFolder, String fileName) throws IOException {
        File file = new File(sourceFolder);
        if (file != null && file.isDirectory()) {
            List<String> fileList = ZipHelper.generateFileList(file, file.getAbsolutePath());
            ZipHelper.zipIt(fileList, fileName, sourceFolder);
        }
    }

    private static void zipIt(List<String> fileList, String zipFile, String sourceFolder) throws IOException {
        byte[] buffer = new byte[1024];
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (String file : fileList) {
            int len;
            ZipEntry ze = new ZipEntry(file);
            zos.putNextEntry(ze);
            FileInputStream fis = new FileInputStream(String.valueOf(sourceFolder) + File.separator + file);
            while ((len = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            fis.close();
        }
        zos.closeEntry();
        zos.close();
        zos.flush();
    }

    private static List<String> generateFileList(File node, String sourceFolder) {
        ArrayList<String> fileList = new ArrayList<String>();
        if (node.isFile()) {
            fileList.add(ZipHelper.generateZipEntry(node.getAbsoluteFile().toString(), sourceFolder));
        }
        if (node.isDirectory()) {
            String[] subNote;
            String[] stringArray = subNote = node.list();
            int n = subNote.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                fileList.addAll(ZipHelper.generateFileList(new File(node, filename), sourceFolder));
                ++n2;
            }
        }
        return fileList;
    }

    private static String generateZipEntry(String file, String sourceFolder) {
        return file.substring(sourceFolder.length() + 1, file.length());
    }
}

