/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.interfaces;

import br.com.ophos.util.Util;
import br.com.ophos.xml.nfse.consulta.v100.RetConsultaNfse;
import br.com.ophos.xml.nfse.envio.v100.Rps;
import br.com.ophos.xml.nfse.evento.EventoNFSE;
import br.com.ophos.xml.nfse.evento.retorno.v100.RetEnvioCancelamentoNfse;
import br.com.ophos.xml.nfse.retorno.v100.RetEnvioRps;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class NFSeInterface {
    private String wsEvento = "";
    private String wsRps = "";
    private String token = "";
    private Integer timeOut = 5;
    static final JAXBContext jaxbContextRps = NFSeInterface.iniciarContextoRps();
    static final JAXBContext jaxbContextRetEnvioRps = NFSeInterface.iniciarContextoRetEnvioRps();
    static final JAXBContext jaxbContextRetEnvioEvento = NFSeInterface.iniciarContextoRetEnvioEvento();
    static final JAXBContext jaxbContextRetConsultaNfse = NFSeInterface.iniciarContextoRetConsultaNfse();

    public NFSeInterface(String wsManifesto, String token, Integer timeoutP) {
        this.wsRps = wsManifesto + "/nfse/service/";
        this.wsEvento = wsManifesto + "/nfse/service/";
        this.token = token;
        this.timeOut = timeoutP;
    }

    private static JAXBContext iniciarContextoRps() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{Rps.class});
        }
        catch (JAXBException ex) {
            Logger.getLogger(NFSeInterface.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static JAXBContext iniciarContextoRetEnvioRps() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{RetEnvioRps.class});
        }
        catch (JAXBException ex) {
            Logger.getLogger(NFSeInterface.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static JAXBContext iniciarContextoRetEnvioEvento() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{RetEnvioCancelamentoNfse.class});
        }
        catch (JAXBException ex) {
            Logger.getLogger(NFSeInterface.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static JAXBContext iniciarContextoRetConsultaNfse() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{RetConsultaNfse.class});
        }
        catch (JAXBException ex) {
            Logger.getLogger(NFSeInterface.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public RetEnvioCancelamentoNfse enviarCancelamento(EventoNFSE evento) throws Exception {
        String uri = this.wsEvento + "cancelamento/" + evento.getHash() + "?justificativa=" + evento.getJustificativa() + "&tipo=" + evento.getTipoCancelamento();
        URL url = Util.stringToUrl(uri);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        conn.setRequestProperty("x-access-token", this.token);
        Unmarshaller jaxbUnmarshaller = jaxbContextRetEnvioEvento.createUnmarshaller();
        RetEnvioCancelamentoNfse retCancelamento = (RetEnvioCancelamentoNfse)jaxbUnmarshaller.unmarshal(conn.getInputStream());
        conn.disconnect();
        return retCancelamento;
    }

    public RetEnvioRps enviarRps(Rps rps) throws Exception {
        URL url = Util.stringToUrl(this.wsRps + "recepcao/");
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/xml");
        conn.setRequestProperty("x-access-token", this.token);
        conn.setConnectTimeout(this.getTimeOut() * 1000);
        conn.setReadTimeout(this.getTimeOut() * 1000);
        conn.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        Marshaller jaxbMarshaller = jaxbContextRps.createMarshaller();
        jaxbMarshaller.marshal((Object)rps, (OutputStream)wr);
        wr.flush();
        wr.close();
        Unmarshaller jaxbUnmarshaller = jaxbContextRetEnvioRps.createUnmarshaller();
        RetEnvioRps retRps = (RetEnvioRps)jaxbUnmarshaller.unmarshal(conn.getInputStream());
        conn.disconnect();
        return retRps;
    }

    public RetConsultaNfse retornoConsultaNfse(String hash) throws Exception {
        URL url = Util.stringToUrl(this.wsRps + "consulta/" + hash);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        conn.setRequestProperty("x-access-token", this.token);
        Unmarshaller jaxbUnmarshaller = jaxbContextRetConsultaNfse.createUnmarshaller();
        RetConsultaNfse retConsulta = (RetConsultaNfse)jaxbUnmarshaller.unmarshal(conn.getInputStream());
        conn.disconnect();
        return retConsulta;
    }

    public RetConsultaNfse retornoConsultaNfse(String cnpj, String numero, String serie) throws Exception {
        URL url = Util.stringToUrl(this.wsRps + "consulta/?cnpj=" + cnpj + "&numero=" + numero + "&serie=" + serie);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        conn.setRequestProperty("x-access-token", this.token);
        Unmarshaller jaxbUnmarshaller = jaxbContextRetConsultaNfse.createUnmarshaller();
        RetConsultaNfse retConsulta = (RetConsultaNfse)jaxbUnmarshaller.unmarshal(conn.getInputStream());
        conn.disconnect();
        return retConsulta;
    }

    public Integer getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(Integer timeOut) {
        this.timeOut = timeOut;
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

