/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.monitor;

import br.com.ophos.enumerations.TipoIntegracao;
import br.com.ophos.integracao.admin.config.Parametro;
import br.com.ophos.integracao.admin.config.TipoArmazenamento;
import br.com.ophos.integracao.cte.CteInterface;
import br.com.ophos.integracao.interfaces.averbacao.dto.RetAverbacao;
import br.com.ophos.monitor.BufferDB;
import br.com.ophos.monitor.EnvioIntegracao;
import br.com.ophos.retorno.RetornoCTE;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.cte.V200.AverbacaoCTE;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class ConsumidorAverbacao
implements Runnable {
    private BufferDB sharedLocation;
    private Parametro paramProperties;

    public ConsumidorAverbacao(BufferDB shared, Parametro param) {
        this.sharedLocation = shared;
        this.paramProperties = param;
    }

    private void DeleteTmpFile(EnvioIntegracao objEnvio) throws IOException {
        File file2;
        File file;
        String nomeFilein = objEnvio.getPathFileArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.XML) {
            file = new File(nomeFilein + ".TMX");
            file.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.TXT) {
            file = new File(nomeFilein + ".TMP");
            file.delete();
            file2 = new File(nomeFilein + ".TMX");
            file2.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.BANCO) {
            file = new File(nomeFilein + ".BD");
            file.delete();
            file2 = new File(nomeFilein + ".BDK");
            file2.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.SAP) {
            file = new File(nomeFilein + ".SAP1");
            file.delete();
        }
    }

    @Override
    public void run() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        String nomeFile = "";
        while (true) {
            EnvioIntegracao objEnvio = new EnvioIntegracao();
            objEnvio = (EnvioIntegracao)this.sharedLocation.Get();
            try {
                nomeFile = objEnvio.getNomeArquivo();
                RetAverbacao result = null;
                if (!(objEnvio.getObjEnvio() instanceof AverbacaoCTE)) continue;
                logger.info("Enviando arquivo " + nomeFile);
                if (this.paramProperties.getValidaCaracteres().booleanValue()) {
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - Retirando caracteres especiais...");
                    Util.retiraCaracteres((AverbacaoCTE)objEnvio.getObjEnvio(), this.paramProperties.getCaracteresPermitidos());
                }
                AverbacaoCTE obj = (AverbacaoCTE)objEnvio.getObjEnvio();
                logger.info(this.paramProperties.getVersaoIntegrador() + " - Comunicando com o webservice...");
                RetAverbacao retWS = null;
                switch (obj.getTipo()) {
                    case AVERBAR: {
                        result = CteInterface.averbar(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), obj.getChaveAcesso());
                        break;
                    }
                    case CANCELAR: {
                        result = CteInterface.cancelarAverbacao(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), obj.getChaveAcesso());
                    }
                }
                retWS = result;
                if (retWS == null) {
                    throw new Exception("Erro ao obter retorno do WS de Averba\u00e7\u00e3o");
                }
                logger.info(this.paramProperties.getVersaoIntegrador() + " - " + retWS.getMensagem());
                RetornoCTE.gerarTxtAverbacao(this.paramProperties.getDataOut(), objEnvio.getNomeArquivo(), retWS);
                if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                    RetornoCTE.gerarTxtAverbacao(this.paramProperties.getPastaArmazenamentoRet(), objEnvio.getNomeArquivo(), retWS);
                }
                this.DeleteTmpFile(objEnvio);
                logger.info(this.paramProperties.getVersaoIntegrador() + " - " + objEnvio.getNomeArquivo() + " apagado.");
                continue;
            }
            catch (IOException exIO) {
                logger.severe("Erro ao gerar o arquivo: " + nomeFile + " - " + exIO.getMessage());
                continue;
            }
            catch (Exception ex) {
                logger.severe("Erro geral no registro de averba\u00e7\u00e3o: " + nomeFile + " - " + ex.getMessage());
                continue;
            }
            break;
        }
    }
}

