/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.mdfe.v1;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.mdfe.v1.ParseTXTEnvioMDFEv102;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.envio.DocumentoCTe;
import br.com.ophos.xml.mdfe.envio.DocumentoNFe;
import br.com.ophos.xml.mdfe.envio.InfoAdicional;
import br.com.ophos.xml.mdfe.envio.InfoModal;
import br.com.ophos.xml.mdfe.envio.MunicipioDescarregamento;
import br.com.ophos.xml.mdfe.envio.Proprietario;
import br.com.ophos.xml.mdfe.envio.Reboque;
import br.com.ophos.xml.mdfe.envio.Rodoviario;
import br.com.ophos.xml.mdfe.envio.Totais;
import br.com.ophos.xml.mdfe.envio.Veiculo;

public class ParseTXTEnvioMDFEv103
extends ParseTXTEnvioMDFEv102 {
    private static ParseTXTEnvioMDFEv103 instance;

    public static ParseTXTEnvioMDFEv103 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioMDFEv103();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosManifesto(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 13) {
                throw new ParseException("A linha 000 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 13 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                this.obj.setNumero(Integer.parseInt(scanner.next()));
                this.obj.setSerie(Short.parseShort(scanner.next()));
                this.obj.setDataEmissao(Util.StringToDateTime(scanner.next()));
                this.obj.setTipoModal(scanner.next());
                this.obj.setUfIni(scanner.next());
                this.obj.setUfFim(scanner.next());
                this.obj.setNrReferencia(scanner.next());
                if (this.obj.getTotais() == null) {
                    this.obj.setTotais(new Totais());
                }
                this.obj.getTotais().setPesoBruto(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setUnidadeMedida(scanner.next());
                this.obj.getTotais().setValorTotalCarga(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                if (this.obj.getInfoAdicional() == null) {
                    this.obj.setInfoAdicional(new InfoAdicional());
                }
                this.obj.getInfoAdicional().setInfoContribuinte(scanner.next());
                this.obj.getInfoAdicional().setInfoFisco(scanner.next());
                this.obj.setInicioViagem(Util.StringToDateTime(scanner.next()));
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 000: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosRodoviario(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 3) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 3 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                if (this.obj.getModal() == null) {
                    this.obj.setModal(new InfoModal());
                    this.obj.getModal().setRodoviario(new Rodoviario());
                }
                this.obj.getModal().getRodoviario().setRntrc(scanner.next());
                this.obj.getModal().getRodoviario().setCiot(scanner.next());
                this.obj.getModal().getRodoviario().setCodAgenPorto(scanner.next());
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void dadosVeiculo(String linha) throws ParseException {
        try {
            scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos == 16) ** GOTO lbl44
            throw new ParseException("A linha 003 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 16 campos.");
lbl-1000:
            // 1 sources

            {
                scanner.next();
                if (this.obj.getModal().getRodoviario().getVeiculo() == null) {
                    this.obj.getModal().getRodoviario().setVeiculo(new Veiculo());
                }
                this.obj.getModal().getRodoviario().getVeiculo().setNrInterno(scanner.next());
                this.obj.getModal().getRodoviario().getVeiculo().setPlaca(scanner.next());
                this.obj.getModal().getRodoviario().getVeiculo().setTara(Integer.parseInt(scanner.next()));
                capKG = scanner.next();
                if (capKG != null && !capKG.isEmpty()) {
                    this.obj.getModal().getRodoviario().getVeiculo().setCapacidadeKG(Integer.parseInt(capKG));
                }
                if ((capM3 = scanner.next()) != null && !capM3.isEmpty()) {
                    this.obj.getModal().getRodoviario().getVeiculo().setCapacidadeM3(Integer.parseInt(capM3));
                }
                this.obj.getModal().getRodoviario().getVeiculo().setTipoRodado(scanner.next());
                this.obj.getModal().getRodoviario().getVeiculo().setTipoCarroceria(scanner.next());
                this.obj.getModal().getRodoviario().getVeiculo().setUf(scanner.next());
                renavam = scanner.next();
                if (renavam != null && !renavam.isEmpty()) {
                    this.obj.getModal().getRodoviario().getVeiculo().setRenavam(renavam);
                }
                if ((tipoProprietario = scanner.next()) != null && !tipoProprietario.isEmpty()) {
                    this.obj.getModal().getRodoviario().getVeiculo().setProprietario(new Proprietario());
                    this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setTipoProprietario(tipoProprietario);
                    cnpj = scanner.next();
                    if (cnpj != null && !cnpj.isEmpty()) {
                        this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setCnpj(cnpj);
                    }
                    if ((cpf = scanner.next()) != null && !cpf.isEmpty()) {
                        this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setCpf(cpf);
                    }
                    this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setIe(scanner.next());
                    this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setNome(scanner.next());
                    this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setRntrc(scanner.next());
                    this.obj.getModal().getRodoviario().getVeiculo().getProprietario().setUf(scanner.next());
                    continue;
                }
                i = 1;
                while (i <= 6) {
                    scanner.next();
                    ++i;
                }
lbl44:
                // 3 sources

                ** while (scanner.hasNext())
            }
lbl45:
            // 1 sources

            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 003: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosReboque(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 15) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 15 campos.");
            }
            while (true) {
                String tipoProprietario;
                String capM3;
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                Reboque reboque = new Reboque();
                scanner.next();
                reboque.setNrInterno(scanner.next());
                reboque.setPlaca(scanner.next());
                reboque.setTara(Integer.parseInt(scanner.next()));
                String capKG = scanner.next();
                if (capKG != null && !capKG.isEmpty()) {
                    reboque.setCapacidadeKG(Integer.parseInt(capKG));
                }
                if ((capM3 = scanner.next()) != null && !capM3.isEmpty()) {
                    reboque.setCapacidadeM3(Integer.parseInt(capM3));
                }
                reboque.setTipoCarroceria(scanner.next());
                reboque.setUf(scanner.next());
                String renavam = scanner.next();
                if (renavam != null && !renavam.isEmpty()) {
                    reboque.setRenavam(renavam);
                }
                if ((tipoProprietario = scanner.next()) != null && !tipoProprietario.isEmpty()) {
                    String cpf;
                    reboque.setProprietario(new Proprietario());
                    reboque.getProprietario().setTipoProprietario(tipoProprietario);
                    String cnpj = scanner.next();
                    if (cnpj != null && !cnpj.isEmpty()) {
                        reboque.getProprietario().setCnpj(cnpj);
                    }
                    if ((cpf = scanner.next()) != null && !cpf.isEmpty()) {
                        reboque.getProprietario().setCpf(cpf);
                    }
                    reboque.getProprietario().setIe(scanner.next());
                    reboque.getProprietario().setNome(scanner.next());
                    reboque.getProprietario().setRntrc(scanner.next());
                    reboque.getProprietario().setUf(scanner.next());
                } else {
                    int i = 1;
                    while (i <= 6) {
                        scanner.next();
                        ++i;
                    }
                }
                this.obj.getModal().getRodoviario().getReboque().add(reboque);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 004: " + ex.getMessage());
        }
    }

    @Override
    protected void dadosDocumentos(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 7) {
                throw new ParseException("A linha 009 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 7 campos.");
            }
            if (scanner.hasNext()) {
                scanner.next();
                int id = Integer.parseInt(scanner.next());
                int idMunicipio = Integer.parseInt(scanner.next());
                MunicipioDescarregamento descarregamento = (MunicipioDescarregamento)this.mapMunicipio.get(idMunicipio);
                int tipo = Integer.parseInt(scanner.next());
                switch (tipo) {
                    case 1: {
                        DocumentoCTe cte = new DocumentoCTe();
                        cte.setChaveAcesso(scanner.next());
                        String chaveContingenciaCte = scanner.next();
                        if (chaveContingenciaCte != null && !chaveContingenciaCte.isEmpty()) {
                            cte.setChaveAcessoContingencia(chaveContingenciaCte);
                        }
                        descarregamento.getCte().add(cte);
                        this.mapMunicipio.put(idMunicipio, descarregamento);
                        this.mapDocumento.put(id, cte);
                        break;
                    }
                    case 2: {
                        int i = 1;
                        while (i <= 2) {
                            scanner.next();
                            ++i;
                        }
                        DocumentoNFe nfe = new DocumentoNFe();
                        nfe.setChaveAcesso(scanner.next());
                        String chaveContingenciaNfe = scanner.next();
                        if (chaveContingenciaNfe != null && !chaveContingenciaNfe.isEmpty()) {
                            nfe.setChaveAcessoContingencia(chaveContingenciaNfe);
                        }
                        descarregamento.getNfe().add(nfe);
                        this.mapMunicipio.put(idMunicipio, descarregamento);
                        this.mapDocumento.put(id, nfe);
                        break;
                    }
                    default: {
                        throw new ParseException("N\u00e3o foi informado um tipo v\u00e1lido de documento");
                    }
                }
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 009: " + ex.getMessage());
        }
    }
}

