var attInterval;

function onLoad() {
	document.getElementById('logs-tab').classList.add('active');

	var requestURL = "http://" + window.location.hostname + ":" + window.location.port + '/popular';
	var request = new XMLHttpRequest();
	request.open('GET', requestURL);
	request.responseType = 'json';
	request.send();

	request.onload = function() {
		// popula o form
		var json = request.response;

		popularCampos(json, '')
		onCheckService();
	}

	getListFiles();
}

function getListFiles() {
	var requestURL = "http://" + window.location.hostname + ":" + window.location.port + '/log/listar';
	var request = new XMLHttpRequest();
	request.open('GET', requestURL);
	request.responseType = 'json';
	request.send();

	request.onload = function() {
		let json = request.response;
		var optionsList = document.getElementById('selectLog').options;

		var ele = document.getElementById('selectLog');

		var fileName;

		json.forEach(obj => {
			ele.innerHTML = ele.innerHTML +
				'<option selected value= ' + obj + '>' + obj + '</option>';

			fileName = obj;
		});

		if (fileName) {
			createTable(fileName);
		}
	}
}

function createTable(file) {
	clearInterval(attInterval);

	$('#tabelaLogs').DataTable().destroy();
	$('#tabelaLogs').DataTable({
		stateSave: false,
		stateDuration: -1,
		pagingType: "full_numbers",
		destroy: true,
		processing: true,
		ajax: {
			url: "/log?arquivo=" + file,
			dataSrc: "data"
		},
		columns: [
			{
				data: 'sequencia',
				width: 20					
			},
			{
				data: 'dataLog',
				render: $.fn.dataTable.render.moment('DD-MM-YYYY HH:mm:ss', 'DD/MM/YYYY HH:mm:ss', 'pt-br'),
				className: 'text-center',
				width: 80
			},
			{
				data: 'message'
			},
			{
				data: 'logLevel',
				className: 'text-center',
				width: 20
			},
			{
				data: 'classe',
				visible: false
			},
			{
				data: 'metodo',
				visible: false
			}			
		],
		order: [0, "desc"],
		language: {
			info: "Mostrado _START_ de _END_ de _TOTAL_ registros",
			lengthMenu: "Exibir _MENU_ por página",
			zeroRecords: "Não há registros",
			infoEmpty: "Não há registros",
			infoFiltered: "(Filtrado de _MAX_ registros)",
			search: "Pesquisa",
			select: {
				rows: "%d linha(s) selecionada(s)",
			},
			paginate: {
				first: "Primeira",
				last: "Última",
				next: "Próxima",
				previous: "Anterior"
			},
			aria: {
				sortAscending: ": Ordenar colunas de forma ascendente",
				sortDescending: ": Ordenar colunas de forma descendente"
			}
		}
	});
	
	startTimerLog();
}

function startTimerLog(){
	$('#autoRefresh').prop( "checked", true );

	attInterval = setInterval(function() {
		$('#tabelaLogs').DataTable().ajax.reload();
	}, 3000);	
}

function stopTimerLog() {	
	clearInterval(attInterval);
}

function popularCampos(json, nameObj) {
	for (key in json) {
		if (json.hasOwnProperty(key)) {
			if (json[key] instanceof Object) {
				popularCampos(json[key], json[key].tipo)
			} else {
				$('#' + key + nameObj).val(json[key]);
			}
		}
	}
}

function alterarAmbiente(tpForm) {

    if($('#ambiente' + tpForm).val() == 'HOMOLOGACAO') {
        $('#urlbase' + tpForm).val('https://cloudhom.ophos.com.br')
    } else {
        $('#urlbase' + tpForm).val('https://cloud.ophos.com.br')
    }

}

function salvar() {

    //generico
    const configAvancado = new FormData(document.getElementById('form_avancado'));

    let valueAvancado = Object.fromEntries(configAvancado.entries());


    valueAvancado.parametros = new Array();

    if (valueAvancado.configurarNfe === "SIM") {
        const form_nfe = new FormData(document.getElementById('form_nfe'));
        const valueFormNfe = Object.fromEntries(form_nfe.entries());

        valueFormNfe.tipo = "NFE";

        valueAvancado.parametros.push(valueFormNfe);
    }

    if (valueAvancado.configurarCte === "SIM") {
        const form_cte = new FormData(document.getElementById('form_cte'));
        const valueFormCte = Object.fromEntries(form_cte.entries());

        valueFormCte.tipo = "CTE";

        valueAvancado.parametros.push(valueFormCte);
    }

    if (valueAvancado.configurarMdfe === "SIM") {
        const form_mdfe = new FormData(document.getElementById('form_mdfe'));
        const valueFormMdfe = Object.fromEntries(form_mdfe.entries());

        valueFormMdfe.tipo = "MDFE";

        valueAvancado.parametros.push(valueFormMdfe);
    }

    if (valueAvancado.configurarNfse === "SIM") {
		const form_nfse = new FormData(document.getElementById('form_nfse'));
        const valueFormNfse = Object.fromEntries(form_nfse.entries());

        valueFormNfse.tipo = "NFSE";

        valueAvancado.parametros.push(valueFormNfse);
    }

    if (valueAvancado.configurarCteos === "SIM") {
		const form_cteos = new FormData(document.getElementById('form_cteos'));
        const valueFormCteos = Object.fromEntries(form_cteos.entries());

        valueFormCteos.tipo = "CTEOS";

        valueAvancado.parametros.push(valueFormCteos);
    }

    var requestURL = "http://" + window.location.hostname + ":" + window.location.port + '/salvar';
    var request = new XMLHttpRequest();
    request.open('POST', requestURL);
    request.setRequestHeader("Content-Type", "application/json;charset=UTF-8");


    request.send(JSON.stringify(valueAvancado));

    request.onload = function () {

        if (request.status == 200) {
            alert("Sucesso! Reinicie o integrador para que as alterações sejam aplicadas!");
        } else {
            alert("Erro: " + request.response)
        }

    }

}

function onShowMenu() {
	const side = document.getElementById('sidebar');
	side.classList.toggle("active");
}

function onCheckTabActive(element) {
	const campos = ['logs-tab', 'config-avancadas-tab', 'config-nfe-tab', 'config-cte-tab', 'config-mdfe-tab', 'config-nfse-tab', 'config-cteos-tab'];

	campos.forEach(c => {
		const elemento = document.getElementById(c);
		if (c != element && elemento.classList.contains("active")) {
			elemento.classList.remove("active");
		}
	})

	if (element === 'logs-tab') {
		onChangeLogFile();
		const salvar = document.getElementById('bntSubmit');
		salvar.classList.add('d-none')
	} else {
		stopTimerLog();

		const salvar = document.getElementById('bntSubmit');
		salvar.classList.remove('d-none')
	}
}

function onCheckService(nameProd) {
	
	const elemento = document.getElementById('form_avancado');
	const val = Object.fromEntries(new FormData(elemento).entries());
	
	onLoadDefault(nameProd, val);

	
	if(val.configurarNfe == "SIM"){
		const nfeTab = document.getElementById('config-nfe-tab');
		nfeTab.classList.remove("d-none");
		alterarAmbiente('NFE');
	} else {
		const nfeTab = document.getElementById('config-nfe-tab');
		nfeTab.classList.add("d-none");
	}
	
	if(val.configurarCte == "SIM"){
		const cteTab = document.getElementById('config-cte-tab');
		cteTab.classList.remove("d-none");
		alterarAmbiente('CTE');
	} else {
		const cteTab = document.getElementById('config-cte-tab');
		cteTab.classList.add("d-none");
	}
	
	if(val.configurarMdfe == "SIM"){
		const mdfeTab = document.getElementById('config-mdfe-tab');
		mdfeTab.classList.remove("d-none");
		alterarAmbiente('MDFE');
	} else {
		const mdfeTab = document.getElementById('config-mdfe-tab');
		mdfeTab.classList.add("d-none");
	}
	
	if(val.configurarNfse == "SIM"){
		const nfseTab = document.getElementById('config-nfse-tab');
		nfseTab.classList.remove("d-none");
		alterarAmbiente('NFSE');
	} else {
		const nfseTab = document.getElementById('config-nfse-tab');
		nfseTab.classList.add("d-none");
	}
	
	if(val.configurarCteos == "SIM"){
		const cteosTab = document.getElementById('config-cteos-tab');
		cteosTab.classList.remove("d-none");
		alterarAmbiente('CTEOS');
	} else {
		const cteosTab = document.getElementById('config-cteos-tab');
		cteosTab.classList.add("d-none");
	}
		
}

function onChangeLogFile() {
	const arquivo = document.getElementById('selectLog').value;
	createTable(arquivo);
}

function onChangeAutoRefresh(){
		const isChecked = document.getElementById('autoRefresh').checked;	
	if (isChecked){
		startTimerLog();
	}else{
		stopTimerLog();
	}
}

function downloadLog(){
	const url = "http://" + window.location.hostname + ":" + window.location.port + "/log?arquivo=" + document.getElementById('selectLog').value;
		
	fetch(url).then(res => res.blob()).then(file => {
        let tempUrl = URL.createObjectURL(file);
        const aTag = document.createElement("a");
        aTag.href = tempUrl;
        aTag.download = document.getElementById('selectLog').value;
        document.body.appendChild(aTag);
        aTag.click();
        URL.revokeObjectURL(tempUrl);
        aTag.remove();
    }).catch(() => {
        alert("Failed to download file!");
    });

}

function logout(){

	window.location.href = "http://" + window.location.hostname + ":" + window.location.port + '/desconectado';

}

function popularFormDefault(json, nameObj) {
	for (key in json) {
		if (json.hasOwnProperty(key)) {	
			$('#' + key + nameObj).val(json[key]);
		}
	}
}

function onLoadDefault(nameProd, val) {
	
	var nomeCampo = "";
	
	switch(nameProd){
		case 'Nfse':
			nomeCampo = val.configurarNfse;
			break;
		case 'Nfe':
			nomeCampo = val.configurarNfe;
			break;			
		case 'Cte':
			nomeCampo = val.configurarCte;
			break;			
		case 'Cteos':
			nomeCampo = val.configurarCteos;
			break;			
		case 'Mdfe':
			nomeCampo = val.configurarMdfe;
			break;			
	}
	
	if(nomeCampo == "SIM"){
	
		var requestURL2 = "http://" + window.location.hostname + ":" + window.location.port + '/default?prod=' + nameProd.toUpperCase();
		var request2 = new XMLHttpRequest();
		request2.open('GET', requestURL2);
		request2.responseType = 'json';
		request2.send();
	
		request2.onload = function() {
			// popula o form
			var json1 = request2.response;
	
			popularFormDefault(json1, nameProd.toUpperCase())
		}	
	}
	
}
