/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.cte;

import br.com.ophos.enumerations.TipoEventoCTE;
import br.com.ophos.integracao.cte.EnvioCteService;
import br.com.ophos.integracao.cte.EventoCteService;
import br.com.ophos.integracao.interfaces.averbacao.dto.RetAverbacao;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTe;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaCTe;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaEnvio;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.RetEnvio;
import br.com.ophos.integracao.interfaces.cte.dto.evento.ElementoCCe;
import br.com.ophos.integracao.interfaces.cte.dto.evento.EnvComprovante;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.CTeOS;
import br.com.ophos.integracao.interfaces.cteos.dto.emissao.RetEnvioCTEOS;
import br.com.ophos.integracao.interfaces.dto.EnvInutilizacao;
import br.com.ophos.integracao.interfaces.dto.RetEvento;
import br.com.ophos.integracao.interfaces.dto.RetInutilizacao;
import br.com.ophos.integracao.interfaces.dto.StatusEvento;
import br.com.ophos.interfaces.LoggingFilter;
import br.com.ophos.util.cte.Util;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class CteInterface {
    private static final String PATH = "/cte/service/";
    private static ResteasyClient client;
    private static boolean ativaLog;

    static {
        ativaLog = false;
    }

    private static ResteasyClient getClient() {
        if (client == null) {
            client = new ResteasyClientBuilder().build();
            if (ativaLog) {
                client.register((Object)new LoggingFilter());
            }
        }
        return client;
    }

    public static RetEnvio enviarCTE(String urlWS, String token, CTe obj) {
        try {
            ResteasyClient client = CteInterface.getClient();
            ResteasyWebTarget target = client.target(urlWS + PATH);
            EnvioCteService proxy = (EnvioCteService)target.proxy(EnvioCteService.class);
            ObjectMapper mapper = new ObjectMapper();
            String data = mapper.writeValueAsString((Object)obj);
            return proxy.enviarCte(token, data);
        }
        catch (Exception e) {
            RetEnvio ret = new RetEnvio();
            ret.setCnpj(obj.getEmitente().getCnpj());
            ret.setNumero(obj.getNumero());
            ret.setSerie(obj.getSerie());
            ret.setReferencia(obj.getReferencia());
            ret.setStatus(RetEnvio.StatusEnvio.ERRO_GERAL);
            ret.setMensagem(e.getMessage());
            return ret;
        }
    }

    public static RetEnvioCTEOS enviarCTEOS(String urlWS, String token, CTeOS obj) {
        try {
            ResteasyClient client = CteInterface.getClient();
            ResteasyWebTarget target = client.target(urlWS + PATH);
            EnvioCteService proxy = (EnvioCteService)target.proxy(EnvioCteService.class);
            ObjectMapper mapper = new ObjectMapper();
            String data = mapper.writeValueAsString((Object)obj);
            return proxy.enviarCteOS(token, data);
        }
        catch (Exception e) {
            RetEnvioCTEOS ret = new RetEnvioCTEOS();
            ret.setCnpj(obj.getEmitente().getCnpj());
            ret.setNumero(obj.getNumero());
            ret.setSerie(obj.getSerie());
            ret.setReferencia(obj.getReferencia());
            ret.setStatus(RetEnvioCTEOS.StatusEnvio.ERRO_GERAL);
            ret.setMensagem(e.getMessage());
            return ret;
        }
    }

    public static RetConsultaCTe consultar(String urlWS, String token, String cnpjEmitente, String numero, short serie, String tipo) {
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EnvioCteService proxy = (EnvioCteService)target.proxy(EnvioCteService.class);
        return proxy.consultarCte(token, cnpjEmitente, numero, serie, tipo);
    }

    public static RetEvento cancelar(String urlWS, String token, String cnpjEmitente, String numero, String serie, String justificativa, String modelo) {
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoCteService proxy = (EventoCteService)target.proxy(EventoCteService.class);
        return proxy.registrarCancelamento(token, cnpjEmitente, numero, serie, justificativa, modelo);
    }

    public static RetEvento cancelarPorChaveAcesso(String urlWS, String token, String chaveAcesso, String justificativa) {
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoCteService proxy = (EventoCteService)target.proxy(EventoCteService.class);
        return proxy.registrarCancelamentoChaveAcesso(token, chaveAcesso, justificativa);
    }

    public static RetInutilizacao inutilizar(String urlWS, String token, Util.EnvInutilizacao obj) {
        RetInutilizacao ret = new RetInutilizacao();
        EnvInutilizacao env = new EnvInutilizacao(obj.cnpjEmitente, null, Integer.parseInt(obj.nrAno), Short.parseShort(obj.nrSerie), Integer.parseInt(obj.nrIni), Integer.parseInt(obj.nrFim), obj.justificativa, obj.usuario, "CTE");
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoCteService proxy = (EventoCteService)target.proxy(EventoCteService.class);
        Response retWs = proxy.registarInutilizacao(token, env);
        if (retWs.getStatus() == 201) {
            ret = (RetInutilizacao)retWs.readEntity(RetInutilizacao.class);
            ret.setStatus(201);
        } else {
            ret.setStatus(retWs.getStatus());
            ret.setMsg((String)retWs.readEntity(String.class));
        }
        return ret;
    }

    public static RetEvento registarCartaCorrecao(String urlWS, String token, String chaveAcesso, Collection<ElementoCCe> elementosCT) {
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoCteService proxy = (EventoCteService)target.proxy(EventoCteService.class);
        return proxy.registrarCCe(token, chaveAcesso, elementosCT);
    }

    public static RetEvento registarCompEntrega(String urlWS, String token, String chaveAcesso, EnvComprovante comprovante) {
        try {
            ResteasyClient client = CteInterface.getClient();
            ResteasyWebTarget target = client.target(urlWS + PATH);
            ObjectMapper mapper = new ObjectMapper();
            String data = mapper.writeValueAsString((Object)comprovante);
            EventoCteService proxy = (EventoCteService)target.proxy(EventoCteService.class);
            return proxy.registarComprovanteEntrega(token, chaveAcesso, data);
        }
        catch (Exception e) {
            RetEvento r = new RetEvento();
            r.setStatus(StatusEvento.ERRO_VALIDACAO);
            r.setMensagem(e.getMessage());
            return r;
        }
    }

    public static RetEvento registrarCancelamentoComprovanteEntrega(String urlWS, String token, String chaveAcesso, String protocolo) {
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoCteService proxy = (EventoCteService)target.proxy(EventoCteService.class);
        return proxy.cancelarComprovanteEntrega(token, chaveAcesso, protocolo);
    }

    public static RetEvento registrarMultimodal(String urlWS, String token, String chaveAcesso, String descricao, String documento) {
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoCteService proxy = (EventoCteService)target.proxy(EventoCteService.class);
        return proxy.registrarMultimodal(token, chaveAcesso, descricao, documento);
    }

    public static byte[] obterXmlEvento(String urlWS, String token, String chaveAcesso, TipoEventoCTE evento, String sequencial) throws Exception {
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EventoCteService proxy = (EventoCteService)target.proxy(EventoCteService.class);
        return proxy.obterXmlEvento(token, chaveAcesso, evento.name(), sequencial);
    }

    public static RetConsultaEnvio obterRetornoEnvio(String urlWS, String token, String protocolo) {
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EnvioCteService proxy = (EnvioCteService)target.proxy(EnvioCteService.class);
        return proxy.obterRetorno(token, protocolo);
    }

    public static RetAverbacao averbar(String urlWS, String token, String chaveAcesso) {
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EnvioCteService proxy = (EnvioCteService)target.proxy(EnvioCteService.class);
        return proxy.averbar(token, chaveAcesso);
    }

    public static RetAverbacao cancelarAverbacao(String urlWS, String token, String chaveAcesso) {
        ResteasyClient client = CteInterface.getClient();
        ResteasyWebTarget target = client.target(urlWS + PATH);
        EnvioCteService proxy = (EnvioCteService)target.proxy(EnvioCteService.class);
        return proxy.cancelarAverb(token, chaveAcesso);
    }

    public static void setAtivaLog(boolean ativaLog) {
        CteInterface.ativaLog = ativaLog;
    }
}

