/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.interfaces.nfe.dto.emissao;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeSerializer
extends JsonSerializer<LocalDateTime> {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter formatterToConvert = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter formatterToConvertXML = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZZZZZ");

    public void serialize(LocalDateTime value, JsonGenerator g, SerializerProvider p) throws IOException {
        g.writeString(value.format(formatter));
    }

    public static LocalDateTime parseDateTime(String s) {
        return LocalDateTime.parse(s, formatterToConvert);
    }

    public static LocalDateTime parseDateTimeXML(String s) {
        return LocalDateTime.parse(s, formatterToConvertXML);
    }
}

