/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.parse.nfe.txt;

import br.com.ophos.integracao.parse.nfe.txt.factory.ParseTXTConsultaNFeFactory;
import br.com.ophos.monitor.EnvioConsulta;
import br.com.ophos.parse.ParseException;
import br.com.ophos.util.nfe.Util;
import java.io.InputStream;
import java.util.Scanner;

public class ParseTXTConsultaNFE
extends ParseTXTConsultaNFeFactory {
    private EnvioConsulta obj = null;
    private static ParseTXTConsultaNFE instance;

    public static ParseTXTConsultaNFE getInstance() {
        if (instance == null) {
            instance = new ParseTXTConsultaNFE();
        }
        return instance;
    }

    @Override
    public EnvioConsulta parse(InputStream in) throws ParseException {
        try (Scanner scanner = null;){
            this.obj = new EnvioConsulta();
            scanner = new Scanner(in);
            scanner.useDelimiter("\\|");
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                this.lerLinha(scanner.nextLine() + "|");
            }
        }
        return this.obj;
    }

    private void lerLinha(String aLine) throws ParseException {
        Integer ID = Integer.parseInt(aLine.substring(1, 3));
        switch (ID) {
            case 1: {
                this.InfoConsulta(aLine);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + String.valueOf(ID) + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void InfoConsulta(String aLine) throws ParseException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Scanner scanner = new Scanner(aLine);){
                scanner.useDelimiter("\\|");
                Integer qtdCampos = Util.GetQtdDelimiter(aLine, "|") - 1;
                if (qtdCampos != 5) {
                    throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 5 campos.");
                }
                while (true) {
                    if (!scanner.hasNext()) {
                        return;
                    }
                    scanner.next();
                    this.obj.setNrCnpj(scanner.next());
                    String nrDocumento = scanner.next();
                    this.obj.setNrDocumento(Util.StringToInteger(nrDocumento));
                    this.obj.setNrSerie(Util.StringToShort(scanner.next()));
                    this.obj.setNrIe(scanner.next());
                    this.obj.setUsuario(scanner.next());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 1." + ex.getMessage());
        }
    }
}

