/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.cte.v4;

import br.com.ophos.enumerations.TipoEventoCTE;
import br.com.ophos.evento.cte.CompEntrega;
import br.com.ophos.integracao.interfaces.cte.dto.evento.ElementoCCe;
import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.cte.factory.ParseTXTEventoCTEFactory;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.cte.V200.EventoCTE;
import java.io.InputStream;

public class ParseTXTEventoCTEv400
extends ParseTXTEventoCTEFactory {
    private EventoCTE obj = null;
    private static ParseTXTEventoCTEv400 instance;
    private TipoEventoCTE tipoEvento;

    public static ParseTXTEventoCTEv400 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEventoCTEv400();
        }
        return instance;
    }

    @Override
    public EventoCTE parse(InputStream is) throws ParseException {
        try (Scanner scanner = null;){
            scanner = new Scanner(is);
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String linha = null;
                linha = scanner.nextLine();
                this.lerLinhaEvento(linha + "|");
            }
        }
        return this.obj;
    }

    private void lerLinhaEvento(String linha) throws ParseException {
        Integer ID = Integer.parseInt(linha.substring(1, 3));
        switch (ID) {
            case 1: {
                this.dadosEvento(linha);
                break;
            }
            case 2: {
                switch (this.tipoEvento) {
                    case MULTIMODAL: {
                        this.dadosMultiModal(linha);
                        break;
                    }
                    case CARTA_CORRECAO: {
                        this.dadosCartaCorrecao(linha);
                        break;
                    }
                    case COMP_ENTREGA: {
                        this.dadosCompEntrega(linha);
                        break;
                    }
                    case CANC_COMP_ENTREGA: {
                        this.dadosCancCompEntrega(linha);
                    }
                }
                break;
            }
            case 3: {
                if (this.tipoEvento != TipoEventoCTE.COMP_ENTREGA) break;
                this.comporNfesCompEntrega(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + String.valueOf(ID) + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    private void dadosEvento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            this.obj = new EventoCTE();
            while (scanner.hasNext()) {
                String tipoEventoLido;
                scanner.next();
                switch (tipoEventoLido = scanner.next()) {
                    case "0": {
                        this.obj.setTipoEvento(TipoEventoCTE.MULTIMODAL);
                        this.tipoEvento = TipoEventoCTE.MULTIMODAL;
                        break;
                    }
                    case "1": {
                        this.obj.setTipoEvento(TipoEventoCTE.CARTA_CORRECAO);
                        this.tipoEvento = TipoEventoCTE.CARTA_CORRECAO;
                        break;
                    }
                    case "4": {
                        this.obj.setTipoEvento(TipoEventoCTE.COMP_ENTREGA);
                        this.tipoEvento = TipoEventoCTE.COMP_ENTREGA;
                        break;
                    }
                    case "5": {
                        this.obj.setTipoEvento(TipoEventoCTE.CANC_COMP_ENTREGA);
                        this.tipoEvento = TipoEventoCTE.CANC_COMP_ENTREGA;
                        break;
                    }
                    default: {
                        throw new ParseException("N\u00e3o foi informado o tipo de evento");
                    }
                }
                this.obj.setCnpj(scanner.next());
                this.obj.setChaveAcesso(scanner.next());
                this.obj.setUsuario(scanner.next());
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 001: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dadosMultiModal(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                this.obj.setDescricaoMultiModal(scanner.next());
                this.obj.setDocumento(scanner.next());
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    private void dadosCancCompEntrega(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            scanner.next();
            String protocolo = scanner.next();
            if (protocolo == null || protocolo.isEmpty()) {
                throw new ParseException("O protocolo de autoriza\u00e7\u00e3o n\u00e3o foi informado.");
            }
            this.obj.setnProt(protocolo);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dadosCompEntrega(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 7) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 7 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    return;
                }
                scanner.next();
                String doc = scanner.next();
                String nome = scanner.next();
                String dataEnt = scanner.next();
                String hash = scanner.next();
                String dataHash = scanner.next();
                String lat = scanner.next();
                String longi = scanner.next();
                if (doc == null) throw new ParseException("O documento ou nome ou data da entrega, n\u00e3o foram informados.");
                if (doc.isEmpty()) throw new ParseException("O documento ou nome ou data da entrega, n\u00e3o foram informados.");
                if (nome == null) throw new ParseException("O documento ou nome ou data da entrega, n\u00e3o foram informados.");
                if (nome.isEmpty()) throw new ParseException("O documento ou nome ou data da entrega, n\u00e3o foram informados.");
                if (dataEnt == null) throw new ParseException("O documento ou nome ou data da entrega, n\u00e3o foram informados.");
                if (dataEnt.isEmpty()) {
                    throw new ParseException("O documento ou nome ou data da entrega, n\u00e3o foram informados.");
                }
                CompEntrega entrega = new CompEntrega();
                entrega.setnDoc(doc);
                entrega.setxNome(nome);
                entrega.setDtEntrega(Util.StringToDateTime(dataEnt));
                entrega.setHash(hash != null && !hash.isEmpty() ? hash : null);
                entrega.setDataHash(dataHash != null && !dataHash.isEmpty() ? Util.StringToDateTime(dataHash) : null);
                entrega.setLat(lat != null && !lat.isEmpty() ? Double.valueOf(Double.parseDouble(lat)) : null);
                entrega.setLongi(longi != null && !longi.isEmpty() ? Double.valueOf(Double.parseDouble(longi)) : null);
                this.obj.setCompEntrega(entrega);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    private void comporNfesCompEntrega(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            scanner.next();
            String chave = scanner.next();
            if (chave == null || chave.isEmpty() || chave.length() != 44) {
                throw new ParseException("A chave de acesso da NF-e deve conter 44 digitos.");
            }
            this.obj.getCompEntrega().adicionarNfe(chave);
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dadosCartaCorrecao(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                String elementoCampo = scanner.next();
                String elementoGrupo = scanner.next();
                String elementoValor = scanner.next();
                String elementoShort = scanner.next();
                ElementoCCe elemento = new ElementoCCe();
                elemento.setCampo(elementoCampo);
                elemento.setGrupo(elementoGrupo);
                elemento.setValor(elementoValor);
                if (elementoShort != null && !elementoShort.isEmpty()) {
                    elemento.setPosicao(Short.parseShort(elementoShort));
                }
                this.obj.getElementos().add(elemento);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    public TipoEventoCTE getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(TipoEventoCTE tipoEvento) {
        this.tipoEvento = tipoEvento;
    }
}

