/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.retorno;

import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.ObjectFactory;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.RetInutNFeXML;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.TRetInutNFe;
import br.com.ophos.status.StatusInutilizacaoNFE;
import br.com.ophos.util.nfe.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class RetRecepcaoInutilizacaoNFE {
    private String nrCNPJEmitente;
    private String ambiente;
    private Integer ano;
    private Short nrSerie;
    private Integer nrInicial;
    private Integer nrFinal;
    private String nrProtocolo;
    private Date dataInutilizacao;
    private StatusInutilizacaoNFE status;
    private String msg;

    public String getNrCNPJEmitente() {
        return this.nrCNPJEmitente;
    }

    public void setNrCNPJEmitente(String nrCNPJEmitente) {
        this.nrCNPJEmitente = nrCNPJEmitente;
    }

    public Short getNrSerie() {
        return this.nrSerie;
    }

    public void setNrSerie(Short nrSerie) {
        this.nrSerie = nrSerie;
    }

    public String getStatus() {
        try {
            return Integer.toString(this.status.getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setStatus(StatusInutilizacaoNFE status) {
        this.status = status;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getXmlRetInutIntegraSEFAZ() {
        TRetInutNFe retInut = new TRetInutNFe();
        retInut.setVersao("2.00");
        TRetInutNFe.InfInut infInut = new TRetInutNFe.InfInut();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        try {
            if (this.status != null && this.status == StatusInutilizacaoNFE.SUCESSO) {
                infInut.setAno(this.getAno().toString());
                infInut.setCNPJ(this.getNrCNPJEmitente());
                infInut.setCStat("102");
                infInut.setCUF(this.getNrProtocolo().substring(1, 3));
                infInut.setDhRecbto(fmt.format(this.getDataInutilizacao()));
                infInut.setMod("55");
                infInut.setNNFFin(this.getNrFinal().toString());
                infInut.setNNFIni(this.getNrInicial().toString());
                infInut.setNProt(this.getNrProtocolo());
                infInut.setSerie(this.getNrSerie().toString());
                infInut.setTpAmb(this.getAmbiente());
                infInut.setVerAplic("2.20");
                infInut.setXMotivo(this.getMsg());
            } else {
                if (this.getAno() != null) {
                    infInut.setAno(this.getAno().toString());
                }
                infInut.setCNPJ(this.getNrCNPJEmitente());
                infInut.setCStat("999");
                infInut.setCUF("00");
                GregorianCalendar calendar = new GregorianCalendar();
                Date data = calendar.getTime();
                infInut.setDhRecbto(fmt.format(data));
                infInut.setMod("55");
                if (this.getNrFinal() != null) {
                    infInut.setNNFFin(this.getNrFinal().toString());
                }
                if (this.getNrInicial() != null) {
                    infInut.setNNFIni(this.getNrInicial().toString());
                }
                infInut.setNProt(this.getNrProtocolo());
                if (this.getNrSerie() != null) {
                    infInut.setSerie(this.getNrSerie().toString());
                }
                infInut.setTpAmb(this.getAmbiente());
                infInut.setVerAplic("2.20");
                infInut.setXMotivo(this.getMsg());
            }
            retInut.setInfInut(infInut);
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TRetInutNFe.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)false);
            StringWriter writer = new StringWriter();
            m.marshal((Object)retInut, (Writer)writer);
            String strRet1 = writer.toString();
            Integer idxIni = strRet1.indexOf("<retInutNFe");
            return strRet1.substring(idxIni).replaceAll("<retInutNFe", "<retInutNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\"");
        }
        catch (Exception ex) {
            Util.readStackTrace(ex);
            return null;
        }
    }

    public String getXmlRetInutIntegra() {
        ObjectFactory fac = new ObjectFactory();
        RetInutNFeXML ret = fac.createRetInutNFeXML();
        ret.setRetorno(new RetInutNFeXML.Retorno());
        ret.getRetorno().setCnpjEmitente(this.getNrCNPJEmitente());
        ret.getRetorno().setAno(this.getAno().toString());
        ret.getRetorno().setNrSerie(this.getNrSerie().toString());
        ret.getRetorno().setNrInicial(this.getNrInicial().toString());
        ret.getRetorno().setNrFinal(this.getNrFinal().toString());
        ret.getRetorno().setStatus(this.getStatus());
        ret.getRetorno().setMsg(this.getMsg());
        if (this.getNrProtocolo() != null) {
            ret.setComprovante(new RetInutNFeXML.Comprovante());
            ret.getComprovante().setAmbiente(this.getAmbiente());
            ret.getComprovante().setNumeroProtocolo(this.getNrProtocolo());
            ret.getComprovante().setDatainutilizacao(Util.formataData(this.getDataInutilizacao(), Util.FMTYYYYMMDDhhmmss));
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RetInutNFeXML.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)"iso-8859-1");
            StringWriter writer = new StringWriter();
            m.marshal((Object)ret, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void gerarXML(String path, String nomeArquivo) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            writer.println(this.getXmlRetInutIntegra());
        }
    }

    public void gerarXML_SEFAZ(String path, String nomeArquivo) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            writer.println(this.getXmlRetInutIntegraSEFAZ());
        }
    }

    public void gerarTXT(String path, String nomeArquivo, Object objEnvio) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            if (objEnvio instanceof Util.EnvInutilizacaoV200) {
                writer.println("001|" + this.getNrCNPJEmitente() + "|" + Integer.toString(this.getAno()) + "|" + Short.toString(this.getNrSerie()) + "|" + Integer.toString(this.getNrInicial()) + "|" + Integer.toString(this.getNrFinal()) + "|" + this.getStatus() + "|" + this.getMsg() + "|" + ((Util.EnvInutilizacaoV200)objEnvio).nrIe);
            } else {
                writer.println("001|" + this.getNrCNPJEmitente() + "|" + Integer.toString(this.getAno()) + "|" + Short.toString(this.getNrSerie()) + "|" + Integer.toString(this.getNrInicial()) + "|" + Integer.toString(this.getNrFinal()) + "|" + this.getStatus() + "|" + this.getMsg());
            }
            if (this.status != null && this.status == StatusInutilizacaoNFE.SUCESSO) {
                writer.println("002|" + this.getAmbiente() + "|" + this.getNrProtocolo() + "|" + Util.formataData(this.getDataInutilizacao(), Util.FMTYYYYMMDDhhmmss));
            }
        }
    }

    public String getAmbiente() {
        if (this.ambiente != null) {
            if (this.ambiente.toUpperCase().toString().equals("HOMOLOGACAO")) {
                return "2";
            }
            if (this.ambiente.toUpperCase().toString().equals("PRODUCAO")) {
                return "1";
            }
            return this.ambiente;
        }
        return "";
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
    }

    public String getNrProtocolo() {
        return this.nrProtocolo;
    }

    public void setNrProtocolo(String nrProtocolo) {
        this.nrProtocolo = nrProtocolo;
    }

    public Integer getAno() {
        return this.ano;
    }

    public void setAno(Integer ano) {
        this.ano = ano;
    }

    public Integer getNrInicial() {
        return this.nrInicial;
    }

    public void setNrInicial(Integer nrInicial) {
        this.nrInicial = nrInicial;
    }

    public Integer getNrFinal() {
        return this.nrFinal;
    }

    public void setNrFinal(Integer nrFinal) {
        this.nrFinal = nrFinal;
    }

    public Date getDataInutilizacao() {
        return this.dataInutilizacao;
    }

    public void setDataInutilizacao(Date dataInutilizacao) {
        this.dataInutilizacao = dataInutilizacao;
    }
}

