/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.retorno;

import br.com.ophos.enumerations.TipoArquivo;
import br.com.ophos.enumerations.TipoIntegracao;
import br.com.ophos.integracao.admin.config.Parametro;
import br.com.ophos.integracao.admin.config.TipoArmazenamento;
import br.com.ophos.integracao.interfaces.nfe.NfeInterface;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.AmbienteSistema;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetConsultaEnvio;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetEnvio;
import br.com.ophos.integracao.interfaces.nfe.dto.evento.RetEvento;
import br.com.ophos.integracao.interfaces.nfe.dto.evento.StatusEvento;
import br.com.ophos.integracao.interfaces.nfe.dto.evento.TipoEvento;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.ObjectFactory;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.RetCancNFeXML;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.RetEnvioNFeXML;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.TProtNFe;
import br.com.ophos.integracao.parse.nfe.xml.v1.sefaz.TRetCancNFe;
import br.com.ophos.monitor.EnvioIntegracao;
import br.com.ophos.retorno.RetEnvioNFe;
import br.com.ophos.retorno.RetornoCTE;
import br.com.ophos.util.nfe.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class RetornoNFE {
    public static void DeleteTmpFile(EnvioIntegracao objEnvio) throws IOException {
        File file2;
        File file;
        String nomeFilein = objEnvio.getPathFileArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.XML || objEnvio.getTpIntegraEntrada() == TipoIntegracao.XML_SEFAZ) {
            file = new File(nomeFilein + ".TMX");
            file.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.TXT || objEnvio.getTpIntegraEntrada() == TipoIntegracao.TXT_SEFAZ) {
            file = new File(nomeFilein + ".TMP");
            file.delete();
            file2 = new File(nomeFilein + ".TMX");
            file2.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.BANCO) {
            file = new File(nomeFilein + ".BD");
            file.delete();
            file2 = new File(nomeFilein + ".BDK");
            file2.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.SAP) {
            file = new File(nomeFilein + ".SAP1");
            file.delete();
        }
    }

    public static String getXmlRetCancelIntegra(RetEvento result) {
        ObjectFactory fac = new ObjectFactory();
        RetCancNFeXML ret = fac.createRetCancNFeXML();
        String cnpjEmitente = result.getChaveAcesso().substring(6, 20);
        String serie = result.getChaveAcesso().substring(22, 25);
        String numero = result.getChaveAcesso().substring(25, 34);
        ret.setRetorno(new RetCancNFeXML.Retorno());
        ret.getRetorno().setCnpjEmitente(cnpjEmitente);
        ret.getRetorno().setNrrefsis(result.getChaveAcesso());
        ret.getRetorno().setNrDocumento(numero);
        ret.getRetorno().setNrSerie(serie);
        ret.getRetorno().setStatus(Util.statusCancelamentoToValue(result.getStatus()));
        ret.getRetorno().setMsg(result.getMensagem());
        if (result.getProtocolo() != null) {
            ret.setComprovante(new RetCancNFeXML.Comprovante());
            ret.getComprovante().setAmbiente(result.getAmbiente().getValue());
            ret.getComprovante().setNumeroProtocolo(result.getProtocolo());
            ret.getComprovante().setDatacancelamento(result.getData());
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RetCancNFeXML.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)"iso-8859-1");
            StringWriter writer = new StringWriter();
            m.marshal((Object)ret, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void gerarTXT(String path, String nomeArquivo, Object resultObj) throws IOException {
        try (PrintWriter writer = null;){
            Object resultEnvio;
            String ambiente;
            writer = new PrintWriter(path + "/" + nomeArquivo);
            if (resultObj instanceof RetConsultaEnvio) {
                RetConsultaEnvio result = (RetConsultaEnvio)resultObj;
                ambiente = "";
                if (result.getAmbienteSistema() == null) {
                    ambiente = "";
                } else {
                    if (result.getAmbienteSistema().equals((Object)AmbienteSistema.HOMOLOGACAO)) {
                        ambiente = "1";
                    }
                    if (result.getAmbienteSistema().equals((Object)AmbienteSistema.PRODUCAO)) {
                        ambiente = "2";
                    }
                }
                writer.println("001|" + ambiente + "|" + result.getCnpj() + "|" + result.getReferencia() + "|" + Util.statusConsultaNFeToValue(result.getStatus()) + "|" + result.getMensagem());
                if (result.getStatus() != null && (result.getStatus() == RetConsultaEnvio.StatusConsultaEnvio.AUTORIZADA || result.getStatus() == RetConsultaEnvio.StatusConsultaEnvio.DENEGADA)) {
                    writer.println("002|" + result.getChaveAcesso() + "|" + (result.getProtocolo() != null ? result.getProtocolo() : "") + "|" + (result.getData() != null ? result.getData() : ""));
                }
            }
            if (resultObj instanceof RetEnvioNFe) {
                resultEnvio = (RetEnvioNFe)resultObj;
                ambiente = "";
                if (((RetEnvioNFe)resultEnvio).getAmbiente() != null) {
                    ambiente = ((RetEnvioNFe)resultEnvio).getAmbiente();
                }
                writer.println("001|" + ambiente + "|" + ((RetEnvioNFe)resultEnvio).getNrCNPJEmitente() + "|" + ((RetEnvioNFe)resultEnvio).getNrDocumentoReferente() + "|" + ((RetEnvioNFe)resultEnvio).getStatus() + "|" + ((RetEnvioNFe)resultEnvio).getMsg());
            }
            if (resultObj instanceof RetEnvio) {
                resultEnvio = (RetEnvio)resultObj;
                ambiente = "";
                if (((RetEnvio)resultEnvio).getAmbienteSistema() == null) {
                    ambiente = "";
                } else {
                    if (((RetEnvio)resultEnvio).getAmbienteSistema().equals((Object)AmbienteSistema.HOMOLOGACAO)) {
                        ambiente = "1";
                    }
                    if (((RetEnvio)resultEnvio).getAmbienteSistema().equals((Object)AmbienteSistema.PRODUCAO)) {
                        ambiente = "2";
                    }
                }
                writer.println("001|" + ambiente + "|" + ((RetEnvio)resultEnvio).getCnpj() + "|" + ((RetEnvio)resultEnvio).getReferencia() + "|" + Util.statusEnvioNfeToValue(((RetEnvio)resultEnvio).getStatus()) + "|" + ((RetEnvio)resultEnvio).getMensagem());
            }
        }
    }

    public static void gerarTXTCancelamento(String path, String nomeArquivo, Object resultObj, Object objEnvio) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            if (resultObj instanceof RetEvento) {
                RetEvento result = (RetEvento)resultObj;
                if (objEnvio instanceof Util.EnvCancelamentoV200) {
                    Util.EnvCancelamentoV200 env = (Util.EnvCancelamentoV200)objEnvio;
                    writer.println("001|" + env.cnpjEmitente + "|" + env.nrReferente + "|" + env.nrDocumento + "|" + env.nrSerie + "|" + Util.statusCancelamentoToValue(result.getStatus()) + "|" + result.getMensagem() + "|" + env.nrIE);
                } else {
                    Util.EnvCancelamento env = (Util.EnvCancelamento)objEnvio;
                    writer.println("001|" + env.cnpjEmitente + "|" + env.nrReferente + "|" + env.nrDocumento + "|" + env.nrSerie + "|" + Util.statusCancelamentoToValue(result.getStatus()) + "|" + result.getMensagem());
                }
                if (result.getStatus() != null && result.getStatus() == StatusEvento.SUCESSO) {
                    writer.println("002|" + result.getAmbiente().getValue() + "|" + result.getProtocolo() + "|" + result.getData());
                }
            }
        }
    }

    public static void gerarTXTEvento(String path, String nomeArquivo, RetEvento result, Object objEnvio) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            if (objEnvio instanceof Util.EnvEvento101) {
                Util.EnvEvento101 obj = (Util.EnvEvento101)objEnvio;
                writer.println("{1.01}");
                writer.println("001|" + obj.cnpjEmitente + "|" + obj.ieEmitente + "|" + obj.tpEvento + "|" + Util.statusRetornoEventoToString(result.getStatus()) + "|" + result.getChaveAcesso() + "|" + result.getMensagem());
                if (result.getStatus() != null && result.getStatus() == StatusEvento.SUCESSO) {
                    writer.println("002|" + Util.statusAmbienteSistemaEventoToValue(result.getAmbiente()) + "|" + result.getProtocolo() + "||" + result.getData());
                }
            } else if (objEnvio instanceof Util.EnvEvento102) {
                Util.EnvEvento102 obj = (Util.EnvEvento102)objEnvio;
                writer.println("{1.02}");
                writer.println("001|" + obj.cnpjEmitente + "|" + obj.ieEmitente + "|" + obj.tpEvento + "|" + Util.statusRetornoEventoToString(result.getStatus()) + "|" + result.getChaveAcesso() + "|" + result.getMensagem());
                if (result.getStatus() != null && result.getStatus() == StatusEvento.SUCESSO) {
                    writer.println("002|" + Util.statusAmbienteSistemaEventoToValue(result.getAmbiente()) + "|" + result.getProtocolo() + "||" + result.getData());
                }
            } else if (objEnvio instanceof Util.EnvEvento) {
                writer.println("001|" + Util.statusRetornoEventoToString(result.getStatus()) + "|" + result.getChaveAcesso() + "|" + result.getMensagem());
                if (result.getStatus() != null && result.getStatus() == StatusEvento.SUCESSO) {
                    writer.println("002|" + Util.statusAmbienteSistemaEventoToValue(result.getAmbiente()) + "|" + result.getProtocolo() + "||" + result.getData());
                }
            }
        }
    }

    public static void gerarXMLEvento(String wsUrl, String token, String path, String nomeArquivo, RetEvento result, Object objEnvio) throws IOException {
        block12: {
            try (PrintWriter writer = null;){
                try {
                    writer = new PrintWriter(path + "/" + nomeArquivo);
                    if (!(objEnvio instanceof Util.EnvEvento)) break block12;
                    Util.EnvEvento objIntegra = (Util.EnvEvento)objEnvio;
                    if (StatusEvento.SUCESSO.equals((Object)result.getStatus())) {
                        TipoEvento t = null;
                        t = Util.valueToTipoManifestacao(((Util.EnvEvento101)objEnvio).tpEvento);
                        byte[] xml = null;
                        switch (t) {
                            case CANCELAMENTO: {
                                xml = NfeInterface.obterXmlCancelamento(wsUrl, token, result.getChaveAcesso());
                                break;
                            }
                            default: {
                                xml = NfeInterface.obterXmlEvento(wsUrl, token, result.getChaveAcesso(), t, result.getSequencial().toString());
                            }
                        }
                        if (xml != null) {
                            String str = new String(xml);
                            Integer iniRet = str.indexOf("<retEvento");
                            Integer fimRet = str.indexOf("</retEvento>");
                            String xmlRet = str.substring(iniRet, fimRet + 12);
                            Integer idxIni = xmlRet.indexOf("<infEvento");
                            Integer idxFim = xmlRet.indexOf("</infEvento>");
                            String retXml = xmlRet.substring(idxIni, idxFim + 12);
                            retXml = retXml.replaceAll("<infEvento", "<infEvento xmlns=\"http://www.portalfiscal.inf.br/nfe\"");
                            writer.println(retXml);
                            writer.flush();
                        }
                        break block12;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("<infEvento xmlns=\"http://www.portalfiscal.inf.br/nfe\">");
                    sb.append("<tpAmb></tpAmb>");
                    sb.append("<verAplic></verAplic>");
                    sb.append("<cOrgao>");
                    sb.append(objIntegra.chaveAcesso.substring(0, 2));
                    sb.append("</cOrgao>");
                    sb.append("<cStat>");
                    sb.append("999");
                    sb.append("</cStat>");
                    sb.append("<xMotivo>");
                    sb.append(Util.retiraCaracteres(result.getMensagem()));
                    sb.append("</xMotivo>");
                    sb.append("<chNFe>");
                    sb.append(objIntegra.chaveAcesso);
                    sb.append("</chNFe>");
                    sb.append("<tpEvento>110110</tpEvento>");
                    sb.append("<xEvento></xEvento>");
                    sb.append("<nSeqEvento></nSeqEvento>");
                    sb.append("<dhRegEvento></dhRegEvento>");
                    sb.append("<nProt></nProt>");
                    sb.append("</infEvento>");
                    writer.println(sb);
                }
                catch (Exception e) {
                    Logger.getLogger(RetornoCTE.class.getName()).info("Ocorreu um erro ao recuperar o XML do evento: " + e.getMessage());
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
        }
    }

    public static String getXmlRetCancelIntegraSEFAZ(RetEvento result) {
        TRetCancNFe.InfCanc infCanc = new TRetCancNFe.InfCanc();
        SimpleDateFormat formatDate2 = new SimpleDateFormat("yyyyMMdd");
        try {
            Date data;
            GregorianCalendar calendar;
            if (result.getStatus() != null && result.getStatus() == StatusEvento.SUCESSO) {
                infCanc.setCStat("101");
                infCanc.setCUF(result.getChaveAcesso().substring(0, 2));
                infCanc.setChNFe(result.getChaveAcesso());
                calendar = new GregorianCalendar();
                data = calendar.getTime();
                infCanc.setDhRecbto(Util.StringToXMLCalendar(formatDate2.format(data)));
                infCanc.setNProt(result.getProtocolo());
                infCanc.setTpAmb(result.getAmbiente().getValue());
                infCanc.setVerAplic("2.20");
                infCanc.setXMotivo(result.getMensagem());
            } else {
                infCanc.setCStat("999");
                if (result.getChaveAcesso() != null) {
                    infCanc.setCUF(result.getChaveAcesso().substring(0, 2));
                    infCanc.setChNFe(result.getChaveAcesso());
                } else {
                    infCanc.setCUF("");
                    infCanc.setChNFe("");
                }
                calendar = new GregorianCalendar();
                data = calendar.getTime();
                infCanc.setDhRecbto(Util.StringToXMLCalendar(formatDate2.format(data)));
                infCanc.setNProt("000000000");
                infCanc.setVerAplic("2.20");
                infCanc.setTpAmb(result.getAmbiente().getValue());
                infCanc.setXMotivo(result.getMensagem());
            }
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TRetCancNFe.InfCanc.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)false);
            StringWriter writer = new StringWriter();
            m.marshal((Object)infCanc, (Writer)writer);
            return writer.toString();
        }
        catch (Exception ex) {
            Util.readStackTrace(ex);
            return null;
        }
    }

    public static void gerarXMLRetCancelIntegra(String path, String nomeArquivo, RetEvento result) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            writer.println(RetornoNFE.getXmlRetCancelIntegra(result));
        }
    }

    public static void gerarXML_SEFAZ_Cancel(String path, String nomeArquivo, String xmlEnvio, RetEvento result) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            Object xmlRetorno = RetornoNFE.getXmlRetCancelIntegraSEFAZ(result);
            Integer inicio = xmlEnvio.indexOf("<cancNFe", 0);
            Integer fim = xmlEnvio.indexOf("</cancNFe>", 0) + 10;
            xmlEnvio = xmlEnvio.substring(inicio, fim);
            Integer inicio2 = ((String)xmlRetorno).indexOf("<infCanc", 0);
            Integer fim2 = ((String)xmlRetorno).indexOf("</infCanc>", 0) + 10;
            xmlRetorno = ((String)xmlRetorno).substring(inicio2, fim2);
            xmlRetorno = "<procCancNFe versao=\"1.07\" xmlns=\"http://www.portalfiscal.inf.br/nfe\">" + xmlEnvio + "<retCancNFe versao=\"1.07\" xmlns=\"http://www.portalfiscal.inf.br/nfe\">" + (String)xmlRetorno + "</retCancNFe></procCancNFe>";
            writer.println((String)xmlRetorno);
        }
    }

    public static String getXmlRetEnvioIntegra(RetConsultaEnvio result, RetEnvio resultEnvio, String chaveAcesso) {
        String ambiente;
        ObjectFactory fac = new ObjectFactory();
        RetEnvioNFeXML ret = fac.createRetEnvioNFe();
        ret.setRetorno(new RetEnvioNFeXML.Retorno());
        if (result != null) {
            ambiente = "";
            if (result.getAmbienteSistema() == null) {
                ambiente = "";
            } else {
                if (result.getAmbienteSistema().equals((Object)AmbienteSistema.HOMOLOGACAO)) {
                    ambiente = "1";
                }
                if (result.getAmbienteSistema().equals((Object)AmbienteSistema.PRODUCAO)) {
                    ambiente = "2";
                }
            }
            ret.getRetorno().setAmbiente(ambiente);
            ret.getRetorno().setCnpjEmitente(result.getCnpj());
            ret.getRetorno().setNrrefsis(result.getReferencia());
            ret.getRetorno().setNrDocumento(result.getNumero().toString());
            ret.getRetorno().setNrSerie(Short.toString(result.getSerie()));
            ret.getRetorno().setStatus(Util.statusConsultaNFeToValue(result.getStatus()));
            ret.getRetorno().setMsg(result.getMensagem());
            if (result.getStatus().equals((Object)RetConsultaEnvio.StatusConsultaEnvio.AUTORIZADA)) {
                ret.setAutorizacao(new RetEnvioNFeXML.Autorizacao());
                ret.getAutorizacao().setChaveAcesso(result.getChaveAcesso());
                ret.getAutorizacao().setNumeroProtocolo(result.getProtocolo());
                ret.getAutorizacao().setDataAutorizacao(result.getData());
            }
        }
        if (resultEnvio != null) {
            ambiente = "";
            if (resultEnvio.getAmbienteSistema() == null) {
                ambiente = "";
            } else {
                if (resultEnvio.getAmbienteSistema().equals((Object)AmbienteSistema.HOMOLOGACAO)) {
                    ambiente = "1";
                }
                if (resultEnvio.getAmbienteSistema().equals((Object)AmbienteSistema.PRODUCAO)) {
                    ambiente = "2";
                }
            }
            ret.getRetorno().setAmbiente(ambiente);
            ret.getRetorno().setCnpjEmitente(resultEnvio.getCnpj());
            ret.getRetorno().setNrrefsis(resultEnvio.getReferencia());
            ret.getRetorno().setNrDocumento(resultEnvio.getNumero().toString());
            ret.getRetorno().setNrSerie(Short.toString(resultEnvio.getSerie()));
            ret.getRetorno().setStatus(Util.statusEnvioToValue(resultEnvio.getStatus()));
            ret.getRetorno().setMsg(resultEnvio.getMensagem());
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RetEnvioNFeXML.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)"iso-8859-1");
            StringWriter writer = new StringWriter();
            m.marshal((Object)ret, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getXmlRetEnvioIntegraSEFAZ(Object resultParam, RetEnvio resultEnvio, EnvioIntegracao objEnvio) {
        TProtNFe.InfProt infProt = new TProtNFe.InfProt();
        SimpleDateFormat formatDate2 = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            if (resultParam instanceof RetConsultaEnvio) {
                RetConsultaEnvio result = (RetConsultaEnvio)resultParam;
                if (result != null && (result.getStatus() == RetConsultaEnvio.StatusConsultaEnvio.AUTORIZADA || result.getStatus() == RetConsultaEnvio.StatusConsultaEnvio.DENEGADA)) {
                    if (result.getStatus() == RetConsultaEnvio.StatusConsultaEnvio.AUTORIZADA) {
                        infProt.setCStat("100");
                    }
                    if (result.getStatus() == RetConsultaEnvio.StatusConsultaEnvio.DENEGADA) {
                        infProt.setCStat(Util.IntegerToString(result.getNrMsgSefaz()));
                    }
                    infProt.setChNFe(result.getChaveAcesso());
                    if (result.getData() != null) {
                        infProt.setDhRecbto(Util.StringToDateTime(result.getData().replaceAll("-", "").replaceAll(":", "").replaceAll(" ", "")));
                    }
                    infProt.setDigVal(new String("PRAsGWN7N1RGDZ5qRwQCnzK+KPc=").getBytes());
                    infProt.setId("NFe" + result.getProtocolo());
                    infProt.setVerAplic("2.00");
                    infProt.setNProt(result.getProtocolo());
                    infProt.setTpAmb(Util.statusAmbienteSistemaToValue(result.getAmbienteSistema() == AmbienteSistema.PRODUCAO ? AmbienteSistema.PRODUCAO : AmbienteSistema.HOMOLOGACAO));
                    infProt.setXMotivo("Autorizado o uso da NF-e");
                } else {
                    infProt.setCStat("999");
                    if (result.getChaveAcesso() != null) {
                        infProt.setChNFe(result.getChaveAcesso());
                    } else if (objEnvio != null) {
                        infProt.setChNFe(objEnvio.getNrChaveAcesso());
                    } else {
                        infProt.setChNFe("");
                    }
                    GregorianCalendar calendar = new GregorianCalendar();
                    Date data = calendar.getTime();
                    if (result.getData() != null) {
                        infProt.setDhRecbto(Util.StringToDateTime(formatDate2.format(data)));
                    } else {
                        infProt.setDhRecbto(Util.StringToDateTime(formatDate2.format(data.getTime())));
                    }
                    infProt.setDigVal(new String("PRAsGWN7N1RGDZ5qRwQCnzK+KPc=").getBytes());
                    infProt.setId("NFe000000000000");
                    infProt.setVerAplic("2.00");
                    infProt.setNProt("000000000000");
                    infProt.setTpAmb(Util.statusAmbienteSistemaToValue(result.getAmbienteSistema() == AmbienteSistema.PRODUCAO ? AmbienteSistema.PRODUCAO : AmbienteSistema.HOMOLOGACAO));
                    infProt.setXMotivo(Util.retiraCaracteres(result.getMensagem()));
                }
            }
            if (resultParam == null && resultEnvio != null) {
                infProt.setCStat("999");
                infProt.setChNFe(objEnvio.getNrChaveAcesso());
                GregorianCalendar calendar = new GregorianCalendar();
                Date data = calendar.getTime();
                infProt.setDigVal(new String("PRAsGWN7N1RGDZ5qRwQCnzK+KPc=").getBytes());
                infProt.setId("NFe000000000000");
                infProt.setVerAplic("2.00");
                infProt.setNProt("000000000000");
                infProt.setTpAmb(objEnvio.getTpAmb());
                infProt.setXMotivo(Util.retiraCaracteres(resultEnvio.getMensagem()));
                infProt.setDhRecbto(Util.StringToDateTime(formatDate2.format(data.getTime())));
            }
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TProtNFe.InfProt.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)false);
            m.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)Boolean.FALSE);
            StringWriter writer = new StringWriter();
            m.marshal((Object)infProt, (Writer)writer);
            return writer.toString();
        }
        catch (Exception ex) {
            Util.readStackTrace(ex);
            return null;
        }
    }

    public static void gerarXML_Integra(String path, String nomeArquivo, RetConsultaEnvio result, RetEnvio resultEnvio, String chaveAcesso) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + nomeArquivo);
            writer.println(RetornoNFE.getXmlRetEnvioIntegra(result, resultEnvio, chaveAcesso));
        }
    }

    public static void gerarXML_SEFAZ(String path, String nomeArquivo, Object result, RetEnvio resultEnvio, EnvioIntegracao objEnvio) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(path + "/" + RetornoNFE.RetornaNomeSemExtensao(nomeArquivo) + ".XML");
            writer.println(RetornoNFE.getXmlRetEnvioIntegraSEFAZ(result, resultEnvio, objEnvio));
        }
    }

    private static String RetornaNomeSemExtensao(String nomeFile) {
        return nomeFile.substring(0, nomeFile.lastIndexOf("."));
    }

    public static void GeraRetornoEvento(RetEvento result, EnvioIntegracao objEnvio, Parametro param) throws IOException {
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            Logger.getLogger("Util").info(result.getStatus().toString() + " - " + result.getMensagem());
            if (param.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoNFE.gerarTXTEvento(param.getPastaArmazenamentoRet(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result, objEnvio.getObjEnvio());
            }
            RetornoNFE.gerarTXTEvento(param.getDataOut(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result, objEnvio.getObjEnvio());
        }
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ || objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
            Logger.getLogger("Util").info(result.getStatus().toString() + " - " + result.getMensagem());
            if (param.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoNFE.gerarXMLEvento(param.getUrlbase(), param.getToken(), param.getPastaArmazenamentoRet(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".XML", result, objEnvio.getObjEnvio());
            }
            RetornoNFE.gerarXMLEvento(param.getUrlbase(), param.getToken(), param.getDataOut(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".XML", result, objEnvio.getObjEnvio());
        }
        RetornoNFE.DeleteTmpFile(objEnvio);
    }

    public static void GeraRetornoCancelamento(Object resultObj, EnvioIntegracao objEnvio, String nrMsgEnvio, Parametro param) throws IOException {
        Object result;
        if (resultObj instanceof RetEvento) {
            result = (RetEvento)resultObj;
            if (((RetEvento)result).getChaveAcesso() == null && ((Util.EnvCancelamento)objEnvio.getObjEnvio()).nrReferente != null) {
                ((RetEvento)result).setChaveAcesso(((Util.EnvCancelamento)objEnvio.getObjEnvio()).nrReferente);
            }
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                Logger.getLogger("Util").info(((RetEvento)result).getStatus().toString() + " - " + ((RetEvento)result).getMensagem());
                if (param.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                    RetornoNFE.gerarTXTCancelamento(param.getPastaArmazenamentoRet(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result, objEnvio.getObjEnvio());
                }
                RetornoNFE.gerarTXTCancelamento(param.getDataOut(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result, objEnvio.getObjEnvio());
            }
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML || objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                Logger.getLogger("Util").info(((RetEvento)result).getStatus().toString() + " - " + ((RetEvento)result).getMensagem());
                if (((RetEvento)result).getStatus() == StatusEvento.SUCESSO) {
                    Logger.getLogger("Util").info(((RetEvento)result).getStatus().toString() + " - " + ((RetEvento)result).getMensagem());
                } else {
                    Logger.getLogger("Util").severe(((RetEvento)result).getStatus().toString() + " - " + ((RetEvento)result).getMensagem());
                }
                if (param.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                    if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                        RetornoNFE.gerarXMLRetCancelIntegra(param.getPastaArmazenamentoRet(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", (RetEvento)result);
                    }
                    if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                        RetornoNFE.gerarXML_SEFAZ_Cancel(param.getPastaArmazenamentoRet(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", (String)objEnvio.getObjEnvio(), (RetEvento)result);
                    }
                }
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                    RetornoNFE.gerarXMLRetCancelIntegra(param.getDataOut(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", (RetEvento)result);
                }
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                    RetornoNFE.gerarXML_SEFAZ_Cancel(param.getDataOut(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().replace('I', 'O')) + ".XML", objEnvio.getDadosImpressao(), (RetEvento)result);
                }
            }
        }
        if (resultObj instanceof RetConsultaEnvio) {
            result = (RetConsultaEnvio)resultObj;
            if (((RetConsultaEnvio)result).getChaveAcesso() == null && ((Util.EnvCancelamento)objEnvio.getObjEnvio()).nrReferente != null) {
                ((RetConsultaEnvio)result).setChaveAcesso(((Util.EnvCancelamento)objEnvio.getObjEnvio()).nrReferente);
            }
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
                Logger.getLogger("Util").severe(((RetConsultaEnvio)result).getStatus().toString() + " - " + ((RetConsultaEnvio)result).getMensagem());
                if (param.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                    RetornoNFE.gerarTXTCancelamento(param.getPastaArmazenamentoRet(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result, objEnvio.getObjEnvio());
                }
                RetornoNFE.gerarTXTCancelamento(param.getDataOut(), RetornoNFE.RetornaNomeSemExtensao(objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result, objEnvio.getObjEnvio());
            }
        }
        RetornoNFE.DeleteTmpFile(objEnvio);
    }

    public static String GetId_XML_NFE(byte[] xmlDoc) throws IOException, JDOMException {
        ByteArrayInputStream bin = new ByteArrayInputStream(xmlDoc);
        SAXBuilder sb = new SAXBuilder();
        String id = "";
        Document d = sb.build((InputStream)bin);
        Element nfeProc = d.getRootElement();
        Element nfe = nfeProc.getChild("NFe", Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
        Element infNfe = nfeProc.getChild("infNFe", Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
        if (nfe != null) {
            Element infNFe2 = nfe.getChild("infNFe", Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
            id = infNFe2.getAttributeValue("Id");
        } else if (infNfe != null) {
            id = infNfe.getAttributeValue("Id");
        } else {
            throw new IOException("XML Incorreto");
        }
        bin.close();
        if (id.toUpperCase().startsWith("NFE")) {
            return id.substring(3);
        }
        return id;
    }

    public static String GetVersaoXML_NFE(byte[] xmlDoc, TipoArquivo tpArquivo) throws IOException, JDOMException {
        ByteArrayInputStream bin = new ByteArrayInputStream(xmlDoc);
        SAXBuilder sb = new SAXBuilder();
        String versao = "";
        Document d = sb.build((InputStream)bin);
        if (tpArquivo.equals((Object)TipoArquivo.ENVIO)) {
            Element nfeProc = d.getRootElement();
            Element nfe = nfeProc.getChild("NFe", Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
            Element infNfe = nfeProc.getChild("infNFe", Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
            if (nfe != null) {
                Element infNFe2 = nfe.getChild("infNFe", Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
                versao = infNFe2.getAttributeValue("versao");
            } else if (infNfe != null) {
                versao = infNfe.getAttributeValue("versao");
            } else {
                throw new IOException("XML Incorreto");
            }
        }
        if (tpArquivo.equals((Object)TipoArquivo.CANCELAMENTO)) {
            Element nfeCanc = d.getRootElement();
            versao = nfeCanc.getAttributeValue("versao");
        }
        if (tpArquivo.equals((Object)TipoArquivo.EVENTO)) {
            Element evento = d.getRootElement();
            versao = evento.getAttributeValue("versao");
        }
        bin.close();
        return versao;
    }
}

