/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.sign;

import br.com.ophos.sign.AssinaturaException;
import br.com.ophos.sign.ParametroAssinatura;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Sign {
    private ParametroAssinatura param = null;
    private PrivateKey chavePrivada = null;
    private X509Certificate cert = null;
    private String digestValue = null;

    public Sign(ParametroAssinatura param) {
        this.param = param;
    }

    public synchronized byte[] assinar(Document doc, String ref) throws AssinaturaException {
        try {
            this.obterCertificadoDigital();
            return this.gerarAssinatura(doc, ref, null);
        }
        catch (Exception e) {
            throw new AssinaturaException("Ocorreu um erro ao assinar o XML." + e.getMessage());
        }
    }

    public synchronized byte[] assinar(String text, String ref) throws AssinaturaException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
            Document doc = dbf.newDocumentBuilder().parse(is);
            this.obterCertificadoDigital();
            return this.gerarAssinatura(doc, ref, null);
        }
        catch (Exception e) {
            throw new AssinaturaException("Ocorreu um erro ao assinar o XML." + e.getMessage());
        }
    }

    public synchronized String assinar(byte[] text) throws AssinaturaException {
        try {
            this.obterCertificadoDigital();
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(this.chavePrivada);
            signature.update(text);
            return new String(Base64.getEncoder().encodeToString(signature.sign()));
        }
        catch (Exception e) {
            throw new AssinaturaException("Ocorreu um erro ao assinar o XML." + e.getMessage());
        }
    }

    public synchronized void obterCertificadoDigital() throws Exception {
        try {
            String pass = this.param.getSenhaCert();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            FileInputStream in = new FileInputStream(this.param.getPathChave());
            ks.load(in, pass.toCharArray());
            in.close();
            Enumeration<String> en = ks.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                Key key = ks.getKey(alias, pass.toCharArray());
                if (!(key instanceof PrivateKey)) continue;
                this.chavePrivada = (PrivateKey)key;
                this.cert = (X509Certificate)ks.getCertificate(alias);
            }
        }
        catch (KeyStoreException kse) {
            throw new Exception("Erro ao carregar o certificado." + kse.getMessage());
        }
        catch (FileNotFoundException fne) {
            throw new Exception("Arquivo n\u00c3\u00a3o encontrado." + fne.getMessage());
        }
        catch (IOException ioe) {
            throw new Exception("Erro." + ioe.getMessage());
        }
    }

    private synchronized byte[] gerarAssinatura(Document doc, String referencia, String referenciaAssinatura) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, TransformerException, NoSuchProviderException {
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        Transform tr1 = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        Transform tr2 = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null);
        transformList.add(tr1);
        transformList.add(tr2);
        Reference ref = fac.newReference(new String("#" + referencia), fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        X509Data x509 = kif.newX509Data(Collections.singletonList(this.cert));
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(x509));
        Node element = doc.getDocumentElement().getFirstChild();
        Element el = (Element)element;
        el.setIdAttribute("Id", true);
        DOMSignContext dsc = new DOMSignContext(this.chavePrivada, (Node)doc.getDocumentElement());
        XMLSignature signature = fac.newXMLSignature(si, ki, null, null, null);
        signature.sign(dsc);
        this.digestValue = doc.getDocumentElement().getElementsByTagName("DigestValue").item(0).getTextContent();
        StringWriter fos = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("standalone", "yes");
        trans.setOutputProperty("indent", "no");
        trans.transform(new DOMSource(doc), new StreamResult(fos));
        return fos.toString().replaceAll("\n|\r|\t", "").getBytes();
    }

    public String getDigestValue() {
        return this.digestValue;
    }

    public void setDigestValue(String digestValue) {
        this.digestValue = digestValue;
    }
}

