/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateTimeHelper {
    public static String FMTYYYYMMDD = "yyyy-MM-dd";
    public static String FMTYYYYMMDD2 = "yyyyMMdd";
    public static String FMTYYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";

    public static String formatDate(LocalDate local) {
        DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern(FMTYYYYMMDD);
        return local.format(FORMATTER);
    }

    public static String formatDate(LocalDate local, String format) {
        DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern(format);
        return local.format(FORMATTER);
    }

    public static String formatDateTime(LocalDateTime local) {
        DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern(FMTYYYYMMDDHHMMSS);
        return local.format(FORMATTER);
    }

    public static LocalDate parseDate(String date) {
        if (date != null && !date.trim().isEmpty()) {
            DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern(FMTYYYYMMDD);
            return LocalDate.parse(date, FORMATTER);
        }
        return null;
    }

    public static LocalDateTime parseDateTime(String datetime) {
        if (datetime != null && !datetime.trim().isEmpty()) {
            DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern(FMTYYYYMMDDHHMMSS);
            return LocalDateTime.parse(datetime, FORMATTER);
        }
        return null;
    }

    public static LocalDate dateToLocalDate(Date data) {
        if (data != null) {
            return Instant.ofEpochMilli(data.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        return null;
    }

    public static LocalDateTime dateToLocalDateTime(Date data) {
        if (data != null) {
            return Instant.ofEpochMilli(data.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        return null;
    }

    public static Date localDateTimeToDate(LocalDateTime data) {
        if (data != null) {
            return Date.from(data.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }
}

