/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.parse.nfe.xml;

import br.com.ophos.monitor.EnvioConsulta;
import br.com.ophos.parse.ParseException;
import br.com.ophos.util.nfe.Util;
import java.io.IOException;
import java.io.InputStream;

public class ParseXMLConsultaNFE {
    private EnvioConsulta obj = null;
    public InputStream in = null;

    public EnvioConsulta parse() throws ParseException {
        try {
            this.obj = new EnvioConsulta();
            String arquivoIntegracao = new String(Util.getBytesFromFile(this.in));
            arquivoIntegracao = arquivoIntegracao.trim();
            if (arquivoIntegracao.indexOf("consSitNFe") >= 0) {
                Integer idxInicial = arquivoIntegracao.indexOf("<chNFe>") + 7;
                Integer idxFinal = arquivoIntegracao.indexOf("</chNFe>");
                String chaveAcesso = arquivoIntegracao.substring(idxInicial, idxFinal);
                String cnpjEmitente = chaveAcesso.substring(6, 20);
                String nrSerie = chaveAcesso.substring(23, 25);
                String nrDocumento = chaveAcesso.substring(26, 34);
                this.obj.setNrCnpj(cnpjEmitente);
                this.obj.setNrDocumento(Util.StringToInteger(nrDocumento));
                this.obj.setNrSerie(Util.StringToShort(nrSerie));
            }
            this.in.close();
            return this.obj;
        }
        catch (Exception ex) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ex.getCause() != null) {
                throw new ParseException("Ocorreu um erro ao fazer o bind do XML para o OBJ de cancelamento " + ex.getMessage() + ex.getCause().getMessage());
            }
            throw new ParseException("Ocorreu um erro ao fazer o bind do XML para o OBJ de cancelamento " + ex.getMessage());
        }
    }
}

