/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.monitor;

import br.com.ophos.enumerations.TipoIntegracao;
import br.com.ophos.integracao.admin.config.Parametro;
import br.com.ophos.integracao.admin.config.TipoArmazenamento;
import br.com.ophos.integracao.cte.CteInterface;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.AmbienteSistema;
import br.com.ophos.integracao.interfaces.cte.dto.evento.ParseRetInutilizacao;
import br.com.ophos.integracao.interfaces.dto.RetInutilizacao;
import br.com.ophos.integracao.interfaces.nfe.NfeInterface;
import br.com.ophos.monitor.BufferDB;
import br.com.ophos.monitor.EnvioIntegracao;
import br.com.ophos.retorno.RetRecepcaoInutilizacaoNFE;
import br.com.ophos.retorno.RetornoCTE;
import br.com.ophos.status.StatusInutilizacaoCTE;
import br.com.ophos.status.StatusInutilizacaoNFE;
import br.com.ophos.util.cte.Util;
import br.com.ophos.util.nfe.Util;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public class ConsumidorInutilizacao
implements Runnable {
    private BufferDB sharedLocation;
    private String dirSaida;
    public Parametro paramProperties;

    public ConsumidorInutilizacao(BufferDB shared, Parametro param) {
        this.sharedLocation = shared;
        this.dirSaida = param.getDataOut();
        this.paramProperties = param;
    }

    private void DeleteTmpFile(EnvioIntegracao objEnvio) throws IOException {
        File file2;
        File file;
        String nomeFilein = objEnvio.getPathFileArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.XML) {
            file = new File(nomeFilein + ".TMX");
            file.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.TXT) {
            file = new File(nomeFilein + ".TMP");
            file.delete();
            file2 = new File(nomeFilein + ".TMX");
            file2.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.BANCO) {
            file = new File(nomeFilein + ".BD");
            file.delete();
            file2 = new File(nomeFilein + ".BDK");
            file2.delete();
        }
        if (objEnvio.getTpIntegraEntrada() == TipoIntegracao.SAP) {
            file = new File(nomeFilein + ".SAP1");
            file.delete();
        }
    }

    private void GeraRetornoNFE(RetInutilizacao result, EnvioIntegracao objEnvio, String nrMsgEnvio) throws IOException {
        Date date;
        SimpleDateFormat formatter2;
        RetRecepcaoInutilizacaoNFE ret;
        Logger logger = Logger.getLogger(this.getClass().getName());
        Util.EnvInutilizacao objEnv = (Util.EnvInutilizacao)objEnvio.getObjEnvio();
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            ret = new RetRecepcaoInutilizacaoNFE();
            ret.setNrCNPJEmitente(objEnv.cnpjEmitente);
            ret.setAno(Integer.parseInt(objEnv.nrAno));
            ret.setNrSerie(Short.parseShort(objEnv.nrSerie));
            ret.setNrInicial(Integer.parseInt(objEnv.nrIni));
            ret.setNrFinal(Integer.parseInt(objEnv.nrFim));
            ret.setMsg(result.getMsg());
            ret.setAmbiente(objEnv.ambiente);
            if (result.getStatus() == 201) {
                logger.info("NF-e inutilizada protocolo: " + result.getProtocolo());
                ret.setStatus(StatusInutilizacaoNFE.SUCESSO);
                ret.setNrProtocolo(result.getProtocolo());
                if (result.getData() != null) {
                    try {
                        formatter2 = new SimpleDateFormat(Util.FMTYYYYMMDDhhmmss);
                        date = formatter2.parse(result.getData());
                        ret.setDataInutilizacao(date);
                    }
                    catch (Exception formatter2) {}
                }
            } else {
                ret.setStatus(StatusInutilizacaoNFE.ERRO_GERAL);
                logger.severe(result.getMsg());
            }
            ret.gerarTXT(this.dirSaida, objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), objEnvio.getObjEnvio());
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                ret.gerarTXT(this.paramProperties.getPastaArmazenamentoRet(), objEnvio.getNomeArquivo().toUpperCase().replace('I', 'O'), objEnvio.getObjEnvio());
            }
        }
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML || objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
            ret = new RetRecepcaoInutilizacaoNFE();
            ret.setNrCNPJEmitente(objEnv.cnpjEmitente);
            ret.setAno(Integer.parseInt(objEnv.nrAno));
            ret.setNrSerie(Short.parseShort(objEnv.nrSerie));
            ret.setNrInicial(Integer.parseInt(objEnv.nrIni));
            ret.setNrFinal(Integer.parseInt(objEnv.nrFim));
            ret.setAmbiente(objEnv.ambiente);
            if (result.getStatus() == 201) {
                logger.info("NF-e inutilizada protocolo: " + result.getProtocolo());
                ret.setStatus(StatusInutilizacaoNFE.SUCESSO);
                ret.setNrProtocolo(result.getProtocolo());
                ret.setMsg("A inutilizacao foi registrada com sucesso");
                if (result.getData() != null) {
                    try {
                        formatter2 = new SimpleDateFormat(Util.FMTYYYY_MM_DDhhmmss);
                        date = formatter2.parse(result.getData());
                        ret.setDataInutilizacao(date);
                    }
                    catch (Exception exception) {}
                }
            } else {
                logger.severe(result.getMsg());
                ret.setMsg(Util.retiraCaracteres(result.getMsg()));
                ret.setStatus(StatusInutilizacaoNFE.ERRO_GERAL);
            }
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                ret.gerarXML(this.dirSaida, objEnvio.getNomeArquivo().replace('I', 'O'));
            }
            if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                ret.gerarXML_SEFAZ(this.dirSaida, objEnvio.getNomeArquivo().replace('I', 'O'));
            }
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML) {
                    ret.gerarXML(this.paramProperties.getPastaArmazenamentoRet(), objEnvio.getNomeArquivo().replace('I', 'O'));
                }
                if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
                    ret.gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamentoRet(), objEnvio.getNomeArquivo().replace('I', 'O'));
                }
            }
        }
        this.DeleteTmpFile(objEnvio);
    }

    private void GeraRetornoCTE(RetInutilizacao result, EnvioIntegracao objEnvio) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        Util.EnvInutilizacao env = (Util.EnvInutilizacao)objEnvio.getObjEnvio();
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.TXT) {
            ParseRetInutilizacao ret = new ParseRetInutilizacao();
            ret.setCnpjEmitente(env.cnpjEmitente);
            ret.setAno(env.nrAno);
            ret.setNrSerie(env.nrSerie);
            ret.setNrIni(env.nrIni);
            ret.setNrFinal(env.nrFim);
            ret.setMsg(result.getMsg());
            ret.setAmbiente(AmbienteSistema.valueOf(objEnvio.getTpAmb()));
            if (result.getStatus() == 201) {
                logger.info("CT-e inutilizado protocolo: " + result.getProtocolo());
                ret.setStatus(StatusInutilizacaoCTE.SUCESSO);
                ret.setProtocolo(result.getProtocolo());
                if (result.getData() != null) {
                    try {
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date date = formatter.parse(result.getData());
                        ret.setDataInutilizacao(date);
                    }
                    catch (Exception exception) {}
                }
            } else {
                ret.setStatus(StatusInutilizacaoCTE.ERRO_GERAL);
                logger.severe(result.getMsg());
                logger.info("Erro geral - " + result.getMsg());
            }
            RetornoCTE.gerarTxtInutilizacao(this.dirSaida, objEnvio.getNomeArquivo(), ret);
            this.DeleteTmpFile(objEnvio);
        }
        if (objEnvio.getTpIntegraSaida() == TipoIntegracao.XML_SEFAZ) {
            if (result.getStatus() == 201) {
                logger.info("CT-e inutilizado protocolo: " + result.getProtocolo());
            } else {
                logger.info("Erro geral - " + result.getMsg());
            }
            RetornoCTE.gerarXML_INUT_SEFAZ(this.dirSaida, objEnvio.getNomeArquivo(), objEnvio, result);
            this.DeleteTmpFile(objEnvio);
        }
    }

    @Override
    public void run() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        String nomeFile = "";
        while (true) {
            try {
                while (true) {
                    EnvioIntegracao objEnvio = new EnvioIntegracao();
                    objEnvio = (EnvioIntegracao)this.sharedLocation.Get();
                    objEnvio.setTpAmb(this.paramProperties.getAmbiente().name());
                    nomeFile = objEnvio.getNomeArquivo();
                    logger.info("Inutilizando arquivo " + objEnvio.getNomeArquivo());
                    RetInutilizacao result = null;
                    if (objEnvio.getObjEnvio() instanceof Util.EnvInutilizacao) {
                        if (((Util.EnvInutilizacao)objEnvio.getObjEnvio()).usuario == null) {
                            logger.info(this.paramProperties.getVersaoIntegrador() + " - Setando usu\u00e1rio padr\u00e3o...");
                            ((Util.EnvInutilizacao)objEnvio.getObjEnvio()).usuario = this.paramProperties.getUsuarioPadraoGeral();
                        }
                        Util.EnvInutilizacaoV200 objEnv = (Util.EnvInutilizacaoV200)objEnvio.getObjEnvio();
                        RetInutilizacao ret = result = NfeInterface.inutilizar(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), objEnv);
                        logger.info("Status inutiliza\u00e7\u00e3o: " + ret.getStatus());
                        if (ret.getStatus() == 201) {
                            this.GeraRetornoNFE(ret, objEnvio, "102");
                        } else {
                            this.GeraRetornoNFE(ret, objEnvio, "999");
                        }
                    }
                    if (!(objEnvio.getObjEnvio() instanceof Util.EnvInutilizacao)) continue;
                    Util.EnvInutilizacao env = (Util.EnvInutilizacao)objEnvio.getObjEnvio();
                    if (env.usuario == null) {
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - Setando usu\u00e1rio padr\u00e3o...");
                        env.usuario = this.paramProperties.getUsuarioPadraoGeral();
                    }
                    result = CteInterface.inutilizar(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), env);
                    this.GeraRetornoCTE(result, objEnvio);
                }
            }
            catch (IOException exIO) {
                logger.severe("Erro ao gerar o arquivo: " + nomeFile + " - " + exIO.getMessage());
                continue;
            }
            catch (Exception ex) {
                logger.severe("Erro geral no envio: " + nomeFile + " - " + ex.getMessage());
                continue;
            }
            break;
        }
    }
}

