/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.cte.v3;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.cte.factory.ParseTXTAverbacaoCTEFactory;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.cte.V200.AverbacaoCTE;
import java.io.InputStream;

public class ParseTXTAverbacaoCTEv300
extends ParseTXTAverbacaoCTEFactory {
    private AverbacaoCTE obj = null;
    private static ParseTXTAverbacaoCTEv300 instance;

    public static ParseTXTAverbacaoCTEv300 getInstance() {
        if (instance == null) {
            instance = new ParseTXTAverbacaoCTEv300();
        }
        return instance;
    }

    @Override
    public AverbacaoCTE parse(InputStream is) throws ParseException {
        try (Scanner scanner = null;){
            scanner = new Scanner(is);
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String linha = null;
                linha = scanner.nextLine();
                this.lerLinhaAverbacao(linha + "|");
            }
        }
        return this.obj;
    }

    private void lerLinhaAverbacao(String linha) throws ParseException {
        Integer ID = Integer.parseInt(linha.substring(1, 3));
        switch (ID) {
            case 1: {
                this.dadosAverbacao(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + String.valueOf(ID) + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    private void dadosAverbacao(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            this.obj = new AverbacaoCTE();
            while (scanner.hasNext()) {
                scanner.next();
                String chaveAcesso = scanner.next();
                String tipo = scanner.next();
                this.obj.setChaveAcesso(chaveAcesso);
                switch (tipo) {
                    case "0": {
                        this.obj.setTipo(AverbacaoCTE.TipoProcessoAverbacao.AVERBAR);
                        break;
                    }
                    case "1": {
                        this.obj.setTipo(AverbacaoCTE.TipoProcessoAverbacao.CANCELAR);
                        break;
                    }
                    default: {
                        throw new ParseException("Tipo de Processo de Averba\u00e7\u00e3o inv\u00e1lido.");
                    }
                }
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 001: " + ex.getMessage());
        }
    }
}

