/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.cte.v3;

import br.com.ophos.integracao.interfaces.cte.dto.emissao.Aereo;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Aquaviario;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Balsa;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTe;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTeAnulacao;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTeComplemento;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTeNormal;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.CTeSubstituto;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ComponentePrestacao;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Destinatario;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Documento;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoCTe;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoNF;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoNFe;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoOutro;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.DocumentoPapel;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Duplicata;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Emitente;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.EmitenteDocAnterior;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Entrega;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.EscolhaSN;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Expedidor;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Fatura;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.FluxoCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMS;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN00;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN20;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN40;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN41;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN51;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN60;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSN90;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSOutraUF;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSSN;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ICMSUFDestino;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Impostos;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.InfoContribuinte;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.InfoFisco;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.InformacaoAdicional;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.InformacaoCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Lacre;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ManuseioCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.MultiModal;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.NaturezaCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.OrdemColeta;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.PermissaoDownload;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.PontoPassagem;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.ProdutoPerigosoAereo;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.QuantidadeCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Recebedor;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Remetente;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Rodoviario;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.SeguroMultimodal;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Tarifa;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.TipoConhecimento;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.Tomador;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.UnidadeCarga;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.UnidadeTransporte;
import br.com.ophos.integracao.interfaces.cte.dto.emissao.VeiculoNovo;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalDateSerializer;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.LocalDateTimeSerializer;
import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.ParseException2;
import br.com.ophos.parse.txt.cte.factory.ParseTXTEnvioCTEFactory;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class ParseTXTEnvioCTEv300
extends ParseTXTEnvioCTEFactory {
    private static ParseTXTEnvioCTEv300 instance;
    protected CTe obj = null;
    protected HashMap<Integer, Object> mapDocumento = new HashMap();
    protected HashMap<Integer, UnidadeTransporte> mapUnidadeTransporte = new HashMap();
    protected HashMap<Integer, UnidadeCarga> mapUnidadeCargaTransporte = new HashMap();
    protected HashMap<Integer, UnidadeCarga> mapUnidadeCarga = new HashMap();
    protected String caracQuebraLinha;

    public static ParseTXTEnvioCTEv300 getInstance(String charQuebraLinha) {
        if (instance == null) {
            instance = new ParseTXTEnvioCTEv300(charQuebraLinha);
        }
        return instance;
    }

    public ParseTXTEnvioCTEv300() {
    }

    public ParseTXTEnvioCTEv300(String charQuebraLinha) {
        this.caracQuebraLinha = charQuebraLinha;
    }

    protected Integer GetQtdDelimiter(String line, String delimiter) {
        Integer qtdRetorno = 0;
        char[] caracters = line.toCharArray();
        int i = 0;
        while (i < caracters.length) {
            String charac = String.valueOf(caracters[i]);
            if (charac.equals(delimiter)) {
                qtdRetorno = qtdRetorno + 1;
            }
            ++i;
        }
        return qtdRetorno;
    }

    @Override
    public CTe parse(InputStream in) throws ParseException2 {
        try (Scanner scanner = null;){
            this.obj = new CTe();
            this.obj.setInfoAdicional(new InformacaoAdicional());
            this.obj.getInfoAdicional().setFluxoCarga(new FluxoCarga());
            this.obj.setImpostos(new Impostos());
            this.obj.setInfoCte(new CTeNormal());
            this.obj.setTipo(TipoConhecimento.NORMAL);
            ArrayList<Integer> linhasErro = new ArrayList<Integer>();
            ArrayList<Integer> linhasObrigatorias = new ArrayList<Integer>();
            linhasObrigatorias.add(1);
            linhasObrigatorias.add(4);
            linhasObrigatorias.add(7);
            ArrayList<Integer> linhasEncontradas = new ArrayList<Integer>();
            scanner = new Scanner(in);
            scanner.next();
            while (scanner.hasNextLine()) {
                String linha = scanner.nextLine();
                if (linha.length() < 3) continue;
                Integer n = Integer.parseInt(linha.substring(1, 3));
                linhasEncontradas.add(n);
                try {
                    this.lerLinha(linha + "|");
                }
                catch (ParseException paex) {
                    linhasErro.add(n);
                }
            }
            Object msgException = "";
            for (Object e : linhasErro) {
                msgException = (String)msgException + String.valueOf(e);
            }
            if (linhasErro.size() > 0) {
                throw new ParseException2("ERRO_LAYOUT: " + (String)msgException, this.obj);
            }
            for (Object e : linhasObrigatorias) {
                Integer id = (Integer)e;
                if (linhasEncontradas.contains(id)) continue;
                throw new ParseException2("Linha obrigat\u00f3ria: " + e.toString() + " n\u00e3o encontrada no arquivo texto.", this.obj);
            }
        }
        return this.obj;
    }

    protected void lerLinha(String aLine) throws ParseException {
        Integer ID = Integer.parseInt(aLine.substring(1, 3));
        switch (ID) {
            case 1: {
                this.infoCTe(aLine);
                break;
            }
            case 2: {
                this.tomador(aLine);
                break;
            }
            case 3: {
                this.pontoPassagem(aLine);
                break;
            }
            case 4: {
                this.emitente(aLine);
                break;
            }
            case 5: {
                this.remetente(aLine);
                break;
            }
            case 6: {
                this.documentos(aLine);
                break;
            }
            case 7: {
                this.valoresPrestacao(aLine);
                break;
            }
            case 8: {
                this.expedidor(aLine);
                break;
            }
            case 9: {
                this.recebedor(aLine);
                break;
            }
            case 10: {
                this.destinatario(aLine);
                break;
            }
            case 11: {
                this.localEntrega(aLine);
                break;
            }
            case 12: {
                this.componentesPrestacao(aLine);
                break;
            }
            case 13: {
                this.informacaoCarga(aLine);
                break;
            }
            case 14: {
                this.quantidadeCarga(aLine);
                break;
            }
            case 15: {
                this.container(aLine);
                break;
            }
            case 16: {
                this.lacreContainer(aLine);
                break;
            }
            case 17: {
                this.emitenteDocAnterior(aLine);
                break;
            }
            case 18: {
                this.seguroCarga(aLine);
                break;
            }
            case 19: {
                this.infoRodoviario(aLine);
                break;
            }
            case 20: {
                this.ordemColeta(aLine);
                break;
            }
            case 21: {
                this.comporInformacoesValePedagio(aLine);
                break;
            }
            case 22: {
                this.comporVeiculo(aLine);
                break;
            }
            case 23: {
                this.complementado(aLine);
                break;
            }
            case 24: {
                this.componentesComplementado(aLine);
                break;
            }
            case 25: {
                this.documentoAnterior(aLine);
                break;
            }
            case 27: {
                this.motorista(aLine);
                break;
            }
            case 28: {
                this.cteAnulacao(aLine);
                break;
            }
            case 29: {
                this.cteSubstituto(aLine);
                break;
            }
            case 30: {
                this.produtosPerigosos(aLine);
                break;
            }
            case 31: {
                this.comporVeiculosNovos(aLine);
                break;
            }
            case 32: {
                this.comporDadosCobranca(aLine);
                break;
            }
            case 33: {
                this.comporDuplicatas(aLine);
                break;
            }
            case 34: {
                this.comporProprietarioVeiculo(aLine);
                break;
            }
            case 35: {
                this.lacreRodoviario(aLine);
                break;
            }
            case 36: {
                this.infoContribuinte(aLine);
                break;
            }
            case 37: {
                this.infoFisco(aLine);
                break;
            }
            case 38: {
                this.infoAereo(aLine);
                break;
            }
            case 39: {
                this.infoManuseio(aLine);
                break;
            }
            case 40: {
                this.infoCargaEspecial(aLine);
                break;
            }
            case 41: {
                this.infoAquaviario(aLine);
                break;
            }
            case 42: {
                this.infoBalsa(aLine);
                break;
            }
            case 43: {
                this.infoConteinerAquaviario(aLine);
                break;
            }
            case 44: {
                this.infoLacreConteiner(aLine);
                break;
            }
            case 45: {
                this.infoDocumentoConteiner(aLine);
                break;
            }
            case 46: {
                this.dadosLocalRetirada(aLine);
                break;
            }
            case 47: {
                this.dadosUnidadesTransporte(aLine);
                break;
            }
            case 48: {
                this.dadosUnidadesCargaTransporte(aLine);
                break;
            }
            case 49: {
                this.dadosUnidadesCarga(aLine);
                break;
            }
            case 50: {
                this.dadosLacresTransporte(aLine);
                break;
            }
            case 51: {
                this.dadosLacresCargaTransporte(aLine);
                break;
            }
            case 52: {
                this.dadosLacresCarga(aLine);
                break;
            }
            case 53: {
                this.dadosMultiModal(aLine);
                break;
            }
            case 54: {
                this.dadosAutorizacaoXML(aLine);
                break;
            }
            case 55: {
                this.dadosProdutoPerigosoAereo(aLine);
                break;
            }
            case 56: {
                this.dadosDocumentosMultimodal(aLine);
                break;
            }
            case 57: {
                this.dadosSeguroMultimodal(aLine);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + String.valueOf(ID) + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void infoCTe(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 46) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 46 campos.");
            }
            while (true) {
                String grp4TipoOper;
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                this.obj.setReferencia(scanner.next());
                this.obj.setUsuarioEmitente(scanner.next());
                this.obj.setCfop(br.com.ophos.util.cte.Util.StringToShort(scanner.next()));
                this.obj.setNaturezaOperacao(scanner.next());
                String indicadorGlobalizado = scanner.next();
                if ("1".equals(indicadorGlobalizado)) {
                    this.obj.setIndicadorGlobalizado(Boolean.TRUE);
                } else {
                    this.obj.setIndicadorGlobalizado(Boolean.FALSE);
                }
                this.obj.setSerie(br.com.ophos.util.cte.Util.StringToShort(scanner.next()));
                this.obj.setNumero(br.com.ophos.util.cte.Util.StringToInteger(scanner.next()));
                this.obj.setDataEmissao(LocalDateTimeSerializer.parseDateTime(scanner.next().replaceAll("-", "")));
                this.obj.setTipo(br.com.ophos.util.cte.Util.valueToTipoConhecimento(scanner.next()));
                if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                    this.obj.setInfoCte(new CTeSubstituto());
                }
                if (this.obj.getTipo().equals((Object)TipoConhecimento.ANULACAO_VALORES)) {
                    this.obj.setInfoCte(new CTeAnulacao());
                }
                if (this.obj.getTipo().equals((Object)TipoConhecimento.COMPLEMENTO_VALOR)) {
                    this.obj.setInfoCte(new CTeComplemento());
                }
                this.obj.setNrChaveAcessoRef(scanner.next());
                this.obj.setNrMunicipioEmissao(br.com.ophos.util.cte.Util.StringToInteger(scanner.next()));
                this.obj.setMunicipioEmissao(scanner.next());
                this.obj.setUfEmissao(scanner.next());
                this.obj.setTipoModal(br.com.ophos.util.cte.Util.valueToTipoModal(scanner.next()));
                this.obj.setTipoServico(br.com.ophos.util.cte.Util.valueToTipoServico(scanner.next()));
                this.obj.setNrMunicipioInicio(br.com.ophos.util.cte.Util.StringToInteger(scanner.next()));
                this.obj.setMunicipioInicio(scanner.next());
                this.obj.setUfInicio(scanner.next());
                this.obj.setNrMunicipioFim(br.com.ophos.util.cte.Util.StringToInteger(scanner.next()));
                this.obj.setMunicipioFim(scanner.next());
                this.obj.setUfFim(scanner.next());
                this.obj.setRetira(br.com.ophos.util.cte.Util.valueEscolhaSN(scanner.next()));
                this.obj.setDetalheRetira(scanner.next());
                this.obj.getInfoAdicional().setCaracteristicaTransporte(scanner.next());
                this.obj.getInfoAdicional().setCaracteristicaServico(scanner.next());
                scanner.next();
                this.obj.getInfoAdicional().getFluxoCarga().setOrigem(scanner.next());
                this.obj.getInfoAdicional().getFluxoCarga().setDestino(scanner.next());
                this.obj.getInfoAdicional().getFluxoCarga().setRota(scanner.next());
                Entrega entrega = new Entrega();
                String grpTipoOper = scanner.next();
                if (!grpTipoOper.equals("")) {
                    entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoData(grpTipoOper));
                }
                String grp2TipoOper = scanner.next();
                String grp2Dprog = scanner.next();
                if (!grp2Dprog.equals("")) {
                    entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoHora(grp2TipoOper));
                }
                String grp3TipoOper = scanner.next();
                scanner.next();
                scanner.next();
                if (!grp3TipoOper.equals("")) {
                    entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoData(grp3TipoOper));
                }
                if (!(grp4TipoOper = scanner.next()).equals("")) {
                    entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoHora(grp4TipoOper));
                }
                String grp5TipoOper = scanner.next();
                scanner.next();
                if (!grp5TipoOper.equals("")) {
                    entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoHora(grp5TipoOper));
                }
                String grp6TipoOper = scanner.next();
                scanner.next();
                scanner.next();
                if (!grp6TipoOper.equals("")) {
                    entrega.setTipoPeriodo(br.com.ophos.util.cte.Util.valueToTipoPeriodoHora(grp6TipoOper));
                }
                this.obj.getInfoAdicional().setOrigemCalculo(scanner.next());
                this.obj.getInfoAdicional().setDestinoCalculo(scanner.next());
                this.obj.setObservacao(Util.adicionarQuebraLinha(scanner.next(), this.caracQuebraLinha).trim());
                this.obj.getImpostos().setObservacaoFisco(scanner.next());
                String infoGlobalizado = scanner.next();
                if (infoGlobalizado == null || infoGlobalizado.trim().isEmpty()) continue;
                if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                    ((CTeNormal)this.obj.getInfoCte()).setInfoGlobalizado(infoGlobalizado);
                    continue;
                }
                if (!this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) continue;
                ((CTeSubstituto)this.obj.getInfoCte()).setInfoGlobalizado(infoGlobalizado);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 1. " + ex.getMessage(), this.obj);
        }
    }

    protected void tomador(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 18) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 18 campos.");
            }
            Tomador tomador = new Tomador();
            while (scanner.hasNext()) {
                scanner.next();
                String tipo = scanner.next();
                String cpfCnpj = scanner.next();
                String inscricaoEstadual = scanner.next();
                String tipoIcms = scanner.next();
                String razaoSocial = scanner.next();
                String fantasia = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String nrMunicipio = scanner.next();
                String municipio = scanner.next();
                String cep = scanner.next();
                String uf = scanner.next();
                String nrPais = scanner.next();
                String pais = scanner.next();
                String email = scanner.next();
                String telefone = scanner.next().trim();
                tomador.setTipo(br.com.ophos.util.cte.Util.valueToTipoTomador(tipo));
                tomador.setTipoIcmsTomador(br.com.ophos.util.cte.Util.valueToTipoIcmsTomador(tipoIcms));
                tomador.setCnpjCpf(cpfCnpj);
                tomador.setInscricaoEstadual(inscricaoEstadual);
                tomador.setRazaoSocial(razaoSocial);
                if (fantasia != null && !fantasia.trim().isEmpty()) {
                    tomador.setNomeFantasia(fantasia);
                }
                tomador.setLogradouro(logradouro);
                tomador.setNumero(numero);
                if (complemento != null && !complemento.trim().isEmpty()) {
                    tomador.setComplemento(complemento);
                }
                tomador.setBairro(bairro);
                tomador.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(nrMunicipio));
                tomador.setMunicipio(municipio);
                if (cep != null && !cep.trim().isEmpty()) {
                    tomador.setCep(cep);
                }
                tomador.setUf(uf);
                if (nrPais != null && !nrPais.trim().isEmpty()) {
                    tomador.setNrPais(br.com.ophos.util.cte.Util.StringToShort(nrPais));
                }
                if (pais != null && !pais.trim().isEmpty()) {
                    tomador.setPais(pais);
                }
                if (telefone != null && !telefone.trim().isEmpty()) {
                    tomador.setTelefone(telefone);
                }
                if (email == null || email.trim().isEmpty()) continue;
                tomador.setEmail(email);
            }
            this.obj.setTomador(tomador);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 2. " + ex.getMessage());
        }
    }

    protected void pontoPassagem(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 003 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campos.");
            }
            PontoPassagem ponto = new PontoPassagem();
            while (scanner.hasNext()) {
                scanner.next();
                ponto.setIdentificacao(scanner.next());
            }
            this.obj.getInfoAdicional().getFluxoCarga().getPontoPassagem().add(ponto);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 3. " + ex.getMessage());
        }
    }

    protected void emitente(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 18) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 18 campos.");
            }
            Emitente emitente = new Emitente();
            while (scanner.hasNext()) {
                scanner.next();
                String cnpj = scanner.next();
                String inscricaoEstadual = scanner.next();
                String inscricaoEstadualSt = scanner.next();
                String razaoSocial = scanner.next();
                String fantasia = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String nrMunicipio = scanner.next();
                String municipio = scanner.next();
                String cep = scanner.next();
                String nrUf = scanner.next();
                String uf = scanner.next();
                scanner.next();
                scanner.next();
                String telefone = scanner.next();
                String email = scanner.next();
                emitente.setCnpj(cnpj);
                emitente.setInscricaoEstadual(inscricaoEstadual);
                emitente.setInscricaoEstadualSt(inscricaoEstadualSt);
                emitente.setRazaoSocial(razaoSocial);
                if (fantasia != null && !fantasia.trim().isEmpty()) {
                    emitente.setFantasia(fantasia);
                }
                emitente.setLogradouro(logradouro);
                emitente.setNumero(numero);
                if (complemento != null && !complemento.trim().isEmpty()) {
                    emitente.setComplemento(complemento);
                }
                emitente.setBairro(bairro);
                emitente.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(nrMunicipio));
                emitente.setMunicipio(municipio);
                if (cep != null && !cep.trim().isEmpty()) {
                    emitente.setCep(cep);
                }
                emitente.setNrUF(br.com.ophos.util.cte.Util.StringToShort(nrUf));
                emitente.setUf(uf);
                if (telefone != null && !telefone.trim().isEmpty()) {
                    emitente.setTelefone(telefone);
                }
                if (email == null || email.trim().isEmpty()) continue;
                emitente.setEmail(email);
            }
            this.obj.setEmitente(emitente);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 4. " + ex.getMessage());
        }
    }

    protected void remetente(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 16) {
                throw new ParseException("A linha 005 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 16 campos.");
            }
            Remetente remetente = new Remetente();
            while (scanner.hasNext()) {
                scanner.next();
                String cpfCnpj = scanner.next();
                String inscricaoEstadual = scanner.next();
                String razaoSocial = scanner.next();
                String fantasia = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String nrMunicipio = scanner.next();
                String municipio = scanner.next();
                String cep = scanner.next();
                String uf = scanner.next();
                String nrPais = scanner.next();
                String pais = scanner.next();
                String email = scanner.next();
                String telefone = scanner.next().trim();
                remetente.setCnpjCpf(cpfCnpj);
                remetente.setInscricaoEstadual(inscricaoEstadual);
                remetente.setRazaoSocial(razaoSocial);
                if (fantasia != null && !fantasia.trim().isEmpty()) {
                    remetente.setNomeFantasia(fantasia);
                }
                remetente.setLogradouro(logradouro);
                remetente.setNumero(numero);
                if (complemento != null && !complemento.trim().isEmpty()) {
                    remetente.setComplemento(complemento);
                }
                remetente.setBairro(bairro);
                remetente.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(nrMunicipio));
                remetente.setMunicipio(municipio);
                if (cep != null && !cep.trim().isEmpty()) {
                    remetente.setCep(cep);
                }
                remetente.setUf(uf);
                if (nrPais != null && !nrPais.trim().isEmpty()) {
                    remetente.setNrPais(br.com.ophos.util.cte.Util.StringToShort(nrPais));
                }
                if (pais != null && !pais.trim().isEmpty()) {
                    remetente.setPais(pais);
                }
                if (telefone != null && !telefone.trim().isEmpty()) {
                    remetente.setTelefone(telefone);
                }
                if (email == null || email.trim().isEmpty()) continue;
                remetente.setEmail(email);
            }
            this.obj.setRemetente(remetente);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 5. " + ex.getMessage());
        }
    }

    protected void documentos(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 26) {
                throw new ParseException("A linha 006 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 26 campos.");
            }
            scanner.next();
            Integer documentoId = Integer.parseInt(scanner.next());
            String grpNFromaneo = scanner.next();
            String grpNFnrPedido = scanner.next();
            String grpMod = scanner.next();
            String grpNFnrSerie = scanner.next();
            String grpNFnrDocumento = scanner.next();
            String grpNFdtEmissao = scanner.next();
            String grpNFvlBC = scanner.next();
            String grpNFvlICMS = scanner.next();
            String grpNFvlBCST = scanner.next();
            String grpNFvlST = scanner.next();
            String grpNFvlProd = scanner.next();
            String grpNFvlNF = scanner.next();
            String grpNFnrCFOP = scanner.next();
            String grpNFpeso = scanner.next();
            String grpNFsuframa = scanner.next();
            String grpNFdataPrevista = scanner.next();
            if (!grpNFnrDocumento.equals("")) {
                DocumentoNF docNF = new DocumentoNF();
                docNF.setNrRomaneo(grpNFromaneo);
                docNF.setNrPedido(grpNFnrPedido);
                docNF.setModelo(br.com.ophos.util.cte.Util.valueToTipoDocNF(grpMod));
                docNF.setNrSerie(grpNFnrSerie);
                docNF.setNrDocumento(grpNFnrDocumento);
                docNF.setDataEmissao(LocalDateSerializer.parseDate(grpNFdtEmissao.replaceAll("-", "")));
                docNF.setBaseCalculo(br.com.ophos.util.cte.Util.StringToDouble(grpNFvlBC, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                docNF.setValorICMS(br.com.ophos.util.cte.Util.StringToDouble(grpNFvlICMS, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                docNF.setBaseCalculoST(br.com.ophos.util.cte.Util.StringToDouble(grpNFvlBCST, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                docNF.setValorICMSST(br.com.ophos.util.cte.Util.StringToDouble(grpNFvlST, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                docNF.setValorTotalProduto(br.com.ophos.util.cte.Util.StringToDouble(grpNFvlProd, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                docNF.setValorTotal(br.com.ophos.util.cte.Util.StringToDouble(grpNFvlNF, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                docNF.setCfopPredomina(br.com.ophos.util.cte.Util.StringToShort(grpNFnrCFOP));
                docNF.setNrPeso(br.com.ophos.util.cte.Util.StringToDouble(grpNFpeso, br.com.ophos.util.cte.Util.ST_FMT_TRES_DECIMAIS));
                docNF.setNrPIN(grpNFsuframa);
                if (grpNFdataPrevista != null && !grpNFdataPrevista.isBlank()) {
                    docNF.setDataPrevista(LocalDateSerializer.parseDate(grpNFdataPrevista.replaceAll("-", "")));
                }
                if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                    ((CTeNormal)this.obj.getInfoCte()).getDocumentos().add(docNF);
                }
                if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                    ((CTeSubstituto)this.obj.getInfoCte()).getDocumentos().add(docNF);
                }
                this.mapDocumento.put(documentoId, docNF);
            }
            String grpNFeChaveAcesso = scanner.next();
            String grpNFeSuframa = scanner.next();
            String grpNFeDataPrevista = scanner.next();
            if (!grpNFeChaveAcesso.equals("")) {
                DocumentoNFe docNFe = new DocumentoNFe();
                docNFe.setChaveAcesso(grpNFeChaveAcesso);
                if (grpNFeSuframa != null && !grpNFeSuframa.isEmpty()) {
                    docNFe.setNrPIN(grpNFeSuframa);
                }
                if (grpNFeDataPrevista != null && !grpNFeDataPrevista.isBlank()) {
                    docNFe.setDataPrevista(LocalDateSerializer.parseDate(grpNFeDataPrevista.replaceAll("-", "")));
                }
                if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                    ((CTeNormal)this.obj.getInfoCte()).getDocumentos().add(docNFe);
                }
                if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                    ((CTeSubstituto)this.obj.getInfoCte()).getDocumentos().add(docNFe);
                }
                this.mapDocumento.put(documentoId, docNFe);
            }
            String grpOutrosTipoDoc = scanner.next();
            String grpOutrosDescOutro = scanner.next();
            String grpOutrosNdoc = scanner.next();
            String grpOutrosDemi = scanner.next();
            String grpOutrosVdoFisc = scanner.next();
            String grpOutrosDataPrevista = scanner.next();
            if (!grpOutrosTipoDoc.equals("")) {
                DocumentoOutro docOutro = new DocumentoOutro();
                docOutro.setTipo(br.com.ophos.util.cte.Util.valueToTipoDocumentoOutro(grpOutrosTipoDoc));
                docOutro.setDescricao(grpOutrosDescOutro);
                docOutro.setNrDocumento(grpOutrosNdoc);
                docOutro.setDataEmissao(LocalDateSerializer.parseDate(grpOutrosDemi.replaceAll("-", "")));
                docOutro.setValor(br.com.ophos.util.cte.Util.StringToDouble(grpOutrosVdoFisc, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                if (grpNFeDataPrevista != null && !grpNFeDataPrevista.isBlank()) {
                    docOutro.setDataPrevista(LocalDateSerializer.parseDate(grpOutrosDataPrevista.replaceAll("-", "")));
                }
                if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                    ((CTeNormal)this.obj.getInfoCte()).getDocumentos().add(docOutro);
                }
                if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                    ((CTeSubstituto)this.obj.getInfoCte()).getDocumentos().add(docOutro);
                }
                this.mapDocumento.put(documentoId, docOutro);
            }
            scanner.close();
        }
        catch (ParseException | NumberFormatException ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 6. " + ex.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void valoresPrestacao(String aLine) throws ParseException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (java.util.Scanner scanner = new java.util.Scanner(aLine);){
                scanner.useDelimiter("\\|");
                Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
                if (qtdCampos != 33) {
                    throw new ParseException("A linha 007 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 33 campos.");
                }
                while (true) {
                    void var6_9;
                    String grpIndSN;
                    String grp40situacaoTrib;
                    if (!scanner.hasNext()) {
                        scanner.close();
                        return;
                    }
                    scanner.next();
                    this.obj.setValorTotalPrestacao(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    this.obj.setValorReceber(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    this.obj.getImpostos().setValorTotalTributos(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    Object var6_10 = null;
                    String grp00vlBcIcms = scanner.next();
                    String grp00vlAliqIcms = scanner.next();
                    String grp00vlIcms = scanner.next();
                    if (!grp00vlIcms.equals("")) {
                        ICMSN00 iCMSN00 = new ICMSN00();
                        iCMSN00.setValorBC(br.com.ophos.util.cte.Util.StringToDouble(grp00vlBcIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN00.setAliquota(br.com.ophos.util.cte.Util.StringToDouble(grp00vlAliqIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN00.setValor(br.com.ophos.util.cte.Util.StringToDouble(grp00vlIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    String grp20vlRedBCIcms = scanner.next();
                    String grp20vlBcIcms = scanner.next();
                    String grp20vlAliqIcms = scanner.next();
                    String grp20vlIcms = scanner.next();
                    if (!grp20vlIcms.equals("")) {
                        ICMSN20 iCMSN20 = new ICMSN20();
                        iCMSN20.setReducaoBC(br.com.ophos.util.cte.Util.StringToDouble(grp20vlRedBCIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN20.setValorBC(br.com.ophos.util.cte.Util.StringToDouble(grp20vlBcIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN20.setAliquota(br.com.ophos.util.cte.Util.StringToDouble(grp20vlAliqIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN20.setValor(br.com.ophos.util.cte.Util.StringToDouble(grp20vlIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (!(grp40situacaoTrib = scanner.next()).equals("")) {
                        if (grp40situacaoTrib.equals("40")) {
                            ICMSN40 iCMSN40 = new ICMSN40();
                        }
                        if (grp40situacaoTrib.equals("41")) {
                            ICMSN41 iCMSN41 = new ICMSN41();
                        }
                        if (grp40situacaoTrib.equals("51")) {
                            ICMSN51 iCMSN51 = new ICMSN51();
                        }
                    }
                    String grp60vlBcRetIcms = scanner.next();
                    String grp60vlRetIcms = scanner.next();
                    String grp60vlAliqRetIcms = scanner.next();
                    String grp60vlCredRetIcms = scanner.next();
                    if (!grp60vlRetIcms.equals("")) {
                        ICMSN60 iCMSN60 = new ICMSN60();
                        iCMSN60.setValorBC(br.com.ophos.util.cte.Util.StringToDouble(grp60vlBcRetIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN60.setAliquota(br.com.ophos.util.cte.Util.StringToDouble(grp60vlAliqRetIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN60.setValor(br.com.ophos.util.cte.Util.StringToDouble(grp60vlRetIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN60.setValorCredito(br.com.ophos.util.cte.Util.StringToDouble(grp60vlCredRetIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    String grp90vlBcRedIcms = scanner.next();
                    String grp90vlBcIcms = scanner.next();
                    String grp90vlAliqIcms = scanner.next();
                    String grp90vlIcms = scanner.next();
                    String grp90vlCtedIcms = scanner.next();
                    if (!grp90vlIcms.equals("")) {
                        ICMSN90 iCMSN90 = new ICMSN90();
                        iCMSN90.setReducaoBC(br.com.ophos.util.cte.Util.StringToDouble(grp90vlBcRedIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN90.setValorBC(br.com.ophos.util.cte.Util.StringToDouble(grp90vlBcIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN90.setAliquota(br.com.ophos.util.cte.Util.StringToDouble(grp90vlAliqIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN90.setValor(br.com.ophos.util.cte.Util.StringToDouble(grp90vlIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSN90.setValorCredito(br.com.ophos.util.cte.Util.StringToDouble(grp90vlCtedIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    String grpOutrasUFvlBcRedIcms = scanner.next();
                    String grpOutrasUFvlBcIcms = scanner.next();
                    String grpOutrasUFvlAliqIcms = scanner.next();
                    String grpOutrasUFvlIcms = scanner.next();
                    if (!grpOutrasUFvlIcms.equals("")) {
                        ICMSOutraUF iCMSOutraUF = new ICMSOutraUF();
                        iCMSOutraUF.setReducaoBC(br.com.ophos.util.cte.Util.StringToDouble(grpOutrasUFvlBcRedIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSOutraUF.setValorBC(br.com.ophos.util.cte.Util.StringToDouble(grpOutrasUFvlBcIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSOutraUF.setAliquota(br.com.ophos.util.cte.Util.StringToDouble(grpOutrasUFvlAliqIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        iCMSOutraUF.setValor(br.com.ophos.util.cte.Util.StringToDouble(grpOutrasUFvlIcms, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if ((grpIndSN = scanner.next()).equals("1")) {
                        ICMSSN iCMSSN = new ICMSSN();
                    }
                    String valorBaseCalculoIcmsUfDest = scanner.next();
                    String valorAliquotaInternaIcmsUfDest = scanner.next();
                    String valorAliquotaInterestadualIcmsUfDest = scanner.next();
                    String valorPercentualProvisorioIcmsUfDest = scanner.next();
                    String valorAliquotaFCP = scanner.next();
                    String valorFCP = scanner.next();
                    String valorIcmsUfDestino = scanner.next();
                    String valorIcmsUfRemetente = scanner.next();
                    if (valorBaseCalculoIcmsUfDest != null && !valorBaseCalculoIcmsUfDest.trim().isEmpty()) {
                        ICMSUFDestino icmsufdestino = new ICMSUFDestino();
                        icmsufdestino.setBaseCalculoDest(br.com.ophos.util.cte.Util.StringToDouble(valorBaseCalculoIcmsUfDest, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        icmsufdestino.setAliquotaInterna(br.com.ophos.util.cte.Util.StringToDouble(valorAliquotaInternaIcmsUfDest, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        icmsufdestino.setAliquotaInterestadual(br.com.ophos.util.cte.Util.StringToDouble(valorAliquotaInterestadualIcmsUfDest, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        icmsufdestino.setPercentualProvisorio(br.com.ophos.util.cte.Util.StringToDouble(valorPercentualProvisorioIcmsUfDest, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        icmsufdestino.setPercentualFCP(br.com.ophos.util.cte.Util.StringToDouble(valorAliquotaFCP, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        icmsufdestino.setValorFCPDest(br.com.ophos.util.cte.Util.StringToDouble(valorFCP, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        icmsufdestino.setValorICMSDest(br.com.ophos.util.cte.Util.StringToDouble(valorIcmsUfDestino, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        icmsufdestino.setValorICMSRem(br.com.ophos.util.cte.Util.StringToDouble(valorIcmsUfRemetente, br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                        this.obj.getImpostos().setIcmsufdestino(icmsufdestino);
                    }
                    this.obj.getImpostos().setIcms((ICMS)var6_9);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 7. " + ex.getMessage());
        }
    }

    protected void expedidor(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 15) {
                throw new ParseException("A linha 008 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 15 campos.");
            }
            Expedidor expedidor = new Expedidor();
            while (scanner.hasNext()) {
                scanner.next();
                String cpfCnpj = scanner.next();
                String inscricaoEstadual = scanner.next();
                String razaoSocial = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String nrMunicipio = scanner.next();
                String municipio = scanner.next();
                String cep = scanner.next();
                String uf = scanner.next();
                String nrPais = scanner.next();
                String pais = scanner.next();
                String telefone = scanner.next().trim();
                String email = scanner.next();
                expedidor.setCnpjCpf(cpfCnpj);
                expedidor.setInscricaoEstadual(inscricaoEstadual);
                expedidor.setRazaoSocial(razaoSocial);
                expedidor.setLogradouro(logradouro);
                expedidor.setNumero(numero);
                if (complemento != null && !complemento.trim().isEmpty()) {
                    expedidor.setComplemento(complemento);
                }
                expedidor.setBairro(bairro);
                expedidor.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(nrMunicipio));
                expedidor.setMunicipio(municipio);
                if (cep != null && !cep.trim().isEmpty()) {
                    expedidor.setCep(cep);
                }
                expedidor.setUf(uf);
                if (nrPais != null && !nrPais.trim().isEmpty()) {
                    expedidor.setNrPais(br.com.ophos.util.cte.Util.StringToShort(nrPais));
                }
                if (pais != null && !pais.trim().isEmpty()) {
                    expedidor.setPais(pais);
                }
                if (telefone != null && !telefone.trim().isEmpty()) {
                    expedidor.setTelefone(telefone);
                }
                if (email == null || email.trim().isEmpty()) continue;
                expedidor.setEmail(email);
            }
            this.obj.setExpedidor(expedidor);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 8. " + ex.getMessage());
        }
    }

    protected void recebedor(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 15) {
                throw new ParseException("A linha 009 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 15 campos.");
            }
            Recebedor recebedor = new Recebedor();
            while (scanner.hasNext()) {
                scanner.next();
                String cpfCnpj = scanner.next();
                String inscricaoEstadual = scanner.next();
                String razaoSocial = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String nrMunicipio = scanner.next();
                String municipio = scanner.next();
                String cep = scanner.next();
                String uf = scanner.next();
                String nrPais = scanner.next();
                String pais = scanner.next();
                String telefone = scanner.next().trim();
                String email = scanner.next();
                recebedor.setCnpjCpf(cpfCnpj);
                recebedor.setInscricaoEstadual(inscricaoEstadual);
                recebedor.setRazaoSocial(razaoSocial);
                recebedor.setLogradouro(logradouro);
                recebedor.setNumero(numero);
                if (complemento != null && !complemento.trim().isEmpty()) {
                    recebedor.setComplemento(complemento);
                }
                recebedor.setBairro(bairro);
                recebedor.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(nrMunicipio));
                recebedor.setMunicipio(municipio);
                if (cep != null && !cep.trim().isEmpty()) {
                    recebedor.setCep(cep);
                }
                recebedor.setUf(uf);
                if (nrPais != null && !nrPais.trim().isEmpty()) {
                    recebedor.setNrPais(br.com.ophos.util.cte.Util.StringToShort(nrPais));
                }
                if (pais != null && !pais.trim().isEmpty()) {
                    recebedor.setPais(pais);
                }
                if (telefone != null && !telefone.trim().isEmpty()) {
                    recebedor.setTelefone(telefone);
                }
                if (email == null || email.trim().isEmpty()) continue;
                recebedor.setEmail(email);
            }
            this.obj.setRecebedor(recebedor);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 9. " + ex.getMessage());
        }
    }

    protected void destinatario(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 16) {
                throw new ParseException("A linha 010 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 16 campos.");
            }
            Destinatario destinatario = new Destinatario();
            while (scanner.hasNext()) {
                scanner.next();
                String cpfCnpj = scanner.next();
                String inscricaoEstadual = scanner.next();
                String razaoSocial = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String nrMunicipio = scanner.next();
                String municipio = scanner.next();
                String cep = scanner.next();
                String uf = scanner.next();
                String nrPais = scanner.next();
                String pais = scanner.next();
                String telefone = scanner.next().trim();
                String suframa = scanner.next();
                String email = scanner.next();
                destinatario.setCnpjCpf(cpfCnpj);
                destinatario.setInscricaoEstadual(inscricaoEstadual);
                destinatario.setRazaoSocial(razaoSocial);
                destinatario.setLogradouro(logradouro);
                destinatario.setNumero(numero);
                if (complemento != null && !complemento.trim().isEmpty()) {
                    destinatario.setComplemento(complemento);
                }
                destinatario.setBairro(bairro);
                destinatario.setNrMunicipio(br.com.ophos.util.cte.Util.StringToInteger(nrMunicipio));
                destinatario.setMunicipio(municipio);
                if (cep != null && !cep.trim().isEmpty()) {
                    destinatario.setCep(cep);
                }
                destinatario.setUf(uf);
                if (nrPais != null && !nrPais.trim().isEmpty()) {
                    destinatario.setNrPais(br.com.ophos.util.cte.Util.StringToShort(nrPais));
                }
                if (pais != null && !pais.trim().isEmpty()) {
                    destinatario.setPais(pais);
                }
                if (telefone != null && !telefone.trim().isEmpty()) {
                    destinatario.setTelefone(telefone);
                }
                if (suframa != null && !suframa.trim().isEmpty()) {
                    destinatario.setInscricaoSuframa(suframa);
                }
                if (email == null || email.trim().isEmpty()) continue;
                destinatario.setEmail(email);
            }
            this.obj.setDestinatario(destinatario);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 10. " + ex.getMessage());
        }
    }

    @Deprecated
    protected void localEntrega(String aLine) throws ParseException {
        throw new ParseException("Linha 011 desativada por adequa\u00e7\u00e3o \u00e0 NT2015.001");
    }

    protected void componentesPrestacao(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 012 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            ComponentePrestacao comp = new ComponentePrestacao();
            while (scanner.hasNext()) {
                scanner.next();
                comp.setDescricao(scanner.next());
                comp.setValor(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            this.obj.getComponentePrestacao().add(comp);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 12. " + ex.getMessage());
        }
    }

    protected void informacaoCarga(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 013 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            InformacaoCarga info = new InformacaoCarga();
            while (scanner.hasNext()) {
                scanner.next();
                info.setValorTotalCarga(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                info.setProdutoPredominante(scanner.next());
                info.setOutraCaracteristica(scanner.next());
                info.setValorAverbacao(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setInformacaoCarga(info);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setInformacaoCarga(info);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 13. " + ex.getMessage());
        }
    }

    protected void quantidadeCarga(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 3) {
                throw new ParseException("A linha 014 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 3 campos.");
            }
            QuantidadeCarga qtde = new QuantidadeCarga();
            while (scanner.hasNext()) {
                scanner.next();
                qtde.setNrUM(br.com.ophos.util.cte.Util.valueToUnidadeMedida(scanner.next()));
                qtde.setDescricaoUN(scanner.next());
                qtde.setQuantidade(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_QUATRO_DECIMAIS));
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).getInformacaoCarga().getQuantidadeCarga().add(qtde);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).getInformacaoCarga().getQuantidadeCarga().add(qtde);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 14. " + ex.getMessage());
        }
    }

    @Deprecated
    protected void container(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 015 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    @Deprecated
    protected void lacreContainer(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 016 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    protected void emitenteDocAnterior(String aLine) throws ParseException {
        try {
            EmitenteDocAnterior emitenteAnterior = new EmitenteDocAnterior();
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 030 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            while (scanner.hasNext()) {
                scanner.next();
                emitenteAnterior.setCnpjCpf(scanner.next());
                emitenteAnterior.setInscricaoEstadual(scanner.next());
                emitenteAnterior.setUf(scanner.next());
                emitenteAnterior.setNome(scanner.next());
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).getEmitenteDocumentoAnterior().add(emitenteAnterior);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).getEmitenteDocumentoAnterior().add(emitenteAnterior);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 17. " + ex.getMessage());
        }
    }

    @Deprecated
    protected void seguroCarga(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 018 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    protected void infoRodoviario(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 019 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            Rodoviario rod = new Rodoviario();
            while (scanner.hasNext()) {
                scanner.next();
                rod.setNrRNTRC(scanner.next());
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setModal(rod);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setModal(rod);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 19. " + ex.getMessage());
        }
    }

    protected void ordemColeta(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 8) {
                throw new ParseException("A linha 020 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 8 campos.");
            }
            OrdemColeta ordem = new OrdemColeta();
            while (scanner.hasNext()) {
                scanner.next();
                ordem.setNrSerie(scanner.next());
                ordem.setNrOrdem(br.com.ophos.util.cte.Util.StringToInteger(scanner.next()));
                ordem.setDataEmissao(LocalDateSerializer.parseDate(scanner.next().replaceAll("-", "")));
                ordem.setCnpj(scanner.next());
                ordem.setNrInterno(scanner.next());
                ordem.setNrIE(scanner.next());
                ordem.setUf(scanner.next());
                ordem.setTelefone(scanner.next());
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((Rodoviario)((CTeNormal)this.obj.getInfoCte()).getModal()).getOrdemColeta().add(ordem);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((Rodoviario)((CTeSubstituto)this.obj.getInfoCte()).getModal()).getOrdemColeta().add(ordem);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 20. " + ex.getMessage());
        }
    }

    @Deprecated
    protected void comporInformacoesValePedagio(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 021 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    @Deprecated
    protected void comporVeiculo(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 022 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    protected void complementado(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 023 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            scanner.useDelimiter("\\|");
            CTeComplemento comp = new CTeComplemento();
            while (scanner.hasNext()) {
                scanner.next();
                comp.setChaveAcesso(scanner.next());
                this.obj.setInfoCte(comp);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 23. " + ex.getMessage());
        }
    }

    @Deprecated
    protected void componentesComplementado(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 024 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    protected void documentoAnterior(String aLine) throws ParseException {
        try {
            Documento documentoAnterior = null;
            String cnpjCpf = null;
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 7) {
                throw new ParseException("A linha 025 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 7 campos.");
            }
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            while (scanner.hasNext()) {
                scanner.next();
                cnpjCpf = scanner.next();
                String tipoDocumento = scanner.next();
                String serie = scanner.next();
                String subSerie = scanner.next();
                String nrDocumento = scanner.next();
                String dtemissao = scanner.next();
                String chaveAcesso = scanner.next();
                if (nrDocumento != null && !nrDocumento.trim().isEmpty()) {
                    documentoAnterior = new DocumentoPapel();
                    ((DocumentoPapel)documentoAnterior).setTipo(br.com.ophos.util.cte.Util.valueToTipoDocumento(tipoDocumento));
                    ((DocumentoPapel)documentoAnterior).setNrSerie(serie);
                    ((DocumentoPapel)documentoAnterior).setNrSubSerie(subSerie);
                    ((DocumentoPapel)documentoAnterior).setNrDocumento(nrDocumento);
                    ((DocumentoPapel)documentoAnterior).setDataEmissao(LocalDateSerializer.parseDate(dtemissao.replaceAll("-", "")));
                }
                if (chaveAcesso == null || chaveAcesso.trim().isEmpty()) continue;
                documentoAnterior = new DocumentoCTe();
                ((DocumentoCTe)documentoAnterior).setChaveAcesso(chaveAcesso);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                for (EmitenteDocAnterior emitente : ((CTeNormal)this.obj.getInfoCte()).getEmitenteDocumentoAnterior()) {
                    if (!emitente.getCnpjCpf().equals(cnpjCpf)) continue;
                    emitente.getDocumentos().add(documentoAnterior);
                }
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                for (EmitenteDocAnterior emitente : ((CTeSubstituto)this.obj.getInfoCte()).getEmitenteDocumentoAnterior()) {
                    if (!emitente.getCnpjCpf().equals(cnpjCpf)) continue;
                    emitente.getDocumentos().add(documentoAnterior);
                }
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 25. " + ex.getMessage());
        }
    }

    @Deprecated
    protected void motorista(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 027 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    protected void cteAnulacao(String aLine) throws ParseException {
        try {
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 028 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            while (scanner.hasNext()) {
                scanner.next();
                ((CTeAnulacao)this.obj.getInfoCte()).setNrChaveAcesso(scanner.next());
                ((CTeAnulacao)this.obj.getInfoCte()).setDataEmissao(LocalDateSerializer.parseDate(scanner.next().replaceAll("-", "")));
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 28. " + ex.getMessage());
        }
    }

    protected void cteSubstituto(String aLine) throws ParseException {
        try {
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 12) {
                throw new ParseException("A linha 029 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 12 campos.");
            }
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            while (scanner.hasNext()) {
                scanner.next();
                String alteracaoTomador = scanner.next();
                String chaveAcesso = scanner.next();
                String refCte = scanner.next();
                String refNfe = scanner.next();
                String cnpjCpf = scanner.next();
                String modDoc = scanner.next();
                String serie = scanner.next();
                String subserie = scanner.next();
                String nrDocumento = scanner.next();
                String valor = scanner.next();
                String dataEmissao = scanner.next();
                String refCteAnulacao = scanner.next();
                ((CTeSubstituto)this.obj.getInfoCte()).setAlteracaoTomador(br.com.ophos.util.cte.Util.valueEscolhaSN2(alteracaoTomador.trim()));
                ((CTeSubstituto)this.obj.getInfoCte()).setNrChaveAcesso(chaveAcesso.trim());
                if (refCte != null && !refCte.trim().isEmpty()) {
                    ((CTeSubstituto)this.obj.getInfoCte()).setNrChaveAcessoRefCteEmitido(refCte.trim());
                }
                if (refNfe != null && !refNfe.trim().isEmpty()) {
                    ((CTeSubstituto)this.obj.getInfoCte()).setNrChaveAcessoRefNFeEmitida(refNfe.trim());
                }
                if (cnpjCpf != null && !cnpjCpf.trim().isEmpty()) {
                    ((CTeSubstituto)this.obj.getInfoCte()).setCnpj(cnpjCpf.trim());
                    ((CTeSubstituto)this.obj.getInfoCte()).setModeloDocumento(modDoc.trim());
                    ((CTeSubstituto)this.obj.getInfoCte()).setSerie(br.com.ophos.util.cte.Util.StringToShort(serie.trim()));
                    if (subserie != null && !subserie.trim().isEmpty()) {
                        ((CTeSubstituto)this.obj.getInfoCte()).setSubSerie(br.com.ophos.util.cte.Util.StringToShort(subserie.trim()));
                    }
                    ((CTeSubstituto)this.obj.getInfoCte()).setNrDocumento(nrDocumento.trim());
                    ((CTeSubstituto)this.obj.getInfoCte()).setValor(br.com.ophos.util.cte.Util.StringToDouble(valor.trim(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                    ((CTeSubstituto)this.obj.getInfoCte()).setDataEmissao(LocalDateSerializer.parseDate(dataEmissao.replaceAll("-", "")));
                }
                if (refCteAnulacao != null && !refCteAnulacao.trim().isEmpty()) {
                    ((CTeSubstituto)this.obj.getInfoCte()).setRefCteAnulado(refCteAnulacao.trim());
                }
                if (refCteAnulacao != null && !refCteAnulacao.trim().isEmpty()) {
                    ((CTeSubstituto)this.obj.getInfoCte()).setTomadorContribuinteICMS(EscolhaSN.NAO);
                    continue;
                }
                ((CTeSubstituto)this.obj.getInfoCte()).setTomadorContribuinteICMS(EscolhaSN.SIM);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 29. " + ex.getMessage());
        }
    }

    @Deprecated
    protected void produtosPerigosos(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 030 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    protected void comporVeiculosNovos(String aLine) throws ParseException {
        try {
            VeiculoNovo veiculoNovo = new VeiculoNovo();
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 6) {
                throw new ParseException("A linha 031 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 6 campos.");
            }
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            while (scanner.hasNext()) {
                scanner.next();
                veiculoNovo.setChassi(scanner.next());
                veiculoNovo.setNrCor(scanner.next());
                veiculoNovo.setDescCor(scanner.next());
                veiculoNovo.setModelo(scanner.next());
                veiculoNovo.setValorUnitario(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                veiculoNovo.setValorFrete(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).getVeiculoNovo().add(veiculoNovo);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).getVeiculoNovo().add(veiculoNovo);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 31. " + ex.getMessage());
        }
    }

    protected void comporDadosCobranca(String aLine) throws ParseException {
        try {
            Fatura fatura = new Fatura();
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 032 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            while (scanner.hasNext()) {
                scanner.next();
                fatura.setNumero(scanner.next());
                fatura.setValorOriginal(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                fatura.setValorDesconto(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                fatura.setValorLiquido(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setFatura(fatura);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setFatura(fatura);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 32. " + ex.getMessage());
        }
    }

    protected void comporDuplicatas(String aLine) throws ParseException {
        try {
            Duplicata duplicata = new Duplicata();
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 3) {
                throw new ParseException("A linha 033 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 3 campos.");
            }
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            while (scanner.hasNext()) {
                scanner.next();
                duplicata.setNumero(scanner.next());
                duplicata.setData(LocalDateSerializer.parseDate(scanner.next().replaceAll("-", "")));
                duplicata.setValor(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).getDuplicatas().add(duplicata);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).getDuplicatas().add(duplicata);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 30. " + ex.getMessage());
        }
    }

    @Deprecated
    protected void comporProprietarioVeiculo(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 034 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    protected void lacreRodoviario(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 035 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campos.");
            }
            Lacre lacre = new Lacre();
            while (scanner.hasNext()) {
                scanner.next();
                lacre.setNrLacre(scanner.next());
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((Rodoviario)((CTeNormal)this.obj.getInfoCte()).getModal()).getLacres().add(lacre);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((Rodoviario)((CTeSubstituto)this.obj.getInfoCte()).getModal()).getLacres().add(lacre);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 35. " + ex.getMessage());
        }
    }

    protected void infoContribuinte(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 036 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            InfoContribuinte info = new InfoContribuinte();
            while (scanner.hasNext()) {
                scanner.next();
                info.setCampo(scanner.next());
                info.setDescricao(scanner.next());
            }
            this.obj.getInfoAdicional().getCamposAdicionais().add(info);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 36. " + ex.getMessage());
        }
    }

    protected void infoFisco(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 037 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            InfoFisco info = new InfoFisco();
            while (scanner.hasNext()) {
                scanner.next();
                info.setCampo(scanner.next());
                info.setDescricao(scanner.next());
            }
            this.obj.getInfoAdicional().getCamposAdicionais().add(info);
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 37. " + ex.getMessage());
        }
    }

    protected void infoAereo(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 7) {
                throw new ParseException("A linha 038 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 7 campos.");
            }
            Aereo aereo = new Aereo();
            aereo.setNaturezaCarga(new NaturezaCarga());
            aereo.setTarifa(new Tarifa());
            while (scanner.hasNext()) {
                scanner.next();
                aereo.setnMinu(scanner.next());
                aereo.setnOCA(scanner.next());
                aereo.setDataPrevista(LocalDateSerializer.parseDate(scanner.next().replaceAll("-", "")));
                aereo.getNaturezaCarga().setDimensao(scanner.next());
                aereo.getTarifa().setClasseTarifa(br.com.ophos.util.cte.Util.valueToTipoClasseTarifa(scanner.next()));
                aereo.getTarifa().setCodigoTarifa(scanner.next());
                aereo.getTarifa().setValorTarifa(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setModal(aereo);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setModal(aereo);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 38. " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void infoManuseio(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 039 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                ManuseioCarga manuseio = new ManuseioCarga();
                manuseio.setTipoManuseio(br.com.ophos.util.cte.Util.valueToTipoManuseioCarga(scanner.next()));
                if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                    ((Aereo)((CTeNormal)this.obj.getInfoCte()).getModal()).getNaturezaCarga().getManuseioCarga().add(manuseio);
                }
                if (!this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) continue;
                ((Aereo)((CTeSubstituto)this.obj.getInfoCte()).getModal()).getNaturezaCarga().getManuseioCarga().add(manuseio);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 39. " + ex.getMessage());
        }
    }

    @Deprecated
    protected void infoCargaEspecial(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 040 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    protected void infoAquaviario(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 7) {
                throw new ParseException("A linha 041 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 7 campos.");
            }
            Aquaviario aquav = new Aquaviario();
            while (scanner.hasNext()) {
                scanner.next();
                aquav.setValorPrestacao(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                aquav.setValorAFRMM(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_DOIS_DECIMAIS));
                aquav.setDescricaoNavio(scanner.next());
                aquav.setnViagem(scanner.next());
                aquav.setTipoDirecaoViagem(br.com.ophos.util.cte.Util.valueToTipoDirecaoViagem(scanner.next()));
                aquav.setIrin(scanner.next());
                aquav.setTipoNavegacao(br.com.ophos.util.cte.Util.valueToTipoNavegacao(scanner.next()));
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setModal(aquav);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setModal(aquav);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 41. " + ex.getMessage());
        }
    }

    protected void infoBalsa(String aLine) throws ParseException {
        try {
            Scanner scanner = new Scanner(aLine);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(aLine, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 042 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            Balsa balsa = new Balsa();
            while (scanner.hasNext()) {
                scanner.next();
                balsa.setDescricaoBalsa(scanner.next());
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((Aquaviario)((CTeNormal)this.obj.getInfoCte()).getModal()).getBalsas().add(balsa);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((Aquaviario)((CTeSubstituto)this.obj.getInfoCte()).getModal()).getBalsas().add(balsa);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 42. " + ex.getMessage());
        }
    }

    @Deprecated
    protected void infoConteinerAquaviario(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 043 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    @Deprecated
    protected void infoLacreConteiner(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 044 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    @Deprecated
    protected void infoDocumentoConteiner(String aLine) throws ParseException {
        throw new ParseException("Erro ao realizar o parse. A linha 045 n\u00e3o pertence a vers\u00e3o informada do layout TXT. " + aLine);
    }

    @Deprecated
    protected void dadosLocalRetirada(String linha) throws ParseException {
        throw new ParseException("Linha 046 desativada por adequa\u00e7\u00e3o \u00e0 NT2015.001");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosUnidadesTransporte(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 5) {
                throw new ParseException("A linha 047 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 5 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                int id = Integer.parseInt(scanner.next());
                int idDocumento = Integer.parseInt(scanner.next());
                Object documento = this.mapDocumento.get(idDocumento);
                UnidadeTransporte ut = new UnidadeTransporte();
                ut.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeTransporte(scanner.next()));
                ut.setIdentificacao(scanner.next());
                ut.setQuantidadeRateada(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_TRES_DECIMAIS));
                if (documento instanceof DocumentoNF) {
                    DocumentoNF nf = (DocumentoNF)documento;
                    nf.getUnidadesTransporte().add(ut);
                    this.mapDocumento.put(id, nf);
                }
                if (documento instanceof DocumentoNFe) {
                    DocumentoNFe nfe = (DocumentoNFe)documento;
                    nfe.getUnidadesTransporte().add(ut);
                    this.mapDocumento.put(idDocumento, nfe);
                }
                if (documento instanceof DocumentoOutro) {
                    DocumentoOutro outro = (DocumentoOutro)documento;
                    outro.getUnidadesTransporte().add(ut);
                    this.mapDocumento.put(idDocumento, outro);
                }
                this.mapUnidadeTransporte.put(id, ut);
            }
        }
        catch (ParseException | NumberFormatException ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 047: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosUnidadesCargaTransporte(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 5) {
                throw new ParseException("A linha 048 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 5 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                int id = Integer.parseInt(scanner.next());
                int idTransporte = Integer.parseInt(scanner.next());
                UnidadeTransporte ut = this.mapUnidadeTransporte.get(idTransporte);
                UnidadeCarga uc = new UnidadeCarga();
                uc.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeCarga(scanner.next()));
                uc.setIdentificacao(scanner.next());
                uc.setQuantidadeRateada(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_TRES_DECIMAIS));
                ut.getUnidadeCarga().add(uc);
                this.mapUnidadeTransporte.put(idTransporte, ut);
                this.mapUnidadeCargaTransporte.put(id, uc);
            }
        }
        catch (ParseException | NumberFormatException ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 048: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosUnidadesCarga(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 5) {
                throw new ParseException("A linha 049 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 5 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                int id = Integer.parseInt(scanner.next());
                int idDocumento = Integer.parseInt(scanner.next());
                Object documento = this.mapDocumento.get(idDocumento);
                UnidadeCarga uc = new UnidadeCarga();
                uc.setTipo(br.com.ophos.util.cte.Util.valueToTipoUnidadeCarga(scanner.next()));
                uc.setIdentificacao(scanner.next());
                uc.setQuantidadeRateada(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_TRES_DECIMAIS));
                if (documento instanceof DocumentoNF) {
                    DocumentoNF nf = (DocumentoNF)documento;
                    nf.getUnidadesCarga().add(uc);
                    this.mapDocumento.put(id, nf);
                }
                if (documento instanceof DocumentoNFe) {
                    DocumentoNFe nfe = (DocumentoNFe)documento;
                    nfe.getUnidadesCarga().add(uc);
                    this.mapDocumento.put(idDocumento, nfe);
                }
                if (documento instanceof DocumentoOutro) {
                    DocumentoOutro outro = (DocumentoOutro)documento;
                    outro.getUnidadesCarga().add(uc);
                    this.mapDocumento.put(idDocumento, outro);
                }
                this.mapUnidadeCarga.put(id, uc);
            }
        }
        catch (ParseException | NumberFormatException ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 049: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosLacresTransporte(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 050 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                int idTransporte = Integer.parseInt(scanner.next());
                UnidadeTransporte ut = this.mapUnidadeTransporte.get(idTransporte);
                Lacre lacre = new Lacre();
                lacre.setNrLacre(scanner.next());
                ut.getLacres().add(lacre);
                this.mapUnidadeTransporte.put(idTransporte, ut);
            }
        }
        catch (ParseException | NumberFormatException ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 050: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosLacresCargaTransporte(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 051 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                int idCargaTransporte = Integer.parseInt(scanner.next());
                UnidadeCarga uc = this.mapUnidadeCargaTransporte.get(idCargaTransporte);
                Lacre lacre = new Lacre();
                lacre.setNrLacre(scanner.next());
                uc.getLacres().add(lacre);
                this.mapUnidadeCargaTransporte.put(idCargaTransporte, uc);
            }
        }
        catch (ParseException | NumberFormatException ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 051: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosLacresCarga(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 052 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                int idCarga = Integer.parseInt(scanner.next());
                UnidadeCarga uc = this.mapUnidadeCarga.get(idCarga);
                Lacre lacre = new Lacre();
                lacre.setNrLacre(scanner.next());
                uc.getLacres().add(lacre);
                this.mapUnidadeCarga.put(idCarga, uc);
            }
        }
        catch (ParseException | NumberFormatException ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 052: " + ex.getMessage());
        }
    }

    protected void dadosMultiModal(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 053 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campos.");
            }
            MultiModal multi = new MultiModal();
            while (scanner.hasNext()) {
                scanner.next();
                multi.setCOTM(scanner.next());
                multi.setIndicadorNegociavel(br.com.ophos.util.cte.Util.valueToIndicadorNegociavel(scanner.next()));
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                ((CTeNormal)this.obj.getInfoCte()).setModal(multi);
            }
            if (this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) {
                ((CTeSubstituto)this.obj.getInfoCte()).setModal(multi);
            }
            scanner.close();
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 053: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosAutorizacaoXML(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 054 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                this.obj.setPermitidos(new PermissaoDownload());
                this.obj.getPermitidos().getCnpjCpf().add(scanner.next());
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 054: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosProdutoPerigosoAereo(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 055 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            while (true) {
                Aereo aereo;
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                ProdutoPerigosoAereo produtoPerigosoAereo = new ProdutoPerigosoAereo();
                produtoPerigosoAereo.setNrOnu(scanner.next());
                produtoPerigosoAereo.setQuantidadeEmbalagem(scanner.next());
                produtoPerigosoAereo.setQuantidadeTotal(br.com.ophos.util.cte.Util.StringToDouble(scanner.next(), br.com.ophos.util.cte.Util.ST_FMT_QUATRO_DECIMAIS));
                produtoPerigosoAereo.setUnidadeMedida(br.com.ophos.util.cte.Util.valueToUnidadeProdutoPerigoso(scanner.next()));
                if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                    aereo = (Aereo)((CTeNormal)this.obj.getInfoCte()).getModal();
                    aereo.getProdutoPerigoso().add(produtoPerigosoAereo);
                    ((CTeNormal)this.obj.getInfoCte()).setModal(aereo);
                }
                if (!this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) continue;
                aereo = (Aereo)((CTeSubstituto)this.obj.getInfoCte()).getModal();
                aereo.getProdutoPerigoso().add(produtoPerigosoAereo);
                ((CTeSubstituto)this.obj.getInfoCte()).setModal(aereo);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 055: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosDocumentosMultimodal(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 1) {
                throw new ParseException("A linha 056 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 1 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                ((CTeNormal)this.obj.getInfoCte()).getChaveAcessoMultimodal().add(scanner.next());
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 056: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosSeguroMultimodal(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = this.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 057 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campos.");
            }
            while (true) {
                MultiModal multimodal;
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                SeguroMultimodal seguroMultimodal = new SeguroMultimodal();
                seguroMultimodal.setCnpjSeguradora(scanner.next());
                seguroMultimodal.setNomeSeguradora(scanner.next());
                seguroMultimodal.setNumeroApolice(scanner.next());
                seguroMultimodal.setNumeroAverbacao(scanner.next());
                if (this.obj.getTipo().equals((Object)TipoConhecimento.NORMAL)) {
                    multimodal = (MultiModal)((CTeNormal)this.obj.getInfoCte()).getModal();
                    multimodal.setSeguro(seguroMultimodal);
                    ((CTeNormal)this.obj.getInfoCte()).setModal(multimodal);
                }
                if (!this.obj.getTipo().equals((Object)TipoConhecimento.SUBSTITUTO)) continue;
                multimodal = (MultiModal)((CTeSubstituto)this.obj.getInfoCte()).getModal();
                multimodal.setSeguro(seguroMultimodal);
                ((CTeSubstituto)this.obj.getInfoCte()).setModal(multimodal);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 057: " + ex.getMessage());
        }
    }
}

